/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.MetalSlug;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class MetalSlugMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int BREAK_CHERRY = 13;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_ORANGE = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    protected int[][] flagTable = new int[][]{{4, 56768, 360, 180, 7240, 656, 328}, {4, 56756, 368, 184, 7240, 656, 328}, {4, 56744, 376, 188, 7240, 656, 328}, {4, 56732, 384, 192, 7240, 656, 328}, {4, 56732, 384, 192, 7240, 656, 328}, {4, 56732, 384, 192, 7240, 656, 328}};
    protected int[][] flagTableBig = new int[][]{{984, 18000, 41380, 5172}, {984, 18000, 41380, 5172}, {984, 18000, 41380, 5172}, {984, 18000, 41380, 5172}, {984, 18000, 41380, 5172}, {984, 18000, 41380, 5172}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][] rtTable = new int[][]{{8, 11, 11, 11, 8, 8, 13, 16, 18, 38, 38, 46, 18, 8, 4, 0}, {8, 24, 27, 26, 14, 12, 17, 13, 11, 21, 26, 33, 12, 8, 4, 0}, {8, 24, 27, 26, 14, 12, 17, 13, 11, 21, 26, 33, 12, 8, 4, 0}, {8, 24, 27, 26, 14, 12, 17, 13, 11, 21, 26, 33, 12, 8, 4, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 111, 75, 30, 8, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 251}};
    protected int[][] rtG = new int[][]{{1, 9, 17, 25, 33, 41, 49, 65, 81, 97, 161, 289, 545, 801, 1057, 1313}, {8, 16, 24, 32, 40, 48, 64, 80, 96, 160, 288, 544, 800, 1056, 1312, 1344}};
    protected int[][][] modeTable = new int[][][]{new int[][]{{80, 1, 12, 1, 54, 108}, {77, 2, 16, 1, 96, 64}, {101, 2, 12, 12, 43, 86}, {86, 3, 19, 19, 77, 52}, {64, 4, 32, 32, 62, 62}, {148, 4, 20, 20, 32, 32}}, new int[][]{{1, 222, 1, 30, 1, 1}, {1, 222, 1, 30, 1, 1}, {1, 222, 1, 30, 1, 1}, {1, 222, 1, 30, 1, 1}, {1, 222, 1, 30, 1, 1}, {1, 222, 1, 30, 1, 1}}, new int[][]{{13, 0, 1, 80, 54, 108}, {15, 0, 1, 80, 96, 64}, {36, 0, 1, 90, 43, 86}, {36, 0, 1, 90, 77, 52}, {21, 2, 1, 108, 62, 62}, {82, 1, 1, 108, 32, 32}}, new int[][]{{1, 0, 173, 80, 1, 1}, {1, 0, 173, 80, 1, 1}, {1, 0, 163, 90, 1, 1}, {1, 0, 163, 90, 1, 1}, {1, 2, 143, 108, 1, 1}, {1, 1, 144, 108, 1, 1}}, new int[][]{{251, 1, 1, 1, 1, 1}, {251, 1, 1, 1, 1, 1}, {251, 1, 1, 1, 1, 1}, {251, 1, 1, 1, 1, 1}, {251, 1, 1, 1, 1, 1}, {251, 1, 1, 1, 1, 1}}, new int[][]{{1, 7, 123, 123, 1, 1}, {1, 7, 123, 123, 1, 1}, {1, 7, 123, 123, 1, 1}, {1, 7, 123, 123, 1, 1}, {1, 7, 123, 123, 1, 1}, {1, 7, 123, 123, 1, 1}}};

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 < 650) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                if (this.nextBonus == 3) {
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(3);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 >= 650) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(8);
                break;
            }
            case 2: {
                if (SimulatorLibrary.random((int)8) == 0) {
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(10);
                break;
            }
            case 3: {
                this.fireCoinPlus(15);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.currentMode = this._getNextMode();
            this.rtFloor = this._getRtFloor();
            if (this.nextBonus == 4 && this.rtFloor > 777) {
                this.rtFloor = 777;
            }
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.currentMode = -1;
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.currentMode - 1], (int)256);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    private int _getNextMode() {
        if (this.currentMode < 1) {
            return 1;
        }
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)256);
        return index + 1;
    }
}

