/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Gurukun;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class GurukunMainBoard
extends AbstractMainBoard4Stock {
    private int currentRtTable = 0;
    private int[][] modeSelectionTable = new int[][]{{8, 1, 4, 6, 6, 6, 6, 12, 3, 6, 6, 6, 8, 8, 15, 6, 6, 6, 8, 10, 4, 6, 6, 24, 20, 24, 35}, {16, 1, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 4, 5, 14, 5, 6, 8, 10, 10, 12, 14, 18, 20, 20, 26, 42}, {8, 4, 5, 5, 5, 5, 5, 11, 6, 6, 6, 6, 7, 8, 10, 10, 4, 6, 8, 12, 7, 7, 9, 12, 24, 20, 40}, {25, 1, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 6, 8, 8, 8, 7, 6, 6, 9, 16, 16, 16, 16, 16, 24, 40}, {26, 1, 5, 5, 5, 0, 0, 0, 4, 5, 7, 7, 7, 7, 0, 8, 10, 10, 12, 14, 9, 10, 20, 20, 20, 20, 24}, {36, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 10, 12, 12, 18, 18, 34, 34, 0, 26, 37}};
    private int[][] rtTable = new int[][]{{255, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {84, 0, 8, 26, 0, 40, 26, 8, 0, 0, 0, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 26, 0, 0, 0, 0, 26, 0, 0, 0, 0, 76, 32, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 8, 16, 0, 26, 16, 8, 40, 16, 0, 0, 0, 0, 0, 62, 40, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 8, 8, 8, 8, 0, 8, 16, 16, 40, 0, 128, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 12, 24, 180}};
    private int[][] rtG = new int[][]{{1, 2, 33, 65, 1, 97, 129, 193, 1, 129, 255, 257, 321, 385, 321, 449, 513, 577, 641, 705, 513, 769, 833, 897, 961, 769, 1025, 1281, 1537}, {32, 33, 64, 96, 128, 128, 192, 256, 256, 256, 256, 320, 384, 448, 448, 512, 576, 640, 704, 768, 768, 832, 896, 960, 1024, 1024, 1280, 1536, 1792}};
    private int[] rtTableSelection = new int[]{2, 3, 4, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0};
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    private int[][] flagTable = new int[][]{{47579, 8978, 496, 333, 7150, 1000}, {47579, 8978, 496, 333, 7150, 1000}, {47579, 8978, 496, 333, 7150, 1000}, {47429, 8978, 496, 333, 7300, 1000}, {47329, 8978, 496, 333, 7400, 1000}, {46879, 8978, 496, 333, 7850, 1000}};
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    private int[][] flagTableBig = new int[][]{{4836, 20000, 40500, 200}, {4836, 20000, 40500, 200}, {4836, 20000, 40500, 200}, {4836, 20000, 40500, 200}, {4836, 20000, 40500, 200}, {4836, 20000, 40500, 200}};
    private int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(3);
            }
        }
    }

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (++this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                if (!this.isBreak) break;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(3);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.fireCoinPlus(3);
                this.setJacIn();
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(3);
            }
        }
    }

    public void setup() {
        this.currentMode = -1;
        this.currentRtTable = -1;
        this.rtFloor = 65536;
        this.rtCounter = 0;
    }

    public void reset() {
        super.reset();
        if (this.stock.size() > 0) {
            this.noStock = false;
            this.currentMode = this._getNextMode();
            this.nextBonus = this._getNextBonus();
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.isBreak = false;
            ((AbstractMainBoard)this).isReplay = false;
        } else {
            this.noStock = true;
            this.nextBonus = -1;
            this.rtFloor = 65536;
            this.rtCounter = 0;
            this.isBreak = false;
            ((AbstractMainBoard)this).isReplay = false;
        }
    }

    private int _getNextMode() {
        int result = -1;
        if (this.currentMode < 0) {
            result = 0;
        } else {
            int random256 = -1;
            switch (this.currentMode) {
                case 0: 
                case 1: 
                case 2: 
                case 26: {
                    result = this.__getNextMode();
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    result = 27;
                    break;
                }
                case 4: 
                case 8: 
                case 13: 
                case 19: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 86) {
                        result = 28;
                        break;
                    }
                    if (random256 < 171) {
                        result = 29;
                        break;
                    }
                    result = 31;
                    break;
                }
                case 5: 
                case 9: 
                case 14: 
                case 20: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 64) {
                        result = 33;
                        break;
                    }
                    if (random256 < 128) {
                        result = 34;
                        break;
                    }
                    if (random256 < 192) {
                        result = 35;
                        break;
                    }
                    result = 37;
                    break;
                }
                case 6: 
                case 10: 
                case 15: 
                case 21: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 64) {
                        result = 39;
                        break;
                    }
                    if (random256 < 128) {
                        result = 40;
                        break;
                    }
                    if (random256 < 192) {
                        result = 41;
                        break;
                    }
                    result = 43;
                    break;
                }
                case 11: 
                case 17: 
                case 23: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 86) {
                        result = 50;
                        break;
                    }
                    if (random256 < 171) {
                        result = 52;
                        break;
                    }
                    result = 54;
                    break;
                }
                case 16: 
                case 22: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 45;
                        break;
                    }
                    result = 47;
                    break;
                }
                case 18: 
                case 24: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 67;
                        break;
                    }
                    result = 68;
                    break;
                }
                case 25: {
                    result = 59;
                    break;
                }
                case 27: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = this.__getNextMode();
                        break;
                    }
                    result = 27;
                    break;
                }
                case 28: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = this.__getNextMode();
                        break;
                    }
                    result = 28;
                    break;
                }
                case 29: 
                case 31: 
                case 35: 
                case 37: 
                case 41: 
                case 47: 
                case 48: 
                case 50: 
                case 52: 
                case 55: 
                case 57: 
                case 60: 
                case 62: 
                case 64: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = this.currentMode + 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 30: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = this.__getNextMode();
                        break;
                    }
                    result = 30;
                    break;
                }
                case 32: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = this.__getNextMode();
                        break;
                    }
                    result = 32;
                    break;
                }
                case 33: 
                case 34: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 28;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 36: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 36;
                        break;
                    }
                    if (random256 < 250) {
                        result = 30;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 38: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = 31;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 39: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 214) {
                        result = 39;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 40: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 40;
                        break;
                    }
                    if (random256 < 250) {
                        result = 35;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 42: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 42;
                        break;
                    }
                    if (random256 < 250) {
                        result = 36;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 43: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 43;
                        break;
                    }
                    if (random256 < 250) {
                        result = 44;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 44: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 44;
                        break;
                    }
                    if (random256 < 250) {
                        result = 31;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 45: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 45;
                        break;
                    }
                    if (random256 < 250) {
                        result = 46;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 46: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = 40;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 49: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 250) {
                        result = 39;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 51: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 51;
                        break;
                    }
                    if (random256 < 250) {
                        result = 49;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 53: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 53;
                        break;
                    }
                    if (random256 < 250) {
                        result = 51;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 54: 
                case 59: 
                case 63: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = this.currentMode + 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 56: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 56;
                        break;
                    }
                    if (random256 < 250) {
                        result = 57;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 58: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 58;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 61: 
                case 65: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = this.currentMode + 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 66: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 66;
                        break;
                    }
                    if (random256 < 250) {
                        result = 39;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 67: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 214) {
                        result = 67;
                        break;
                    }
                    if (random256 < 250) {
                        result = 50;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 68: {
                    random256 = SimulatorLibrary.random((int)256);
                    if (random256 < 128) {
                        result = 68;
                        break;
                    }
                    if (random256 < 250) {
                        result = 54;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                default: {
                    throw new RuntimeException("\u898b\u77e5\u3089\u306c\u30e2\u30fc\u30c9\u3002\u6b21\u306e\u30e2\u30fc\u30c9\u304c\u6c7a\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                }
            }
        }
        return result;
    }

    private int __getNextMode() {
        int index = SimulatorLibrary.getTableIndex((int[])this.modeSelectionTable[((AbstractMainBoard)this).settei - 1], (int)256);
        return 26 - index;
    }

    private int _getRtFloor() {
        this.currentRtTable = this.rtTableSelection[this.currentMode];
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.currentRtTable], (int)256);
        return SimulatorLibrary.getRandomPerRange((int)this.rtG[0][index], (int)this.rtG[1][index]);
    }

    private int _getNextBonus() {
        int next = -1;
        next = this.currentMode < 27 ? 3 : (SimulatorLibrary.random((int)11) < 9 ? 3 : 4);
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getCurrentRtTable() {
        return this.currentRtTable;
    }
}

