/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.FD;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.FD.FDMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class FDDataCounter
extends AbstractDataCounter4Stock {
    private JCheckBoxMenuItem mmReport = null;
    private JCheckBoxMenuItem highReport = null;

    public FDDataCounter() {
        this.initialize();
    }

    protected String getFrameTitle() {
        return "\u30d5\u30a1\u30a4\u30e4\u30fc\u30c9\u30ea\u30d5\u30c8\u30b7\u30df\u30e5";
    }

    protected void initializeGui(JPanel northPanel) {
        super.initializeGui(northPanel);
        this.mmReport = new JCheckBoxMenuItem("MM\u8868\u793a", false);
        this.highReport = new JCheckBoxMenuItem("\u9ad8\u78ba\u4e0a\u4e57\u305b\u8868\u793a", false);
        this.addOptionMenu(this.mmReport);
        this.addOptionMenu(this.highReport);
    }

    protected MainBoardInterface getSimulator() {
        return new FDMainBoard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 21: {
                this.eventHigh(event);
                break;
            }
            case 23: {
                this.eventMm(event);
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((FDMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case 3: {
                this.appendLog("\u5929\u4e95");
                break;
            }
            case 1: {
                this.appendLog("MM\u30af\u30ea\u30a2");
                break;
            }
            case 2: {
                this.appendLog("\u30ea\u30d7\u30ec\u30a44\u9023");
                break;
            }
            case 0: {
                this.appendLog("\u76f4\u6483");
            }
        }
        this.appendLog("\t\u9ad8\u78ba\u6b8b:" + ((FDMainBoard)((AbstractDataCounter)this).simulator).getHighFloor());
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    private void eventHigh(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.highReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + this.getCurrentGameCount() + "]");
        this.appendLog("\t\u9ad8\u78ba+" + ((FDMainBoard)((AbstractDataCounter)this).simulator).getCurrentHitHighGame());
        this.appendLog("\t\u9ad8\u78ba\u6b8b:" + ((FDMainBoard)((AbstractDataCounter)this).simulator).getHighFloor());
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    private void eventMm(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.mmReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + this.getCurrentGameCount() + "]");
        this.appendLog("\tMM" + ((FDMainBoard)((AbstractDataCounter)this).simulator).getMmFloor());
        this.appendLog("\t\u9ad8\u78ba\u6b8b:" + ((FDMainBoard)((AbstractDataCounter)this).simulator).getHighFloor());
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
    }

    public static void main(String[] args) {
        FDDataCounter main = null;
        try {
            main = new FDDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }
}

