/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.DeathValley;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class DeathValleyMainBoard
extends AbstractMainBoard4Stock {
    private int currentRtTable = 0;
    private int[][] modeSelectionTable = new int[][]{{4, 40, 48, 54, 9, 4, 3, 2, 10, 8, 5, 3, 1, 12, 10, 8, 6, 3, 2, 12, 5, 3, 2, 1, 1}, {16, 35, 50, 50, 16, 9, 5, 3, 14, 10, 8, 4, 2, 9, 8, 6, 4, 3, 1, 0, 0, 1, 1, 1, 0}, {14, 25, 44, 54, 5, 5, 5, 3, 5, 5, 5, 5, 5, 16, 6, 6, 6, 6, 5, 10, 7, 6, 4, 3, 1}, {24, 42, 36, 36, 16, 10, 6, 4, 15, 12, 8, 5, 3, 9, 9, 8, 3, 3, 3, 0, 0, 1, 1, 1, 1}, {32, 32, 24, 24, 12, 10, 7, 5, 16, 12, 9, 7, 6, 12, 10, 9, 8, 8, 7, 1, 1, 1, 1, 1, 1}, {64, 52, 40, 0, 16, 12, 10, 5, 20, 12, 10, 5, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0}};
    private int[][] rtTable = new int[][]{{72, 32, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {10, 20, 10, 20, 48, 36, 48, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 6, 6, 20, 20, 0, 0, 32, 32, 24, 104, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 5, 5, 5, 5, 0, 0, 10, 10, 26, 26, 10, 40, 26, 78, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 26, 0, 10, 0, 26, 16, 16, 16, 32, 14, 26, 74, 0}, {0, 0, 0, 0, 0, 0, 0, 12, 0, 24, 12, 0, 0, 0, 0, 0, 12, 12, 88, 96}};
    private int[][] rtG = new int[][]{{1, 33, 65, 97, 129, 193, 255, 257, 321, 385, 449, 513, 577, 641, 705, 769, 833, 897, 961, 1025}, {32, 64, 96, 128, 192, 256, 256, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024, 1280}};
    private int[] rtTableSelection = new int[]{1, 2, 3, 4, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0};
    public static final int FLAG_CUP = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    private int[][] flagTable = new int[][]{{1, 58486, 386, 193, 5770, 300, 400}, {1, 58486, 386, 193, 5770, 300, 400}, {1, 58486, 386, 193, 5770, 300, 400}, {1, 58486, 386, 193, 5770, 300, 400}, {1, 58486, 386, 193, 5770, 300, 400}, {1, 58486, 386, 193, 5770, 300, 400}};
    public static final int FLAG_BIG_7CUP = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private int[][] flagTableBig = new int[][]{{46, 12000, 45990, 4500, 3000}, {46, 12000, 45990, 4500, 3000}, {46, 12000, 45990, 4500, 3000}, {46, 12000, 45990, 4500, 3000}, {46, 12000, 45990, 4500, 3000}, {46, 12000, 45990, 4500, 3000}};
    private int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 628) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
            }
        }
    }

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (++this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                this.isBreak = true;
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 628) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                if (!this.isBreak) break;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
                break;
            }
            case 6: {
                this.fireCoinPlus(3);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 22) break;
                this.fireCoinPlus(15);
                this.setJacIn();
                break;
            }
            case 2: {
                this.fireCoinPlus(15);
                break;
            }
            case 3: {
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                this.fireCoinPlus(15);
            }
        }
    }

    public void setup() {
        this.currentMode = -1;
        this.currentRtTable = -1;
        this.rtFloor = 65536;
        this.rtCounter = 0;
    }

    public void reset() {
        super.reset();
        if (this.stock.size() > 0) {
            this.noStock = false;
            this.currentMode = this._getNextMode();
            this.nextBonus = this._getNextBonus();
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.isBreak = false;
            ((AbstractMainBoard)this).isReplay = false;
        } else {
            this.noStock = true;
            this.nextBonus = -1;
            this.rtFloor = 65536;
            this.rtCounter = 0;
            this.isBreak = false;
            ((AbstractMainBoard)this).isReplay = false;
        }
    }

    private int _getNextMode() {
        int result;
        block68: {
            block69: {
                block67: {
                    result = -1;
                    if (this.currentMode >= 0) break block67;
                    result = this.__getNextMode();
                    break block68;
                }
                if (this.nextBonus == 4 && (this.currentMode == 26 || this.currentMode == 27 || this.currentMode == 29)) {
                    return this.currentMode;
                }
                if (this.currentMode > 25) break block69;
                switch (this.currentMode) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 25: {
                        result = this.__getNextMode();
                        break block68;
                    }
                    case 4: 
                    case 8: 
                    case 13: 
                    case 19: {
                        result = 25;
                        break block68;
                    }
                    case 5: {
                        result = 26;
                        break block68;
                    }
                    case 6: {
                        result = 31;
                        break block68;
                    }
                    case 7: {
                        result = 37;
                        break block68;
                    }
                    case 9: {
                        result = 28;
                        break block68;
                    }
                    case 10: {
                        result = 32;
                        break block68;
                    }
                    case 11: {
                        result = 38;
                        break block68;
                    }
                    case 12: {
                        result = 49;
                        break block68;
                    }
                    case 14: {
                        result = 30;
                        break block68;
                    }
                    case 15: {
                        result = 34;
                        break block68;
                    }
                    case 16: {
                        result = 40;
                        break block68;
                    }
                    case 17: {
                        result = 44;
                        break block68;
                    }
                    case 18: {
                        result = 51;
                        break block68;
                    }
                    case 20: {
                        result = 36;
                        break block68;
                    }
                    case 21: {
                        result = 42;
                        break block68;
                    }
                    case 22: {
                        result = 47;
                        break block68;
                    }
                    case 23: {
                        result = 55;
                        break block68;
                    }
                    case 24: {
                        result = 55;
                        break block68;
                    }
                    default: {
                        throw new RuntimeException("\u898b\u77e5\u3089\u306c\u30e2\u30fc\u30c9\u3002\u6b21\u306e\u30e2\u30fc\u30c9\u304c\u6c7a\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 M=" + this.currentMode);
                    }
                }
            }
            int random256 = -1;
            random256 = SimulatorLibrary.random((int)256);
            switch (this.currentMode) {
                case 26: {
                    if (random256 < 128) {
                        result = 26;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 27: 
                case 29: {
                    if (random256 < 250) {
                        result = this.__getNextMode();
                        break;
                    }
                    result = this.currentMode;
                    break;
                }
                case 28: 
                case 40: 
                case 46: 
                case 51: 
                case 55: {
                    if (random256 < 250) {
                        result = this.currentMode - 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 30: 
                case 34: 
                case 36: 
                case 47: 
                case 49: 
                case 54: {
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = this.currentMode - 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 31: 
                case 32: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 30;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 33: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 27;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 35: {
                    if (random256 < 250) {
                        result = 30;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 37: {
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 38: 
                case 39: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 33;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 41: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 30;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 42: 
                case 44: 
                case 53: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = this.currentMode - 1;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 43: {
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 38;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 45: {
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 37;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 48: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 45;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 50: {
                    if (random256 < 128) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 48;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                case 52: {
                    if (random256 < 214) {
                        result = this.currentMode;
                        break;
                    }
                    if (random256 < 250) {
                        result = 26;
                        break;
                    }
                    result = this.__getNextMode();
                    break;
                }
                default: {
                    throw new RuntimeException("\u898b\u77e5\u3089\u306c\u30e2\u30fc\u30c9\u3002\u6b21\u306e\u30e2\u30fc\u30c9\u304c\u6c7a\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 M=" + this.currentMode);
                }
            }
        }
        return result;
    }

    private int __getNextMode() {
        int index = SimulatorLibrary.getTableIndex((int[])this.modeSelectionTable[((AbstractMainBoard)this).settei - 1], (int)256);
        return index;
    }

    private int _getRtFloor() {
        this.currentRtTable = this.rtTableSelection[this.currentMode];
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.currentRtTable], (int)256);
        return SimulatorLibrary.getRandomPerRange((int)this.rtG[0][index], (int)this.rtG[1][index]);
    }

    private int _getNextBonus() {
        int next = -1;
        next = this.currentMode < 25 || this.currentMode == 26 || this.currentMode == 27 || this.currentMode == 29 ? 3 : (SimulatorLibrary.random((int)10) < 5 ? 3 : 4);
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getCurrentRtTable() {
        return this.currentRtTable;
    }
}

