/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.DeathValley;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.DeathValley.DeathValleyMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class DeathValleyDataCounter
extends AbstractDataCounter4Stock {
    private int[] mode = new int[56];
    private int[] rtTable = new int[6];
    private int bonusCount = 0;
    private int[] hitRange = new int[21];
    private static final int RANGE_1_33 = 0;
    private static final int RANGE_34_64 = 1;
    private static final int RANGE_65_96 = 2;
    private static final int RANGE_97_128 = 3;
    private static final int RANGE_129_256 = 4;
    private static final int RANGE_257_320 = 5;
    private static final int RANGE_321_384 = 6;
    private static final int RANGE_385_448 = 7;
    private static final int RANGE_449_512 = 8;
    private static final int RANGE_513_576 = 9;
    private static final int RANGE_577_640 = 10;
    private static final int RANGE_641_704 = 11;
    private static final int RANGE_705_768 = 12;
    private static final int RANGE_769_832 = 13;
    private static final int RANGE_833_896 = 14;
    private static final int RANGE_897_960 = 15;
    private static final int RANGE_961_1024 = 16;
    private static final int RANGE_1025_5000 = 17;

    public static final void main(String[] args) {
        DeathValleyDataCounter main = null;
        try {
            main = new DeathValleyDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public DeathValleyDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.textInitialStock.setText("10");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30c7\u30b9\u30d0\u30ec\u30fc\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new DeathValleyMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 23: {
                this.eventRtStart();
            }
        }
    }

    protected void eventBonusStart() {
        ++this.bonusCount;
        int modeIndex = ((DeathValleyMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode();
        int rtTableIndex = ((DeathValleyMainBoard)((AbstractDataCounter)this).simulator).getCurrentRtTable();
        int n = modeIndex;
        this.mode[n] = this.mode[n] + 1;
        int n2 = rtTableIndex;
        this.rtTable[n2] = this.rtTable[n2] + 1;
        int rangeIndex = -1;
        int g = this.getCurrentGameCount();
        if (g >= 0 && g <= 33) {
            rangeIndex = 0;
        } else if (g >= 34 && g <= 64) {
            rangeIndex = 1;
        } else if (g >= 65 && g <= 96) {
            rangeIndex = 2;
        } else if (g >= 97 && g <= 128) {
            rangeIndex = 3;
        } else if (g >= 129 && g <= 256) {
            rangeIndex = 4;
        } else if (g >= 257 && g <= 320) {
            rangeIndex = 5;
        } else if (g >= 321 && g <= 384) {
            rangeIndex = 6;
        } else if (g >= 385 && g <= 448) {
            rangeIndex = 7;
        } else if (g >= 449 && g <= 512) {
            rangeIndex = 8;
        } else if (g >= 513 && g <= 576) {
            rangeIndex = 9;
        } else if (g >= 577 && g <= 640) {
            rangeIndex = 10;
        } else if (g >= 641 && g <= 704) {
            rangeIndex = 11;
        } else if (g >= 705 && g <= 768) {
            rangeIndex = 12;
        } else if (g >= 769 && g <= 832) {
            rangeIndex = 13;
        } else if (g >= 833 && g <= 896) {
            rangeIndex = 14;
        } else if (g >= 897 && g <= 960) {
            rangeIndex = 15;
        } else if (g >= 961 && g <= 1024) {
            rangeIndex = 16;
        } else if (g >= 1025) {
            rangeIndex = 17;
        }
        int n3 = rangeIndex;
        this.hitRange[n3] = this.hitRange[n3] + 1;
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        int mode = ((DeathValleyMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode();
        int rtTable = ((DeathValleyMainBoard)((AbstractDataCounter)this).simulator).getCurrentRtTable();
        this.appendLog("\tM" + mode + "(T" + rtTable + ")");
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventSimulateEnd() {
        super.eventSimulateEnd();
        this.appendLog("\n\u30dc\u30fc\u30ca\u30b9\u5206\u5e03\n");
        int i = 0;
        while (i < this.hitRange.length) {
            switch (i) {
                case 0: {
                    this.appendLogPercent("   1-  33", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 1: {
                    this.appendLogPercent("  34-  64", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 2: {
                    this.appendLogPercent("  65-  96", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 3: {
                    this.appendLogPercent("  97- 128", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 4: {
                    this.appendLogPercent(" 129- 256", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 5: {
                    this.appendLogPercent(" 257- 320", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 6: {
                    this.appendLogPercent(" 321- 384", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 7: {
                    this.appendLogPercent(" 385- 448", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 8: {
                    this.appendLogPercent(" 449- 512", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 9: {
                    this.appendLogPercent(" 513- 576", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 10: {
                    this.appendLogPercent(" 577- 640", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 11: {
                    this.appendLogPercent(" 641- 704", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 12: {
                    this.appendLogPercent(" 705- 768", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 13: {
                    this.appendLogPercent(" 769- 832", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 14: {
                    this.appendLogPercent(" 833- 896", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 15: {
                    this.appendLogPercent(" 897- 960", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 16: {
                    this.appendLogPercent(" 961-1024", this.hitRange[i], this.bonusCount);
                    break;
                }
                case 17: {
                    this.appendLogPercent("1025-----", this.hitRange[i], this.bonusCount);
                }
            }
            ++i;
        }
        this.appendLog("\n\u30c6\u30fc\u30d6\u30eb\u5225\u6ede\u5728\u7387\n");
        int i2 = 0;
        while (i2 < this.rtTable.length) {
            this.appendLogPercent("T" + i2, this.rtTable[i2], this.bonusCount);
            ++i2;
        }
        this.appendLog("\n\u30c6\u30fc\u30d6\u30eb\u5225\u6ede\u5728\u7387(T0\u629c\u304d)\n");
        int i3 = 1;
        while (i3 < this.rtTable.length) {
            this.appendLogPercent("T" + i3, this.rtTable[i3], this.bonusCount - this.rtTable[0]);
            ++i3;
        }
        this.appendLog("\n\u30c6\u30fc\u30d6\u30eb\u5225\u6ede\u5728\u7387(T0,T1\u629c\u304d)\n");
        int i4 = 2;
        while (i4 < this.rtTable.length) {
            this.appendLogPercent("T" + i4, this.rtTable[i4], this.bonusCount - this.rtTable[0] - this.rtTable[1]);
            ++i4;
        }
        this.appendLog("\n");
        int i5 = 0;
        while (i5 < this.mode.length) {
            this.appendLogPercent("M" + i5, this.mode[i5], this.bonusCount);
            ++i5;
        }
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        int i = 0;
        while (i < this.mode.length) {
            this.mode[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.rtTable.length) {
            this.rtTable[i2] = 0;
            ++i2;
        }
        this.bonusCount = 0;
        int i3 = 0;
        while (i3 < this.hitRange.length) {
            this.hitRange[i3] = 0;
            ++i3;
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

