/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Bakuhuu;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class BakuhuuMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int BREAK_NORMAL = 10;
    protected boolean isZentyouRt = false;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_SUIKA = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    protected int[][] flagTable = new int[][]{{1, 56013, 386, 210, 8220, 656, 50}, {1, 56013, 386, 210, 8220, 656, 50}, {1, 56013, 386, 210, 8220, 656, 50}, {1, 56013, 386, 210, 8220, 656, 50}, {1, 55833, 386, 210, 8400, 656, 50}, {1, 55033, 386, 210, 9200, 656, 50}};
    protected int[][] breakRatio = new int[][]{{114, 1}, {123, 1}, {140, 1}, {164, 22}, {178, 44}, {200, 100}};
    protected int[][] flagTableBig = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    protected int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    protected int RT_INDEX_MODE1_BIG = 0;
    protected int RT_INDEX_MODE1_REG = 1;
    protected int RT_INDEX_MODE2 = 2;
    protected int RT_INDEX_MODE3 = 3;
    protected int RT_INDEX_MODE4 = 4;
    protected int RT_INDEX_ZENTYOU = 5;
    protected int[][] rtTable = new int[][]{{2048, 4096, 6144, 4096, 2048, 4096, 6144, 4096, 2048, 4096, 6144, 4096, 16384}, {655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 655, 3280, 9831, 6554, 19661, 15730}, {1966, 9830, 8192, 4916, 4916, 4916, 4916, 4916, 2621, 2621, 2621, 2621, 2621, 2621, 2621, 2621}, {656, 3277, 3277, 3277, 3277, 1310, 1310, 1310, 983, 983, 983, 983, 983, 983, 1310, 1310, 3277, 3277, 4916, 4916, 9831, 1310}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}, {4, 4, 4, 4, 4, 4, 4, 4, 12, 12, 12, 16, 16, 32, 54, 70}};
    protected int[][] rtG = new int[][]{{545, 561, 577, 593, 945, 961, 977, 993, 1441, 1457, 1473, 1489, 1913}, {257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433, 449, 465, 481, 497, 513, 529, 545, 561, 577}, {2, 17, 33, 49, 65, 81, 97, 1163, 129, 145, 161, 177, 193, 209, 225, 241}, {2, 17, 33, 49, 65, 81, 97, 1163, 129, 145, 161, 177, 193, 209, 225, 241, 257, 273, 289, 305, 321, 337}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}};
    protected static final int MODE_INDEX_1_BIG = 0;
    protected static final int MODE_INDEX_1_REG = 1;
    protected static final int MODE_INDEX_23_BIG = 2;
    protected static final int MODE_INDEX_2_REG = 3;
    protected static final int MODE_INDEX_3_REG = 4;
    protected static final int MODE_INDEX_4_BIG = 5;
    protected static final int MODE_INDEX_4_REG = 6;
    protected int[][][] modeTable = new int[][][]{new int[][]{{127, 0, 1, 128}, {118, 0, 10, 128}, {112, 0, 16, 128}, {112, 0, 16, 128}, {112, 0, 16, 128}, {50, 0, 26, 180}}, new int[][]{{204, 52, 0, 0}, {192, 64, 0, 0}, {179, 77, 0, 0}, {166, 90, 0, 0}, {140, 116, 0, 0}, {56, 200, 0, 0}}, new int[][]{{127, 0, 1, 128}, {124, 0, 4, 128}, {115, 0, 13, 128}, {115, 0, 13, 128}, {115, 0, 13, 128}, {75, 0, 1, 180}}, new int[][]{{52, 128, 76, 0}, {52, 128, 76, 0}, {52, 128, 76, 0}, {52, 128, 76, 0}, {52, 128, 76, 0}, {50, 26, 180, 0}}, new int[][]{{166, 90, 0, 0}, {166, 90, 0, 0}, {166, 90, 0, 0}, {166, 90, 0, 0}, {166, 90, 0, 0}, {133, 123, 0, 0}}, new int[][]{{127, 0, 1, 128}, {124, 0, 4, 128}, {115, 0, 13, 128}, {115, 0, 13, 128}, {115, 0, 13, 128}, {203, 0, 1, 52}}, new int[][]{{0, 0, 0, 256}, {0, 0, 0, 256}, {0, 0, 0, 256}, {0, 0, 0, 256}, {0, 0, 0, 256}, {0, 0, 0, 256}}};

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getStockType() {
        return 1;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter >= this.rtFloor && this.isZentyouRt) {
            this.isBreak = true;
            this.isZentyouRt = false;
        } else if (this.rtCounter >= this.rtFloor) {
            this.isZentyouRt = true;
            this.rtFloor += this._getZentyouRtFloor();
        }
        int random65536 = SimulatorLibrary.random((int)65536);
        if (random65536 < this.breakRatio[((AbstractMainBoard)this).settei - 1][this.nextBonus - 3]) {
            this.isZentyouRt = true;
            this.rtFloor = this.rtCounter + this._getZentyouRtFloor();
            this.breakFactor = 10;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(5);
                break;
            }
            case 1: {
                if (random4096 < 672) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
                break;
            }
            case 6: {
                this.fireCoinPlus(5);
                break;
            }
            case 1: {
                if (random4096 >= 672) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (game == 6 || game == 11 || game == 15) {
                    this.setJacIn();
                    this.fireCoinPlus(6);
                    break;
                }
                this.fireCoinPlus(15);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        int previousBonus = this.nextBonus;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.currentMode = this.nextMode == -1 ? this._getNextMode(previousBonus) : this.nextMode;
            this.rtFloor = this._getRtFloor();
            if (this.nextBonus == 4 && this.rtFloor > 777) {
                this.rtFloor = 777;
            }
            this.isZentyouRt = false;
            if (this.currentMode == 4 && this.nextBonus == 3) {
                this.isZentyouRt = true;
            }
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
            this.nextMode = this._getNextMode(this.nextBonus);
        } else {
            this.currentMode = -1;
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int[] _rtTable = null;
        int max = 65536;
        switch (this.currentMode) {
            case 1: {
                _rtTable = this.nextBonus == 3 ? this.rtTable[this.RT_INDEX_MODE1_BIG] : this.rtTable[this.RT_INDEX_MODE1_REG];
                break;
            }
            case 2: {
                _rtTable = this.rtTable[this.RT_INDEX_MODE2];
                break;
            }
            case 3: {
                _rtTable = this.rtTable[this.RT_INDEX_MODE3];
                break;
            }
            case 4: {
                _rtTable = this.rtTable[this.RT_INDEX_MODE4];
                max = 256;
            }
        }
        int index = SimulatorLibrary.getTableIndex(_rtTable, (int)max);
        int g = 0;
        switch (this.currentMode) {
            case 1: {
                g = this.nextBonus == 3 ? this.rtG[this.RT_INDEX_MODE1_BIG][index] : this.rtG[this.RT_INDEX_MODE1_REG][index];
                break;
            }
            case 2: {
                g = this.rtG[this.RT_INDEX_MODE2][index];
                break;
            }
            case 3: {
                g = this.rtG[this.RT_INDEX_MODE3][index];
                break;
            }
            case 4: {
                g = this.rtG[this.RT_INDEX_MODE4][index];
                max = 256;
            }
        }
        return g;
    }

    private int _getZentyouRtFloor() {
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.RT_INDEX_ZENTYOU], (int)256);
        int g = this.rtG[this.RT_INDEX_ZENTYOU][index];
        return g;
    }

    private int _getNextMode(int previousBonus) {
        int modeIndex = -1;
        switch (this.currentMode) {
            case 1: {
                modeIndex = previousBonus == 3 ? 0 : 1;
                break;
            }
            case 2: {
                modeIndex = previousBonus == 3 ? 2 : 3;
                break;
            }
            case 3: {
                modeIndex = previousBonus == 3 ? 2 : 4;
                break;
            }
            case 4: {
                int n = modeIndex = previousBonus == 3 ? 5 : 6;
            }
        }
        if (this.currentMode < 1) {
            return 1;
        }
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.modeTable[modeIndex][((AbstractMainBoard)this).settei - 1], (int)256);
        return index + 1;
    }

    public int getMaxBigGameCount() {
        return 15;
    }
}

