/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Gogogo;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class GogogoMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int EVENT_GT_HIT = 25;
    public static final int EVENT_GT_START = 26;
    public static final int EVENT_GT_END = 27;
    public static final int EVENT_SUPERHIGH_START = 28;
    public static final int EVENT_SUPERHIGH_END = 29;
    public static final int EVENT_HIGH_START = 30;
    public static final int EVENT_HIGH_END = 31;
    public static final int EVENT_CHANCE = 32;
    public static final int EVENT_CUP3 = 33;
    public static final int BREAK_CUP3 = 11;
    protected static final int GTHIT_CHANCE = 0;
    protected static final int GTHIT_CHERRY2 = 1;
    protected static final int GTHIT_BIG_CHERRY = 2;
    protected static final int GTHIT_BIG_SUIKA = 3;
    protected static final int GTHIT_BIG_NOFLAG = 4;
    protected static final int GTHIT_JAC_NOFLAG = 5;
    protected static final int GTHIT_REG_BITA = 6;
    protected int gtFactor = 0;
    public static final int FLAG_CUP = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_SUIKA = 6;
    public static final int FLAG_CHANCE = 7;
    public static final int FLAG_CUP_HIT = 8;
    public static final int FLAG_REP_HIT = 9;
    public static final int FLAG_CUP_HIT2 = 10;
    public static final int FLAG_BIG_CHERRY = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    protected int[][] flagTable = new int[][]{{1, 34859, 551, 275, 28500, 350, 1000}, {1, 34859, 551, 275, 28500, 350, 1000}, {1, 34859, 551, 275, 28500, 350, 1000}, {1, 34859, 551, 275, 28500, 350, 1000}, {1, 34859, 551, 275, 28500, 350, 1000}, {1, 34859, 551, 275, 28500, 350, 1000}};
    protected int[][] flagTableBig = new int[][]{{1, 65520, 4, 11}, {1, 65520, 4, 11}, {1, 65520, 4, 11}, {1, 65520, 4, 11}, {1, 65520, 4, 11}, {1, 65520, 4, 11}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][] rtTable1 = new int[][]{{32, 32, 30, 30, 20, 15, 15, 4, 15, 4, 15, 4, 10, 4, 8, 4, 2, 2, 8, 2}, {32, 32, 30, 30, 20, 15, 15, 4, 15, 4, 15, 4, 10, 4, 8, 4, 2, 2, 8, 2}, {32, 32, 30, 30, 20, 15, 15, 4, 15, 4, 15, 4, 10, 4, 8, 4, 2, 2, 8, 2}, {32, 32, 30, 30, 20, 15, 15, 4, 15, 4, 15, 4, 10, 4, 8, 4, 2, 2, 8, 2}, {32, 32, 30, 30, 20, 16, 16, 4, 16, 4, 16, 4, 14, 4, 4, 4, 2, 2, 4, 2}, {36, 34, 30, 28, 25, 20, 18, 4, 15, 4, 12, 4, 10, 4, 8, 2, 2, 0, 0, 0}};
    protected int[][] rtTable2 = new int[][]{{0, 40, 35, 33, 25, 22, 18, 4, 16, 4, 16, 4, 15, 4, 12, 4, 2, 2}, {0, 40, 35, 33, 25, 22, 18, 4, 16, 4, 16, 4, 15, 4, 12, 4, 2, 2}, {0, 40, 35, 33, 25, 22, 18, 4, 16, 4, 16, 4, 15, 4, 12, 4, 2, 2}, {0, 40, 35, 33, 25, 22, 18, 4, 16, 4, 16, 4, 15, 4, 12, 4, 2, 2}, {0, 40, 36, 32, 27, 25, 20, 4, 18, 4, 18, 4, 8, 4, 8, 4, 2, 2}, {0, 45, 36, 32, 30, 25, 22, 4, 20, 4, 16, 4, 14, 4, 0, 0, 0, 0}};
    protected int[][] rtG1 = new int[][]{{1, 17, 33, 65, 97, 129, 257, 332, 385, 443, 513, 554, 641, 665, 769, 776, 887, 998, 1025, 1110}, {16, 32, 64, 96, 128, 256, 384, 332, 512, 443, 640, 554, 768, 665, 1024, 776, 887, 998, 1280, 1110}};
    protected int[][] rtG2 = new int[][]{{1, 17, 33, 65, 97, 129, 257, 332, 385, 443, 513, 554, 641, 665, 769, 776, 887, 998}, {16, 32, 64, 96, 128, 256, 384, 332, 512, 443, 640, 554, 768, 665, 1024, 776, 887, 998}};
    protected static final int INDEX_GT_HIT_SUPERHIGH = 0;
    protected static final int INDEX_GT_HIT_HIGH = 1;
    protected static final int INDEX_GT_HIT_LOW = 2;
    protected int[][] gtHitRatioTable = new int[][]{{108, 54, 6}, {118, 68, 8}, {124, 72, 8}, {128, 90, 14}, {128, 102, 14}, {128, 116, 24}};
    protected int[][] gtRenTableSuperHigh = new int[][]{{500, 10, 500, 4, 4, 4, 2}, {500, 10, 500, 4, 4, 4, 2}, {500, 10, 500, 4, 4, 4, 2}, {500, 10, 500, 4, 4, 4, 2}, {500, 10, 500, 4, 4, 4, 2}, {500, 10, 500, 4, 4, 4, 2}};
    protected int[][] gtRenTableHigh = new int[][]{{300, 100, 370, 200, 40, 10, 4}, {300, 100, 470, 100, 40, 10, 4}, {284, 100, 310, 240, 60, 20, 10}, {270, 100, 374, 150, 100, 20, 10}, {270, 100, 319, 220, 100, 10, 5}, {325, 325, 299, 40, 20, 10, 5}};
    protected int[][] gtRenTableLow = new int[][]{{970, 0, 40, 4, 4, 4, 2}, {970, 0, 40, 4, 4, 4, 2}, {970, 0, 40, 4, 4, 4, 2}, {970, 0, 40, 4, 4, 4, 2}, {970, 0, 40, 4, 4, 4, 2}, {970, 0, 40, 4, 4, 4, 2}};
    protected int[] gtRenTable = new int[]{1, 2, 3, 5, 7, 9, 11};
    protected int[] gtGameCountTable = new int[]{200, 48, 8};
    protected boolean isBreak = false;
    protected boolean isReplay = false;
    protected boolean noStock = false;
    protected boolean isSuperHigh = false;
    protected boolean isHigh = false;
    protected boolean isGt = false;
    protected int currentGtHitCount = 0;
    protected int gtRenCount = 0;
    protected int gtFloor = 0;
    protected int gtGameCounter = 0;
    protected int cupContinueCount = 0;
    protected int cherryContinueCount = 0;

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        int random256;
        ++this.rtCounter;
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        } else {
            this.isReplay = false;
        }
        if (this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
        }
        if ((random256 = SimulatorLibrary.random((int)256)) < 5) {
            if (this.isSuperHigh) {
                this.isSuperHigh = false;
                this.fireEvent(29);
                if (this.isHigh) {
                    this.fireEvent(30);
                }
            } else if (this.isHigh) {
                this.isHigh = false;
                this.fireEvent(31);
            }
        }
        if (this.gtRenCount > 0 && !this.isGt && (random256 = SimulatorLibrary.random((int)256)) < 15) {
            this.isGt = true;
            this.gtGameCounter = 0;
            --this.gtRenCount;
            random256 = SimulatorLibrary.random((int)256);
            this.gtFloor = random256 < this.gtGameCountTable[0] ? 30 : (random256 < this.gtGameCountTable[0] + this.gtGameCountTable[1] ? 50 : 100);
            this.fireEvent(26);
        }
        if (this.isGt && !this.isBreak) {
            ++this.gtGameCounter;
            if (this.gtGameCounter >= this.gtFloor) {
                this.isGt = false;
                this.gtFloor = -1;
                this.fireEvent(27);
            }
        }
        int random128 = SimulatorLibrary.random((int)128);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        if (flag != 4) {
            this.cupContinueCount = 0;
        }
        if (flag != 5) {
            this.cherryContinueCount = 0;
        }
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                if (this.isGt) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    ((AbstractMainBoard)this).currentFlag = 8;
                } else if (random128 < 22) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    ((AbstractMainBoard)this).currentFlag = 8;
                } else if (random128 < 23) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    if (SimulatorLibrary.random((int)1) == 0) {
                        this.isSuperHigh = true;
                        this.fireEvent(28);
                    }
                    ((AbstractMainBoard)this).currentFlag = 10;
                } else {
                    this.cupContinueCount = 0;
                }
                if (this.cupContinueCount != 3) break;
                this.fireEvent(33);
                if (SimulatorLibrary.random((int)128) < 64) {
                    this.isBreak = true;
                    this.breakFactor = 11;
                }
                this.cupContinueCount = 0;
                break;
            }
            case 5: {
                int gtCount;
                this.fireCoinPlus(2);
                ++this.cherryContinueCount;
                if (this.cherryContinueCount != 2) break;
                this.cherryContinueCount = 0;
                int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 1;
                this.fireEvent(25);
                break;
            }
            case 6: {
                if (random128 < 41) {
                    this.fireEvent(32);
                    random256 = SimulatorLibrary.random((int)256);
                    int gtCount = 0;
                    int gtHitRatio = 0;
                    gtHitRatio = this.isSuperHigh ? this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][0] : (this.isHigh ? this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][1] : this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][2]);
                    if (random256 < gtHitRatio) {
                        int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableSuperHigh[((AbstractMainBoard)this).settei - 1], (int)1024);
                        gtCount = this.gtRenTable[index];
                        this.gtRenCount += gtCount;
                        this.currentGtHitCount = gtCount;
                        this.gtFactor = 0;
                        this.fireEvent(25);
                    }
                    ((AbstractMainBoard)this).currentFlag = 7;
                    break;
                }
                this.fireCoinPlus(5);
                break;
            }
            case 1: {
                if (this.isGt && this.isBreak) {
                    if (random128 < 33) {
                        this.isReplay = true;
                        ((AbstractMainBoard)this).currentFlag = 9;
                        break;
                    }
                    this.bonusGet();
                    this.fireCoinPlus(15);
                    break;
                }
                if (this.isGt) {
                    this.isReplay = true;
                    ((AbstractMainBoard)this).currentFlag = 9;
                    break;
                }
                if (this.isBreak) {
                    if (random128 < 33) {
                        this.isReplay = true;
                        ((AbstractMainBoard)this).currentFlag = 9;
                        break;
                    }
                    this.bonusGet();
                    this.fireCoinPlus(15);
                    break;
                }
                if (random128 >= 33) break;
                this.isReplay = true;
                ((AbstractMainBoard)this).currentFlag = 9;
            }
        }
        this.fireEvent(0);
    }

    public void gameNotRt(int flag) {
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        } else {
            this.isReplay = false;
        }
        int random256 = SimulatorLibrary.random((int)256);
        if (random256 < 5) {
            if (this.isSuperHigh) {
                this.isSuperHigh = false;
                this.fireEvent(29);
                if (this.isHigh) {
                    this.fireEvent(30);
                }
            } else if (this.isHigh) {
                this.isHigh = false;
                this.fireEvent(31);
            }
        }
        if (this.gtRenCount > 0 && !this.isGt && (random256 = SimulatorLibrary.random((int)256)) < 15) {
            this.isGt = true;
            this.gtGameCounter = 0;
            --this.gtRenCount;
            random256 = SimulatorLibrary.random((int)256);
            this.gtFloor = random256 < this.gtGameCountTable[0] ? 30 : (random256 < this.gtGameCountTable[0] + this.gtGameCountTable[1] ? 50 : 100);
            this.fireEvent(26);
        }
        if (this.isGt) {
            ++this.gtGameCounter;
            if (this.gtGameCounter >= this.gtFloor) {
                this.isGt = false;
                this.gtFloor = -1;
                this.fireEvent(27);
            }
        }
        int random128 = SimulatorLibrary.random((int)128);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        if (flag != 4) {
            this.cupContinueCount = 0;
        }
        if (flag != 5) {
            this.cherryContinueCount = 0;
        }
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                if (this.isGt) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    ((AbstractMainBoard)this).currentFlag = 8;
                    break;
                }
                if (random128 < 22) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    ((AbstractMainBoard)this).currentFlag = 8;
                    break;
                }
                if (random128 < 23) {
                    this.fireCoinPlus(12);
                    ++this.cupContinueCount;
                    if (SimulatorLibrary.random((int)1) == 0) {
                        this.isSuperHigh = true;
                        this.fireEvent(28);
                    }
                    ((AbstractMainBoard)this).currentFlag = 10;
                    break;
                }
                this.cupContinueCount = 0;
                break;
            }
            case 5: {
                int gtCount;
                this.fireCoinPlus(2);
                ++this.cherryContinueCount;
                if (this.cherryContinueCount != 2) break;
                this.cherryContinueCount = 0;
                int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 1;
                this.fireEvent(25);
                break;
            }
            case 6: {
                if (random128 < 41) {
                    this.fireEvent(32);
                    random256 = SimulatorLibrary.random((int)256);
                    int gtCount = 0;
                    int gtHitRatio = 0;
                    gtHitRatio = this.isSuperHigh ? this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][0] : (this.isHigh ? this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][1] : this.gtHitRatioTable[((AbstractMainBoard)this).settei - 1][2]);
                    if (random256 < gtHitRatio) {
                        int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableSuperHigh[((AbstractMainBoard)this).settei - 1], (int)1024);
                        gtCount = this.gtRenTable[index];
                        this.gtRenCount += gtCount;
                        this.currentGtHitCount = gtCount;
                        this.gtFactor = 0;
                        this.fireEvent(25);
                    }
                    ((AbstractMainBoard)this).currentFlag = 7;
                    break;
                }
                this.fireCoinPlus(5);
                break;
            }
            case 1: {
                if (this.isGt && this.isBreak) {
                    if (random128 >= 33) break;
                    this.isReplay = true;
                    ((AbstractMainBoard)this).currentFlag = 9;
                    break;
                }
                if (this.isGt) {
                    this.isReplay = true;
                    ((AbstractMainBoard)this).currentFlag = 9;
                    break;
                }
                if (this.isBreak) {
                    if (random128 >= 33) break;
                    this.isReplay = true;
                    ((AbstractMainBoard)this).currentFlag = 9;
                    break;
                }
                if (random128 >= 33) break;
                this.isReplay = true;
                ((AbstractMainBoard)this).currentFlag = 9;
            }
        }
        this.fireEvent(0);
    }

    public int getMaxBigGameCount() {
        return 20;
    }

    public int getMaxJacInCount() {
        return 2;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        int index = 0;
        int gtCount = 0;
        switch (flag) {
            case 0: {
                index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 4;
                this.fireEvent(25);
                break;
            }
            case 1: {
                if (game == 11 || game == 20) {
                    this.fireCoinPlus(1);
                    this.setJacIn();
                    break;
                }
                this.fireCoinPlus(11);
                break;
            }
            case 2: {
                this.fireCoinPlus(2);
                index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 2;
                this.fireEvent(25);
                break;
            }
            case 3: {
                this.fireCoinPlus(5);
                index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 3;
                this.fireEvent(25);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                int gtCount;
                int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
                this.currentGtHitCount = gtCount = this.gtRenTable[index];
                this.gtRenCount += gtCount;
                this.gtFactor = 5;
                this.fireEvent(25);
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        int random128;
        this.isBreak = false;
        int oldBonus = this.nextBonus;
        if (oldBonus == 4 && (random128 = SimulatorLibrary.random((int)128)) == 0) {
            int gtCount;
            int index = SimulatorLibrary.getTableIndex((int[])this.gtRenTableLow[((AbstractMainBoard)this).settei - 1], (int)1024);
            this.currentGtHitCount = gtCount = this.gtRenTable[index];
            this.gtRenCount += gtCount;
            this.gtFactor = 6;
            this.fireEvent(25);
        }
        if (this.stock.size() > 0) {
            this.nextBonus = SimulatorLibrary.random((int)256) < 154 ? 3 : 4;
            int index = 0;
            boolean exists = false;
            index = 0;
            while (index < this.stock.size()) {
                if ((Integer)this.stock.get(index) == this.nextBonus) {
                    exists = true;
                    break;
                }
                ++index;
            }
            if (exists) {
                this.stock.remove(index);
            } else {
                System.out.print(this.nextBonus + "\u304c\u898b\u3064\u304b\u3089\u306a\u3044\uff01");
                int i = 0;
                while (i < 100 && i < this.stock.size()) {
                    if ((Integer)this.stock.get(i) == 3) {
                        System.out.print("B");
                    } else {
                        System.out.print("R");
                    }
                    ++i;
                }
                System.out.println();
                this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
                this.stock.remove(0);
            }
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
        this.cherryContinueCount = 0;
        this.cupContinueCount = 0;
        if (this.isSuperHigh) {
            this.isSuperHigh = false;
            this.fireEvent(29);
        }
        if (this.isHigh) {
            this.isHigh = false;
            this.fireEvent(31);
        }
        if (oldBonus == 3) {
            this.isHigh = true;
            this.fireEvent(30);
        }
    }

    private int _getRtFloor() {
        int index = -1;
        int min = -1;
        int max = -1;
        if (this.nextBonus == 3) {
            index = SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)256);
            min = this.rtG1[0][index];
            max = this.rtG1[1][index];
        } else {
            index = SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)256);
            min = this.rtG2[0][index];
            max = this.rtG2[1][index];
        }
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    public int getGtFloor() {
        return this.gtFloor;
    }

    public int getGtGameCounter() {
        return this.gtGameCounter;
    }

    public int getGtRenCount() {
        return this.gtRenCount;
    }

    public boolean isGt() {
        return this.isGt;
    }

    public boolean isHigh() {
        return this.isHigh;
    }

    public boolean isSuperHigh() {
        return this.isSuperHigh;
    }

    public int getGtFactor() {
        return this.gtFactor;
    }

    public int getCurrentGtHitCount() {
        return this.currentGtHitCount;
    }
}

