/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Doronjo;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.machines.Doronjo.DoronjoMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class DoronjoDataCounter
extends AbstractDataCounter {
    private JCheckBoxMenuItem highReport = null;
    private JCheckBoxMenuItem dbPlusReport = null;
    private int[] dbCount = new int[]{0, 0, 0};
    private int[] sdbCount = new int[]{0, 0, 0};
    private int normalGameCount = 0;
    private int highGameCount = 0;
    private int renGameCount = 0;
    private int currentDbHitMode = 0;

    public static final void main(String[] args) {
        DoronjoDataCounter main = null;
        try {
            main = new DoronjoDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public DoronjoDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel northPanel) {
        this.highReport = new JCheckBoxMenuItem("\u9ad8\u78ba\u60c5\u5831\u8868\u793a", false);
        this.dbPlusReport = new JCheckBoxMenuItem("DB\u4e2d\u4e0a\u4e57\u305b\u8868\u793a", true);
        this.addOptionMenu(this.highReport);
        this.addOptionMenu(this.dbPlusReport);
    }

    protected String getFrameTitle() {
        return "\u30c9\u30ed\u30f3\u30b8\u30e7\u306b\u304a\u307e\u304b\u305b\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new DoronjoMainBoard();
    }

    protected void processEvent(int event) {
        int dbType = 0;
        switch (event) {
            case 29: {
                int mode;
                dbType = ((DoronjoMainBoard)this.simulator).getDbType();
                this.currentDbHitMode = mode = ((DoronjoMainBoard)this.simulator).getMode();
                int index = -1;
                if (mode == 1) {
                    index = 0;
                } else if (mode <= 3) {
                    index = 1;
                } else if (mode <= 5) {
                    index = 2;
                }
                if (dbType == 1) {
                    int n = index;
                    this.dbCount[n] = this.dbCount[n] + 1;
                    break;
                }
                int n = index;
                this.sdbCount[n] = this.sdbCount[n] + 1;
                break;
            }
            case 21: 
            case 22: {
                dbType = ((DoronjoMainBoard)this.simulator).getDbType();
                this.logDb(event, dbType);
                break;
            }
            case 27: 
            case 28: {
                this.logFloorAt(event);
                break;
            }
            case 25: 
            case 26: {
                this.logHigh(event);
                break;
            }
            case 23: 
            case 24: {
                this.logDbPlus(event);
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\tBIG(");
        this.appendLog(String.valueOf(this.currentBonusCoin));
        this.appendLog(")\t");
        this.appendLog(String.valueOf(this.getCoin()));
        this.appendLog("\n");
    }

    protected void logDbPlus(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.dbPlusReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]\t");
        if (event == 23) {
            this.appendLog("[100");
        } else {
            this.appendLog("[500");
        }
        this.appendLog("G\u4e0a\u4e57\u305b]\n");
    }

    protected void logHigh(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.highReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]\t\u9ad8\u78ba");
        if (event == 25) {
            this.appendLog("\u958b\u59cb");
        } else {
            this.appendLog("\u7d42\u4e86");
        }
        this.appendLog("\n");
    }

    protected void logDb(int event, int dbType) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        int floorAtFloor = ((DoronjoMainBoard)this.simulator).getFloorAtFloor();
        int dbFloor = ((DoronjoMainBoard)this.simulator).getDbFloor();
        int mode = ((DoronjoMainBoard)this.simulator).getMode();
        if (dbType == 1) {
            this.appendLog("DB");
        } else {
            this.appendLog("SDB");
        }
        if (event == 21) {
            this.appendLog(String.valueOf(dbFloor));
            this.appendLog("\t\u958b\u59cb");
            switch (this.currentDbHitMode) {
                case 5: {
                    this.appendLog("(75%\u9023)");
                    break;
                }
                case 4: {
                    this.appendLog("(50%\u9023)");
                    break;
                }
                case 1: {
                    this.appendLog("(\u901a\u5e38)");
                    break;
                }
                case 2: {
                    this.appendLog("(\u9ad8\u78baA)");
                    break;
                }
                case 3: {
                    this.appendLog("(\u9ad8\u78baB)");
                }
            }
        } else {
            this.appendLog("\t\u7d42\u4e86");
            switch (mode) {
                case 5: {
                    this.appendLog("(75%\u9023)");
                    break;
                }
                case 4: {
                    this.appendLog("(50%\u9023)");
                    break;
                }
                default: {
                    this.appendLog("(\u901a\u5e38)");
                }
            }
        }
        this.appendLog("\t");
        this.appendLog(String.valueOf(this.getCoin()));
        this.appendLog("\n");
    }

    protected void logFloorAt(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        int floorAtFloor = ((DoronjoMainBoard)this.simulator).getFloorAtFloor();
        this.appendLog("\u5929\u4e95AT");
        if (event == 27) {
            if (floorAtFloor > 100) {
                this.appendLog("(\u30dc\u30fc\u30ca\u30b9\u307e\u3067");
            } else {
                this.appendLog("(");
                this.appendLog(String.valueOf(floorAtFloor));
            }
            this.appendLog(")\t\u958b\u59cb");
        } else {
            this.appendLog("\t\u7d42\u4e86");
        }
        this.appendLog("\t");
        this.appendLog(String.valueOf(this.getCoin()));
        this.appendLog("\n");
    }

    protected void eventStart() {
        if (!((DoronjoMainBoard)this.simulator).isDb()) {
            int mode = ((DoronjoMainBoard)this.simulator).getMode();
            if (mode >= 4) {
                ++this.renGameCount;
            } else if (mode >= 2) {
                ++this.highGameCount;
            } else {
                ++this.normalGameCount;
            }
        }
    }

    protected void eventSimulateStart() {
        this.dbCount[0] = 0;
        this.dbCount[1] = 0;
        this.dbCount[2] = 0;
        this.sdbCount[0] = 0;
        this.sdbCount[1] = 0;
        this.sdbCount[2] = 0;
        this.normalGameCount = 0;
        this.highGameCount = 0;
        this.renGameCount = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("DB", this.dbCount[0] + this.dbCount[1] + this.dbCount[2], this.getTotalGameCount());
        this.appendLogDenominator("SDB", this.sdbCount[0] + this.sdbCount[1] + this.sdbCount[2], this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLogDenominator("[S]DB(\u901a\u5e38)", this.dbCount[0] + this.sdbCount[0], this.normalGameCount);
        this.appendLogDenominator("[S]DB(\u9ad8\u78ba)", this.dbCount[1] + this.sdbCount[1], this.highGameCount);
        this.appendLogDenominator("[S]DB(\u9023)", this.dbCount[2] + this.sdbCount[2], this.renGameCount);
        this.appendLogPayout();
    }
}

