/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Yoshimune;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.Yoshimune.YoshimuneMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class YoshimuneDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem rt1G = null;
    protected JCheckBoxMenuItem spzReport = null;
    private int bonusCoin = 0;
    private StringBuffer bonusInfo = new StringBuffer();

    public static final void main(String[] args) {
        YoshimuneDataCounter main = null;
        try {
            main = new YoshimuneDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public YoshimuneDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.rt1G = new JCheckBoxMenuItem("1G\u9023\u306e\u30c8\u30ea\u30ac\u8868\u793a");
        this.spzReport = new JCheckBoxMenuItem("SP\u30be\u30fc\u30f3\u60c5\u5831\u8868\u793a");
        this.addOptionMenu(this.rt1G);
        this.addOptionMenu(this.spzReport);
        this.textInitialStock.setText("20");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u5409\u5b97\u30b7\u30df\u30e5\u30ec\u30fc\u30bf";
    }

    protected MainBoardInterface getSimulator() {
        return new YoshimuneMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 23: {
                this.eventRtStart();
                break;
            }
            case 21: {
                this.eventSpz(eventId);
                break;
            }
            case 22: {
                this.eventSpz(eventId);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.event1GRen(eventId);
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.bonusCoin = this.getCoin();
        this.bonusInfo = null;
        this.bonusInfo = new StringBuffer();
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.bonusCoin = this.getCoin() - this.bonusCoin;
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("\tBIG[" + this.bonusCoin + "]");
        } else {
            this.appendLog("\tREG");
        }
        this.appendLog("\t");
        int breakFactor = ((YoshimuneMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("RT\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 15: {
                this.appendLog("\u5185\u90e8BIG");
                break;
            }
            case 16: {
                this.appendLog("\u5185\u90e8REG");
                break;
            }
            case 13: {
                this.appendLog("\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 14: {
                this.appendLog("\u677e");
                break;
            }
            case 17: {
                this.appendLog("1G\u9023");
            }
        }
        int mode = ((YoshimuneMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode();
        this.appendLog("\tM" + String.valueOf(mode));
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
        if (this.rt1G.isSelected()) {
            this.appendLog(this.bonusInfo.toString());
        }
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
    }

    protected void event1GRen(int eventId) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.rt1G.isSelected()) {
            return;
        }
        this.bonusInfo.append(String.valueOf("\t"));
        switch (eventId) {
            case 31: {
                this.bonusInfo.append("\u30c0\u30d6\u30eb7");
                break;
            }
            case 32: {
                this.bonusInfo.append("\u5c0f\u5f79G\u30cf\u30ba\u30ec");
                break;
            }
            case 30: {
                this.bonusInfo.append("\u30b7\u30f3\u30b0\u30eb7");
                break;
            }
            case 33: {
                this.bonusInfo.append("JAC\u30cf\u30ba\u30ec");
                break;
            }
            case 34: {
                this.bonusInfo.append("\u4ff58\u9023");
                break;
            }
            case 35: {
                this.bonusInfo.append("0\u30d1\u30f3");
                break;
            }
            case 36: {
                this.bonusInfo.append("1\u30d1\u30f3");
                break;
            }
            case 37: {
                this.bonusInfo.append("2\u30d1\u30f3");
            }
        }
        this.bonusInfo.append("\n");
    }

    protected void eventSpz(int eventId) {
        if (!this.spzReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        if (eventId == 21) {
            this.appendLog("\tSPZ\u958b\u59cb");
            int rtFloor = ((YoshimuneMainBoard)((AbstractDataCounter)this).simulator).getSpzFloor();
            this.appendLog("\tG=" + rtFloor);
        } else {
            this.appendLog("\tSPZ\u7d42\u4e86");
        }
        this.appendLog("\n");
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

