/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Yoshimune;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class YoshimuneMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_SPZ_START = 21;
    public static final int EVENT_SPZ_END = 22;
    public static final int EVENT_BIG_SINGLE7 = 30;
    public static final int EVENT_BIG_DOUBLE7 = 31;
    public static final int EVENT_BIG_NOFLAG = 32;
    public static final int EVENT_JAC_NOFLAG = 33;
    public static final int EVENT_JAC_TAWARA8 = 34;
    public static final int EVENT_BIG_0P = 35;
    public static final int EVENT_BIG_1P = 36;
    public static final int EVENT_BIG_2P = 37;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int BREAK_CHERRY = 13;
    public static final int BREAK_MATSU = 14;
    public static final int BREAK_BIG = 15;
    public static final int BREAK_REG = 16;
    public static final int BREAK_1G = 17;
    protected boolean stateSpz = false;
    protected int spzCounter = 0;
    protected int spzFloor = 0;
    public static final int FLAG_TAWARA = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_MATSU = 6;
    protected int[][] flagTable = new int[][]{{20, 57556, 270, 270, 5900, 800, 720}, {18, 57556, 271, 271, 5900, 800, 720}, {26, 57546, 272, 272, 5900, 800, 720}, {38, 57532, 273, 273, 5900, 800, 720}, {45, 57523, 274, 274, 5900, 800, 720}, {60, 57506, 275, 275, 5900, 800, 720}};
    public static final int FLAG_BIG_TAWARA = 2;
    public static final int FLAG_BIG_MATSU = 3;
    protected int[][] flagTableBig = new int[][]{{3, 14564, 50584, 385}, {3, 14564, 50584, 385}, {3, 14564, 50584, 385}, {3, 14564, 50584, 385}, {3, 14564, 50584, 385}, {3, 14564, 50584, 385}};
    protected int[][] flagTableJac = new int[][]{{50, 65486}, {50, 65486}, {50, 65486}, {50, 65486}, {50, 65486}, {50, 65486}};
    private int[][][] rtTable = new int[][][]{new int[][]{{50, 200, 200, 200, 20, 20, 20, 100, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 886}, {50, 200, 200, 200, 20, 20, 20, 100, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 886}, {50, 200, 200, 200, 20, 20, 20, 100, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 886}, {50, 120, 120, 120, 200, 200, 20, 120, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 746}, {50, 120, 120, 120, 200, 200, 20, 120, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 746}, {50, 120, 120, 120, 200, 200, 20, 120, 20, 0, 450, 20, 20, 20, 0, 20, 500, 20, 20, 0, 20, 550, 20, 20, 700, 746}}, new int[][]{{50, 250, 250, 250, 50, 50, 20, 100, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 746}, {50, 250, 250, 250, 50, 50, 20, 100, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 746}, {50, 250, 250, 250, 50, 50, 20, 100, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 746}, {50, 120, 120, 120, 250, 250, 20, 120, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 716}, {50, 120, 120, 120, 250, 250, 20, 120, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 716}, {50, 120, 120, 120, 250, 250, 20, 120, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 716}, {50, 120, 120, 120, 250, 250, 20, 120, 20, 450, 0, 20, 20, 20, 500, 20, 0, 20, 20, 550, 20, 0, 20, 450, 200, 716}}, new int[][]{{96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {96, 750, 750, 750, 750, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}};
    private int[][] rtTableRange = new int[][]{{0, 2, 34, 66, 98, 130, 194, 258, 386, 402, 502, 514, 642, 770, 802, 898, 902, 1026, 1154, 1202, 1282, 1302, 1410, 1538, 1666, 1794}, {1, 33, 65, 97, 129, 193, 257, 385, 513, 465, 565, 641, 769, 897, 865, 1025, 965, 1153, 1281, 1265, 1409, 1365, 1537, 1665, 1793, 1921}};
    private int[][][] modeTable = new int[][][]{new int[][]{{8, 108, 12}, {8, 101, 19}, {8, 93, 27}, {8, 92, 28}, {8, 94, 26}, {8, 90, 30}}, new int[][]{{85, 8, 35}, {77, 8, 43}, {82, 8, 38}, {56, 8, 64}, {78, 8, 42}, {56, 8, 64}}, new int[][]{{55, 35, 38}, {44, 28, 56}, {50, 40, 38}, {53, 31, 44}, {49, 37, 42}, {47, 31, 50}}};
    private int[][][] bonusKind = new int[][][]{new int[][]{{78, 50}, {82, 46}, {76, 52}, {78, 50}, {76, 52}, {78, 50}}, new int[][]{{38, 90}, {42, 86}, {50, 78}, {38, 90}, {50, 78}, {38, 90}}, new int[][]{{96, 32}, {78, 50}, {96, 32}, {78, 50}, {96, 32}, {78, 50}}};
    int[] spGameTable = new int[]{8, 3, 3, 2};
    int[] spGameCount = new int[]{20, 40, 50, 60};
    private int shiftCount = 0;
    private int shiftJacInCount = 0;
    private int big1gRenNaviCount = 0;
    private int big1gRenCount = 0;
    private boolean limitter = false;
    private int tawara8renCount = 0;

    public int getSpzFloor() {
        return this.spzFloor;
    }

    public void bigGame(int flag, int game, int jacInCount) {
        if (game == 1) {
            this.shiftCount = 0;
            this.shiftJacInCount = 0;
        }
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                this.fireCoinPlus(15);
                ++this.shiftCount;
                if (game <= 27 || this.shiftCount <= 0) break;
                this.setJacIn();
                this.tawara8renCount = 0;
                ++this.shiftJacInCount;
                --this.shiftCount;
                break;
            }
            case 3: {
                this.fireCoinPlus(15);
                if (SimulatorLibrary.random((int)8) == 0) {
                    this.fireEvent(31);
                    this.big1gRenNaviCount += 2;
                } else {
                    this.fireEvent(30);
                    ++this.big1gRenNaviCount;
                }
                if (game <= 27 || this.shiftCount <= 0) break;
                this.setJacIn();
                this.tawara8renCount = 0;
                ++this.shiftJacInCount;
                --this.shiftCount;
                break;
            }
            case 2: {
                this.fireCoinPlus(15);
                if (game <= 27 || this.shiftCount <= 0) break;
                this.setJacIn();
                this.tawara8renCount = 0;
                ++this.shiftJacInCount;
                --this.shiftCount;
                break;
            }
            case 0: {
                this.fireEvent(32);
                this.big1gRenNaviCount += 3;
                if (game <= 27 || this.shiftCount <= 0) break;
                this.setJacIn();
                this.tawara8renCount = 0;
                this.fireCoinPlus(15);
                ++this.shiftJacInCount;
                --this.shiftCount;
            }
        }
        if (game == 30 && this.shiftJacInCount < 3) {
            if (this.shiftJacInCount == 0) {
                this.fireEvent(35);
                this.big1gRenNaviCount += 3;
            } else if (this.shiftJacInCount == 1) {
                this.fireEvent(36);
                this.big1gRenNaviCount += 2;
            } else if (this.shiftJacInCount == 2) {
                this.fireEvent(37);
                ++this.big1gRenNaviCount;
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        if (gameCount == 0) {
            this.tawara8renCount = 0;
        }
        switch (flag) {
            case 1: {
                this.tawara8renCount = SimulatorLibrary.random((int)2) < 1 ? ++this.tawara8renCount : 0;
                this.setJacHit();
                this.fireCoinPlus(15);
                break;
            }
            case 0: {
                ++this.big1gRenNaviCount;
                this.fireEvent(33);
            }
        }
        if (gameCount >= 8 && this.tawara8renCount == 8) {
            this.fireEvent(34);
            ++this.big1gRenNaviCount;
        }
    }

    public void gameRt(int flag) {
        ++this.spzCounter;
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        if (this.spzCounter >= this.spzFloor && this.stateSpz) {
            this.stateSpz = false;
            this.fireEvent(22);
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        int random256 = SimulatorLibrary.random((int)256);
        switch (flag) {
            case 0: {
                if (this.rtFloor - this.rtCounter > 33) {
                    this.rtFloor = this.rtCounter + 33;
                }
                this.breakFactor = -11;
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                if (random4096 >= 165) break;
                if (this.rtFloor - this.rtCounter > 33) {
                    this.rtFloor = this.rtCounter + 4;
                }
                this.breakFactor = 15;
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                if (random4096 >= 166) break;
                if (this.rtFloor - this.rtCounter > 33) {
                    this.rtFloor = this.rtCounter + 2;
                }
                this.breakFactor = 16;
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                if (random4096 >= 111) break;
                if (this.rtFloor - this.rtCounter > 33) {
                    this.rtFloor = this.rtCounter + SimulatorLibrary.getRandomPerRange((int)2, (int)5);
                }
                this.breakFactor = 13;
                break;
            }
            case 6: {
                this.fireCoinPlus(5);
                if (random4096 >= 25) break;
                if (this.rtFloor - this.rtCounter > 33) {
                    this.rtFloor = this.rtCounter + 2;
                }
                this.breakFactor = 14;
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 1: {
                if (random4096 < 649) {
                    ((AbstractMainBoard)this).isReplay = true;
                } else if (this.isBreak) {
                    this.bonusGet();
                    this.fireCoinPlus(15);
                }
                if (this.isBreak || random256 >= 1 || this.stateSpz) break;
                this.stateSpz = true;
                this.spzFloor = this._getSpzFloor();
                this.spzCounter = 0;
                this.fireEvent(21);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        int random256 = SimulatorLibrary.random((int)256);
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(5);
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 1: {
                if (random4096 >= 649) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        this.noStock = this.stock.size() <= 0;
        if (!this.noStock) {
            this.currentMode = this.breakFactor == 14 || this.stateSpz ? 3 : this._getNextMode();
            if (this.stateSpz) {
                this.stateSpz = false;
                this.fireEvent(22);
            }
            if (this.big1gRenNaviCount > 0) {
                this.nextBonus = this._getNextBonus(true);
                --this.big1gRenNaviCount;
                this.rtFloor = 0;
                this.breakFactor = 17;
            } else {
                this.nextBonus = this._getNextBonus(false);
                this.rtFloor = this._getRtFloor();
                this.breakFactor = -10;
            }
            this.rtCounter = 0;
            this.spzCounter = 0;
            super.reset();
            this.fireEvent(23);
        } else {
            this.currentMode = -1;
            this.nextBonus = -1;
            this.rtCounter = 0;
            this.spzCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    private int _getSpzFloor() {
        int index = SimulatorLibrary.getTableIndex((int[])this.spGameTable, (int)16);
        return this.spGameCount[index];
    }

    private int _getRtFloor() {
        int index = SimulatorLibrary.getTableIndex((int[])this.rtTable[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)4096);
        int g = SimulatorLibrary.getRandomPerRange((int)this.rtTableRange[0][index], (int)this.rtTableRange[1][index]);
        return g;
    }

    private int _getNextMode() {
        if (this.currentMode < 1) {
            return 1;
        }
        int index = -1;
        index = SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)128);
        return index + 1;
    }

    private int _getNextBonus(boolean is1gren) {
        int next = -1;
        next = is1gren ? 3 : (SimulatorLibrary.random((int)128) < this.bonusKind[this.currentMode - 1][((AbstractMainBoard)this).settei - 1][0] ? 3 : 4);
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }
}

