/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Umi1ban;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class Umi1banMainBoard
extends AbstractMainBoard4Stock {
    public static final int BREAK_REPLAY = 20;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int MODE_6 = 6;
    public static final int MODE_7 = 7;
    private boolean isZentyou = false;
    private int zentyouFloor = -1;
    private int zentyouCounter = 0;
    public static final int FLAG_SUIKA = 4;
    public static final int FLAG_CHERRY = 5;
    private static final int[][] flagNormal = new int[][]{{1, 14368, 93, 9, 1881, 32}, {1, 14352, 94, 9, 1896, 32}, {1, 14331, 95, 9, 1916, 32}, {1, 14305, 96, 9, 1941, 32}, {1, 14275, 96, 9, 1971, 32}, {1, 14270, 96, 9, 2006, 32}};
    public static final int FLAG_BIG_SUIKA = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    private static final int[][] flagBig = new int[][]{{3282, 4950, 8120, 32}, {3202, 4950, 8200, 32}, {3102, 4950, 8300, 32}, {2952, 4950, 8450, 32}, {2752, 4950, 8650, 32}, {2452, 4950, 8950, 32}};
    private static final int[][] flagJac = new int[][]{{2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}, {2, 16382}};
    private static final int REPLAY_CONTROL_HIT = 0;
    private static final int REPLAY_CONTROL_LUCKY = 1;
    private static final int REPLAY_CONTROL_LUCKY_BREAK = 2;
    private static final int REPLAY_CONTROL_NOT_HIT = 3;
    private static final int[][] replayControlTable = new int[][]{{646, 63, 5, 3382}, {646, 63, 5, 3382}, {646, 63, 45, 3342}, {646, 63, 5, 3382}, {1786, 1121, 180, 1009}, {1786, 1306, 140, 864}, {1786, 1306, 140, 864}};
    private static final int[][][] rtTable4Big = new int[][][]{new int[][]{{1, 0, 1, 3, 6, 3, 4, 7, 12, 0, 10, 10, 20, 12, 28, 13, 20, 0, 24, 22, 36, 24, 0}, {1, 0, 1, 4, 10, 3, 4, 9, 14, 0, 12, 10, 22, 12, 28, 13, 18, 0, 22, 20, 30, 23, 0}, {1, 0, 1, 4, 12, 4, 5, 10, 16, 0, 14, 12, 24, 12, 28, 13, 16, 0, 19, 18, 27, 20, 0}, {1, 0, 1, 4, 13, 5, 6, 11, 20, 0, 15, 12, 26, 13, 27, 12, 15, 0, 17, 16, 26, 16, 0}, {1, 0, 1, 4, 15, 8, 8, 14, 21, 0, 15, 12, 28, 14, 26, 12, 14, 0, 15, 12, 22, 14, 0}, {1, 0, 1, 4, 16, 8, 8, 14, 23, 0, 16, 13, 30, 15, 26, 12, 12, 0, 13, 12, 20, 12, 0}}, new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 109}}, new int[][]{{2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 26, 26, 86, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}};
    private static final int[][] rtTable4Reg = new int[][]{{1, 0, 8, 32, 32, 183}, {1, 0, 8, 32, 32, 183}, {2, 26, 26, 86, 116, 0}, {256, 0, 0, 0, 0, 0}, {16, 16, 224, 0, 0, 0}, {16, 16, 224, 0, 0, 0}, {16, 16, 224, 0, 0, 0}};
    private static final int[][] rtGameRange = new int[][]{{1, 5, 21, 37, 101, 165, 229, 293, 325, 453, 469, 533, 565, 693, 725, 853, 885, 949, 965, 1029, 1061, 1189, 1253}, {4, 20, 36, 100, 164, 228, 292, 324, 452, 468, 532, 564, 692, 724, 852, 884, 948, 964, 1028, 1060, 1188, 1252, 1316}};
    private static final int[][][] modeMoveAfterBig = new int[][][]{new int[][]{{56, 3, 3, 2, 63, 0, 1}, {53, 4, 4, 3, 63, 0, 1}, {53, 4, 4, 3, 63, 0, 1}, {52, 4, 5, 3, 63, 0, 1}, {52, 4, 5, 3, 63, 0, 1}, {52, 4, 5, 3, 63, 0, 1}}, new int[][]{{1, 0, 0, 0, 125, 0, 2}, {1, 0, 0, 0, 125, 0, 2}, {1, 0, 0, 0, 125, 0, 2}, {1, 0, 0, 0, 125, 0, 2}, {1, 0, 0, 0, 125, 0, 2}, {1, 0, 0, 0, 125, 0, 2}}, new int[][]{{54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}}, new int[][]{{54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}}, new int[][]{{54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}, {54, 4, 3, 3, 63, 0, 1}}, new int[][]{{1, 0, 0, 0, 34, 93, 0}, {1, 0, 0, 0, 34, 93, 0}, {1, 0, 0, 0, 34, 93, 0}, {1, 0, 0, 0, 34, 93, 0}, {1, 0, 0, 0, 34, 93, 0}, {1, 0, 0, 0, 34, 93, 0}}, new int[][]{{1, 0, 0, 0, 0, 34, 93}, {1, 0, 0, 0, 0, 34, 93}, {1, 0, 0, 0, 0, 34, 93}, {1, 0, 0, 0, 0, 34, 93}, {1, 0, 0, 0, 0, 34, 93}, {1, 0, 0, 0, 0, 34, 93}}};
    private static final int[][] modeMoveAfterReg = new int[][]{{116, 2, 6, 4, 0, 0, 0}, {116, 2, 6, 4, 0, 0, 0}, {116, 2, 6, 4, 0, 0, 0}, {116, 2, 6, 4, 0, 0, 0}, {0, 0, 0, 0, 127, 1, 0}, {0, 0, 0, 0, 0, 127, 1}, {0, 0, 0, 0, 0, 1, 127}};
    private static final int[] zentyouRt = new int[]{1, 1, 2, 4, 8};

    public int getStockType() {
        return 1;
    }

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        ((AbstractMainBoard)this).isReplay = false;
        if (!this.isBreak && !this.isZentyou) {
            ++this.rtCounter;
            if (this.rtCounter >= this.rtFloor) {
                this.isBreak = true;
                this.breakFactor = -10;
            }
        }
        if (this.isZentyou) {
            ++this.zentyouCounter;
            if (this.zentyouCounter >= this.zentyouFloor) {
                this.isBreak = true;
            }
        }
        switch (flag) {
            case 0: {
                this.isBreak = true;
                this.breakFactor = -11;
                break;
            }
            case 1: {
                int replayControl = SimulatorLibrary.getTableIndex((int[])replayControlTable[this.currentMode - 1], (int)4096);
                if (replayControl == 0) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isZentyou && !this.isBreak && replayControl == 2) {
                    this.isZentyou = true;
                    this.zentyouFloor = SimulatorLibrary.getTableIndex((int[])zentyouRt, (int)16) + 1;
                    this.breakFactor = 20;
                    break;
                }
                if (!this.isBreak) break;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 2: {
                this.stock.add(3);
                break;
            }
            case 3: {
                this.stock.add(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
            }
        }
    }

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        ((AbstractMainBoard)this).isReplay = false;
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                int replayControl = SimulatorLibrary.getTableIndex((int[])replayControlTable[this.currentMode - 1], (int)4096);
                if (replayControl != 0) break;
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 2: {
                this.stock.add(3);
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(4);
                this.reset();
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(2);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (jacInCount >= 2 && game <= 22) break;
                this.fireCoinPlus(1);
                this.setJacIn();
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(2);
            }
        }
    }

    public void reset() {
        if (this.stock.size() > 0) {
            int oldBonus = this.getCurrentBonus();
            this.noStock = false;
            this.nextBonus = this._getNextBonus();
            this.currentMode = this._getNextMode(oldBonus);
            this.rtFloor = this._getRtFloor();
        } else {
            this.noStock = true;
            this.nextBonus = -1;
        }
        this.rtCounter = 0;
        this.isZentyou = false;
        this.zentyouFloor = -1;
        this.zentyouCounter = 0;
        this.isBreak = false;
        ((AbstractMainBoard)this).isBonus = false;
        this.fireEvent(23);
    }

    private int _getNextBonus() {
        int next = -1;
        next = (Integer)this.stock.get(0);
        this.stock.remove(0);
        return next;
    }

    private int _getRtFloor() {
        int floor = -1;
        int index = -1;
        index = this.nextBonus == 3 ? SimulatorLibrary.getTableIndex((int[])rtTable4Big[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)256) : SimulatorLibrary.getTableIndex((int[])rtTable4Reg[this.currentMode - 1], (int)256);
        return SimulatorLibrary.getRandomPerRange((int)rtGameRange[0][index], (int)rtGameRange[1][index]);
    }

    private int _getNextMode(int oldBonus) {
        if (this.currentMode < 1) {
            int random128 = SimulatorLibrary.random((int)128);
            if (random128 < 81) {
                return 1;
            }
            if (random128 < 85) {
                return 2;
            }
            return 3;
        }
        int next = -1;
        int index = -1;
        if (oldBonus == 3) {
            return SimulatorLibrary.getTableIndex((int[])modeMoveAfterBig[this.currentMode - 1][((AbstractMainBoard)this).settei - 1], (int)128) + 1;
        }
        return SimulatorLibrary.getTableIndex((int[])modeMoveAfterReg[((AbstractMainBoard)this).settei - 1], (int)128) + 1;
    }

    public int getRandomMax() {
        return 16384;
    }

    public int[][] getFlagTableHigh() {
        return flagNormal;
    }

    public int[][] getFlagTableBigGame() {
        return flagBig;
    }

    public int[][] getFlagTableBonusGame() {
        return flagJac;
    }
}

