/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Nights;

import java.awt.Window;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractNormalDataCounter;
import jp.sourceforge.slotsimulator.machines.Nights.NightsMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class NightsDataCounter
extends AbstractNormalDataCounter {
    private int hyperCount = 0;
    private int challengeCount = 0;
    private int hyperBonusCoin = 0;
    private int challengeBonusCoin = 0;
    private JCheckBoxMenuItem hzReport = null;

    protected String getFrameTitle() {
        return "\u30ca\u30a4\u30c4\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new NightsMainBoard();
    }

    public NightsDataCounter() {
        this.initialize();
    }

    public static void main(String[] args) {
        NightsDataCounter main = null;
        try {
            main = new NightsDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    protected void eventBonusEnd() {
        boolean isHyper = ((NightsMainBoard)((AbstractDataCounter)this).simulator).isHyper();
        if (isHyper) {
            ++this.hyperCount;
            this.hyperBonusCoin = (int)((long)this.hyperBonusCoin + ((AbstractDataCounter)this).currentBonusCoin);
        } else {
            ++this.challengeCount;
            this.challengeBonusCoin = (int)((long)this.challengeBonusCoin + ((AbstractDataCounter)this).currentBonusCoin);
        }
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (isHyper) {
            this.appendLog("H-BIG");
        } else {
            this.appendLog("C-BIG");
        }
        this.appendLog("(");
        this.appendLog(((AbstractDataCounter)this).currentBonusCoin);
        this.appendLog(")");
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\n");
    }

    protected void eventHz(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.hzReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]\tHZ");
        if (event == 21) {
            this.appendLog("\u958b\u59cb");
        } else {
            this.appendLog("\u7d42\u4e86");
        }
        this.appendLog("\n");
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("H-BIG", this.hyperCount, this.getTotalGameCount());
        this.appendLogDenominator("C-BIG", this.challengeCount, this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount(), this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLog("H-BIG\u7372\u5f97\u5e73\u5747:");
        this.appendLog("\t");
        this.appendLog((double)this.hyperBonusCoin / (double)this.hyperCount);
        this.appendLog("\u679a\n");
        this.appendLog("C-BIG\u7372\u5f97\u5e73\u5747:");
        this.appendLog("\t");
        this.appendLog((double)this.challengeBonusCoin / (double)this.challengeCount);
        this.appendLog("\u679a\n");
        this.appendLogPayout();
    }

    protected void eventSimulateStart() {
        this.hyperCount = 0;
        this.challengeCount = 0;
        this.hyperBonusCoin = 0;
        this.challengeBonusCoin = 0;
    }

    protected void processEvent(int event) {
        switch (event) {
            case 21: 
            case 22: {
                this.eventHz(event);
            }
        }
    }

    protected void initializeGui(JPanel northPanel) {
        super.initializeGui(northPanel);
        this.hzReport = new JCheckBoxMenuItem("\u30cf\u30a4\u30d1\u30fc\u30be\u30fc\u30f3\u8868\u793a");
        this.addOptionMenu(this.hzReport);
    }
}

