/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.NangokuSodati;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class NangokuSodatiMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_0 = 0;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    protected int[][] flagTable = new int[][]{{3, 56332, 386, 275, 8380, 80, 80}, {7, 56198, 386, 275, 8510, 80, 80}, {13, 56062, 386, 275, 8640, 80, 80}, {16, 55929, 386, 275, 8770, 80, 80}, {21, 55748, 386, 321, 8900, 80, 80}, {21, 55583, 386, 356, 9030, 80, 80}};
    protected int[] flagBreak = new int[]{199, 199, 199, 206, 215, 247};
    protected int[][] flagTableBig = new int[][]{{6280, 18250, 40896, 10, 100}, {6280, 18250, 40896, 10, 100}, {6280, 18250, 40896, 10, 100}, {6280, 18250, 40896, 10, 100}, {6280, 18250, 40896, 10, 100}, {6280, 18250, 40896, 10, 100}};
    protected int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    protected int[] rtTable = new int[]{996, 996, 6000, 996, 0, 0};
    private int previousMode = -1;
    protected int[][][] modeTable = new int[][][]{new int[][]{{140, 108, 5, 0, 0, 3}, {128, 120, 5, 0, 0, 3}, {140, 108, 5, 0, 0, 3}, {109, 139, 5, 0, 0, 3}, {52, 196, 5, 0, 0, 3}, {40, 208, 5, 0, 0, 3}}, new int[][]{{0, 178, 0, 26, 52, 0}, {0, 172, 0, 32, 52, 0}, {0, 160, 0, 39, 57, 0}, {0, 136, 0, 56, 64, 0}, {0, 106, 0, 64, 86, 0}, {0, 40, 0, 24, 192, 0}}, new int[][]{{0, 0, 102, 0, 154, 0}, {0, 0, 102, 0, 154, 0}, {0, 0, 102, 0, 154, 0}, {0, 0, 102, 0, 154, 0}, {0, 0, 102, 0, 154, 0}, {0, 0, 102, 0, 154, 0}}, new int[][]{{0, 0, 0, 115, 141, 0}, {0, 0, 0, 115, 141, 0}, {0, 0, 0, 105, 151, 0}, {0, 0, 0, 92, 164, 0}, {0, 0, 0, 64, 192, 0}, {0, 0, 0, 40, 216, 0}}, new int[][]{{46, 30, 10, 0, 0, 170}, {50, 16, 20, 0, 0, 170}, {46, 30, 10, 0, 0, 170}, {50, 16, 20, 0, 0, 170}, {50, 26, 10, 0, 0, 170}, {20, 8, 10, 0, 0, 218}}, new int[][]{{30, 24, 10, 0, 192, 0}, {36, 12, 16, 0, 192, 0}, {19, 22, 10, 0, 205, 0}, {25, 10, 16, 0, 205, 0}, {48, 18, 10, 0, 180, 0}, {200, 14, 16, 0, 26, 0}}};
    private boolean firstRun = true;

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getStockType() {
        return 1;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            this.isBreak = true;
        }
        if (SimulatorLibrary.random((int)65536) < this.flagBreak[((AbstractMainBoard)this).settei - 1]) {
            this.isBreak = true;
        }
        switch (flag) {
            case 0: {
                this.bonusGet();
                this.fireCoinPlus(15);
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 653) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (this.isBreak) {
                    this.bonusGet();
                    this.fireCoinPlus(15);
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 6: {
                this.fireCoinPlus(2);
                break;
            }
            case 5: {
                this.fireCoinPlus(5);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 653) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 6: {
                this.fireCoinPlus(2);
                break;
            }
            case 5: {
                this.fireCoinPlus(5);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (jacInCount >= 2 && game < 22) break;
                this.setJacIn();
                this.fireCoinPlus(5);
                break;
            }
            case 2: {
                this.fireCoinPlus(7);
                break;
            }
            case 4: {
                this.fireCoinPlus(2);
                break;
            }
            case 3: {
                this.fireCoinPlus(5);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void setup() {
        this.currentMode = 1;
        this.nextBonus = -1;
        this.firstRun = true;
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            if (!this.firstRun) {
                this.currentMode = this._getNextMode();
            }
            this.rtFloor = this.rtTable[this.currentMode];
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.currentMode = 1;
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
        this.firstRun = false;
    }

    private int _getNextMode() {
        if (this.currentMode < 0) {
            return 1;
        }
        return SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)256);
    }

    public int getPreviousMode() {
        return this.previousMode;
    }
}

