/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.MahouBisukasu;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class MahouBisukasuMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_0 = 0;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int BREAK_NORMAL = 10;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    public static final int FLAG_REPLAY2 = 7;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    protected int[][] flagTable = new int[][]{{1, 2245, 82, 50, 2048, 128, 64, 11766}, {1, 2245, 82, 51, 2048, 128, 64, 11765}, {1, 2245, 82, 52, 2048, 128, 64, 11764}, {1, 2245, 82, 53, 2048, 128, 64, 11763}, {1, 2245, 82, 54, 2048, 128, 64, 11762}, {1, 2245, 82, 55, 2048, 128, 64, 11761}};
    protected int[] flagBreak = new int[]{128, 64, 32, 2, 512, 512};
    protected int[][] flagTableBig = new int[][]{{1624, 4850, 8200, 1700, 10}, {1574, 4850, 8250, 1700, 10}, {1524, 4850, 8300, 1700, 10}, {1474, 4850, 8350, 1700, 10}, {1324, 4850, 8500, 1700, 10}, {1024, 4850, 8800, 1700, 10}};
    protected int[][] flagTableJac = new int[][]{{1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}};
    private int previousMode = -1;
    protected int[][][] modeTable = new int[][][]{new int[][]{{150, 150, 220, 440, 63, 1}, {233, 233, 154, 308, 95, 1}, {292, 292, 104, 208, 127, 1}, {343, 343, 70, 140, 127, 1}, {370, 370, 52, 104, 127, 1}, {512, 256, 127, 1, 127, 1}, {0, 0, 0, 0, 1024, 0}}, new int[][]{{118, 118, 440, 220, 127, 1}, {217, 217, 308, 154, 127, 1}, {292, 292, 208, 104, 127, 1}, {327, 327, 140, 70, 159, 1}, {338, 338, 104, 52, 191, 1}, {512, 256, 127, 1, 127, 1}, {128, 608, 256, 0, 32, 0}}, new int[][]{{512, 256, 0, 0, 254, 2}, {512, 256, 0, 0, 254, 2}, {512, 256, 0, 0, 254, 2}, {512, 256, 0, 0, 254, 2}, {512, 256, 0, 0, 254, 2}, {0, 0, 0, 0, 512, 512}, {128, 736, 128, 0, 32, 0}}, new int[][]{{0, 0, 0, 0, 512, 512}, {0, 0, 0, 0, 512, 512}, {0, 0, 0, 0, 512, 512}, {0, 0, 0, 0, 512, 512}, {0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 0, 1024}, {256, 608, 128, 0, 32, 0}}, new int[][]{{128, 128, 128, 128, 511, 1}, {144, 144, 112, 112, 511, 1}, {160, 160, 96, 96, 511, 1}, {176, 176, 80, 80, 511, 1}, {192, 192, 64, 64, 511, 1}, {512, 256, 127, 1, 127, 1}, {0, 0, 0, 0, 0, 1024}}, new int[][]{{0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 256, 768}, {0, 0, 0, 0, 512, 512}, {0, 0, 0, 0, 0, 1024}}};
    private int zentyouRtFloor = 0;
    private int zentyouRtCounter = 0;
    private boolean firstRun = true;

    public int getRandomMax() {
        return 16384;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getStockType() {
        return 2;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (this.zentyouRtFloor > 0) {
            ++this.zentyouRtCounter;
        }
        if (this.rtCounter > this.rtFloor) {
            if (this.breakFactor == -12) {
                this.breakFactor = -10;
                if (SimulatorLibrary.random((int)1) == 0) {
                    this.zentyouRtFloor = 4;
                    this.zentyouRtCounter = 0;
                }
            }
            this.isBreak = true;
        }
        if (!this.isBreak && SimulatorLibrary.random((int)16384) < this.flagBreak[this.currentMode]) {
            this.breakFactor = 10;
            this.isBreak = true;
            if (SimulatorLibrary.random((int)1) == 0) {
                this.zentyouRtFloor = 4;
                this.zentyouRtCounter = 0;
            }
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                this.breakFactor = 10;
                this.bonusGet();
                this.fireCoinPlus(15);
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 7: {
                if (!this.isBreak || this.zentyouRtFloor > this.zentyouRtCounter) break;
                this.bonusGet();
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 6: {
                this.fireCoinPlus(2);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                this.fireCoinPlus(7);
                break;
            }
            case 6: {
                this.fireCoinPlus(2);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (!this.isHazusi()) {
                    this.setJacIn();
                    this.fireCoinPlus(3);
                    break;
                }
                if (jacInCount >= 2 && game < 21) break;
                this.setJacIn();
                this.fireCoinPlus(3);
                break;
            }
            case 2: {
                this.fireCoinPlus(7);
                break;
            }
            case 4: {
                this.fireCoinPlus(2);
                break;
            }
            case 3: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void setup() {
        this.currentMode = SimulatorLibrary.random((int)1) == 1 ? 0 : 1;
        this.nextBonus = -1;
        this.firstRun = true;
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            if (((AbstractMainBoard)this).settei == 6) {
                this.nextBonus = SimulatorLibrary.random((int)16384) < 10240 ? 3 : 4;
            } else {
                int n = this.nextBonus = SimulatorLibrary.random((int)16384) < 10928 ? 3 : 4;
            }
            if (this.nextBonus == 3 && this.stock.getBigCount() <= 0) {
                this.nextBonus = 4;
            } else if (this.nextBonus == 4 && this.stock.getRegCount() <= 0) {
                this.nextBonus = 3;
            }
            if (this.nextBonus == 3) {
                this.stock.removeBig();
            } else {
                this.stock.removeReg();
            }
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            if (!this.firstRun) {
                this.currentMode = this._getNextMode();
            }
            this.rtFloor = this._getRtFloor();
            this.fireEvent(23);
        } else {
            this.currentMode = SimulatorLibrary.random((int)1) == 1 ? 0 : 1;
        }
        super.reset();
        this.rtCounter = 0;
        this.breakFactor = -12;
        this.firstRun = false;
        this.zentyouRtFloor = 0;
        this.zentyouRtCounter = 0;
    }

    private int _getNextMode() {
        if (this.firstRun) {
            return SimulatorLibrary.random((int)1) == 1 ? 0 : 1;
        }
        if (this.breakFactor == -10) {
            return SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode][6], (int)1024);
        }
        return SimulatorLibrary.getTableIndex((int[])this.modeTable[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)1024);
    }

    private int _getRtFloor() {
        return SimulatorLibrary.getRandomPerRange((int)367, (int)495);
    }

    public int getPreviousMode() {
        return this.previousMode;
    }
}

