/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.MahouBisukasu;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.MahouBisukasu.MahouBisukasuMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;

public class MahouBisukasuDataCounter
extends AbstractDataCounter4Stock {
    int beforeBonusCoin = 0;
    private static final String[] modeNames = new String[]{"\u901a\u5e38A", "\u901a\u5e38B", "\u30c1\u30e3\u30f3\u30b9", "\u5730\u7344", "\u9b54\u6cd5", "\u5927\u9b54\u6cd5"};

    public static final void main(String[] args) {
        MahouBisukasuDataCounter main = null;
        try {
            main = new MahouBisukasuDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public MahouBisukasuDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.textInitialStock.setText("50");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u9b54\u6cd5\u306e\u30cf\u30a4\u30d3\u30b9\u30ab\u30b9\u30b7\u30df\u30e5\u30ec\u30fc\u30bf";
    }

    protected MainBoardInterface getSimulator() {
        return new MahouBisukasuMainBoard();
    }

    public void processEvent(int eventId) {
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.beforeBonusCoin = this.getCoin();
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        int bonusCoin = this.getCoin() - this.beforeBonusCoin;
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + bonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        int mode = ((MahouBisukasuMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode();
        this.appendLog("\t" + modeNames[mode]);
        int breakFactor = ((MahouBisukasuMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("\t\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case 10: {
                this.appendLog("\t\u901a\u5e38\u89e3\u9664");
                break;
            }
            case -11: {
                this.appendLog("\t\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            default: {
                this.appendLog("\t\uff1f\uff1f\uff1f");
            }
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventRtStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int mode = ((MainBoardInterface4Stock)((AbstractDataCounter)this).simulator).getCurrentMode();
        this.appendLog("\tM" + mode);
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        int bonusCount = this.getBigCount() + this.getRegCount();
        this.appendLog("\n\n");
        double stayedRatio = 0.0;
        double breakRatio = 0.0;
        this.appendLogPayout();
    }

    public void eventSimulateStart() {
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

