/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.KingPulserA;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class KingPulserAMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int BREAK_ORANGE = 11;
    public static final int BREAK_CHERRY = 12;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_ORANGE = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    public static final int FLAG_BIG_ORANGE = 4;
    protected int[][] flagTable = new int[][]{{1, 14316, 55, 27, 1845, 120, 20}, {1, 14316, 55, 27, 1845, 120, 20}, {1, 14308, 58, 32, 1845, 120, 20}, {1, 14300, 61, 37, 1845, 120, 20}, {1, 14292, 64, 42, 1845, 120, 20}, {1, 14205, 68, 45, 1925, 120, 20}};
    protected int[][] flagTableBig = new int[][]{{1684, 4800, 7200, 1500, 1200}, {1684, 4800, 7200, 1500, 1200}, {1684, 4800, 7200, 1500, 1200}, {1684, 4800, 7200, 1500, 1200}, {1184, 4800, 7700, 1500, 1200}, {684, 4800, 8200, 1500, 1200}};
    protected int[][] flagTableJac = new int[][]{{1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}};
    protected int[][] rtTable1 = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 77, 72, 55, 6, 6, 6, 6, 6, 6, 6}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 88, 77, 50, 7, 6, 6, 6, 6, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 80, 77, 50, 6, 6, 6, 6, 5, 5, 5}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 88, 82, 45, 7, 6, 6, 6, 6, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 88, 82, 55, 6, 5, 2, 2, 2, 2, 2}, {1, 173, 1, 1, 1, 1, 1, 1, 1, 1, 33, 33, 1, 1, 1, 1, 1, 1, 1, 1}};
    protected int[][] rtTable2 = new int[][]{{8, 26, 29, 28, 16, 12, 19, 13, 8, 13, 20, 11, 11, 6, 6, 6, 6, 6, 6, 6}, {9, 27, 30, 29, 17, 13, 20, 14, 10, 15, 22, 14, 14, 8, 6, 3, 2, 1, 1, 1}, {8, 26, 29, 28, 16, 12, 19, 13, 9, 14, 21, 11, 11, 6, 6, 6, 6, 5, 5, 5}, {9, 27, 30, 29, 17, 13, 20, 14, 10, 15, 22, 14, 14, 8, 6, 3, 2, 1, 1, 1}, {10, 28, 31, 30, 18, 14, 21, 15, 11, 16, 18, 9, 9, 6, 5, 3, 3, 3, 3, 3}, {12, 32, 35, 33, 22, 20, 23, 16, 10, 12, 12, 8, 9, 6, 1, 1, 1, 1, 1, 1}};
    protected int[][] rtG = new int[][]{{1, 9, 17, 25, 33, 41, 49, 65, 81, 97, 129, 193, 257, 385, 513, 641, 769, 897, 1025, 1153}, {8, 16, 24, 32, 40, 48, 64, 80, 96, 128, 192, 256, 384, 512, 640, 768, 896, 1024, 1152, 1280}};
    protected boolean newStock = false;

    public int getRandomMax() {
        super.getRandomMax();
        return 16384;
    }

    public int getStockType() {
        return 1;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (this.rtCounter > this.rtFloor) {
            if (this.breakFactor == -12) {
                this.breakFactor = -10;
            }
            this.isBreak = true;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                if (this.isBreak || SimulatorLibrary.random((int)25) >= 10) break;
                this.isBreak = true;
                this.breakFactor = 12;
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                if (this.isBreak || SimulatorLibrary.random((int)99) >= 10) break;
                this.isBreak = true;
                this.rtFloor += 6;
                this.breakFactor = 11;
                break;
            }
            case 1: {
                int random4096 = SimulatorLibrary.random((int)4096);
                if (random4096 < 648) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
            }
            case 1: {
                int random4096 = SimulatorLibrary.random((int)4096);
                ((AbstractMainBoard)this).isReplay = random4096 < 648;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(6);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.newStock = this.noStock;
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -12;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = -1;
        index = this.newStock ? SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)256) : SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)256);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }
}

