/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.KingOfKingPulser;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class KingOfKingPulserMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int BREAK_REPLAY = 11;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_ORANGE = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    public static final int FLAG_BIG_ORANGE = 4;
    protected int[][] flagTable = new int[][]{{4, 57264, 220, 108, 7380, 80, 480}, {4, 57264, 220, 108, 7380, 80, 480}, {4, 57232, 232, 128, 7380, 80, 480}, {4, 57200, 244, 148, 7380, 80, 480}, {4, 57168, 256, 168, 7380, 80, 480}, {4, 56820, 272, 180, 7700, 80, 480}};
    protected int[][] flagTableBig = new int[][]{{6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {4736, 19200, 30800, 4800, 6000}, {2736, 19200, 32800, 4800, 6000}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][] rtTable1 = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 22, 4}, {1, 1, 1, 1, 1, 1, 1, 1, 64, 1, 48, 1, 48, 1, 28, 1, 28, 1, 24, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 22, 4}, {1, 1, 1, 1, 1, 1, 1, 1, 64, 1, 48, 1, 48, 1, 28, 1, 28, 1, 24, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 48, 1, 48, 1, 48, 1, 36, 1, 24, 1, 24, 1, 10, 4}, {1, 183, 1, 1, 1, 1, 1, 1, 32, 1, 8, 1, 7, 1, 6, 1, 5, 1, 3, 1, 0, 0}};
    protected int[][] rtTable2 = new int[][]{{11, 29, 34, 31, 30, 19, 21, 10, 12, 8, 6, 9, 13, 7, 4, 2, 10}, {12, 29, 34, 31, 30, 19, 21, 10, 16, 12, 10, 12, 16, 1, 1, 1, 1}, {13, 29, 34, 31, 30, 19, 21, 10, 12, 8, 6, 9, 13, 7, 4, 2, 8}, {14, 30, 35, 32, 31, 20, 21, 10, 16, 12, 10, 12, 9, 1, 1, 1, 1}, {15, 31, 36, 33, 32, 21, 21, 10, 12, 7, 5, 8, 12, 6, 3, 2, 2}, {21, 40, 40, 40, 33, 22, 21, 10, 5, 5, 5, 5, 5, 1, 1, 1, 1}};
    protected int[][] rtG1 = new int[][]{{1, 9, 17, 25, 33, 49, 65, 97, 129, 130, 194, 195, 259, 260, 324, 325, 453, 454, 710, 711, 967, 968}, {8, 16, 24, 32, 48, 64, 96, 128, 129, 193, 194, 258, 259, 323, 324, 452, 453, 709, 710, 966, 967, 1223}};
    protected int[][] rtG2 = new int[][]{{1, 9, 17, 25, 33, 49, 65, 97, 129, 194, 259, 324, 453, 710, 967, 1224, 1288}, {8, 16, 24, 32, 48, 64, 96, 128, 193, 258, 323, 452, 709, 966, 1223, 1287, 1303}};
    protected boolean newStock = false;

    public int getStockType() {
        return 1;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 < 6) {
                    this.breakFactor = 11;
                    this.isBreak = true;
                    break;
                }
                if (random4096 < 649) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
            }
            case 1: {
                if (random4096 < 42 || random4096 >= 691) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(6);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.newStock = this.noStock;
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = -1;
        int min = 0;
        int max = 0;
        if (this.newStock) {
            index = SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)256);
            min = this.rtG1[0][index];
            max = this.rtG1[1][index];
        } else {
            index = SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)256);
            min = this.rtG2[0][index];
            max = this.rtG2[1][index];
        }
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }
}

