/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.KingCamel;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;

public class KingCamelMainBoard
extends AbstractMainBoard {
    public static final int EVENT_DEBUG = 50;
    public static final int EVENT_SYUUTYUU_START = 20;
    public static final int EVENT_SYUUTYUU_END = 21;
    public static final int EVENT_AT_KB_START = 22;
    public static final int EVENT_AT_KB_END = 23;
    public static final int EVENT_AT_MB_START = 24;
    public static final int EVENT_AT_MB_END = 25;
    public static final int EVENT_AT_CC_SHORT_START = 26;
    public static final int EVENT_AT_CC_SHORT_END = 27;
    public static final int EVENT_AT_CC_LONG_START = 28;
    public static final int EVENT_AT_CC_LONG_END = 29;
    public static final int EVENT_CZ_START = 30;
    public static final int EVENT_CZ_END = 31;
    public static final int EVENT_CHERRY3 = 32;
    public static final int EVENT_JACGAME = 33;
    public static final int MODE_0 = 0;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    private int[] syuutyuuHitTable = new int[]{277, 278, 279, 280, 281, 430};
    private int[] syuutyuuPunkTable = new int[]{750, 750, 750, 750, 750, 750};
    private int[][] czTable = new int[][]{{5, 96, 128, 20, 2}, {5, 40, 132, 72, 2}, {5, 40, 132, 72, 2}, {5, 40, 132, 72, 2}, {5, 40, 132, 72, 2}, {16, 89, 128, 16, 2}};
    private int[] czGameCount = new int[]{50, 75, 100, 200, 500};
    private int[][] atHitTable = new int[][]{{65535, 20000, 1200, 326}, {65535, 20000, 1350, 456}, {65535, 20000, 1600, 576}, {65535, 20000, 1900, 700}, {65535, 20000, 2300, 800}, {65535, 20000, 1900, 700}};
    public static final int ATKIND_CC_SHORT = 0;
    public static final int ATKIND_MB = 1;
    public static final int ATKIND_KB = 2;
    public static final int ATKIND_CC_LONG = 3;
    private int[][][] atKindTable = new int[][][]{new int[][]{{232, 16, 8}, {232, 16, 8}, {232, 16, 8}, {232, 16, 8}, {232, 16, 8}, {232, 16, 8}}, new int[][]{{196, 52, 8}, {192, 52, 12}, {184, 52, 20}, {180, 52, 24}, {172, 52, 32}, {188, 52, 16}}, new int[][]{{64, 64, 128}, {64, 64, 128}, {56, 56, 144}, {48, 48, 160}, {48, 48, 160}, {85, 85, 86}}, new int[][]{{0, 0, 256}, {0, 0, 256}, {0, 0, 256}, {0, 0, 256}, {0, 0, 256}, {0, 0, 256}}};
    public static final int FLAG_SINGLEBONUS = 4;
    public static final int FLAG_BELL = 5;
    public static final int FLAG_CHERRY = 6;
    private int[][] flagTableLow = new int[][]{{32357, 8978, 0, 0, 3300, 20900, 1}, {32357, 8978, 0, 0, 3300, 20900, 1}, {32357, 8978, 0, 0, 3300, 20900, 1}, {32357, 8978, 0, 0, 3300, 20900, 1}, {32357, 8978, 0, 0, 3300, 20900, 1}, {32357, 8978, 0, 0, 3300, 20900, 1}};
    private int[][] flagTableSyuutyuu = new int[][]{{2657, 8978, 0, 0, 33000, 20900, 1}, {2657, 8978, 0, 0, 33000, 20900, 1}, {2657, 8978, 0, 0, 33000, 20900, 1}, {2657, 8978, 0, 0, 33000, 20900, 1}, {2657, 8978, 0, 0, 33000, 20900, 1}, {2657, 8978, 0, 0, 33000, 20900, 1}};
    private boolean isSyuutyuu = false;
    private boolean isAtSenpuku = false;
    private boolean isAt = false;
    private int atFloor = -1;
    private int atCounter = -1;
    private int atKind = -1;
    private int currentMode = 0;
    private boolean isCz = false;
    private int czFloor = -1;
    private int czCounter = -1;
    private boolean isKbPunk = false;
    private int atPunkFactor = 0;
    public static final int ATPUNKFACTOR_SYUUTYUUPUNK = 0;
    public static final int ATPUNKFACTOR_ATPUNK = 1;
    protected int[] genzanchi = new int[]{0, 0, 0, 0, 0, 0};
    protected int[] kasanchi = new int[]{0, 0, 0, 0, 0, 0};

    public int[][] getFlagTableHigh() {
        return this.flagTableLow;
    }

    public int[][] getFlagTableLow() {
        return this.getFlagTableHigh();
    }

    public void game(int flag) {
        int index;
        if (this.isSyuutyuu) {
            this.currentFlag = flag = SimulatorLibrary.getTableIndex((int[])this.flagTableSyuutyuu[this.settei - 1], (int)65536);
        }
        int random65536 = SimulatorLibrary.random((int)65536);
        int random2048 = SimulatorLibrary.random((int)2048);
        if (this.isSyuutyuu && random65536 < this.syuutyuuPunkTable[this.settei - 1]) {
            this.fireEvent(21);
            this.isSyuutyuu = false;
            if (this.currentMode == 1) {
                index = SimulatorLibrary.getTableIndex((int[])this.czTable[this.settei - 1], (int)251);
                this.isCz = true;
                this.czFloor = this.czGameCount[index];
                this.czCounter = 0;
                this.fireEvent(30);
            }
        } else if (!this.isSyuutyuu && random65536 < this.syuutyuuHitTable[this.settei - 1]) {
            this.isSyuutyuu = true;
            if (this.isCz) {
                this.currentMode = 1;
                this.fireEvent(31);
                this.fireEvent(20);
            } else {
                this.currentMode = 2;
                this.fireEvent(20);
            }
        }
        if (this.isAtSenpuku) {
            if (!this.isSyuutyuu) {
                this.isAtSenpuku = false;
            } else if (SimulatorLibrary.random((int)4) == 0) {
                this.isAtSenpuku = false;
                this.isAt = true;
                this.atKind = SimulatorLibrary.getTableIndex((int[])this.atKindTable[this.currentMode - 1][this.settei - 1], (int)256);
                if (this.atKind == 2) {
                    this.atFloor = 50;
                    this.isKbPunk = false;
                    this.atCounter = 0;
                    this.fireEvent(22);
                } else if (this.atKind == 1) {
                    this.atFloor = 20;
                    this.atCounter = 0;
                    this.fireEvent(24);
                } else if (this.atKind == 0) {
                    this.atFloor = 65536;
                    this.atCounter = 0;
                    if (SimulatorLibrary.random((int)256) < 16) {
                        this.atKind = 3;
                        this.fireEvent(28);
                    } else {
                        this.fireEvent(26);
                    }
                }
            }
        }
        if (this.isAt) {
            switch (this.atKind) {
                case 2: {
                    ++this.atCounter;
                    if (this.atCounter > this.atFloor) {
                        if (this.isKbPunk) {
                            if (!this.isSyuutyuu) {
                                this.currentMode = 0;
                            }
                            this.fireEvent(23);
                            this.isAt = false;
                            index = SimulatorLibrary.getTableIndex((int[])this.czTable[this.settei - 1], (int)251);
                            this.isCz = true;
                            this.czFloor = this.czGameCount[index];
                            this.czCounter = 0;
                            this.fireEvent(30);
                            break;
                        }
                        if (!this.isSyuutyuu) break;
                        this.currentMode = 1;
                        this.fireEvent(23);
                        this.isAt = false;
                        break;
                    }
                    if (this.isSyuutyuu) break;
                    this.isKbPunk = true;
                    break;
                }
                case 1: {
                    ++this.atCounter;
                    if (this.atCounter <= this.atFloor) break;
                    if (this.isSyuutyuu && this.currentMode != 1) {
                        this.currentMode = 4;
                    } else if (!this.isSyuutyuu) {
                        this.currentMode = 0;
                    }
                    this.fireEvent(25);
                    this.isAt = false;
                    break;
                }
                case 3: {
                    ++this.atCounter;
                    if (!this.isSyuutyuu && this.atCounter > 4) {
                        this.currentMode = 0;
                        this.fireEvent(29);
                        this.isAt = false;
                        if (this.currentMode != 1) break;
                        index = SimulatorLibrary.getTableIndex((int[])this.czTable[this.settei - 1], (int)251);
                        this.isCz = true;
                        this.czFloor = this.czGameCount[index];
                        this.czCounter = 0;
                        this.fireEvent(30);
                        break;
                    }
                    if (SimulatorLibrary.random((int)65536) >= 768 || this.atCounter <= 4) break;
                    if (this.isSyuutyuu && this.currentMode != 1) {
                        this.currentMode = 3;
                    }
                    this.fireEvent(29);
                    this.isAt = false;
                    break;
                }
                case 0: {
                    ++this.atCounter;
                    if (!this.isSyuutyuu && this.atCounter > 4) {
                        this.currentMode = 0;
                        this.fireEvent(27);
                        this.isAt = false;
                        if (this.currentMode != 1) break;
                        index = SimulatorLibrary.getTableIndex((int[])this.czTable[this.settei - 1], (int)251);
                        this.isCz = true;
                        this.czFloor = this.czGameCount[index];
                        this.czCounter = 0;
                        this.fireEvent(30);
                        break;
                    }
                    if (SimulatorLibrary.random((int)65536) >= 7430 || this.atCounter <= 4) break;
                    if (this.isSyuutyuu && this.currentMode != 1) {
                        this.currentMode = 3;
                    }
                    this.fireEvent(27);
                    this.isAt = false;
                }
            }
        } else if (this.isCz) {
            ++this.czCounter;
            if (this.czCounter > this.czFloor) {
                this.isCz = false;
                this.fireEvent(31);
            }
        }
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            this.isReplay = false;
        }
        switch (flag) {
            case 4: {
                if (this.isAt) {
                    this.fireCoinPlus(13);
                    this.fireEvent(33);
                    ++this.atCounter;
                    this.fireCoinMinus(3);
                    this.fireCoinPlus(13);
                    switch (this.atKind) {
                        case 2: {
                            if (this.atCounter >= this.atFloor) {
                                if (this.isKbPunk) {
                                    if (!this.isSyuutyuu) {
                                        this.currentMode = 0;
                                    }
                                    this.fireEvent(23);
                                    this.isAt = false;
                                    index = SimulatorLibrary.getTableIndex((int[])this.czTable[this.settei - 1], (int)251);
                                    this.isCz = true;
                                    this.czFloor = this.czGameCount[index];
                                    this.czCounter = 0;
                                    this.fireEvent(30);
                                    break;
                                }
                                if (!this.isSyuutyuu) break;
                                this.currentMode = 1;
                                this.fireEvent(23);
                                this.isAt = false;
                                break;
                            }
                            if (this.isSyuutyuu) break;
                            this.isKbPunk = true;
                            break;
                        }
                        case 1: {
                            if (this.atCounter < this.atFloor) break;
                            if (this.isSyuutyuu && this.currentMode != 1) {
                                this.currentMode = 4;
                            } else if (!this.isSyuutyuu) {
                                this.currentMode = 0;
                            }
                            this.fireEvent(25);
                            this.isAt = false;
                            break;
                        }
                        case 3: {
                            if (SimulatorLibrary.random((int)65536) >= 768 || this.atCounter <= 4) break;
                            if (this.isSyuutyuu && this.currentMode != 1) {
                                this.currentMode = 3;
                            }
                            this.fireEvent(29);
                            this.isAt = false;
                            break;
                        }
                        case 0: {
                            if (SimulatorLibrary.random((int)65536) >= 7430 || this.atCounter <= 4) break;
                            if (this.isSyuutyuu && this.currentMode != 1) {
                                this.currentMode = 3;
                            }
                            this.fireEvent(27);
                            this.isAt = false;
                        }
                    }
                    break;
                }
                if (random2048 >= 342) break;
                this.fireCoinPlus(13);
                if (this.isCz) {
                    ++this.czCounter;
                }
                this.fireCoinMinus(3);
                this.fireCoinPlus(13);
                break;
            }
            case 1: {
                this.isReplay = true;
                break;
            }
            case 5: {
                if (this.isSyuutyuu) {
                    if (this.isAt) {
                        this.fireCoinPlus(13);
                        break;
                    }
                    if (!this.isAt && !this.isAtSenpuku && SimulatorLibrary.random((int)65536) < this.atHitTable[this.settei - 1][this.currentMode - 1]) {
                        this.isAtSenpuku = true;
                    }
                    if (random2048 >= 448) break;
                    this.fireCoinPlus(13);
                    break;
                }
                if (this.isAt) {
                    this.fireCoinPlus(13);
                    break;
                }
                if (random2048 >= 448) break;
                this.fireCoinPlus(13);
                break;
            }
            case 6: {
                this.fireEvent(32);
                this.fireCoinPlus(3);
            }
        }
        this.fireEvent(50);
    }

    public void reset() {
        super.reset();
        this.isSyuutyuu = false;
        this.isAt = false;
        this.isCz = false;
    }

    public void bigGame(int flag, int game, int jacInCount) {
    }

    public int[][] getFlagTableBigGame() {
        return null;
    }

    public int[][] getFlagTableBonusGame() {
        return null;
    }

    public int getCurrentBonus() {
        return 0;
    }

    public int[] genzanchi() {
        return this.genzanchi;
    }

    public int[] kasanchi() {
        return this.kasanchi;
    }

    public int getAtCounter() {
        return this.atCounter;
    }

    public int[][] getAtHitTable() {
        return this.atHitTable;
    }

    public int getAtKind() {
        return this.atKind;
    }

    public int getAtPunkFactor() {
        return this.atPunkFactor;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getCzCounter() {
        return this.czCounter;
    }

    public int getCzFloor() {
        return this.czFloor;
    }

    public boolean isAt() {
        return this.isAt;
    }

    public boolean isCz() {
        return this.isCz;
    }

    public boolean isKbPunk() {
        return this.isKbPunk;
    }

    public boolean isSyuutyuu() {
        return this.isSyuutyuu;
    }
}

