/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.JSR;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class JSRMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_JC_HIT = 20;
    public static final int EVENT_JC_START = 21;
    public static final int EVENT_JC_END = 22;
    public static final int EVENT_HIGH_START = 23;
    public static final int EVENT_HIGH_END = 24;
    public static final int EVENT_CHANCE = 25;
    private int[][] jcHitTable = new int[][]{{45, 51, 79, 112, 127, 152}, {4, 11, 6, 17, 24, 54}};
    private static final int JCREN_INDEX_LOW = 0;
    private static final int JCREN_INDEX_HIGH = 1;
    private static final int JCREN_INDEX_TENJOU = 2;
    private static final int JCREN_INDEX_DAI = 3;
    private int[][][] jcRenTable = new int[][][]{new int[][]{{64704, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {64704, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}}, new int[][]{{30627, 2006, 2000, 2000, 16322, 2000, 2000, 8005, 64, 64, 64, 64, 64, 256}, {22976, 8192, 3200, 3200, 16320, 3200, 3200, 3200, 640, 640, 320, 320, 64, 64}, {22976, 8192, 3200, 3200, 16320, 3200, 3200, 3200, 640, 640, 320, 320, 64, 64}, {25894, 9000, 6000, 6000, 14194, 2000, 2000, 64, 64, 64, 64, 64, 64, 64}, {25894, 9000, 6000, 6000, 14194, 2000, 2000, 64, 64, 64, 64, 64, 64, 64}, {34688, 9200, 17072, 2000, 2000, 64, 64, 64, 64, 64, 64, 64, 64, 64}}, new int[][]{{54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {45312, 8064, 1920, 1920, 6464, 320, 320, 320, 192, 192, 192, 192, 64, 64}, {54592, 4992, 640, 640, 4096, 64, 64, 64, 64, 64, 64, 64, 64, 64}, {45312, 8064, 1920, 1920, 6464, 320, 320, 320, 192, 192, 192, 192, 64, 64}, {45312, 8064, 1920, 1920, 6464, 320, 320, 320, 192, 192, 192, 192, 64, 64}, {28464, 9672, 10000, 6000, 6000, 500, 500, 3000, 300, 300, 300, 300, 100, 100}}, new int[][]{{0, 0, 0, 0, 0, 21760, 16320, 16384, 3328, 3200, 1920, 1920, 512, 192}, {0, 0, 0, 0, 0, 19211, 16319, 16384, 8663, 3359, 512, 512, 512, 64}, {0, 0, 0, 0, 0, 19211, 16319, 16384, 8663, 3359, 512, 512, 512, 64}, {0, 0, 0, 0, 0, 9742, 25500, 21038, 7000, 2000, 64, 64, 64, 64}, {0, 0, 0, 0, 0, 9742, 25500, 21038, 7000, 2000, 64, 64, 64, 64}, {0, 0, 0, 0, 0, 9742, 25500, 21038, 7000, 2000, 64, 64, 64, 64}}};
    private int[] jcCountTable = new int[]{1, 2, 3, 4, 5, 7, 9, 11, 13, 15, 17, 19, 21, 25};
    private int[][] highGTable = new int[][]{{0, 0, 0, 128, 67, 26, 10, 3, 2, 1, 1, 1, 1, 1}, {60, 96, 60, 10, 10, 1, 1, 1, 1, 1, 0, 0, 0, 0}, {100, 101, 18, 15, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {32, 90, 96, 15, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int HIGHG_INDEX_BIG = 0;
    private static final int HIGHG_INDEX_REG = 1;
    private static final int HIGHG_INDEX_BIG_CHERRY = 2;
    private static final int HIGHG_INDEX_BIG_BLADE = 3;
    private static final int HIGHG_INDEX_RARE_REPLAY = 4;
    private int[] highGCountTable = new int[]{5, 15, 20, 50, 70, 90, 110, 130, 150, 200, 250, 300, 400, 500};
    private int koyakuContinueCount = 0;
    private boolean isHigh = false;
    private int highFloor = 0;
    private int currentHighFloor = 0;
    private boolean is1g = false;
    private int rtCounter = 0;
    private boolean isTenjou = false;
    private int tenjouJcCount = 0;
    private int jcHitFactor = 0;
    public static final int JCHITFACTOR_NOFLAG = 0;
    public static final int JCHITFACTOR_BIGHAZUSHI = 1;
    public static final int JCHITFACTOR_1G_NOFLAG = 2;
    public static final int JCHITFACTOR_JAC_NOFLAG = 3;
    public static final int JCHITFACTOR_BIGFLAG = 4;
    public static final int JCHITFACTOR_TENJOU = 5;
    public static final int JCHITFACTOR_DAI = 6;
    private boolean isJc = false;
    private int jcCount = 0;
    private int currentJcHitCount = 0;
    private int currentJcRenCount = 0;
    private int jcFloor = 0;
    private int naviCount = 0;
    public static final int BREAKFACTOR_REG = 0;
    public static final int BREAKFACTOR_BIG = 1;
    public static final int BREAKFACTOR_7REN = 2;
    public static final int BREAKFACTOR_7REN_JC = 3;
    private int[][] jcGameTable = new int[][]{{65186, 350, 0, 0, 0, 0}, {64986, 350, 200, 0, 0, 0}, {64856, 350, 200, 130, 0, 0}, {64786, 350, 200, 130, 70, 0}, {64716, 350, 200, 130, 70, 70}};
    private int[] jcGameCountTable = new int[]{10, 20, 30, 40, 50, 60};
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_BLADE = 6;
    private int[][] flagTable = new int[][]{{315, 8979, 275, 275, 54237, 800, 655}, {318, 8979, 272, 275, 54237, 800, 655}, {316, 8979, 274, 275, 54237, 800, 655}, {319, 8979, 271, 275, 54237, 800, 655}, {317, 8979, 273, 275, 54237, 800, 655}, {320, 8979, 270, 275, 54237, 800, 655}};
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    public static final int FLAG_BIG_BLADE = 4;
    private int[][] flagTableBig = new int[][]{{10831, 18000, 32768, 660, 3277}, {10771, 18000, 32768, 720, 3277}, {10711, 18000, 32768, 780, 3277}, {10651, 18000, 32768, 840, 3277}, {10531, 18000, 32768, 960, 3277}, {9991, 18000, 32768, 1500, 3277}};
    private int[][] flagTableJac = new int[][]{{1, 65536}, {1, 65536}, {1, 65536}, {1, 65536}, {1, 65536}, {1, 65536}};

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: {
                if (SimulatorLibrary.random((int)65536) >= 12426) break;
                this.fireCoinPlus(6);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(10);
            }
        }
    }

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (this.isHigh) {
            --this.highFloor;
            if (this.highFloor <= 0) {
                this.isHigh = false;
                this.fireEvent(24);
            }
        }
        if (!this.isJc && this.jcCount > 0) {
            if (this.currentJcRenCount == 0) {
                if (SimulatorLibrary.random((int)10) == 0) {
                    this.isJc = true;
                    ++this.currentJcRenCount;
                    --this.jcCount;
                    this.jcFloor = this._getJcFloor();
                    this.fireEvent(21);
                }
            } else if (SimulatorLibrary.random((int)15) == 0) {
                this.isJc = true;
                ++this.currentJcRenCount;
                --this.jcCount;
                this.jcFloor = this._getJcFloor();
                this.fireEvent(21);
            }
        }
        ++this.rtCounter;
        if (this.rtCounter == 1100) {
            this.isTenjou = true;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                ++this.koyakuContinueCount;
                if (SimulatorLibrary.random((int)65536) < 197) {
                    this.jcHit(3, 6);
                    break;
                }
                if (this.is1g) {
                    this.jcHit(1, 2);
                } else if (this.isHigh) {
                    if (SimulatorLibrary.random((int)251) < this.jcHitTable[0][((AbstractMainBoard)this).settei - 1]) {
                        this.jcHit(1, 0);
                    }
                } else if (SimulatorLibrary.random((int)251) < this.jcHitTable[1][((AbstractMainBoard)this).settei - 1]) {
                    this.jcHit(0, 0);
                }
                this.fireEvent(25);
                break;
            }
            case 2: {
                ++this.koyakuContinueCount;
                this.stock.add((Object)new Integer(3));
                if (SimulatorLibrary.random((int)65536) < 3) {
                    this.isBreak = true;
                    this.breakFactor = 1;
                    break;
                }
                if (SimulatorLibrary.random((int)65536) >= 4) break;
                this.jcHit(0, 4);
                break;
            }
            case 3: {
                ++this.koyakuContinueCount;
                this.stock.add((Object)new Integer(4));
                if (SimulatorLibrary.random((int)65536) >= 46502) break;
                this.isBreak = true;
                this.breakFactor = 0;
                break;
            }
            case 1: {
                ++this.koyakuContinueCount;
                if (SimulatorLibrary.random((int)251) < 2) {
                    this.highFloor += this.highHit(4);
                    this.isHigh = true;
                    this.fireEvent(23);
                }
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: {
                if (this.isJc && !this.isBreak) {
                    this.fireCoinPlus(6);
                    ++this.koyakuContinueCount;
                    break;
                }
                if (this.naviCount > 0) {
                    --this.naviCount;
                    this.fireCoinPlus(6);
                    ++this.koyakuContinueCount;
                    break;
                }
                if (this.isBreak && !this.isJc) {
                    if (SimulatorLibrary.random((int)65536) < 12426) {
                        this.fireCoinPlus(6);
                        break;
                    }
                    if (this.nextBonus == 3) {
                        this.fireCoinPlus(15);
                    } else {
                        this.fireCoinPlus(1);
                    }
                    this.bonusGet();
                    break;
                }
                if (SimulatorLibrary.random((int)65536) < 12426) {
                    this.fireCoinPlus(6);
                    ++this.koyakuContinueCount;
                    break;
                }
                this.koyakuContinueCount = 0;
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                ++this.koyakuContinueCount;
                if (!this.isTenjou) break;
                this.jcHit(2, 5);
                this.rtCounter = 0;
                this.isTenjou = false;
                break;
            }
            case 6: {
                this.fireCoinPlus(10);
                ++this.koyakuContinueCount;
            }
        }
        if (this.isJc && this.jcFloor > 0) {
            --this.jcFloor;
            if (this.jcFloor == 0) {
                this.fireEvent(22);
            }
        }
        if (!this.isBreak && this.koyakuContinueCount >= 7 && this.jcFloor < 1) {
            this.isBreak = true;
            this.breakFactor = this.isJc ? 3 : 2;
        } else if (this.koyakuContinueCount == 5) {
            if (SimulatorLibrary.random((int)4096) < 85) {
                this.naviCount = 2;
            }
        } else if (this.koyakuContinueCount == 6 && SimulatorLibrary.random((int)4096) < 850) {
            this.naviCount = 1;
        }
        this.is1g = false;
        if (this.isJc && this.jcFloor < 1) {
            this.isJc = false;
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                this.koyakuContinueCount = 0;
                break;
            }
            case 1: {
                if (jacInCount < 2 || game > 21) {
                    this.setJacIn();
                    this.fireCoinPlus(1);
                    break;
                }
                if (SimulatorLibrary.random((int)251) != 0) break;
                this.jcHit(0, 1);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.highHit(2);
                this.fireCoinPlus(14);
                break;
            }
            case 4: {
                this.highHit(3);
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        super.jacGame(flag, gameCount);
        if (flag == 0) {
            this.jcHit(1, 3);
        }
    }

    protected void reset() {
        super.reset();
        int previousBonus = this.nextBonus;
        if (this.stock.size() > 0) {
            this.noStock = false;
            int index = -1;
            if (previousBonus == 3) {
                this.highFloor += this.highHit(0);
            } else if (previousBonus == 4) {
                this.highFloor += this.highHit(1);
            }
            this.nextBonus = this._getNextBonus();
            if (this.highFloor > 0) {
                this.isHigh = true;
                this.fireEvent(23);
            }
        } else {
            this.noStock = true;
            this.nextBonus = -1;
        }
        if (this.jcCount == 0) {
            this.currentJcRenCount = 0;
        }
        this.koyakuContinueCount = 0;
        if (this.breakFactor == 1 || this.breakFactor == 0) {
            this.rtCounter = 0;
            this.isTenjou = false;
        }
        this.isJc = false;
        this.is1g = true;
        this.jcFloor = 0;
        this.naviCount = 0;
        this.breakFactor = -12;
        this.isBreak = false;
    }

    public void setup() {
        super.setup();
        this.koyakuContinueCount = 0;
        this.isHigh = false;
        this.highFloor = 0;
        this.currentHighFloor = 0;
        this.rtCounter = 0;
        this.isTenjou = false;
        this.jcHitFactor = 0;
        this.isJc = false;
        this.jcCount = 0;
        this.currentJcHitCount = 0;
        this.currentJcRenCount = 0;
    }

    private int highHit(int highIndex) {
        if (this.breakFactor == 1 || this.breakFactor == 0 || highIndex == 4) {
            int index = SimulatorLibrary.getTableIndex((int[])this.highGTable[highIndex], (int)241);
            this.currentHighFloor = this.highGCountTable[index];
        } else {
            this.currentHighFloor = 0;
        }
        return this.currentHighFloor;
    }

    private void jcHit(int jcHitIndex, int factor) {
        int index = SimulatorLibrary.getTableIndex((int[])this.jcRenTable[jcHitIndex][((AbstractMainBoard)this).settei - 1], (int)65536);
        this.currentJcHitCount = this.jcCountTable[index];
        this.jcCount += this.currentJcHitCount;
        this.jcHitFactor = factor;
        this.fireEvent(20);
    }

    private int _getNextBonus() {
        int next = -1;
        int[] big = new int[]{6523, 6328, 6484, 6289, 6367, 6211};
        next = SimulatorLibrary.random((int)10000) < big[((AbstractMainBoard)this).settei - 1] ? 3 : 4;
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }

    private int _getJcFloor() {
        int jcGameTableIndex = -1;
        jcGameTableIndex = this.jcCount >= 10 ? 4 : (this.jcCount >= 6 ? 3 : (this.jcCount >= 4 ? 2 : (this.jcCount >= 2 ? 1 : 0)));
        int index = SimulatorLibrary.getTableIndex((int[])this.jcGameTable[jcGameTableIndex], (int)65536);
        return this.jcGameCountTable[index];
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getCurrentHighFloor() {
        return this.currentHighFloor;
    }

    public int getCurrentJcHitCount() {
        return this.currentJcHitCount;
    }

    public int getCurrentJcRenCount() {
        return this.currentJcRenCount;
    }

    public int getHighFloor() {
        return this.highFloor;
    }

    public boolean isHigh() {
        return this.isHigh;
    }

    public boolean isJc() {
        return this.isJc;
    }

    public boolean isTenjou() {
        return this.isTenjou;
    }

    public int getJcCount() {
        return this.jcCount;
    }

    public int getJcHitFactor() {
        return this.jcHitFactor;
    }

    public int getNaviCount() {
        return this.naviCount;
    }

    public int getJcFloor() {
        return this.jcFloor;
    }
}

