/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Haiena;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.machines.Haiena.HaienaMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class HaienaDataCounter
extends AbstractDataCounter {
    private JCheckBoxMenuItem menuItemAtHit = null;
    private JCheckBoxMenuItem menuItemAtStart = null;
    private JCheckBoxMenuItem menuItemNoflag = null;
    private int atCount = 0;
    private String[] modeString = new String[]{"S", "A", "B", "C"};

    protected void initializeGui(JPanel northPanel) {
        this.menuItemAtHit = new JCheckBoxMenuItem("AT\u5f53\u9078\u8868\u793a", true);
        this.menuItemAtStart = new JCheckBoxMenuItem("AT\u958b\u59cb\u8868\u793a", true);
        this.menuItemNoflag = new JCheckBoxMenuItem("\u7d14\u30cf\u30ba\u30ec\u8868\u793a", false);
        this.addOptionMenu(this.menuItemAtHit);
        this.addOptionMenu(this.menuItemAtStart);
        this.addOptionMenu(this.menuItemNoflag);
    }

    protected String getFrameTitle() {
        return "\u30cf\u30a4\u30a8\u30ca\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new HaienaMainBoard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 21: {
                ++this.atCount;
            }
            case 22: 
            case 24: 
            case 25: {
                this.eventAt(event);
                break;
            }
            case 23: {
                this.eventNoflag();
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (this.simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + this.currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        this.logCommon();
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.atCount = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("AT", this.atCount, this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected void eventAt(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        switch (event) {
            case 21: {
                if (!this.menuItemAtStart.isSelected()) {
                    return;
                }
                this.appendLog("\t");
                this.appendLog(String.valueOf(this.getCurrentGameCount()));
                this.appendLog("\tAT\u958b\u59cb");
                this.logCommon();
                break;
            }
            case 24: {
                if (!this.menuItemAtHit.isSelected()) {
                    return;
                }
                this.appendLog("\t(");
                this.appendLog(String.valueOf(this.getCurrentGameCount()));
                this.appendLog(")");
                this.appendLog("\t\u5f53\u9078");
                int factor = ((HaienaMainBoard)this.simulator).getAtHitFactor();
                switch (factor) {
                    case 3: {
                        this.appendLog("(BIG)");
                        break;
                    }
                    case 2: {
                        this.appendLog("(\u7d99\u7d9a)");
                        break;
                    }
                    case 4: {
                        this.appendLog("(\u5929\u4e95)");
                        break;
                    }
                    case 1: {
                        this.appendLog("(\u7d14\u30cf\u30ba\u30ec)");
                    }
                }
                this.logCommon();
                break;
            }
            case 25: {
                if (!this.menuItemAtHit.isSelected()) {
                    return;
                }
                this.appendLog("\t(");
                this.appendLog(String.valueOf(this.getCurrentGameCount()));
                this.appendLog(")");
                this.appendLog("\tSAT\u5f53\u9078");
                this.logCommon();
            }
        }
    }

    protected void eventNoflag() {
        if (this.menuItemResultOnly.isSelected() || !this.menuItemNoflag.isSelected()) {
            return;
        }
        this.appendLog("\t(");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog(")\t\u7d14\u30cf\u30ba\u30ec");
        this.logCommon();
    }

    private void logCommon() {
        int mode = ((HaienaMainBoard)this.simulator).getCurrentMode();
        this.appendLog("\t" + this.modeString[mode]);
        this.appendLog("\t\u6b8bAT=");
        this.appendLog(((HaienaMainBoard)this.simulator).getAtCount() + ((HaienaMainBoard)this.simulator).getSatCount());
        this.appendLog("\t\u5929\u4e95=");
        this.appendLog(((HaienaMainBoard)this.simulator).getTenjou());
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\n");
    }

    public HaienaDataCounter() {
        this.initialize();
    }

    public static void main(String[] args) {
        HaienaDataCounter main = null;
        try {
            main = new HaienaDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }
}

