/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.GameraHGV;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class GameraHGVMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_MODE_MOVE_1 = 30;
    public static final int EVENT_MODE_MOVE_0 = 31;
    public static final int MODE_0 = 0;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int FLAG_NOREPLAY = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_GYAOSU = 6;
    public static final int FLAG_GIRON = 7;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    protected int[][][] flagTable = new int[][][]{new int[][]{{146, 8980, 270, 132, 48008, 600, 6580, 820}, {163, 8980, 271, 133, 47989, 600, 6580, 820}, {181, 8980, 272, 134, 47969, 600, 6580, 820}, {194, 8980, 273, 135, 47954, 600, 6580, 820}, {206, 8980, 274, 136, 47940, 600, 6580, 820}, {215, 8980, 275, 137, 47929, 600, 6580, 820}}, new int[][]{{146, 8980, 270, 132, 48008, 600, 6580, 820}, {163, 8980, 271, 133, 47989, 600, 6580, 820}, {181, 8980, 272, 134, 47969, 600, 6580, 820}, {194, 8980, 273, 135, 47954, 600, 6580, 820}, {206, 8980, 274, 136, 47940, 600, 6580, 820}, {215, 8980, 275, 137, 47929, 600, 6580, 820}}, new int[][]{{1874, 8980, 270, 132, 46280, 600, 6580, 820}, {1872, 8980, 271, 133, 46280, 600, 6580, 820}, {1870, 8980, 272, 134, 46280, 600, 6580, 820}, {1868, 8980, 273, 135, 46280, 600, 6580, 820}, {1866, 8980, 274, 136, 46280, 600, 6580, 820}, {1864, 8980, 275, 137, 46280, 600, 6580, 820}}, new int[][]{{145, 8980, 270, 132, 48009, 600, 6580, 820}, {162, 8980, 271, 133, 47990, 600, 6580, 820}, {180, 8980, 272, 134, 47970, 600, 6580, 820}, {193, 8980, 273, 135, 47955, 600, 6580, 820}, {205, 8980, 274, 136, 47941, 600, 6580, 820}, {214, 8980, 275, 137, 47930, 600, 6580, 820}}, new int[][]{{4594, 8980, 270, 132, 43560, 600, 6580, 820}, {4592, 8980, 271, 133, 43560, 600, 6580, 820}, {4590, 8980, 272, 134, 43560, 600, 6580, 820}, {4588, 8980, 273, 135, 43560, 600, 6580, 820}, {4586, 8980, 274, 136, 43560, 600, 6580, 820}, {4584, 8980, 275, 137, 43560, 600, 6580, 820}}};
    protected int[][] flagTableBig = new int[][]{{1, 11500, 6666, 47303, 66}, {1, 11500, 6666, 47303, 66}, {1, 11500, 6666, 47303, 66}, {1, 11500, 6666, 47303, 66}, {1, 11500, 6666, 47303, 66}, {1, 11500, 6666, 47303, 66}};
    protected int[][] flagTableJac = new int[][]{{1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}, {1, 65535}};
    protected int[] rtTable = new int[]{0, 1265, 198, 5, 28};
    public static final int MODEMOVE_FLOOR = -1;
    public static final int MODEMOVE_NOFLAG = 0;
    public static final int MODEMOVE_GIRON2 = 1;
    public static final int MODEMOVE_CHERRY2 = 2;
    public static final int MODEMOVE_GYAOSU3 = 3;
    public static final int MODEMOVE_REPLAY3 = 4;
    private int modeMoveFactor = -1;
    private int previousMode = -1;
    private boolean coursedMode2 = false;
    protected int[][][] modeTable = new int[][][]{new int[][]{{16384, 0, 0, 0, 0}, {1494, 0, 9098, 4602, 1190}, {1494, 0, 9102, 4600, 1188}, {0, 0, 0, 16384, 0}, {0, 0, 0, 5718, 10666}}, new int[][]{{16384, 0, 0, 0, 0}, {0, 5126, 608, 10650, 0}, {0, 0, 5734, 10650, 0}, {0, 0, 0, 16384, 0}, {0, 0, 0, 10650, 5734}}, new int[][]{{16384, 0, 0, 0, 0}, {0, 3802, 294, 12288, 0}, {0, 0, 4096, 12288, 0}, {0, 0, 0, 16384, 0}, {0, 0, 0, 12288, 4096}}, new int[][]{{16384, 0, 0, 0, 0}, {0, 12696, 1230, 2458, 0}, {0, 0, 13926, 2458, 0}, {0, 0, 0, 16384, 0}, {0, 0, 0, 2458, 13926}}, new int[][]{{16384, 0, 0, 0, 0}, {0, 13924, 820, 1640, 0}, {0, 0, 14744, 1640, 0}, {0, 0, 0, 16384, 0}, {0, 0, 0, 1640, 14744}}};
    private int replayCotinueCount = 0;
    private int gyaosuCotinueCount = 0;
    private int cherryCotinueCount = 0;
    private int gironCotinueCount = 0;
    private boolean shift = false;

    public int[][] getFlagTableHigh() {
        return this.flagTable[0];
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter > this.rtFloor) {
            this.modeMove(-1);
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)65536);
        if (flag != 1) {
            this.replayCotinueCount = 0;
        }
        if (flag != 6) {
            this.gyaosuCotinueCount = 0;
        }
        if (flag != 5) {
            this.cherryCotinueCount = 0;
        }
        if (flag != 7) {
            this.gironCotinueCount = 0;
        }
        switch (flag) {
            case 0: {
                if (this.currentMode == 0) {
                    this.bonusGet();
                    this.fireCoinPlus(15);
                    break;
                }
                this.modeMove(0);
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 4: {
                if (this.currentMode != 0) break;
                this.bonusGet();
                this.fireCoinPlus(15);
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                ++this.replayCotinueCount;
                if (this.replayCotinueCount < 3) break;
                this.modeMove(4);
                this.replayCotinueCount = 0;
                break;
            }
            case 6: {
                this.fireCoinPlus(9);
                ++this.gyaosuCotinueCount;
                if (this.gyaosuCotinueCount < 3) break;
                this.modeMove(3);
                this.gyaosuCotinueCount = 0;
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                ++this.cherryCotinueCount;
                if (this.cherryCotinueCount < 2) break;
                this.modeMove(2);
                this.cherryCotinueCount = 0;
                break;
            }
            case 7: {
                this.fireCoinPlus(4);
                ++this.gironCotinueCount;
                if (this.gironCotinueCount < 2) break;
                this.modeMove(1);
                this.gironCotinueCount = 0;
            }
        }
    }

    private void modeMove(int factor) {
        if (this.currentMode == 0) {
            return;
        }
        if (factor == -1) {
            this.previousMode = this.currentMode;
            this.currentMode = 0;
            this.modeMoveFactor = factor;
            this.fireEvent(30);
            this.rtFloor = 0;
            this.rtCounter = 0;
            this.isBreak = true;
        } else {
            this.modeMoveFactor = factor;
            this.fireEvent(31);
            int newMode = SimulatorLibrary.getTableIndex((int[])this.modeTable[factor][this.currentMode], (int)16384);
            if (newMode != this.currentMode) {
                this.previousMode = this.currentMode;
                this.currentMode = newMode;
                if (this.currentMode == 2) {
                    this.coursedMode2 = true;
                }
                this.fireEvent(30);
                this.rtFloor = this.rtTable[this.currentMode];
                this.rtCounter = 0;
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                this.fireCoinPlus(9);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 7: {
                this.fireCoinPlus(4);
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        if (game == 1) {
            this.shift = false;
        }
        this.fireCoinMinus(3);
        if (game >= 29 && flag == 1 || game == 30 && this.shift) {
            this.setJacIn();
            this.fireCoinPlus(15);
        } else {
            switch (flag) {
                case 1: {
                    if (jacInCount < 2) {
                        this.setJacIn();
                        this.fireCoinPlus(15);
                        break;
                    }
                    this.shift = true;
                    break;
                }
                case 2: {
                    this.fireCoinPlus(15);
                    break;
                }
                case 3: {
                    this.fireCoinPlus(15);
                }
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void setup() {
        this.currentMode = 1;
        this.nextBonus = -1;
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.nextBonus = SimulatorLibrary.random((int)10) < 6 ? 3 : 4;
            if (this.nextBonus == 3 && this.stock.getBigCount() == 0) {
                this.nextBonus = 4;
            } else if (this.nextBonus == 4 && this.stock.getRegCount() == 0) {
                this.nextBonus = 3;
            }
            if (this.nextBonus == 3) {
                this.stock.removeBig();
            } else {
                this.stock.removeReg();
            }
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.currentMode = this._getNextMode();
            this.coursedMode2 = this.currentMode == 2;
            this.rtFloor = this.rtTable[this.currentMode];
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.currentMode = 1;
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getNextMode() {
        if (this.coursedMode2 && SimulatorLibrary.random((int)256) < 103) {
            return 2;
        }
        return 1;
    }

    public int getModeMoveFactor() {
        return this.modeMoveFactor;
    }

    public int getPreviousMode() {
        return this.previousMode;
    }

    public boolean isCoursedMode2() {
        return this.coursedMode2;
    }
}

