/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.GameraHGV;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.GameraHGV.GameraHGVMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;

public class GameraHGVDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem modeMove0Report = null;
    protected JCheckBoxMenuItem modeMove1Report = null;
    int beforeBonusCoin = 0;

    public static final void main(String[] args) {
        GameraHGVDataCounter main = null;
        try {
            main = new GameraHGVDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public GameraHGVDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.modeMove0Report = new JCheckBoxMenuItem("\u30e2\u30fc\u30c9\u79fb\u884c\u5951\u6a5f\u5c65\u6b74");
        this.addOptionMenu(this.modeMove0Report);
        this.modeMove1Report = new JCheckBoxMenuItem("\u30e2\u30fc\u30c9\u79fb\u884c\u5c65\u6b74");
        this.addOptionMenu(this.modeMove1Report);
        this.modeMove0Report.setSelected(true);
        this.modeMove1Report.setSelected(true);
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30ac\u30e1\u30e9HGV\u30b7\u30df\u30e5\u30ec\u30fc\u30bf";
    }

    protected MainBoardInterface getSimulator() {
        return new GameraHGVMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 31: {
                this.eventModeMove0();
                break;
            }
            case 30: {
                this.eventModeMove1();
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.beforeBonusCoin = this.getCoin();
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        int bonusCoin = this.getCoin() - this.beforeBonusCoin;
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + bonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\tM" + ((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).getPreviousMode());
        if (((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).isCoursedMode2()) {
            this.appendLog("(M2\u7d4c\u7531)");
        } else {
            this.appendLog("");
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventRtStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int mode = ((MainBoardInterface4Stock)((AbstractDataCounter)this).simulator).getCurrentMode();
        this.appendLog("\tM" + mode);
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        int bonusCount = this.getBigCount() + this.getRegCount();
        this.appendLog("\n\n");
        double stayedRatio = 0.0;
        double breakRatio = 0.0;
        this.appendLogPayout();
    }

    protected void eventModeMove0() {
        if (!this.modeMove0Report.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tM");
        this.appendLog(((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode());
        switch (((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).getModeMoveFactor()) {
            case -1: {
                this.appendLog("(\u5929\u4e95)");
                break;
            }
            case 0: {
                this.appendLog("(\u7d14\u30cf\u30ba\u30ec)");
                break;
            }
            case 1: {
                this.appendLog("(\u30ae\u30ed\u30f32\u9023)");
                break;
            }
            case 2: {
                this.appendLog("(\u30c1\u30a7\u30ea2\u9023)");
                break;
            }
            case 3: {
                this.appendLog("(\u30ae\u30e3\u30aa3\u9023)");
                break;
            }
            case 4: {
                this.appendLog("(\u30ea\u30d73\u9023)");
            }
        }
        this.appendLog("\n");
    }

    protected void eventModeMove1() {
        if (!this.modeMove1Report.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tM");
        this.appendLog(((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).getCurrentMode());
        this.appendLog("\u3078\u79fb\u884c");
        switch (((GameraHGVMainBoard)((AbstractDataCounter)this).simulator).getModeMoveFactor()) {
            case -1: {
                this.appendLog("(\u5929\u4e95)");
                break;
            }
            case 0: {
                this.appendLog("(\u7d14\u30cf\u30ba\u30ec)");
                break;
            }
            case 1: {
                this.appendLog("(\u30ae\u30ed\u30f32\u9023)");
                break;
            }
            case 2: {
                this.appendLog("(\u30c1\u30a7\u30ea2\u9023)");
                break;
            }
            case 3: {
                this.appendLog("(\u30ae\u30e3\u30aa3\u9023)");
                break;
            }
            case 4: {
                this.appendLog("(\u30ea\u30d73\u9023)");
            }
        }
        this.appendLog("\n");
    }

    public void eventSimulateStart() {
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

