/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.FD;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class FDMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_0 = 0;
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int MODE_6 = 6;
    public static final int BREAK_NORMAL = 0;
    public static final int BREAK_MM = 1;
    public static final int BREAK_REPLAY4 = 2;
    public static final int BREAK_FLOOR = 3;
    public static final int EVENT_HIGHPLUS = 21;
    public static final int EVENT_MODEMOVE = 22;
    public static final int EVENT_MM_START = 23;
    public static final int EVENT_MM_END = 24;
    private static final int HIGH_BIG = 0;
    private static final int HIGH_REG = 1;
    private static final int HIGH_CHERRY = 2;
    private int replayContinueCount = 0;
    private int mmFloor = 0;
    private int mmCounter = 0;
    private boolean mmClear = false;
    private int zentyouFloor = 6;
    private int zentyouCounter = 0;
    private int highFloor = 0;
    private int currentHitHighGame = 0;
    private int rtCouter = 0;
    public static final int[] highGameCountTable = new int[]{0, 5, 10, 20, 30, 50, 70, 100, 150, 200, 300, 500};
    public static final int[][] highGameTableBig = new int[][]{{1024, 0, 0, 0, 0, 940, 16, 24, 12, 12, 12, 8}, {1024, 0, 0, 0, 0, 780, 16, 139, 53, 16, 12, 8}, {1024, 0, 0, 0, 0, 682, 16, 159, 101, 46, 12, 8}, {1303, 0, 0, 0, 0, 400, 16, 237, 64, 8, 12, 8}, {1365, 0, 0, 0, 0, 483, 16, 140, 16, 8, 12, 8}, {1536, 0, 0, 0, 0, 476, 16, 0, 0, 0, 12, 8}};
    public static final int[][] highGameTableReg = new int[][]{{1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}, {1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}, {1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}, {1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}, {1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}, {1945, 0, 0, 0, 0, 0, 0, 30, 30, 30, 9, 4}};
    public static final int[][] highGameTableCherry = new int[][]{{1365, 350, 197, 1, 128, 1, 1, 1, 1, 1, 1, 1}, {1228, 512, 161, 1, 139, 1, 1, 1, 1, 1, 1, 1}, {1365, 213, 366, 1, 96, 1, 1, 1, 1, 1, 1, 1}, {682, 125, 666, 1, 512, 56, 1, 1, 1, 1, 1, 1}, {512, 175, 517, 1, 512, 256, 70, 1, 1, 1, 1, 1}, {0, 224, 512, 1, 890, 256, 160, 1, 1, 1, 1, 1}};
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    private int[][] flagTableNormal = new int[][]{{48834, 8979, 270, 270, 6200, 328, 655}, {48812, 8979, 271, 271, 6200, 348, 655}, {48691, 8979, 272, 272, 6300, 367, 655}, {48660, 8979, 273, 273, 6300, 396, 655}, {48418, 8979, 274, 274, 6500, 436, 655}, {48301, 8979, 275, 275, 6500, 551, 655}};
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private int[][] flagTableBig = new int[][]{{13652, 16384, 31500, 3000, 1000}, {13652, 16384, 31500, 3000, 1000}, {13652, 16384, 31500, 3000, 1000}, {10152, 16384, 35000, 3000, 1000}, {10152, 16384, 35000, 3000, 1000}, {6652, 16384, 38500, 3000, 1000}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};

    protected void gameRt(int flag) {
        int random65536 = 0;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
            this.replayContinueCount = 0;
        }
        if (this.currentMode == 3 && this.highFloor > 0) {
            this.currentMode = 6;
            this.fireEvent(22);
        }
        switch (flag) {
            case 0: {
                if (this.currentMode == 1) {
                    this.fireCoinPlus(15);
                    this.bonusGet();
                    this.highPlus(0);
                    break;
                }
                if (this.currentMode == 2) {
                    this.fireCoinPlus(1);
                    this.bonusGet();
                    this.highPlus(1);
                    break;
                }
                if (this.currentMode == 5) break;
                switch (this.currentMode) {
                    case 3: {
                        random65536 = SimulatorLibrary.random((int)65536);
                        if (random65536 < 200) {
                            this.mm(1);
                            break;
                        }
                        if (random65536 < 400) {
                            this.mm(2);
                            break;
                        }
                        if (random65536 < 600) {
                            this.mm(3);
                            break;
                        }
                        if (random65536 < 720) {
                            this.currentMode = 5;
                            this.zentyouFloor = 6;
                            this.zentyouCounter = -1;
                            break;
                        }
                        if (random65536 >= 780) break;
                        this.modeMove2Break(0);
                        break;
                    }
                    case 4: {
                        random65536 = SimulatorLibrary.random((int)65536);
                        if (random65536 >= 100) break;
                        this.modeMove2Break(0);
                        break;
                    }
                    case 6: {
                        random65536 = SimulatorLibrary.random((int)65536);
                        if (random65536 < 950) {
                            this.mm(1);
                            break;
                        }
                        if (random65536 < 4800) {
                            this.mm(2);
                            break;
                        }
                        if (random65536 < 8817) {
                            this.mm(3);
                            break;
                        }
                        if (random65536 < 8937) {
                            this.currentMode = 5;
                            this.zentyouFloor = 6;
                            this.zentyouCounter = -1;
                            break;
                        }
                        if (random65536 >= 9137) break;
                        this.modeMove2Break(0);
                    }
                }
                break;
            }
            case 2: {
                this.stock.add(3);
                break;
            }
            case 3: {
                this.stock.add(4);
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                ++this.replayContinueCount;
                if (this.currentMode != 4 || (random65536 = SimulatorLibrary.random((int)65536)) >= 32768) break;
                this.mmClear = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                if (this.currentMode != 4 || (random65536 = SimulatorLibrary.random((int)65536)) >= 655) break;
                this.mmClear = true;
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                if (this.currentMode != 4) break;
                this.mmClear = true;
                break;
            }
            case 6: {
                random65536 = SimulatorLibrary.random((int)65536);
                if (random65536 < 21845) {
                    this.fireCoinPlus(2);
                    this.highPlus(2);
                    break;
                }
                if (random65536 < 32768) {
                    this.fireCoinPlus(4);
                    this.highPlus(2);
                    break;
                }
                this.fireCoinPlus(4);
                if (this.currentMode != 4) break;
                this.highPlus(2);
            }
        }
        if (this.replayContinueCount >= 4) {
            this.modeMove2Break(2);
        }
        switch (this.currentMode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (this.mmClear) {
                    this.modeMove2Break(1);
                }
                ++this.mmCounter;
                if (this.mmCounter < this.mmFloor || this.isBreak) break;
                this.currentMode = this.highFloor > 0 ? 6 : 3;
                this.mmCounter = 0;
                this.mmFloor = 0;
                break;
            }
            case 5: {
                ++this.zentyouCounter;
                if (this.zentyouCounter < this.zentyouFloor) break;
                this.modeMove2Break(0);
                this.zentyouCounter = 0;
                break;
            }
            case 6: {
                --this.highFloor;
                if (this.highFloor >= 1) break;
                this.currentMode = 3;
                this.fireEvent(22);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(this.currentMode) + "stock=" + this.stock.debugOutCount());
            }
        }
        if (!this.isBreak && ++this.rtCounter >= 900) {
            this.modeMove2Break(3);
        }
    }

    protected void gameNotRt(int flag) {
        int random65536 = 0;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 2: {
                this.stock.add(3);
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(4);
                this.reset();
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 5: {
                this.fireCoinPlus(6);
                break;
            }
            case 6: {
                random65536 = SimulatorLibrary.random((int)65536);
                if (random65536 < 21845) {
                    this.fireCoinPlus(2);
                    break;
                }
                if (random65536 < 32768) {
                    this.fireCoinPlus(4);
                    break;
                }
                this.fireCoinPlus(4);
            }
        }
    }

    public void setup() {
        this.currentMode = 0;
        this.nextBonus = -1;
    }

    public void reset() {
        this.isBreak = false;
        this.rtCounter = 0;
        this.mmCounter = 0;
        this.mmFloor = 0;
        this.mmClear = false;
        this.zentyouCounter = 0;
        this.replayContinueCount = 0;
        if (this.stock.size() < 1) {
            this.noStock = true;
            this.currentMode = 0;
        } else {
            this.noStock = false;
            this.currentMode = 3;
        }
        super.reset();
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 22) break;
                this.setJacIn();
                this.fireCoinPlus(1);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(10);
                break;
            }
            case 4: {
                this.fireCoinPlus(4);
            }
        }
    }

    private int _getNextBonus() {
        if (SimulatorLibrary.random((int)9) < 5) {
            this.nextBonus = 3;
            if (this.stock.getBigCount() == 0) {
                this.nextBonus = 4;
            }
        } else {
            this.nextBonus = 4;
            if (this.stock.getRegCount() == 0) {
                this.nextBonus = 3;
            }
        }
        if (this.nextBonus == 3) {
            this.stock.removeBig();
        } else {
            this.stock.removeReg();
        }
        return this.nextBonus;
    }

    private void mm(int game) {
        this.currentMode = 4;
        this.mmClear = false;
        this.mmFloor = game;
        this.mmCounter = -1;
        this.fireEvent(23);
    }

    private void modeMove2Break(int factor) {
        if (this.currentMode == 1 || this.currentMode == 2 || this.isBreak) {
            return;
        }
        this.isBreak = true;
        this.breakFactor = factor;
        this.nextBonus = this._getNextBonus();
        this.currentMode = this.nextBonus == 3 ? 1 : 2;
    }

    private void highPlus(int factor) {
        int index = 0;
        switch (factor) {
            case 0: {
                index = SimulatorLibrary.getTableIndex((int[])highGameTableBig[((AbstractMainBoard)this).settei - 1], (int)2048);
                break;
            }
            case 1: {
                index = SimulatorLibrary.getTableIndex((int[])highGameTableReg[((AbstractMainBoard)this).settei - 1], (int)2048);
                break;
            }
            case 2: {
                index = SimulatorLibrary.getTableIndex((int[])highGameTableCherry[((AbstractMainBoard)this).settei - 1], (int)2048);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.currentHitHighGame = highGameCountTable[index];
        if (this.currentHitHighGame > 0) {
            this.highFloor += this.currentHitHighGame;
            this.fireEvent(21);
        }
    }

    public int[][] getFlagTableHigh() {
        return this.flagTableNormal;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public int getCurrentHitHighGame() {
        return this.currentHitHighGame;
    }

    public int getHighFloor() {
        return this.highFloor;
    }

    public int getMmFloor() {
        return this.mmFloor;
    }
}

