/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.DaiYamato;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class DaiYamatoMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_LOW = 0;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_HIGH = 2;
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int EVENT_MODEMOVE = 25;
    public static final int EVENT_RTRESET_BY_ABOVE8 = 26;
    public static final int EVENT_GZ_START = 27;
    public static final int EVENT_GZ_END = 28;
    public static final int EVENT_8 = 29;
    public static final int EVENT_RTRESET_BY_N8 = 30;
    public static final int BREAK_8 = 11;
    public static final int FLAG_8 = 4;
    public static final int FLAG_12 = 5;
    public static final int FLAG_CHERRY = 6;
    protected int[][] flagTable = new int[][]{{1, 56271, 172, 100, 6944, 440, 1608}, {1, 56255, 188, 100, 6944, 440, 1608}, {1, 56235, 208, 100, 6944, 440, 1608}, {1, 56215, 228, 100, 6944, 440, 1608}, {1, 56195, 248, 100, 6944, 440, 1608}, {1, 56171, 272, 100, 6944, 440, 1608}};
    public static final int FLAG_BIG_15 = 2;
    public static final int FLAG_BIG_12 = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    protected int[][] flagTableBig = new int[][]{{88, 14720, 41270, 6400, 3058}, {88, 14720, 41270, 6400, 3058}, {88, 14720, 41270, 6400, 3058}, {88, 14720, 41270, 6400, 3058}, {88, 14720, 41270, 6400, 3058}, {88, 14720, 41270, 6400, 3058}};
    protected int[][] flagTableJac = new int[][]{{272, 65264}, {272, 65264}, {272, 65264}, {272, 65264}, {272, 65264}, {272, 65264}};
    protected int[][] rtTable1 = new int[][]{{8616, 2090, 2090, 2090, 4174, 1042, 524, 262, 0, 0, 0, 0, 0, 0, 44648}, {9136, 2354, 2090, 2354, 4174, 1042, 524, 262, 0, 0, 0, 0, 0, 0, 43600}, {9136, 2610, 2354, 2610, 4438, 1042, 524, 262, 0, 0, 0, 0, 0, 0, 42560}, {10446, 2870, 2610, 2870, 5223, 1566, 1042, 524, 0, 0, 0, 0, 0, 0, 38385}, {10446, 3655, 2610, 3655, 5223, 1566, 1042, 524, 0, 0, 0, 0, 0, 0, 36815}, {11228, 4700, 2870, 4700, 5742, 1566, 1042, 524, 0, 0, 0, 0, 0, 0, 33164}};
    protected int[][] rtTable2 = new int[][]{{1304, 2608, 1304, 2608, 1304, 2608, 1304, 13058, 20894, 13058, 2092, 1566, 1042, 786, 0}, {1566, 2608, 1566, 2608, 1566, 2608, 1566, 13052, 20894, 13058, 2092, 1304, 786, 262, 0}, {1566, 2870, 1566, 2870, 1566, 2870, 1566, 13318, 20894, 12530, 2092, 1042, 524, 262, 0}, {1828, 3132, 1828, 3132, 1828, 3132, 1828, 13316, 20106, 12530, 1304, 786, 524, 262, 0}, {2090, 3394, 2090, 3394, 2090, 3394, 2090, 13316, 19058, 12530, 1042, 524, 262, 262, 0}, {2352, 3656, 2352, 3656, 2352, 3656, 2352, 13840, 18276, 11472, 786, 262, 262, 262, 0}};
    protected int[][] rtG = new int[][]{{0, 1, 6, 7, 32, 33, 76, 77, 111, 222, 333, 444, 555, 666, 777}, {0, 5, 6, 31, 32, 75, 76, 110, 221, 332, 443, 554, 665, 776, 777}};
    private static final int GZ_FACTOR_BIG = 0;
    private static final int GZ_FACTOR_REG = 1;
    private static final int GZ_FACTOR_12 = 2;
    private static final int GZ_FACTOR_CHERRY1 = 3;
    private static final int GZ_FACTOR_CHERRY2 = 4;
    private static final int GZ_FACTOR_CHERRY3 = 5;
    private int[][] gzHit = new int[][]{{0, 0, 32636, 32900}, {0, 0, 65536, 0}, {37684, 14680, 11732, 1440}, {64096, 1440, 0, 0}, {49348, 16188, 0, 0}, {0, 32640, 16448, 16448}};
    private int[] gzGameCount = new int[]{0, 30, 50, 100};
    private int[][][] modeMove = new int[][][]{new int[][]{{0, 16214, 49322}, {0, 14864, 50672}, {0, 13514, 52022}, {0, 12164, 53372}, {0, 10132, 55404}, {0, 6756, 58780}}, new int[][]{{6756, 41892, 16888}, {6756, 41892, 16888}, {6084, 42564, 16888}, {5408, 43240, 16888}, {4732, 40540, 20264}, {4056, 37832, 23648}}, new int[][]{{3380, 9456, 52700}, {3380, 8784, 53372}, {3380, 8108, 54048}, {2700, 7432, 55404}, {2700, 6082, 56754}, {2024, 4732, 58780}}};
    private int[] rtResetAbove8 = new int[]{18000, 32347, 64695};
    private int[] rtResetNormal8 = new int[]{562, 1688, 22498};
    protected boolean newStock = false;
    private int gzFloor = 0;
    private boolean isSb = false;

    public int getStockType() {
        return 2;
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        int random65536 = -1;
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (!this.isBreak && this.rtCounter > this.rtFloor) {
            this.breakFactor = -10;
            this.isBreak = true;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                random65536 = SimulatorLibrary.random((int)65536);
                this.fireCoinPlus(8);
                if (random65536 < 8235) {
                    this.fireEvent(29);
                    random65536 = SimulatorLibrary.random((int)65536);
                    if (this.rtFloor <= 111 || random65536 >= this.rtResetAbove8[this.currentMode]) break;
                    this.rtFloor = this._getRtFloor();
                    this.fireEvent(26);
                    if (this.rtFloor != 777) break;
                    this.modeMove();
                    break;
                }
                random65536 = SimulatorLibrary.random((int)65536);
                if (this.rtFloor <= 111 || random65536 >= this.rtResetNormal8[this.currentMode]) break;
                this.rtFloor = this._getRtFloor();
                this.fireEvent(30);
                if (this.rtFloor != 777) break;
                this.modeMove();
                break;
            }
            case 6: {
                random65536 = SimulatorLibrary.random((int)65536);
                this.fireCoinPlus(3);
                int gzFactor = 5;
                if (random65536 < 64200) {
                    gzFactor = 3;
                } else if (random65536 < 71736) {
                    gzFactor = 3;
                }
                this.gzHit(gzFactor);
                break;
            }
            case 5: {
                random65536 = SimulatorLibrary.random((int)65536);
                this.fireCoinPlus(12);
                this.gzHit(2);
                break;
            }
            case 1: {
                int random4096 = SimulatorLibrary.random((int)4096);
                if (random4096 < 648) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                ((AbstractMainBoard)this).isReplay = false;
                if (!this.isBreak) break;
                this.isSb = this.gzFloor > 0;
                this.fireCoinPlus(15);
                this.bonusGet();
            }
        }
        if (this.gzFloor > 0) {
            --this.gzFloor;
            if (this.gzFloor == 0) {
                this.fireEvent(28);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 6: {
                this.fireCoinPlus(3);
                break;
            }
            case 5: {
                this.fireCoinPlus(12);
            }
            case 1: {
                int random4096 = SimulatorLibrary.random((int)4096);
                ((AbstractMainBoard)this).isReplay = random4096 < 648;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isSb && jacInCount < 2 || game > 23) {
                    this.setJacIn();
                    this.fireCoinPlus(6);
                    break;
                }
                if ((this.isSb || jacInCount >= 2) && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(6);
                break;
            }
            case 2: {
                if (!this.isSb && SimulatorLibrary.random((int)128) >= 64) break;
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                this.fireCoinPlus(3);
                break;
            }
            case 3: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void setup() {
        this.nextBonus = -1;
        this.currentMode = -1;
    }

    public void reset() {
        this.isBreak = false;
        int previousBonus = this.getCurrentBonus();
        if (this.stock.size() > 0) {
            this.newStock = this.noStock;
            if (this.stock.getBigCount() == 0) {
                this.nextBonus = 4;
            } else if (this.stock.getRegCount() == 0) {
                this.nextBonus = 3;
            } else {
                int n = this.nextBonus = SimulatorLibrary.random((int)65536) < 33531 ? 3 : 4;
            }
            if (this.nextBonus == 3) {
                this.stock.removeBig();
            } else if (this.nextBonus == 4) {
                this.stock.removeReg();
            } else {
                throw new RuntimeException("unknown bonus.");
            }
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            if (this.currentMode < 0) {
                this.currentMode = 1;
                this.fireEvent(25);
            } else {
                this.modeMove();
            }
            if (previousBonus == 3) {
                this.gzFloor = 0;
                this.gzHit(0);
            } else if (previousBonus == 4) {
                this.gzHit(1);
            }
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -12;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = -1;
        index = !this.newStock ? SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)65536) : SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)65536);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }

    private int gzHit(int factor) {
        int index = SimulatorLibrary.getTableIndex((int[])this.gzHit[factor], (int)65536);
        int game = this.gzGameCount[index];
        if (game > 0) {
            this.fireEvent(27);
        }
        this.gzFloor += game;
        return game;
    }

    private int modeMove() {
        int newMode = SimulatorLibrary.getTableIndex((int[])this.modeMove[this.currentMode][((AbstractMainBoard)this).settei - 1], (int)65536);
        if (newMode != this.currentMode) {
            this.currentMode = newMode;
            this.fireEvent(25);
        }
        return newMode;
    }

    public boolean isSb() {
        return this.isSb;
    }
}

