/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.library;

import java.util.AbstractList;
import java.util.ListIterator;
import java.util.Vector;

public class Stock
extends Vector {
    private static final int BIG = 3;
    private static final int REG = 4;
    private int bigCount = 0;
    private int regCount = 0;
    public static final int TYPE_SEQUENCE = 1;
    public static final int TYPE_BR = 2;
    private int type = 1;

    public Stock() {
        this(1);
    }

    public Stock(int type) {
        super(512);
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.bigCount = 0;
        this.regCount = 0;
    }

    public boolean add(int bonus) {
        if (this.type == 1) {
            if (this.size() > 255) {
                return false;
            }
        } else if (this.type == 2) {
            if (this.size() > 511) {
                return false;
            }
            if (bonus == 3 && this.bigCount > 255) {
                return false;
            }
            if (bonus == 4 && this.regCount > 255) {
                return false;
            }
        }
        if (bonus == 3) {
            ++this.bigCount;
        } else if (bonus == 4) {
            ++this.regCount;
        } else {
            throw new IllegalArgumentException("unknown bonus added!");
        }
        return super.add(new Integer(bonus));
    }

    public boolean add(Object bonus) {
        return this.add((Integer)bonus);
    }

    public Object remove(int index) {
        int bonus = (Integer)this.get(index);
        if (bonus == 3) {
            --this.bigCount;
        } else if (bonus == 4) {
            --this.regCount;
        } else {
            throw new RuntimeException("unknown bonus find!");
        }
        return super.remove(index);
    }

    public void removeBig() {
        ListIterator i = ((AbstractList)this).listIterator();
        int index = -1;
        boolean find = false;
        while (i.hasNext()) {
            ++index;
            if ((Integer)i.next() != 3) continue;
            find = true;
            break;
        }
        if (!find) {
            throw new ArrayIndexOutOfBoundsException(this.size() + ":" + this.debugOutCount() + ":" + this.debugOutBonus());
        }
        this.remove(index);
    }

    public void removeReg() {
        ListIterator i = ((AbstractList)this).listIterator();
        int index = -1;
        boolean find = false;
        while (i.hasNext()) {
            ++index;
            if ((Integer)i.next() != 4) continue;
            find = true;
            break;
        }
        if (!find) {
            throw new ArrayIndexOutOfBoundsException(this.size() + ":" + this.debugOutCount() + ":" + this.debugOutBonus());
        }
        this.remove(index);
    }

    public int getBigCount() {
        return this.bigCount;
    }

    public int getRegCount() {
        return this.regCount;
    }

    public boolean isNoStock() {
        return this.bigCount + this.regCount == 0;
    }

    public String debugOutCount() {
        return "B" + this.bigCount + "R" + this.regCount;
    }

    public String debugOutBonus() {
        StringBuffer buffer = new StringBuffer();
        ListIterator iterator = ((AbstractList)this).listIterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            buffer.append(i == 3 ? "B" : "R");
        }
        return buffer.toString();
    }
}

