/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import java.awt.Component;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.datacounter.DataCounterInterface;
import jp.sourceforge.slotsimulator.datacounter.DataCounterListener;
import jp.sourceforge.slotsimulator.datacounter.SlumpPanel;
import jp.sourceforge.slotsimulator.datacounter.StrategyLogPanel;
import jp.sourceforge.slotsimulator.datacounter.StrategyMonitorInterface;
import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class DefaultStrategyMonitor
implements DataCounterInterface,
DataCounterListener,
StrategyMonitorInterface {
    private static int strategyCount = 0;
    private String title = null;
    private int myStrategyCount = 0;
    protected StrategyLogPanel logPanel = null;
    protected SlumpPanel slumpGraph = null;
    protected int coin = 0;
    protected int inCoin = 0;
    protected int outCoin = 0;
    protected boolean checking = false;
    protected boolean isError = false;
    protected boolean isBonus = false;
    protected int strategyPreviousBonusGame = 0;
    protected int strategyPreviousBonusKind = 0;
    protected int strategyStartGameBonusKind = 0;
    protected int strategyStartGame = 0;
    protected int strategyStopGame = 0;
    protected int strategyEndGame = 0;
    protected int previousBonusGame = 0;
    protected int previousBonusKind = 0;
    protected int totalGameCount = 0;
    protected List listeners = new Vector();
    protected DataCounterInterface sender = null;
    private int testCount = 0;
    private int testWinCount = 0;
    private int test1Coin = 0;
    private int test1In = 0;
    private int test1CoinMin = 0;
    private int test1Out = 0;
    private int test1Game = 0;
    private int testNOutTotal = 0;
    private int testNInTotal = 0;
    int bonusCoin = 0;

    public void create(DataCounterInterface sender) {
        try {
            this.logPanel = new StrategyLogPanel();
            this.logPanel.initialize();
            this.sender = sender;
            this.myStrategyCount = ++strategyCount;
            this.title = "\u7acb\u3061\u56de\u308a" + this.myStrategyCount;
            ((AbstractDataCounter4Stock)sender).addLogPanel(this.title, this.logPanel);
            sender.addListener(this);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public void terminate() {
        if (this.slumpGraph != null) {
            this.slumpGraph.dispose();
            this.slumpGraph = null;
        }
        if (this.sender != null) {
            ((AbstractDataCounter4Stock)this.sender).removeLogPanel(this.logPanel);
            this.sender = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.logPanel = null;
    }

    public void finalize() throws Throwable {
        try {
            this.terminate();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void addListener(DataCounterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DataCounterListener l) {
        this.listeners.remove(l);
    }

    public int getMaxSimulateGame() {
        return this.sender.getMaxSimulateGame();
    }

    public int getCurrentBonus() {
        return this.sender.getCurrentBonus();
    }

    public MainBoardInterface getSimulatorRef() {
        return this.sender.getSimulatorRef();
    }

    public void coinMinus(int state, int minus, int currentGameCount, int bigIntervalGameCount) {
        if (this.checking) {
            this.test1Coin -= minus;
            if (this.test1Coin < this.test1CoinMin) {
                this.test1CoinMin = this.test1Coin;
                this.test1In += minus;
                this.test1Out = 0;
            } else {
                this.test1Out -= minus;
            }
            this.inCoin += minus;
            this.coin -= minus;
            ListIterator i = null;
            try {
                i = this.listeners.listIterator();
                while (i.hasNext()) {
                    ((DataCounterListener)i.next()).coinMinus(state, minus, currentGameCount, bigIntervalGameCount);
                }
                Object var7_6 = null;
                i = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                i = null;
                throw throwable;
            }
        }
    }

    public void coinPlus(int state, int plus, int currentGameCount, int bigIntervalGameCount) {
        if (this.checking) {
            this.test1Coin += plus;
            this.test1Out += plus;
            this.outCoin += plus;
            this.coin += plus;
            ListIterator i = null;
            try {
                i = this.listeners.listIterator();
                while (i.hasNext()) {
                    ((DataCounterListener)i.next()).coinPlus(state, plus, currentGameCount, bigIntervalGameCount);
                }
                Object var7_6 = null;
                i = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                i = null;
                throw throwable;
            }
        }
    }

    public void event(int eventId, int currentGameCount, int bigIntervalGameCount) {
        switch (eventId) {
            case 1: {
                this.testCount = 0;
                this.testWinCount = 0;
                this.test1Coin = 0;
                this.test1In = 0;
                this.test1CoinMin = 0;
                this.test1Out = 0;
                this.test1Game = 0;
                this.testNOutTotal = 0;
                this.testNInTotal = 0;
                this.isError = false;
                this.isBonus = false;
                this.totalGameCount = 0;
                this.coin = 0;
                this.inCoin = 0;
                this.outCoin = 0;
                this.checking = false;
                this.logPanel.clear();
                this.strategyPreviousBonusGame = this.logPanel.getPreviousBonusGame();
                this.strategyStartGameBonusKind = this.logPanel.getStartGameBonusKind();
                this.strategyStartGame = this.logPanel.getStartGame();
                this.strategyStopGame = this.logPanel.getStopGame();
                this.strategyEndGame = this.logPanel.getEndGame();
                if (this.strategyStartGame == 0) {
                    this.isError = true;
                }
                if (this.logPanel.isSlumpGraph()) {
                    if (this.slumpGraph == null) {
                        this.slumpGraph = new SlumpPanel();
                        this.slumpGraph.create(this, this.title);
                        ((Component)this.slumpGraph).setBounds(50 + this.myStrategyCount * 16, 50 + this.myStrategyCount * 16, 350, 300);
                    }
                } else if (this.slumpGraph != null) {
                    this.slumpGraph.dispose();
                    this.slumpGraph = null;
                }
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logSimulateStart();
                break;
            }
            case 3: {
                if (this.isError) {
                    return;
                }
                if (this.checking) {
                    ++this.test1Game;
                    ++this.totalGameCount;
                    this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                    if (!this.isStop(currentGameCount, bigIntervalGameCount, this.isBonus, this.previousBonusKind)) break;
                    this.testNInTotal += this.test1In;
                    this.testNOutTotal += this.test1Out;
                    if (this.test1Out - this.test1In > 0) {
                        ++this.testWinCount;
                    }
                    this.checking = false;
                    if (this.isBonus) {
                        this.logEnd(currentGameCount, bigIntervalGameCount);
                        break;
                    }
                    this.logStop(currentGameCount, bigIntervalGameCount);
                    break;
                }
                if (!this.isStart(currentGameCount, bigIntervalGameCount, this.previousBonusKind)) break;
                ++this.testCount;
                this.test1Coin = 0;
                this.test1In = 0;
                this.test1CoinMin = 0;
                this.test1Out = 0;
                this.test1Game = 0;
                this.checking = true;
                this.isBonus = false;
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logStart(currentGameCount, bigIntervalGameCount);
                break;
            }
            case 4: {
                if (this.isError) {
                    return;
                }
                this.previousBonusGame = currentGameCount;
                if (!this.checking) break;
                this.logBonusStart(currentGameCount, bigIntervalGameCount);
                break;
            }
            case 5: {
                if (this.isError) {
                    return;
                }
                this.previousBonusKind = this.sender.getCurrentBonus();
                if (!this.checking) break;
                this.logBonusEnd(currentGameCount, bigIntervalGameCount);
                this.isBonus = true;
                break;
            }
            case 2: {
                if (this.isError) {
                    return;
                }
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logSimulateEnd();
            }
        }
    }

    protected boolean isStart(int currentGameCount, int bigIntervalGameCount, int previousBonusKind) {
        return currentGameCount >= this.strategyStartGame && currentGameCount < this.strategyStopGame && this.previousBonusGame > this.strategyPreviousBonusGame;
    }

    protected boolean isStop(int currentGameCount, int bigIntervalGameCount, boolean isBonus, int previousBonusKind) {
        if (currentGameCount > this.strategyStopGame) {
            return true;
        }
        return currentGameCount > this.strategyEndGame && isBonus;
    }

    protected void fireEvent(int eventId, int currentGameCount, int bigIntervalGameCount) {
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((DataCounterListener)i.next()).event(eventId, currentGameCount, bigIntervalGameCount);
            }
            Object var6_5 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            i = null;
            throw throwable;
        }
    }

    public void logSimulateStart() {
        if (this.isError) {
            this.logPanel.addTextLine("\u5165\u529b\u6761\u4ef6\u304c\u77db\u76fe\u3057\u3066\u307e\u305b\u3093\uff1f");
        } else {
            this.logPanel.addTextLine("\u958b\u59cb\u3057\u307e\u3059\u3002");
        }
    }

    public void logStart(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u6253\u3061\u59cb\u3081");
        this.logPanel.addTextLine(this.state());
    }

    public void logEnd(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u30e4\u30e1");
        this.logPanel.addTextLine(this.state());
        this.logPanel.addTextLine("");
    }

    public void logStop(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u3042\u304d\u3089\u3081");
        this.logPanel.addTextLine(this.state());
        this.logPanel.addTextLine("");
    }

    protected String state() {
        return "\t" + this.coin + "\t\u6295\u8cc7" + this.test1In + "\u679a \u56de\u53ce" + this.test1Out + "\u679a \u5dee\u679a" + (this.test1Out - this.test1In) + "\u679a@" + this.test1Game + "G";
    }

    public void logBonusStart(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.bonusCoin = this.coin;
    }

    public void logBonusEnd(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.bonusCoin = this.coin - this.bonusCoin;
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\tBONUS[");
        this.logPanel.addText(String.valueOf(this.bonusCoin));
        this.logPanel.addText("]");
        this.logPanel.addTextLine(this.state());
    }

    public void logSimulateEnd() {
        double pay = (double)this.outCoin / (double)this.inCoin * 100.0;
        this.logPanel.addTextLine("");
        this.logPanel.addText("\u7dcf\u56de\u8ee2\u6570\t");
        this.logPanel.addTextLine(String.valueOf(this.totalGameCount));
        this.logPanel.addText("in:\t");
        this.logPanel.addTextLine(String.valueOf(this.inCoin));
        this.logPanel.addText("out:\t");
        this.logPanel.addTextLine(String.valueOf(this.outCoin));
        this.logPanel.addText("\u5dee\u679a:\t");
        this.logPanel.addText(String.valueOf(this.coin));
        this.logPanel.addText("(");
        this.logPanel.addText(String.valueOf(pay));
        this.logPanel.addTextLine("%)");
        this.logPanel.addTextLine("");
        this.logPanel.addTextLine("\u8a66\u884c\u56de\u6570\t" + this.testCount);
        this.logPanel.addTextLine("\u52dd\u5229\u56de\u6570\t" + this.testWinCount);
        this.logPanel.addTextLine("\u52dd\u7387\t" + SimulatorLibrary.getPercent(this.testWinCount, this.testCount));
        this.logPanel.addTextLine("");
        this.logPanel.addTextLine("\u5e73\u5747\u30b2\u30fc\u30e0\t" + this.totalGameCount / this.testCount + "G");
        this.logPanel.addTextLine("\u5e73\u5747\u6295\u8cc7\t" + this.testNInTotal / this.testCount + "\u679a");
        this.logPanel.addTextLine("\u5e73\u5747\u56de\u53ce\t" + this.testNOutTotal / this.testCount + "\u679a");
        this.logPanel.addTextLine("\u5e73\u5747\u5dee\u679a\t" + this.coin / this.testCount + "\u679a");
        this.logPanel.addTextLine("700G\u3042\u305f\u308a\t" + (double)this.coin / (double)this.totalGameCount * 700.0 + "\u679a");
    }
}

