{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Vars

 Global variables

*********************************************************}
unit Vars;

interface

uses
  SysUtils, Classes, Classes2, Graphics, ZLibEx, WinSock, Windows, Constants,
  STypes, Bans, BlckSock, SynSock, Users, LocalUsers, Registered, Servers,
  Slavastrings, Class_Cmdlist, Class_CmdExList, Class_DoubleCmdList,
    Class_Cmd2List;

type
  TWQBlockMethod = (Block, Leech, Ban);

var
  Running, Restarting, ShowForm, Closing, Win98: Boolean;
  ApplicationDir: string;
  // Server main variables
  Server_Socket: array[0..MAX_LISTEN_SOCKET] of HSocket;
  Server_Port: array[0..MAX_LISTEN_SOCKET] of Integer;
  ServerName_T, ServerName_I: string;
    // 2 variables instead of one to make it thread-safe
  ServerAlias: string;
  MyServerHandle: Integer;
  Listen_Interface: string;
  Sync_Reply_List: TNapDoubleCmdList;
  Cmd_List: TNapDoubleCmdList;
  Log_File, Debug_File: TFileStream;
  Start_Time: Cardinal;
  Start_Time_T: Time_T;
  Cpu_Usage: Integer;
  Cpu_Disable: Boolean;
  Friend_Sound: Boolean;
  // Meta_Enabled  : Boolean;
  // Meta_Port  : Integer;
  // Options
  Language: string;
  Null_Password: string;
  // Limits and Settings
  Registered_Only: Boolean;
  Allow_Register: Boolean;
  Accept_Remote_Users: Boolean;
  Max_Users: Integer;
  Stats_Delay: Cardinal;
  Max_Hotlist: Integer;
  Max_Ignorelist: Integer;
  Max_Clones: Integer;
  Memory_Limit: Integer;
  DefSearchResults: Integer;
  MaxSearchResults: Integer;
  MaxRemoteSearchResults: Integer;
  DisableRemoteSearch: Boolean;
  MaxBrowseResults: Integer;
  MaxRemoteBrowse: Integer;
  Search_Noforward_Results, Search_Noforward_Requests: Boolean;
  Browse_Noforward_Results, Browse_Noforward_Requests: Boolean;
  TimeOut_Remote_Search: Cardinal;
  Linking: Boolean;
  Max_Users_Per_Minute, Users_Per_Minute: Integer;
  Allow_Create_Channels: Boolean;
  Redirect_Cqex: Boolean;
  Old_Opsay: Boolean;
  Max_Channels, Max_Channels_Total: Integer;
  Block_Cqex_Chat: Boolean;
  Bytes_in, Bytes_Out, Total_Bytes_in, Total_Bytes_Out: Int64;
  Last_Bytes_in, Last_Bytes_Out: Int64;
  Total_Searches, Num_Searches, Last_Searches, Successful_Searches,
    Total_Search_Results: Int64;
  Total_Transfers, Num_Transfers, Last_Transfers: Int64;
  Total_Browses, Num_Browses, Last_Browses, Total_Browse_Results: Int64;
  Num_Login, Last_Login: Integer;
  Num_Rejects, Last_Rejects: Integer;
  Num_Servers, Direct_Links: Integer;
  Num_Processed: Integer;
  Blocked_Clients: array[0..softUnknown] of Boolean;
  Blocked_Clients_Desc: array[0..29] of PChar = ('Napster', 'audioGnome',
    'WinMX (normal)', 'GnomePlus', 'Amster', 'FileNavigator', 'CQEX',
    'SunshineUN', 'Teknap', 'Nap', 'MacNap', 'MP3Rage', 'XNap', 'Spotlight',
    'NFS', 'DMNapster', 'KNapster', 'Lopster', 'Rapigator', 'Swaptor', 'Dagsta',
    'Floodster', 'Drumbeat', 'WinMX (changed)', 'MlDonkey', 'Napigator',
    'Opennap', 'Nap v0.8', 'WinMX (Japanese)', 'Other');
  Blocked_Custom: array[0..MAX_CUSTOM_BLOCK] of string;
  Blocked_Messagetype: TBlockedMessageType;
  Blocked_Message: string;
  Limit_Mx, Mx_UsePing: Boolean;
  Quota_Mx: Integer;
  Mx_Users: Integer;
  Mx_Ban: Integer;
  Ban_FakeMX: Boolean;
  Allow_Link: TAllowLinkType;
  Allowed_Servers: string;
  Restrict_Outgoing: Boolean;
  Outgoing_List: string;
  Switch_Chat: Boolean;
  Sockets_Users_default: Boolean;
  Sockets_Users_Send, Sockets_Users_Recv: Integer;
  Sockets_Servers_default: Boolean;
  Sockets_Servers_Send, Sockets_Servers_Recv: Integer;
  Max_Privmsg_Len, Max_Channelmsg_Len: Integer;
  Show_Operators: Boolean;
  Network_Hub: Boolean;
  Hub_Syncreg, Hub_Syncban, Hub_SyncBlock: Boolean;
  Wallop_Serverban: Boolean;
  BanMail: string;
  Redirect_Url: string;
  Channels_Irc, Channels_Low, Channels_Timestamp: Boolean;
  AutoLink_Only1: Boolean;
  Restart_User: string;
  Prevent_Shouting: Boolean;
  Chat_Flash, Chat_Mini, Wallop_Im, Wallop_Sound: Boolean;
  Reconnect_Delay: Boolean;
  Ping_Users: Boolean;
  True_Stats: Boolean;
  Max_Servers_Enabled: Boolean;
  Max_Servers: Integer;
  Remote_Admin_Ok: Boolean;
  Remote_Adminpass: string;
  // Lists
  DB_Online: TOnlineUsers;
  DB_Local: TMyList;
  DB_Servers: TMyList;
  DB_Blocks: TMyList;
  DB_Registered: TRegUserDataBase;
  DB_Bans: TBanList;
  DB_Motd: TStringHash;
  DB_Friends: TStringHash;
  DB_Channels: TMyList;
  DB_Software: TNapCmd2List;
  DB_Invitations: TNapCmdExList;
  DB_Reconnect: TMyStringList; // for reconnectors
  DB_Whowas: TNapCmdExList;
  DB_Ips: TNapCmdExList;
  DB_Ips_Local: string;
  DB_Closed: TNapCmd2List; // List of Closed sockets
  DB_Dirs: TNapCmdList;
  // Console
  Cons: TLocalUser;
  Cons_Channels: TMyList;
  Cons_Chat: TMyList;
  Cons_Whois: TMyList;
  Cons_Blocks: TStringHash;
  Cons_Friends: TStringHash;
  Cons_Ignored: TStringHash;
  Cons_List: TConsoleList;
  Cons_Reg_User: string;
  Cons_Autojoin1, Cons_Autojoin2, Cons_Autojoin3: string;
  // interface
  B3_Canclose: Bool3;
  Allow_Multiple_Instances, Startup_Hide: Boolean;
  Last_Away_User: string;
  Last_Away_Time: Cardinal;
  IsHide: array[0..30] of Boolean; // List_Users Column visibility
  // Log
  Log_To_File, Log_Console_Data: Boolean;
  Save_Stats: Boolean;
  Clear_Serverstats,
    Clear_Clientstats: Boolean;
  Log_Commands: Boolean;
  Log_Servercommands: Boolean;
  Log_Napigator: Boolean;
  Log_Dagsta: Boolean;
  Log_Login: Boolean;
  Log_Search: Boolean;
  Log_Browse: Boolean;
  Log_Transfers: Boolean;
  // Log_Links: Boolean;
   // Timeouts
  TimeOut_Login: Cardinal;
  Current_Time: Cardinal;
  Current_Time_T: Time_T;
  // Statistics
  Local_Users, Total_Users, Local_Users_Max,
    Total_Users_Limit, Total_Users_Max: Integer;
  Local_Files, Total_Files, Local_Files_Max, Total_Files_Max,
    Local_Bytes, Total_Bytes, Local_Bytes_Max, Total_Bytes_Max: Int64;
  Total_Connections: Integer;
  // Sharing
  Allow_Share, ShareInform: Boolean;
  Share_Nomodem, Share_Checkdup: Boolean;
  MinShare, MaxShare: Integer;
  MinFileName: Integer;
  MinDuration: Integer;
  Share_Auto_FriendAdd_Minimum: Integer;
  Auto_FriendAdd: Boolean;
  MaxShareIndex: Integer;
  MaxShare_Total: Int64;
  MaxShare_Audio, MaxShare_Video, MaxShare_Image, MaxShare_App, MaxShare_Cd,
    MaxShare_Text, MaxShare_Mp3: Integer;
  MinFileSize_Audio, MaxFileSize_Audio,
    MinFileSize_Video, MaxFileSize_Video,
    MinFileSize_Image, MaxFileSize_Image,
    MinFileSize_App, MaxFileSize_App,
    MinFileSize_Cd, MaxFileSize_Cd,
    MinFileSize_Text, MaxFileSize_Text,
    MinFileSize_Mp3, MaxFileSize_Mp3: Int64;
  Ext_Mp3, Ext_Audio, Ext_Video, Ext_Text, Ext_Image, Ext_App, Ext_Cd: string;
  Ext_Mp3_List, Ext_Audio_List, Ext_Video_List, Ext_App_List, Ext_Image_List,
    Ext_Cd_List, Ext_Text_List: TStringHash;
  Share_320, Share_256, Share_224, Share_192, Share_160, Share_128, Share_112,
    Share_96, Share_80, Share_64, Share_56, Share_48, Share_40, Share_32,
    Share_24, Share_Unknown: Boolean;
  // Blocklist
  Block_AllowShare, Block_AllowShare_Admins, Block_CheckMods: Boolean;
  // Napigator
  Stats_Socket: HSocket;
  Napigator_Socket: HSocket;
  Napigator_Host: string;
  Napigator_Port: string;
  Napigator_User: string;
  Napigator_Password: string;
  Napigator_Salt: string;
  Napigator_MyPort: Integer;
  Napigator_Enabled: Boolean;
  Napigator_Myip: string;
  Napigator_Autodisconnect: Boolean;
  Napigator_Delay: Cardinal;
  Napigator_Fake_Ip: Boolean;
  Dagsta_Socket: HSocket;
  Dagsta_Host: string;
  Dagsta_Port: string;
  Dagsta_User: string;
  Dagsta_Password: string;
  Dagsta_Salt: string;
  Dagsta_MyPort: Integer;
  Dagsta_Enabled: Boolean;
  Dagsta_Myip: string;
  Dagsta_Autodisconnect: Boolean;
  Dagsta_Delay: Cardinal;
  // Bots
  Ann_Enabled: Boolean;
  Ann_Delay, Last_Announcement: Cardinal;
  Ann_User: string;
  Ann_Messages: array[0..MAX_ANNOUNCEMENT] of string;
  Old_Report_Enabled: Boolean;
  Old_Report_Socket: HSocket;
  Old_Report_Port: Integer;
  New_Report_Enabled: Boolean;
  New_Report_Socket: HSocket;
  Meta_Socket: HSocket;
  New_Report_Port: Integer;
  New_Report_Hide_Hub: Boolean;
  MinShare_Delay: Cardinal;
  MinShare_Ban: Boolean;
  MinShare_Banip: Boolean;
  MinShare_Bantime: Integer; // Seconds
  MinShare_Size: Int64;
  MinShare_Fullonly: Boolean;
  MinShare_Only10: Boolean;
  MinShare_Kickchat: Boolean;
  // Bandwith limits
  Bandwidth_Up, Bandwidth_Down, Bandwidth_MaxUp, Bandwidth_MaxDown,
    Bandwidth_Allowedup, Bandwidth_Alloweddown: Integer;
  Bandwidth_Limitservers, Bandwidth_Limited: Boolean;
  Bandwidth_Lastcheck: Cardinal;
  // Flood control
  Flood_Max_User_Message: Integer;
  Flood_Max_Same_Message: Integer;
  Flood_Warning: Boolean;
  Flood_Enable: Boolean;
  Flood_Max_Searches: Integer;
  // From handler.pas
  Tmp_Pos: Integer;
    // Debug variable. Shows position of exception. Assign unique digit - last used digit should be written at last line of Handler.pas
  // for checksync.pas
  Check_Sync_T: Integer;
  // Colors
  slError,
    slWallop,
    slAnnounce,
    slWhowas,
    slPong,
    slOffline,
    slOnline,
    slDebugData,
    slNapigator,
    slDagsta,
    slSearch,
    slBrowse,
    slTransfer,
    slTopic,
    slChannelMessage,
    slChannelMyMessage,
    slChannelEmote,
    slChannelMyEmote,
    slChannelJoin,
    slChannelPart,
    slChatMessage,
    slChatMyMessage,
    slBackground,
    slText: Integer;
  // Other
  SearchBlock_ChkFiles: Boolean;
  SearchBlock_ChkSize: Boolean;
  SearchBlock_Hard: Boolean;
  SearchBlock_Files: Integer;
  SearchBlock_Size: Int64;
  DomBlock_ChkFiles: Boolean;
  DomBlock_ChkSize: Boolean;
  DomBlock_Hard: Boolean;
  DomBlock_Files: Integer;
  DomBlock_Size: Int64;
  DLFloodBlock_Count: Integer;
  DLFloodBlock_Method: TWQBlockMethod; // (Block, leech, Ban)
  DLFloodBlock_Bantime: Cardinal;
  WQFloodBlock_Count: Integer;
  WQFloodBlock_Method: TWQBlockMethod; // (Block, leech, Ban)
  WQFloodBlock_Bantime: Cardinal;
  Nocount_Text: Boolean;
  Autoban_Incomplete: Boolean;
  Disable_FakeExt: Boolean;
  Fakeext: string;
  Fakeext_List: TStringHash;
  Enable_TrapPort: Boolean;
  Trap_Socket: array[0..MAX_LISTEN_TRAPSOCKET] of HSocket;
  Trap_Port: array[0..MAX_LISTEN_TRAPSOCKET] of Integer;
  Cons_Browse: TMyList;
  Block_TransferPort: Boolean;
  Blocked_TransferPort: string;
  Blocked_TransferPort_List: TStringHash;
  Share_MatchedFile_Only: Boolean;
  Enable_Loginim: Boolean;
  LoginIMBot: string;
  Loginim: array[0..MAX_LOGINIM] of string;
  Force_Enter: Boolean;
  Force_Enter_Channel: string;
  Force_Enter_Channel_List: TStringHash;
  Allow_2ByteName: Boolean;
  Check_Loginpass: Boolean;
  Loginpass: string;
  Enable_Msgserv: Boolean;
  DB_MsgServ: TStringHash;
  Restrict_Hitperuser: Boolean;
  MaxHitPerUser: Integer;
  MinShare_NoBlockAct: Boolean;
  Kill_Idleuser: Boolean;
  Kill_Idleuser_Time: Cardinal;
  Listall_for_Users: Boolean;
  Block_Weird_XnapFile: Boolean;
  Suggest_DBrowse: Boolean;
  Log_Folder: string;
  Max_Resolving_Count: Integer;
  DB_Login: TMyList;
  Last_Force_Enter: Cardinal;
  Allow_Rtf_Code: Boolean;
  Enable_Metaserver: Boolean;
  MetaPort: string;
  MetaPort_List: array of Integer;
  Metasocket_List: array of HSocket;
  Redirected_Server: string;
  Redirected_Server_Chk: string;
  Redirected_Servers: TNapCmdList;
  IsSetupFailed: Boolean;
  Disable_Nullip: Boolean;

implementation

procedure CheckWindows;
var
  OSVersionInfo: TOSVersionInfo;
begin
  OSVersionInfo.dwOSVersionInfoSize := SizeOf(OSVersionInfo);
  GetVersionEx(OSVersionInfo);
  Win98 := OSVersionInfo.dwPlatformId = 1;
end;

initialization
  CheckWindows;
end.
