{*********************************************************

 Unit: AnnounceForm

 Announce messages window (inherited from private messages window)
 ̃t@CɊւ鎿͂ցusj12262@hotmail.com

*********************************************************}
unit AnnounceForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Menus, LocalUsers, StringResources;

type
  TSlavaNapAnnounceWindow = class(TForm)
    Panel_Bottom: TPanel;
    Edit: TEdit;
    Panel_Left: TPanel;
    Log: TRichEdit;
    MainMenu1: TMainMenu;
    Mnu_Close: TMenuItem;
    Mnu_Whois: TMenuItem;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Panel_BottomResize(Sender: TObject);
    procedure LogChange(Sender: TObject);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure editKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Mnu_Draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect;
      Selected: Boolean);
    procedure Mnu_CloseClick(Sender: TObject);
    procedure Mnu_WhoisClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MyWndProc(var Message: TMessage);
  private
    { Private declarations }
  public
    { Public declarations }
    Users: TStringList;
    History: TStringList;
    Last: Integer;
    Flash_Count: Integer;
    procedure AddMessage(Color: Integer; Text: string);
    procedure ChangeColors;
  end;

var
  SlavaNapAnnounceWindow: TSlavaNapAnnounceWindow;

implementation

uses STypes, Vars, Constants, Lang, SlavaMenu;

{$R *.DFM}

procedure TSlavaNapAnnounceWindow.Panel_BottomResize(Sender: TObject);
begin
  Edit.Width := Panel_Bottom.Width - 4;
end;

procedure TSlavaNapAnnounceWindow.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapAnnounceWindow.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
  History := TStringList.Create;
  WindowProc := MyWndProc;
  Flash_Count := 100;
  SetActiveWindow(Handle);
  Log.Lines.Clear;
  Edit.Text := '';
  ChangeColors;
  if Chat_Mini then
    WindowState := wsMinimized;
end;

procedure TSlavaNapAnnounceWindow.LogChange(Sender: TObject);
var
  C1: TRichEdit;
begin
  if Sender Is TRichEdit then
  begin
    C1 := Sender as TRichEdit;
    C1.SelStart := C1.Perform(EM_LINEINDEX, C1.Lines.Count, 0);
    C1.Perform(EM_SCROLLCARET, 0, 0);
    Exit;
  end;
end;

procedure TSlavaNapAnnounceWindow.editKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #13 then
    Key := #0;
end;

procedure TSlavaNapAnnounceWindow.AddMessage(Color: Integer; Text: string);
begin
  try
    if Log.Lines.Count > 300 then
    begin
      Log.Lines.BeginUpdate;
      while Log.Lines.Count > 300 do
        Log.Lines.Delete(0);
      Log.Lines.EndUpdate;
    end;
    Log.SelLength := 0;
    Log.SelStart := Length(Log.Text);
    Log.SelAttributes.Color := Color;
    // Log.Lines.Add(GetLogTime + Text);
    Log.Lines.Add(Text);
    LogChange(Log);
    if Chat_Flash then
      Flash_Count := 0;
  except
  end;
  try
    if Switch_Chat then
      Edit.SetFocus;
  except
  end;
end;

procedure TSlavaNapAnnounceWindow.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  Users.Free;
  Users := nil;
  History.Free;
  History := nil;
  if Cons_Chat <> nil then
    for I := Cons_Chat.Count - 1 downto 0 do
      if Cons_Chat.Items[I] = Self then
        Cons_Chat.Delete(I);
end;

procedure TSlavaNapAnnounceWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TSlavaNapAnnounceWindow.editKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Str: string;
  I: Integer;
begin
  case Key of
    13:
      try
        if not Running then Exit;
        Str := Edit.Text;
        for I := 0 to Users.Count - 1 do
          Cmd_List.AddDoubleCmd(MSG_CLIENT_PRIVMSG, 0,
            Format(RS_AnnounceForm_SendMsg, [Users[I], Str]), '');
        Self.AddMessage(slChatMyMessage, Format(RS_AnnounceForm_ShowMsg,
          [Cons.Nick, Str]));
        Last := History.Add(Str) + 1;
        if History.Count > 100 then
        begin
          History.Delete(0);
          Dec(Last);
        end;
        Edit.Text := '';
      except
      end;
    38:
      begin // Up
        if Last > 0 then
        begin
          Dec(Last);
          Str := History.Strings[Last];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end
        else if History.Count > 0 then
        begin
          Str := History.Strings[0];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end;
      end;
    40:
      begin // Down
        if Last < (History.Count - 1) then
        begin
          Inc(Last);
          Str := History.Strings[Last];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end
        else
        begin
          Last := History.Count;
          Edit.Text := '';
        end;
      end;
  end;
end;

procedure TSlavaNapAnnounceWindow.Mnu_Draw(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
  SlavaDrawMainMenu(Self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapAnnounceWindow.Mnu_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapAnnounceWindow.Mnu_WhoisClick(Sender: TObject);
var
  I: Integer;
begin
  if not Running then Exit;
  I := 0;
  while (I < 5) and (I < Users.Count) do
  begin
    Cmd_List.AddDoubleCmd(MSG_CLIENT_WHOIS, 0, Users[I], '');
    Inc(I);
  end;
end;

procedure TSlavaNapAnnounceWindow.FormShow(Sender: TObject);
begin
  Mnu_Close.Caption := GetLangI(LNG_CMNU_CLOSE);
end;

procedure TSlavaNapAnnounceWindow.FormResize(Sender: TObject);
begin
  try
    Log.Invalidate;
  except
  end;
end;

procedure TSlavaNapAnnounceWindow.Timer1Timer(Sender: TObject);
begin
  if Flash_Count < 11 then
    FlashWindow(Handle, not Active);
  if Flash_Count = 11 then
    FlashWindow(Handle, False);
  Inc(Flash_Count);
end;

procedure TSlavaNapAnnounceWindow.FormActivate(Sender: TObject);
begin
  Flash_Count := 100;
end;

procedure TSlavaNapAnnounceWindow.MyWndProc(var Message: TMessage);
begin
  WndProc(Message);
  if Message.Msg = WM_ACTIVATE then
    Flash_Count := 100;
end;

procedure TSlavaNapAnnounceWindow.ChangeColors;
begin
  Log.Color := slBackground;
  Log.Font.Color := slText;
  Edit.Color := slBackground;
  Edit.Font.Color := slText;
end;

end.
