{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: settings

 Settings window

*********************************************************}
unit settings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, OfficePanel, ComCtrls, StdCtrls, inifiles, registry,
  SpectrumCombo, ShellApi, Buttons, Spin, basecombo, DFWPages;

type
  TSlavaNapSettings = class(TForm)
    Panel1: TPanel;
    ksoOfficePanel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    header: TPaintBox;
    tree: TTreeView;
    pages: TDFWPageControles;
    sh_main: TDFWTabSheetes;
    btn_change: TButton;
    btn_restore: TButton;
    btn_close: TButton;
    lbl_note: TLabel;
    lbl_change: TLabel;
    Label1: TLabel;
    edit_main_ports: TEdit;
    Label3: TLabel;
    edit_main_host: TEdit;
    Label4: TLabel;
    sh_users: TDFWTabSheetes;
    cb_users_reg_only: TCheckBox;
    cb_users_reg_allow: TCheckBox;
    Label5: TLabel;
    edit_users_limit: TSpinEdit;
    sh_limits: TDFWTabSheetes;
    Label6: TLabel;
    edit_limits_stats: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    edit_limits_hotlist: TSpinEdit;
    edit_limits_ignored: TSpinEdit;
    Label9: TLabel;
    edit_users_clones: TSpinEdit;
    Label12: TLabel;
    edit_users_logintimeout: TSpinEdit;
    sh_interface: TDFWTabSheetes;
    sh_log: TDFWTabSheetes;
    cb_log_login: TCheckBox;
    cb_log_napigator: TCheckBox;
    cb_log_search: TCheckBox;
    cb_log_transfers: TCheckBox;
    cb_log_users: TCheckBox;
    cb_log_save: TCheckBox;
    cb_log_servers: TCheckBox;
    sh_share: TDFWTabSheetes;
    cb_share_disable: TCheckBox;
    cb_share_inform: TCheckBox;
    cb_share_nomodem: TCheckBox;
    Label13: TLabel;
    Label14: TLabel;
    edit_share_max: TSpinEdit;
    edit_share_maxtotal: TSpinEdit;
    Label15: TLabel;
    Label16: TLabel;
    edit_share_filename: TSpinEdit;
    edit_share_duration: TSpinEdit;
    sh_share_mp3: TDFWTabSheetes;
    Label17: TLabel;
    edit_mp3_ext: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    edit_mp3_max: TSpinEdit;
    edit_mp3_maxsize: TSpinEdit;
    edit_mp3_minsize: TSpinEdit;
    sh_share_audio: TDFWTabSheetes;
    Label21: TLabel;
    edit_audio_ext: TEdit;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    edit_audio_maxsize: TSpinEdit;
    edit_audio_minsize: TSpinEdit;
    edit_audio_max: TSpinEdit;
    sh_share_video: TDFWTabSheetes;
    Label25: TLabel;
    edit_video_ext: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    edit_video_maxsize: TSpinEdit;
    edit_video_minsize: TSpinEdit;
    edit_video_max: TSpinEdit;
    sh_share_images: TDFWTabSheetes;
    Label29: TLabel;
    edit_images_ext: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    edit_images_maxsize: TSpinEdit;
    edit_images_minsize: TSpinEdit;
    edit_images_max: TSpinEdit;
    sh_share_apps: TDFWTabSheetes;
    Label33: TLabel;
    edit_apps_ext: TEdit;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    edit_apps_maxsize: TSpinEdit;
    edit_apps_minsize: TSpinEdit;
    edit_apps_max: TSpinEdit;
    sh_share_cd: TDFWTabSheetes;
    Label37: TLabel;
    edit_cd_ext: TEdit;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    edit_cd_maxsize: TSpinEdit;
    edit_cd_minsize: TSpinEdit;
    edit_cd_max: TSpinEdit;
    sh_share_text: TDFWTabSheetes;
    Label41: TLabel;
    edit_text_ext: TEdit;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    edit_text_maxsize: TSpinEdit;
    edit_text_minsize: TSpinEdit;
    edit_text_max: TSpinEdit;
    Label45: TLabel;
    cb_mp3_320: TCheckBox;
    cb_mp3_256: TCheckBox;
    cb_mp3_224: TCheckBox;
    cb_mp3_192: TCheckBox;
    cb_mp3_160: TCheckBox;
    cb_mp3_128: TCheckBox;
    cb_mp3_112: TCheckBox;
    cb_mp3_96: TCheckBox;
    cb_mp3_80: TCheckBox;
    cb_mp3_64: TCheckBox;
    cb_mp3_56: TCheckBox;
    cb_mp3_48: TCheckBox;
    cb_mp3_40: TCheckBox;
    cb_mp3_32: TCheckBox;
    cb_mp3_24: TCheckBox;
    cb_mp3_0: TCheckBox;
    Label46: TLabel;
    sh_napigator: TDFWTabSheetes;
    sh_search: TDFWTabSheetes;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    edit_search_defsearch: TSpinEdit;
    edit_search_maxsearch: TSpinEdit;
    edit_search_maxbrowse: TSpinEdit;
    edit_search_searchespm: TSpinEdit;
    sh_levels: TDFWTabSheetes;
    sh_channels: TDFWTabSheetes;
    cb_channels_allowcreate: TCheckBox;
    Label52: TLabel;
    Label53: TLabel;
    edit_channels_max: TSpinEdit;
    edit_channels_max2: TSpinEdit;
    cb_channels_blockcqex: TCheckBox;
    cb_interface_startup: TCheckBox;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    edit_level_0: TEdit;
    edit_level_1: TEdit;
    edit_level_2: TEdit;
    edit_level_3: TEdit;
    edit_level_4: TEdit;
    btn_level_default: TButton;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    edit_napigator_host: TEdit;
    edit_napigator_port: TSpinEdit;
    edit_napigator_user: TEdit;
    btn_napigator_password: TButton;
    edit_napigator_myport: TSpinEdit;
    cb_napigator_enabled: TCheckBox;
    btn_napigator_disconnect: TButton;
    Label66: TLabel;
    Label67: TLabel;
    edit_main_listenip: TEdit;
    cb_log_serverstats: TCheckBox;
    sh_console: TDFWTabSheetes;
    sh_blocked: TDFWTabSheetes;
    Label68: TLabel;
    cb_block_napster: TCheckBox;
    cb_block_audiognome: TCheckBox;
    cb_block_winmx: TCheckBox;
    cb_block_gnomeplus: TCheckBox;
    cb_block_amster: TCheckBox;
    cb_block_filenavigator: TCheckBox;
    cb_block_cqex: TCheckBox;
    cb_block_sunshineun: TCheckBox;
    cb_block_teknap: TCheckBox;
    cb_block_nap: TCheckBox;
    cb_block_macnap: TCheckBox;
    cb_block_mp3rage: TCheckBox;
    cb_block_xnap: TCheckBox;
    cb_block_spotlight: TCheckBox;
    cb_block_nfs: TCheckBox;
    cb_block_dmnapster: TCheckBox;
    cb_block_knapster: TCheckBox;
    cb_block_lopster: TCheckBox;
    cb_block_rapigator: TCheckBox;
    cb_block_swaptor: TCheckBox;
    cb_block_other: TCheckBox;
    Label69: TLabel;
    Label70: TLabel;
    edit_console_user: TEdit;
    edit_console_speed: TComboBox;
    Label71: TLabel;
    Label72: TLabel;
    edit_search_maxremotebrowse: TSpinEdit;
    cb_log_clearserverstats: TCheckBox;
    cb_log_clearclientstats: TCheckBox;
    panel_block_other: TPanel;
    Label74: TLabel;
    edit_block_sign0: TEdit;
    edit_block_sign1: TEdit;
    edit_block_sign2: TEdit;
    Label75: TLabel;
    Label76: TLabel;
    edit_main_handle: TSpinEdit;
    lbl_handle: TLabel;
    sh_links: TDFWTabSheetes;
    ksoOfficePanel2: TPanel;
    cb_link_all: TRadioButton;
    cb_link_list: TRadioButton;
    cb_link_none: TRadioButton;
    Label77: TLabel;
    edit_interface_cpu: TSpinEdit;
    Label78: TLabel;
    cb_search_disable_remote: TCheckBox;
    edit_search_maxremote: TSpinEdit;
    lbl_search_maxremote: TLabel;
    cb_channels_oldwallop: TCheckBox;
    Label79: TLabel;
    edit_users_maxaccept: TSpinEdit;
    cb_interface_noswitch: TCheckBox;
    cb_block_dagsta: TCheckBox;
    cb_users_noremote: TCheckBox;
    sh_sockets: TDFWTabSheetes;
    cb_sockets_users_def: TCheckBox;
    edit_sockets_users_send: TSpinEdit;
    edit_sockets_users_recv: TSpinEdit;
    cb_sockets_servers_def: TCheckBox;
    edit_sockets_servers_send: TSpinEdit;
    edit_sockets_servers_recv: TSpinEdit;
    lbl_sockets_users_send: TLabel;
    lbl_sockets_users_recv: TLabel;
    lbl_sockets_servers_send: TLabel;
    lbl_sockets_servers_recv: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    edit_channels_maxmessage: TSpinEdit;
    edit_channels_maxprivmessage: TSpinEdit;
    sh_report: TDFWTabSheetes;
    sh_other: TDFWTabSheetes;
    Label84: TLabel;
    ksoOfficeGroupBox1: TGroupBox;
    Label85: TLabel;
    cb_ann_enable: TCheckBox;
    Label86: TLabel;
    edit_ann_delay: TSpinEdit;
    edit_ann_messages: TMemo;
    Label87: TLabel;
    Label88: TLabel;
    edit_ann_user: TEdit;
    ksoOfficeGroupBox2: TGroupBox;
    cb_report_old_enable: TCheckBox;
    Label89: TLabel;
    edit_report_old_port: TSpinEdit;
    ksoOfficeGroupBox3: TGroupBox;
    cb_report_new_enabled: TCheckBox;
    edit_report_new_port: TSpinEdit;
    cb_report_new_hidehub: TCheckBox;
    Label90: TLabel;
    sh_minshare: TDFWTabSheetes;
    Label91: TLabel;
    edit_minshare_minshare: TSpinEdit;
    Label92: TLabel;
    Label93: TLabel;
    edit_minshare_delay: TSpinEdit;
    Label94: TLabel;
    cb_minshare_ban: TCheckBox;
    edit_minshare_bantime: TSpinEdit;
    Label95: TLabel;
    edit_minshare_minsharesize: TSpinEdit;
    cb_minshare_onlyfull: TCheckBox;
    cb_minshare_banip: TCheckBox;
    cb_block_smartwinmx: TCheckBox;
    cb_minshare_full10: TCheckBox;
    Label73: TLabel;
    edit_napigator_myip: TEdit;
    cb_limits_blockwinmxqueue: TCheckBox;
    cb_channels_showops: TCheckBox;
    sh_motd: TDFWTabSheetes;
    Label96: TLabel;
    edit_motd: TMemo;
    cb_minshare_kickchat: TCheckBox;
    cb_napigator_autodisconnect: TCheckBox;
    Label97: TLabel;
    cb_link_hub: TCheckBox;
    Label98: TLabel;
    cb_minshare_wallop: TCheckBox;
    cb_block_floodster: TCheckBox;
    cb_users_redirectcqex: TCheckBox;
    cb_link_syncreg: TCheckBox;
    cb_channels_irc: TCheckBox;
    cb_channels_low: TCheckBox;
    cb_link_noautoconnect: TCheckBox;
    Label99: TLabel;
    Label100: TLabel;
    edit_limits_maxdown: TSpinEdit;
    edit_limits_maxup: TSpinEdit;
    cb_limits_limitservers: TCheckBox;
    cb_block_drumbeat: TCheckBox;
    Label101: TLabel;
    edit_share_maxindex: TSpinEdit;
    cb_channels_preventshout: TCheckBox;
    cb_interface_chatflash: TCheckBox;
    edit_channels_flood_user: TSpinEdit;
    edit_channels_flood_same: TSpinEdit;
    cb_channels_flood_warn: TCheckBox;
    lbl_flood1: TLabel;
    lbl_flood2: TLabel;
    sh_colors: TDFWTabSheetes;
    edit_color_bg: TksoSpectrumComboBox;
    Label104: TLabel;
    Label105: TLabel;
    edit_color_text: TksoSpectrumComboBox;
    Label106: TLabel;
    Label107: TLabel;
    Label108: TLabel;
    Label109: TLabel;
    Label110: TLabel;
    Label111: TLabel;
    Label112: TLabel;
    Label113: TLabel;
    edit_color_chat: TksoSpectrumComboBox;
    edit_color_mychat: TksoSpectrumComboBox;
    edit_color_channelchat: TksoSpectrumComboBox;
    edit_color_mychannelchat: TksoSpectrumComboBox;
    edit_color_emote: TksoSpectrumComboBox;
    edit_color_myemote: TksoSpectrumComboBox;
    edit_color_join: TksoSpectrumComboBox;
    edit_color_part: TksoSpectrumComboBox;
    Label114: TLabel;
    edit_color_topic: TksoSpectrumComboBox;
    Label115: TLabel;
    Label116: TLabel;
    Label117: TLabel;
    Label118: TLabel;
    Label119: TLabel;
    Label120: TLabel;
    Label121: TLabel;
    Label122: TLabel;
    Label123: TLabel;
    Label124: TLabel;
    Label125: TLabel;
    edit_color_debug: TksoSpectrumComboBox;
    edit_color_error: TksoSpectrumComboBox;
    edit_color_wallop: TksoSpectrumComboBox;
    edit_color_announce: TksoSpectrumComboBox;
    edit_color_online: TksoSpectrumComboBox;
    edit_color_offline: TksoSpectrumComboBox;
    edit_color_search: TksoSpectrumComboBox;
    edit_color_transfer: TksoSpectrumComboBox;
    edit_color_napigator: TksoSpectrumComboBox;
    edit_color_pong: TksoSpectrumComboBox;
    edit_color_whowas: TksoSpectrumComboBox;
    btn_colors_default: TButton;
    cd: TColorDialog;
    btn_color_ch1: TSpeedButton;
    btn_color_ch2: TSpeedButton;
    btn_color_ch3: TSpeedButton;
    btn_color_ch4: TSpeedButton;
    btn_color_ch5: TSpeedButton;
    btn_color_ch6: TSpeedButton;
    btn_color_ch7: TSpeedButton;
    btn_color_ch8: TSpeedButton;
    btn_color_ch9: TSpeedButton;
    btn_color_ch10: TSpeedButton;
    btn_color_ch11: TSpeedButton;
    btn_color_ch12: TSpeedButton;
    btn_color_ch13: TSpeedButton;
    btn_color_ch14: TSpeedButton;
    btn_color_ch15: TSpeedButton;
    btn_color_ch16: TSpeedButton;
    btn_color_ch17: TSpeedButton;
    btn_color_ch18: TSpeedButton;
    btn_color_ch19: TSpeedButton;
    btn_color_ch20: TSpeedButton;
    btn_color_ch21: TSpeedButton;
    btn_color_ch22: TSpeedButton;
    Label10: TLabel;
    edit_limits_memory: TSpinEdit;
    Label11: TLabel;
    Label2: TLabel;
    edit_users_banmail: TEdit;
    edit_napigator_delay: TSpinEdit;
    Label126: TLabel;
    edit_block_sign3: TEdit;
    edit_block_sign4: TEdit;
    edit_block_sign5: TEdit;
    panel_block_message: TPanel;
    lbl_block_message: TLabel;
    edit_block_message: TEdit;
    cb_block_custommessage: TRadioButton;
    cb_block_defaultmessage: TRadioButton;
    cb_block_nomessage: TRadioButton;
    cb_link_syncban: TCheckBox;
    Label127: TLabel;
    edit_main_remoteadmin: TEdit;
    cb_link_list2: TRadioButton;
    edit_link_list: TEdit;
    sh_links2: TDFWTabSheetes;
    Label80: TLabel;
    cb_link2_lagnosearch: TCheckBox;
    cb_link2_lagnosearchreq: TCheckBox;
    cb_link2_lagnobrowse: TCheckBox;
    cb_link2_lagnobrowsereq: TCheckBox;
    edit_link_outgoinglist: TEdit;
    cb_link_restrictoutgoing: TCheckBox;
    Label128: TLabel;
    edit_users_redirecturl: TEdit;
    cb_interface_systray: TCheckBox;
    cb_users_reconnect: TCheckBox;
    cb_channels_floodenable: TCheckBox;
    Label102: TLabel;
    edit_level_5: TEdit;
    cb_interface_chatmini: TCheckBox;
    cb_interface_wallop: TCheckBox;
    cb_log_console: TCheckBox;
    cb_log_dagsta: TCheckBox;
    sh_dagsta: TDFWTabSheetes;
    Label103: TLabel;
    edit_dagsta_host: TEdit;
    edit_dagsta_port: TSpinEdit;
    edit_dagsta_user: TEdit;
    btn_dagsta_password: TButton;
    Label129: TLabel;
    Label130: TLabel;
    Label131: TLabel;
    Label132: TLabel;
    Label133: TLabel;
    edit_dagsta_myport: TSpinEdit;
    edit_dagsta_myip: TEdit;
    edit_dagsta_delay: TSpinEdit;
    Label134: TLabel;
    cb_dagsta_enabled: TCheckBox;
    btn_dagsta_disconnect: TButton;
    cb_dagsta_autodisconnect: TCheckBox;
    Label135: TLabel;
    Label136: TLabel;
    edit_color_dagsta: TksoSpectrumComboBox;
    edit_color_ch23: TSpeedButton;
    Label137: TLabel;
    edit_color_remotesearch: TksoSpectrumComboBox;
    btn_color_ch24: TSpeedButton;
    Label51: TLabel;
    cb_share_checkdup: TCheckBox;
    cb_interface_nocpu: TCheckBox;
    sh_other2: TTabSheet;
    cb_loginim_enable: TCheckBox;
    edit_loginim: TMemo;
    edit_loginim_user: TEdit;
    Label139: TLabel;
    cb_ann_imenable: TCheckBox;
    cb_channels_forceenter: TCheckBox;
    edit_channels_forceenter: TEdit;
    cb_force_enter_furiwake: TCheckBox;
    cb_dengon_enable: TCheckBox;
    cb_users_loginpass: TCheckBox;
    edit_users_loginpass: TEdit;
    cb_restrict_searchresult_per_user: TCheckBox;
    edit_max_searchresult_per_user: TSpinEdit;
    edit_search_searchblockshare: TSpinEdit;
    edit_search_searchblocksharesize: TSpinEdit;
    edit_search_domshare: TSpinEdit;
    edit_search_domsharesize: TSpinEdit;
    Label140: TLabel;
    edit_search_wantqueuep3m: TSpinEdit;
    edit_toami_judge: TSpinEdit;
    cb_searchblock_chknum: TCheckBox;
    cb_searchblock_chksize: TCheckBox;
    cb_browsedlblock_chknum: TCheckBox;
    cb_browsedlblock_chksize: TCheckBox;
    radio_searchblock_and: TRadioButton;
    radio_searchblock_or: TRadioButton;
    radio_domblock_and: TRadioButton;
    radio_domblock_or: TRadioButton;
    gb_searchblock: TGroupBox;
    gb_domblock: TGroupBox;
    sh_other3: TTabSheet;
    cb_nocount_text: TCheckBox;
    cb_share_matchedfile_only: TCheckBox;
    edit_folder_depth: TSpinEdit;
    Label138: TLabel;
    Label141: TLabel;
    edit_toami_bantime: TComboBox;
    Label143: TLabel;
    Label144: TLabel;
    Panel4: TPanel;
    radio_dl_block: TRadioButton;
    radio_dl_leech: TRadioButton;
    radio_dl_ban: TRadioButton;
    Label142: TLabel;
    edit_wq_bantime: TComboBox;
    Panel5: TPanel;
    Label145: TLabel;
    radio_wq_block: TRadioButton;
    radio_wq_leech: TRadioButton;
    radio_wq_ban: TRadioButton;
    edit_MX_quota: TSpinEdit;
    cb_block_limitMX: TCheckBox;
    lbl_limitMX: TLabel;
    cb_autoban_incomplete: TCheckBox;
    Label146: TLabel;
    edit_incomplete_bantime: TComboBox;
    cb_loginblock_port: TCheckBox;
    Label147: TLabel;
    edit_loginblock_port: TEdit;
    cb_l2b_level: TCheckBox;
    cb_enable_rating: TCheckBox;
    edit_rating_threshold: TSpinEdit;
    Label148: TLabel;
    cb_inflections: TCheckBox;
    cb_l2b_log: TCheckBox;
    sh_other4: TTabSheet;
    cb_WindowClose: TCheckBox;
    cb_allow_napster: TCheckBox;
    cb_allow_winmx: TCheckBox;
    cb_allow_napchan: TCheckBox;
    cb_allow_lopster: TCheckBox;
    cb_allow_xnap: TCheckBox;
    cb_allow_utatane: TCheckBox;
    cb_allow_2get: TCheckBox;
    cb_allow_other: TCheckBox;
    edit_allow_sign0: TEdit;
    edit_allow_sign1: TEdit;
    edit_allow_sign2: TEdit;
    edit_allow_sign3: TEdit;
    edit_allow_sign4: TEdit;
    cb_allow_teknap: TCheckBox;
    cb_regsoft_only: TCheckBox;
    cb_channels_old_forceenter: TCheckBox;
    cb_mx3_auto_IM: TCheckBox;
    edit_mx3_auto_IM: TEdit;
    cb_2byte_id_enabled: TCheckBox;
    cb_2byte_channel_enabled: TCheckBox;
    cb_channels_timestamp: TCheckBox;
    cb_suggest_dbrowse: TCheckBox;
    cb_whois_gethost: TCheckBox;
    edit_ul_gethost_max_resolving_cnt: TSpinEdit;
    Label149: TLabel;
    Label150: TLabel;
    Label151: TLabel;
    Label152: TLabel;
    Label153: TLabel;
    cb_enable_trapport: TCheckBox;
    edit_trapport: TEdit;
    procedure Panel3Resize(Sender: TObject);
    procedure headerPaint(Sender: TObject);
    procedure SetTopText(str: String);
    procedure btn_closeClick(Sender: TObject);
    procedure btn_restoreClick(Sender: TObject);
    procedure SetChange(change: Boolean);
    procedure CreateParams(Var params: TCreateParams);override;
    procedure treeChange(Sender: TObject; Node: TTreeNode);
    procedure sh_mainShow(Sender: TObject);
    procedure sh_usersShow(Sender: TObject);
    procedure cb_users_reg_onlyClick(Sender: TObject);
    procedure sh_limitsShow(Sender: TObject);
    procedure sh_interfaceShow(Sender: TObject);
    procedure sh_logShow(Sender: TObject);
    procedure cb_log_saveClick(Sender: TObject);
    procedure sh_shareShow(Sender: TObject);
    procedure sh_share_mp3Show(Sender: TObject);
    procedure sh_share_audioShow(Sender: TObject);
    procedure sh_share_videoShow(Sender: TObject);
    procedure sh_share_imagesShow(Sender: TObject);
    procedure sh_share_appsShow(Sender: TObject);
    procedure sh_share_cdShow(Sender: TObject);
    procedure sh_share_textShow(Sender: TObject);
    procedure sh_napigatorShow(Sender: TObject);
    procedure sh_searchShow(Sender: TObject);
    procedure sh_levelsShow(Sender: TObject);
    procedure btn_changeClick(Sender: TObject);
    procedure sh_channelsShow(Sender: TObject);
    procedure btn_level_defaultClick(Sender: TObject);
    procedure btn_napigator_disconnectClick(Sender: TObject);
    procedure btn_napigator_passwordClick(Sender: TObject);
    procedure sh_consoleShow(Sender: TObject);
    procedure sh_blockedShow(Sender: TObject);
    procedure cb_log_serverstatsClick(Sender: TObject);
    procedure cb_block_custommessageClick(Sender: TObject);
    procedure sh_linksShow(Sender: TObject);
    procedure cb_search_disable_remoteClick(Sender: TObject);
    procedure sh_socketsShow(Sender: TObject);
    procedure cb_sockets_users_defClick(Sender: TObject);
    procedure cb_sockets_servers_defClick(Sender: TObject);
    procedure sh_reportShow(Sender: TObject);
    procedure sh_otherShow(Sender: TObject);
    procedure sh_minshareShow(Sender: TObject);
    procedure cb_block_winmxClick(Sender: TObject);
    procedure cb_minshare_onlyfullClick(Sender: TObject);
    procedure sh_motdShow(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sh_colorsShow(Sender: TObject);
    procedure btn_colors_defaultClick(Sender: TObject);
    procedure btn_color_chClick(Sender: TObject);
    procedure sh_links2Show(Sender: TObject);
    procedure cb_channels_floodenableClick(Sender: TObject);
    procedure sh_dagstaShow(Sender: TObject);
    procedure btn_dagsta_disconnectClick(Sender: TObject);
    procedure Label137Click(Sender: TObject);
    procedure sh_other2Show(Sender: TObject);
    procedure cb_ann_enableClick(Sender: TObject);
    procedure cb_searchblock_chknumClick(Sender: TObject);
    procedure cb_searchblock_chksizeClick(Sender: TObject);
    procedure cb_browsedlblock_chknumClick(Sender: TObject);
    procedure cb_browsedlblock_chksizeClick(Sender: TObject);
    procedure sh_other3Show(Sender: TObject);
    procedure radio_dlClick(Sender: TObject);
    procedure radio_wqClick(Sender: TObject);
    procedure cb_block_limitMXClick(Sender: TObject);
    procedure cb_autoban_incompleteClick(Sender: TObject);
    procedure cb_loginblock_portClick(Sender: TObject);
    procedure cb_enable_ratingClick(Sender: TObject);
    procedure sh_other4Show(Sender: TObject);
    procedure cb_allow_otherClick(Sender: TObject);
    procedure cb_channels_forceenterClick(Sender: TObject);
    procedure cb_mx3_auto_IMClick(Sender: TObject);
    procedure cb_enable_trapportClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetBanItems(control: TComboBox);
    function  GetBanID(control: TComboBox): Integer;
    function  GetBanIndex(t: Integer): Integer;
  public
    { Public declarations }
    top_text: String;
    procedure ChangeColors;
  end;

var
  SlavaNapSettings: TSlavaNapSettings;

implementation

uses
 stypes, vars, constants, mainform, bans, handler, lang, users, editdialog,
 servers, winsock, blcksock, memory_manager;

{$R *.DFM}

const
 DATA_MAIN          = pointer(1);
 DATA_SOCKETS       = pointer(2);
 DATA_USERS         = pointer(3);
 DATA_LIMITS        = pointer(4);
 DATA_SEARCH        = pointer(5);
 DATA_CHANNELS      = pointer(6);
 DATA_LINKS         = pointer(7);
 DATA_NAPIGATOR     = pointer(8);
 DATA_LEVELS        = pointer(9);
 DATA_BLOCKED       = pointer(10);
 DATA_MOTD          = pointer(11);
 DATA_INTERFACE     = pointer(12);
 DATA_CONSOLE       = pointer(13);
 DATA_LOG           = pointer(14);
 DATA_SHARE         = pointer(15);
 DATA_SHARE_MP3     = pointer(16);
 DATA_SHARE_AUDIO   = pointer(17);
 DATA_SHARE_VIDEO   = pointer(18);
 DATA_SHARE_IMAGES  = pointer(19);
 DATA_SHARE_APP     = pointer(20);
 DATA_SHARE_CD      = pointer(21);
 DATA_SHARE_TEXT    = pointer(22);
 DATA_SHARE_MINSHARE = pointer(23);
 DATA_OTHER         = pointer(24);
 DATA_REPORT        = pointer(25);
 DATA_COLORS        = pointer(26);
 DATA_LINKS2        = pointer(27); 
 DATA_DAGSTA        = pointer(28);
 DATA_OTHER2        = pointer(29);
 DATA_OTHER3        = pointer(30);
 DATA_OTHER4        = pointer(31);

procedure TSlavaNapSettings.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapSettings.Panel3Resize(Sender: TObject);
begin
 header.Width:=Panel3.Width - 16;
end;

procedure TSlavaNapSettings.headerPaint(Sender: TObject);
var
 b,b1: TBitmap;
 i,j,w,h,x: Integer;
 c,c1,c2: TColor;
 r: TRect;
begin
 try
  w:=header.Width;
  h:=header.Height;
  r:=Rect(0,0,w,h);
  b:=CreateTBitmap;
  b1:=CreateTBitmap;
  try
    b.Width:=w;
    b.Height:=h;
    b1.Width:=w;
    b1.Height:=h;
    stypes.GradientFill(b.canvas.handle,r,$00C04B94,clBtnFace,128,false);
    b.Canvas.Pen.Color:=clBtnFace;
    b.Canvas.MoveTo(0,0);
    b.Canvas.LineTo(w-1,0);
    b.Canvas.MoveTo(w-1,h-1);
    b.Canvas.LineTo(0,h-1);
    b.Canvas.LineTo(0,h-2);
    b.Canvas.Pen.Color:=countcolor(b.Canvas.Pixels[1,0],$00C04B94,1,1);
    b.Canvas.LineTo(0,0);
    b.Canvas.font.Assign(header.font);
    b.Canvas.Brush.Style:=bsClear;
    b.Canvas.Font.Color:=CountColor($00C04B94,clBlack,1,1);
    b.Canvas.TextOut(11,5,top_text);
    b1.Canvas.CopyRect(r,b.canvas,r);
    x:=b.Canvas.TextWidth(top_text)+15;
    for i:=2 to x do // blur (my own, not gaussian)  ;-)
     for j:=2 to h-3 do
     begin
       c:=b1.Canvas.Pixels[i,j];
       c1:=countcolor(b1.Canvas.Pixels[i+1,j],b1.Canvas.Pixels[i-1,j],1,1);
       c2:=countcolor(b1.Canvas.Pixels[i,j+1],b1.Canvas.Pixels[i,j-1],1,1);
       c1:=countcolor(c1,c2,1,1);
       b.Canvas.Pixels[i,j]:=countcolor(c,c1,1,4);
     end;
    // blur borders
    for i:=1 to w-2 do
    begin
      // top
      c:=b1.Canvas.Pixels[i,0];
      c1:=countcolor(b1.Canvas.Pixels[i+1,1],b1.Canvas.Pixels[i-1,1],1,1);
      c2:=countcolor(b1.Canvas.Pixels[i,2],b1.Canvas.Pixels[i,0],1,1);
      c1:=countcolor(c1,c2,1,1);
      b.Canvas.Pixels[i,1]:=countcolor(c,c1,1,4);
      // bottom
      c:=b1.Canvas.Pixels[i,h-1];
      c1:=countcolor(b1.Canvas.Pixels[i+1,h-2],b1.Canvas.Pixels[i-1,h-2],1,1);
      c2:=countcolor(b1.Canvas.Pixels[i,h-3],b1.Canvas.Pixels[i,h-1],1,1);
      c1:=countcolor(c1,c2,1,1);
      b.Canvas.Pixels[i,h-2]:=countcolor(c,c1,1,4);
    end;
    b.Canvas.Font.Color:=clWhite;
    b.Canvas.TextOut(10,4,top_text);
    header.Canvas.CopyRect(r,b.canvas,r);
   except
  end;
  FreeTBitmap(b);
  FreeTBitmap(b1);
  except
 end;
end;

procedure TSlavaNapSettings.SetTopText(str: String);
begin
 if top_text=str then exit;
 top_text:=str;
 try
  headerPaint(header);
  except
 end;
end;

procedure TSlavaNapSettings.FormCreate(Sender: TObject);
var
 i: Integer;
begin
 Height:=Height-90;
 for i:=0 to Ord(napSpeedT3) do
  edit_console_speed.Items.Add(Speed2Str(TNapSpeed(i)));
 SetBanItems(edit_toami_bantime);
 SetBanItems(edit_wq_bantime);
 SetBanItems(edit_incomplete_bantime);
end;

procedure TSlavaNapSettings.FormShow(Sender: TObject);
var
 t,item,it1: TTreeNode;
 i: Integer;
begin
 Caption:=GetLangI(LNG_S_CAPTION);
 btn_restore.Caption:=GetLangI(LNG_S_BTN_RESTORE);
 btn_close.Caption:=GetLangI(LNG_S_BTN_CLOSE);
 lbl_change.Caption:=GetLangI(LNG_S_LBL_NOTE);
 pages.ActivePage:=sh_main;
 sh_mainShow(nil);
 ChangeColors;
 tree.Items.Clear;
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_MAIN));
 item.Data:=DATA_MAIN;
 it1:=item;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SOCKETS));
       t.data:=DATA_SOCKETS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_USERS));
       t.data:=DATA_USERS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LIMITS));
       t.data:=DATA_LIMITS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SEARCH));
       t.data:=DATA_SEARCH;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_CHANNELS));
       t.data:=DATA_CHANNELS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LINKS));
       t.data:=DATA_LINKS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LINKS2));
       t.data:=DATA_LINKS2;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_NAPIGATOR));
       t.data:=DATA_NAPIGATOR;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_DAGSTA));
       t.data:=DATA_DAGSTA;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_LEVELS));
       t.data:=DATA_LEVELS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_BLOCKED));
       t.data:=DATA_BLOCKED;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_MOTD));
       t.data:=DATA_MOTD;
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_INTERFACE));
       item.data:=DATA_INTERFACE;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_CONSOLE));
       t.data:=DATA_CONSOLE;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_COLORS));
       t.data:=DATA_COLORS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LOG));
       t.data:=DATA_LOG;
 item.Expand(true);
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_SHARE));
       item.data:=DATA_SHARE;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_MP3));
       t.data:=DATA_SHARE_MP3;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_AUDIO));
       t.data:=DATA_SHARE_AUDIO;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_VIDEO));
       t.data:=DATA_SHARE_VIDEO;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_IMAGES));
       t.data:=DATA_SHARE_IMAGES;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_SHARE_APP));
       t.data:=DATA_SHARE_APP;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_CD));
       t.data:=DATA_SHARE_CD;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_TEXT));
       t.data:=DATA_SHARE_TEXT;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_MINSHARE));
       t.data:=DATA_SHARE_MINSHARE;
 item.Expand(true);
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_OTHER));
       item.data:=DATA_OTHER;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_REPORT));
       t.data:=DATA_REPORT;
       t:=tree.Items.AddChild(item,'Other2');
       t.data:=DATA_OTHER2;
       t:=tree.Items.AddChild(item,'Other3');
       t.data:=DATA_OTHER3;
       t:=tree.Items.AddChild(item,'Other4');
       t.Data:=DATA_OTHER4;
 item.Expand(true);
 it1.Expand(true); // expand first item and focus it
end;

procedure TSlavaNapSettings.btn_closeClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapSettings.btn_restoreClick(Sender: TObject);
begin
 if assigned(pages.ActivePage.OnShow) then
  pages.ActivePage.OnShow(nil);
end;

procedure TSlavaNapSettings.SetChange(change: Boolean);
begin
 if change then
 begin
   btn_change.Caption:=GetLangI(LNG_S_BTN_CHANGE);
   lbl_note.Caption:=GetLangI(LNG_S_LBL_CHANGE);
   lbl_change.Visible:=false;
 end
 else
 begin
   btn_change.Caption:=GetLangI(LNG_S_BTN_SAVE);;
   lbl_note.Caption:=GetLangI(LNG_S_LBL_SAVE);;
   lbl_change.Visible:=true;
 end;
end;

procedure TSlavaNapSettings.treeChange(Sender: TObject; Node: TTreeNode);
begin
 if node=nil then exit;
 if not node.Selected then exit;
 if node.data=DATA_MAIN then pages.ActivePage:=sh_main
 else if node.data=DATA_USERS then pages.ActivePage:=sh_users
 else if node.data=DATA_LIMITS then pages.ActivePage:=sh_limits
 else if node.data=DATA_INTERFACE then pages.ActivePage:=sh_interface
 else if node.data=DATA_LOG then pages.ActivePage:=sh_log
 else if node.data=DATA_SHARE then pages.ActivePage:=sh_share
 else if node.data=DATA_SHARE_MP3 then pages.ActivePage:=sh_share_mp3
 else if node.data=DATA_SHARE_AUDIO then pages.ActivePage:=sh_share_audio
 else if node.data=DATA_SHARE_VIDEO then pages.ActivePage:=sh_share_video
 else if node.data=DATA_SHARE_IMAGES then pages.ActivePage:=sh_share_images
 else if node.data=DATA_SHARE_APP then pages.ActivePage:=sh_share_apps
 else if node.data=DATA_SHARE_CD then pages.ActivePage:=sh_share_cd
 else if node.data=DATA_SHARE_TEXT then pages.ActivePage:=sh_share_text
 else if node.data=DATA_NAPIGATOR then pages.ActivePage:=sh_napigator
 else if node.data=DATA_DAGSTA then pages.ActivePage:=sh_dagsta
 else if node.data=DATA_SEARCH then pages.ActivePage:=sh_search
 else if node.data=DATA_LEVELS then pages.ActivePage:=sh_levels
 else if node.data=DATA_CHANNELS then pages.ActivePage:=sh_channels
 else if node.data=DATA_CONSOLE then pages.ActivePage:=sh_console
 else if node.data=DATA_BLOCKED then pages.ActivePage:=sh_blocked
 else if node.data=DATA_LINKS then pages.ActivePage:=sh_links
 else if node.data=DATA_SOCKETS then pages.ActivePage:=sh_sockets
 else if node.data=DATA_OTHER then pages.ActivePage:=sh_other
 else if node.Data=DATA_OTHER2 then pages.ActivePage:=sh_other2
 else if node.Data=DATA_OTHER3 then pages.ActivePage:=sh_other3
 else if node.Data=DATA_OTHER4 then pages.ActivePage:=sh_other4
 else if node.data=DATA_REPORT then pages.ActivePage:=sh_report
 else if node.data=DATA_SHARE_MINSHARE then pages.ActivePage:=sh_minshare
 else if node.data=DATA_MOTD then pages.ActivePage:=sh_motd
 else if node.data=DATA_COLORS then pages.ActivePage:=sh_colors
 else if node.data=DATA_LINKS2 then pages.ActivePage:=sh_links2;
end;

procedure TSlavaNapSettings.cb_users_reg_onlyClick(Sender: TObject);
begin
 cb_users_reg_allow.Visible:=cb_users_reg_only.Checked;
end;

procedure TSlavaNapSettings.cb_log_saveClick(Sender: TObject);
begin
 cb_log_users.Visible:=cb_log_save.Checked;
 cb_log_servers.Visible:=cb_log_save.Checked;
end;

procedure TSlavaNapSettings.sh_mainShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_MAIN));
 SetChange(false);
 lbl_handle.Caption:='(current handle = '+IntToStr(myserverhandle)+')';
 lbl_handle.Font.Color:=clPurple;
 edit_main_remoteadmin.Text:=cons_reg_user;
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 edit_main_ports.Text:=ini.ReadString('Server','Ports',DEF_LISTEN_PORTS);
 edit_main_host.Text:=ini.ReadString('Server','ReportHost','localhost');
 edit_main_handle.Value:=ini.ReadInteger('Server','ServerHandle',0);
 edit_main_listenip.Text:=ini.ReadString('Server','SocketsInterface','0.0.0.0');
 ini.Free;
end;

procedure TSlavaNapSettings.sh_usersShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_USERS));
 SetChange(true);
 cb_users_reg_only.Checked:=registered_only;
 cb_users_reg_allow.Checked:=allow_register;
 cb_users_reg_allow.Visible:=cb_users_reg_only.Checked;
 cb_users_noremote.Checked:=not accept_remote_users;
 edit_users_limit.Value:=max_users;
 edit_users_clones.Value:=max_clones;
 edit_users_logintimeout.Value:=timeout_login div 1000;
 edit_users_maxaccept.Value:=max_accept;
 cb_users_redirectcqex.Checked:=redirect_cqex;
 edit_users_banmail.Text:=banmail;
 edit_users_redirecturl.Text:=redirect_url;
 cb_users_reconnect.Checked:=reconnect_delay;
end;

procedure TSlavaNapSettings.sh_limitsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LIMITS));
 SetChange(true);
 edit_limits_stats.Value:=stats_delay div 1000;
 edit_limits_hotlist.Value:=max_hotlist;
 edit_limits_ignored.Value:=max_ignorelist;
 cb_limits_blockwinmxqueue.Checked:=block_wantqueue;
 cb_limits_limitservers.Checked:=not bandwidth_limitservers;
 edit_limits_maxdown.Value:=bandwidth_maxdown;
 edit_limits_maxup.Value:=bandwidth_maxup;
 edit_limits_memory.Value:=memory_limit div 1048576;
end;

procedure TSlavaNapSettings.sh_interfaceShow(Sender: TObject);
var
 reg: TRegistry;
 b: Boolean;
 str: String;
begin
 SetTopText(GetLangI(LNG_S_TEXT_INTERFACE));
 SetChange(true);
 edit_interface_cpu.Value:=cpu_usage;
 cb_interface_nocpu.checked:=cpu_disable;
 cb_interface_noswitch.Checked:=not switch_chat;
 cb_interface_chatflash.Checked:=chat_flash;
 cb_interface_systray.Checked:=SlavaNapwindow.tray.active;
 cb_interface_chatmini.Checked:=chat_mini;
 cb_interface_wallop.Checked:=wallop_im;
 reg:=TRegistry.Create;
 b:=false;
 try
  reg.RootKey:=HKEY_LOCAL_MACHINE;
  reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run',true);
  str:=reg.ReadString('SlavaNap');
  if str<>'' then b:=true;
  except
 end;
 reg.Free;
 cb_interface_startup.Checked:=b;
end;

procedure TSlavaNapSettings.sh_logShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LOG));
 SetChange(true);
 cb_log_login.Checked:=log_login;
 cb_log_napigator.Checked:=log_napigator;
 cb_log_dagsta.Checked:=log_dagsta;
 cb_log_search.Checked:=log_search;
 cb_log_transfers.Checked:=log_transfers;
// cb_log_links.Checked:=log_links;
 cb_log_save.Checked:=log_to_file;
 cb_log_saveClick(nil);
 cb_log_users.Checked:=log_commands;
 cb_log_servers.Checked:=log_servercommands;
 cb_log_serverstats.Checked:=save_stats;
 cb_log_serverstatsClick(nil);
 cb_log_clearserverstats.Checked:=clear_serverstats;
 cb_log_clearclientstats.Checked:=clear_clientstats;
 cb_log_console.Checked:=log_console_data;
end;


procedure TSlavaNapSettings.sh_shareShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE));
 SetChange(true);
 edit_share_max.Value:=maxshare;
 edit_share_maxtotal.Value:=maxshare_total;
 edit_share_filename.Value:=minfilename;
 edit_share_duration.Value:=minduration;
 cb_share_disable.checked:=not allow_share;
 cb_share_inform.Checked:=shareinform;
 cb_share_nomodem.Checked:=share_nomodem;
 edit_share_maxindex.Value:=maxshareindex;
 cb_share_checkdup.Checked:=share_checkdup;
end;

procedure TSlavaNapSettings.sh_share_mp3Show(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_MP3));
 SetChange(true);
 edit_mp3_ext.Text:=ext_mp3;
 edit_mp3_max.Value:=maxshare_mp3;
 edit_mp3_minsize.Value:=minfilesize_mp3 div 1024;
 edit_mp3_maxsize.Value:=maxfilesize_mp3 div 1024;
 cb_mp3_320.Checked:=share_320;
 cb_mp3_256.checked:=share_256;
 cb_mp3_224.checked:=share_224;
 cb_mp3_192.checked:=share_192;
 cb_mp3_160.checked:=share_160;
 cb_mp3_128.checked:=share_128;
 cb_mp3_112.checked:=share_112;
 cb_mp3_96.checked:=share_96;
 cb_mp3_80.checked:=share_80;
 cb_mp3_64.checked:=share_64;
 cb_mp3_56.checked:=share_56;
 cb_mp3_48.checked:=share_48;
 cb_mp3_40.checked:=share_40;
 cb_mp3_32.checked:=share_32;
 cb_mp3_24.checked:=share_24;
 cb_mp3_0.checked:=share_unknown;
end;

procedure TSlavaNapSettings.sh_share_audioShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_AUDIO));
 SetChange(true);
 edit_audio_ext.Text:=ext_audio;
 edit_audio_max.Value:=maxshare_audio;
 edit_audio_minsize.Value:=minfilesize_audio div 1024;
 edit_audio_maxsize.Value:=maxfilesize_audio div 1024;
end;

procedure TSlavaNapSettings.sh_share_videoShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_VIDEO));
 SetChange(true);
 edit_video_ext.Text:=ext_video;
 edit_video_max.Value:=maxshare_video;
 edit_video_minsize.Value:=minfilesize_video div 1024;
 edit_video_maxsize.Value:=maxfilesize_video div 1024;
end;

procedure TSlavaNapSettings.sh_share_imagesShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_IMAGES));
 SetChange(true);
 edit_images_ext.Text:=ext_image;
 edit_images_max.Value:=maxshare_image;
 edit_images_minsize.Value:=minfilesize_image div 1024;
 edit_images_maxsize.Value:=maxfilesize_image div 1024;
end;

procedure TSlavaNapSettings.sh_share_appsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_APP));
 SetChange(true);
 edit_apps_ext.Text:=ext_app;
 edit_apps_max.Value:=maxshare_app;
 edit_apps_minsize.Value:=minfilesize_app div 1024;
 edit_apps_maxsize.Value:=maxfilesize_app div 1024;
end;

procedure TSlavaNapSettings.sh_share_cdShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_CD));
 SetChange(true);
 edit_cd_ext.Text:=ext_cd;
 edit_cd_max.Value:=maxshare_cd;
 edit_cd_minsize.Value:=minfilesize_cd div 1024;
 edit_cd_maxsize.Value:=maxfilesize_cd div 1024;
end;

procedure TSlavaNapSettings.sh_share_textShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_TEXT));
 SetChange(true);
 edit_text_ext.Text:=ext_text;
 edit_text_max.Value:=maxshare_text;
 edit_text_minsize.Value:=minfilesize_text div 1024;
 edit_text_maxsize.Value:=maxfilesize_text div 1024;
end;

procedure TSlavaNapSettings.sh_napigatorShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_NAPIGATOR));
 SetChange(true);
 edit_napigator_host.Text:=napigator_host;
 edit_napigator_port.Text:=napigator_port;
 edit_napigator_user.Text:=napigator_user;
 edit_napigator_myport.Value:=napigator_myport;
 edit_napigator_myip.Text:=napigator_myip;
 cb_napigator_enabled.Checked:=napigator_enabled;
 cb_napigator_autodisconnect.Checked:=napigator_autodisconnect;
 edit_napigator_delay.Value:=napigator_delay div 60000;
end;

procedure TSlavaNapSettings.sh_dagstaShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_DAGSTA));
 SetChange(true);
 edit_dagsta_host.Text:=dagsta_host;
 edit_dagsta_port.Text:=dagsta_port;
 edit_dagsta_user.Text:=dagsta_user;
 edit_dagsta_myport.Value:=dagsta_myport;
 edit_dagsta_myip.Text:=dagsta_myip;
 cb_dagsta_enabled.Checked:=dagsta_enabled;
 cb_dagsta_autodisconnect.Checked:=dagsta_autodisconnect;
 edit_dagsta_delay.Value:=dagsta_delay div 60000;
end;

procedure TSlavaNapSettings.sh_searchShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SEARCH));
 SetChange(true);
 edit_search_defsearch.Value:=defsearchresults;
 edit_search_maxsearch.Value:=maxsearchresults;
 edit_search_maxbrowse.Value:=maxbrowseresults;
 edit_search_maxremotebrowse.Value:=maxremotebrowse;
 edit_search_maxremote.Value:=maxremotesearchresults;
 edit_search_searchespm.Value:=flood_max_searches;
 cb_search_disable_remote.Checked:=disableremotesearch;
 cb_search_disable_remoteClick(nil);
end;

procedure TSlavaNapSettings.sh_levelsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LEVELS));
 SetChange(true);
 edit_level_0.Text:=levels[0];
 edit_level_1.Text:=levels[1];
 edit_level_2.Text:=levels[2];
 edit_level_3.Text:=levels[3];
 edit_level_4.Text:=levels[4];
 edit_level_5.Text:=levels[5];
end;

procedure TSlavaNapSettings.sh_channelsShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_CHANNELS));
 SetChange(true);
 cb_channels_allowcreate.Checked:=allow_create_channels;
 edit_channels_max.Value:=max_channels;
 edit_channels_max2.Value:=max_channels_total;
 cb_channels_blockcqex.Checked:=block_cqex_chat;
 cb_channels_oldwallop.Checked:=old_opsay;
 edit_channels_maxprivmessage.Value:=max_privmsg_len;
 edit_channels_maxmessage.Value:=max_channelmsg_len;
 cb_channels_showops.checked:=show_operators;
 cb_channels_preventshout.Checked:=prevent_shouting;
 edit_channels_flood_user.Value:=flood_max_user_message;
 edit_channels_flood_same.Value:=flood_max_same_message;
 cb_channels_flood_warn.Checked:=flood_warning;
 cb_channels_floodenable.Checked:=flood_enable;
 cb_channels_floodenableClick(nil);
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 cb_channels_timestamp.Checked:=ini.ReadBool('Channels','TimeStamp',false);
 cb_channels_irc.Checked:=ini.ReadBool('Channels','IRCStyle',false);
 cb_channels_low.Checked:=ini.ReadBool('Channels','LowerCase',false);
 ini.Free;
end;

procedure TSlavaNapSettings.sh_consoleShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_CONSOLE));
 SetChange(false);
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 edit_console_user.Text:=ini.ReadString('Console','User','Admin');
 if running then edit_console_speed.ItemIndex:=Ord(cons.data^.speed);
 ini.Free;
end;

procedure TSlavaNapSettings.sh_blockedShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_BLOCKED));
 SetChange(true);
 cb_block_napster.Checked:=blocked_clients[softNapster];
 cb_block_audiognome.Checked:=blocked_clients[softAudioGnome];
 cb_block_winmx.Checked:=blocked_clients[softWinMX];
 cb_block_gnomeplus.Checked:=blocked_clients[softGnomePlus];
 cb_block_amster.Checked:=blocked_clients[softAmster];
 cb_block_filenavigator.Checked:=blocked_clients[softFileNavigator];
 cb_block_cqex.Checked:=blocked_clients[softCQEX];
 cb_block_sunshineun.checked:=blocked_clients[softSunshineUN];
 cb_block_teknap.checked:=blocked_clients[softTekNap];
 cb_block_nap.Checked:=blocked_clients[softNap];
 cb_block_macnap.Checked:=blocked_clients[softMacNap];
 cb_block_mp3rage.Checked:=blocked_clients[softMP3Rage];
 cb_block_xnap.Checked:=blocked_clients[softXNap];
 cb_block_spotlight.Checked:=blocked_clients[softSpotlight];
 cb_block_nfs.Checked:=blocked_clients[softNFS];
 cb_block_dmnapster.checked:=blocked_clients[softDMNapster];
 cb_block_knapster.Checked:=blocked_clients[softKNapster];
 cb_block_lopster.Checked:=blocked_clients[softLopster];
 cb_block_rapigator.Checked:=blocked_clients[softRapigator];
 cb_block_swaptor.Checked:=blocked_clients[softSwaptor];
 cb_block_dagsta.Checked:=blocked_clients[softDagsta];
 cb_block_drumbeat.Checked:=blocked_clients[softDrumbeat];
 cb_block_floodster.Checked:=blocked_clients[softFloodster];
 cb_block_other.checked:=blocked_clients[softUnknown];
 case blocked_messagetype of
  blckCustom:  cb_block_custommessage.Checked:=true;
  blckNone:    cb_block_nomessage.Checked:=true;
  else cb_block_defaultmessage.Checked:=true;
 end;
 edit_block_message.Text:=blocked_message;
 edit_block_sign0.Text:=blocked_custom[0];
 edit_block_sign1.Text:=blocked_custom[1];
 edit_block_sign2.Text:=blocked_custom[2];
 edit_block_sign3.Text:=blocked_custom[3];
 edit_block_sign4.Text:=blocked_custom[4];
 edit_block_sign5.text:=blocked_custom[5];
 cb_block_smartwinmx.Checked:=smart_block_winmx;
 cb_block_limitMX.Checked:=limit_mx;
 edit_MX_quota.value:=quota_mx;
 cb_block_custommessageClick(nil);
 cb_block_winmxClick(nil);
end;

procedure TSlavaNapSettings.sh_linksShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LINKS));
 SetChange(true);
 case allow_link of
   linkAll: cb_link_all.checked:=true;
   linkNone: cb_link_none.Checked:=true;
   linkCustom: cb_link_list2.Checked:=true;
   else cb_link_list.Checked:=true;
 end;
 edit_link_list.Text:=allowed_servers;
 cb_link_hub.Checked:=network_hub;
 cb_link_syncban.Checked:=hub_syncban;
 cb_link_syncreg.Checked:=hub_syncreg;
 cb_link_noautoconnect.Checked:=autolink_only1;
 cb_link_restrictoutgoing.Checked:=restrict_outgoing;
 edit_link_outgoinglist.Text:=outgoing_list;
end;

procedure TSlavaNapSettings.sh_links2Show(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LINKS2));
 SetChange(true);
 cb_link2_lagnosearch.Checked:=search_noforward_results;
 cb_link2_lagnosearchreq.Checked:=search_noforward_requests;
 cb_link2_lagnobrowse.Checked:=browse_noforward_results;
 cb_link2_lagnobrowsereq.Checked:=browse_noforward_requests;
end;

procedure TSlavaNapSettings.sh_socketsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SOCKETS));
 SetChange(true);
 cb_sockets_users_def.Checked:=sockets_users_default;
 edit_sockets_users_send.Value:=sockets_users_send;
 edit_sockets_users_recv.Value:=sockets_users_recv;
 cb_sockets_users_defClick(nil);
 cb_sockets_servers_def.Checked:=sockets_servers_default;
 edit_sockets_servers_send.Value:=sockets_servers_send;
 edit_sockets_servers_recv.Value:=sockets_servers_recv;
 cb_sockets_servers_defClick(nil);
end;

procedure TSlavaNapSettings.sh_otherShow(Sender: TObject);
var
 i: Integer;
begin
 SetTopText(GetLangI(LNG_S_TEXT_OTHER));
 SetChange(true);
 cb_ann_enable.Checked:=ann_enabled;
 cb_ann_imenable.Checked:=ann_imenabled;
 edit_ann_delay.Value:=ann_delay;
 edit_ann_user.Text:=ann_user;
 edit_ann_messages.Lines.Clear;
 for i:=0 to max_announcement do
  if ann_messages[i]<>'' then
   edit_ann_messages.Lines.Add(ann_messages[i]);
end;

procedure TSlavaNapSettings.sh_other2Show(Sender: TObject);
var
 i: Integer;
begin
  SetTopText('ق̐ݒ');
  SetChange(true);
  cb_loginim_enable.Checked:=loginim_enabled;
  cb_channels_forceenter.Checked:=force_enter;
  edit_channels_forceenter.Text:=force_enter_channel;
  cb_channels_old_forceenter.Checked:=old_force_enter;
  cb_force_enter_furiwake.Checked:=force_enter_furiwake;
  edit_channels_forceenter.Visible:=cb_channels_forceenter.Checked;
  cb_channels_old_forceenter.Visible:=cb_channels_forceenter.Checked;
  cb_force_enter_furiwake.Visible:=cb_channels_forceenter.Checked;
  cb_mx3_auto_im.Checked:=mx3_auto_im;
  edit_mx3_auto_im.Text:=mx3_auto_im_text;
  edit_mx3_auto_im.Visible:=cb_mx3_auto_im.Checked;
  cb_restrict_searchresult_per_user.Checked:=restrict_searchresult_per_user;
  edit_max_searchresult_per_user.Value:=max_searchresult_per_user;
  edit_loginim_user.Text:=loginim_user;
  edit_loginim.Lines.Clear;
  for i:=0 to max_loginim do
   if loginim[i]<>'' then
    edit_loginim.Lines.Add(loginim[i]);
  cb_dengon_enable.Checked:=dengon_enabled;
  cb_users_loginpass.Checked:=check_loginpass;
  edit_users_loginpass.Text:=loginpass;
  edit_search_domshare.Value:=search_domshare;
  edit_search_domsharesize.Value:=search_domsharesize div MegaByte;
  cb_searchblock_chknum.Checked:=searchblock_chknum;
  cb_searchblock_chksize.Checked:=searchblock_chksize;
  cb_browsedlblock_chknum.Checked:=browsedlblock_chknum;
  cb_browsedlblock_chksize.Checked:=browsedlblock_chksize;
  edit_search_searchblockshare.Value:=search_searchblockshare;
  edit_search_searchblocksharesize.Value:=search_searchblocksharesize div MegaByte;
  radio_searchblock_and.Checked:=searchblock_logic_and;
  radio_searchblock_or.Checked:=not searchblock_logic_and;
  radio_domblock_and.Checked:=browsedlblock_logic_and;
  radio_domblock_or.Checked:=not browsedlblock_logic_and;

  edit_search_searchblockshare.Enabled:=cb_searchblock_chknum.Checked;
  edit_search_searchblocksharesize.Enabled:=cb_searchblock_chksize.Checked;
  edit_search_domshare.Enabled:=cb_browsedlblock_chknum.Checked;
  edit_search_domsharesize.Enabled:=cb_browsedlblock_chksize.Checked;
  radio_searchblock_and.Enabled:=cb_searchblock_chknum.Checked and cb_searchblock_chksize.Checked;
  radio_domblock_and.Enabled:=cb_browsedlblock_chknum.Checked and cb_browsedlblock_chksize.Checked;
end;

procedure TSlavaNapSettings.sh_other3Show(Sender: TObject);
begin
  SetTopText('ق̐ݒ2');
  SetChange(true);
  cb_nocount_text.Checked:=nocount_text;
  cb_share_matchedfile_only.Checked:=share_matchedfile_only;
  edit_folder_depth.Value:=folder_depth;
  edit_toami_bantime.ItemIndex:=GetBanIndex(toami_bantime);
  edit_wq_bantime.ItemIndex:=GetBanIndex(wq_bantime);
  edit_incomplete_bantime.ItemIndex:=GetBanIndex(incomplete_bantime);
  edit_search_wantqueuep3m.Value:=flood_max_wantqueue;
  edit_toami_judge.Value:=flood_max_dlrequests;
  cb_autoban_incomplete.Checked:=autoban_incomplete;
  cb_loginblock_port.Checked:=loginblock_port;
  cb_l2b_level.Checked:=local2global_level;
  cb_enable_rating.Checked:=enable_rating;
  edit_rating_threshold.Value:=rating_threshold;
  cb_inflections.Checked:=enable_inflections;
  cb_l2b_log.Checked:=local2global_log;

  if toami_taiou='block' then radio_dl_block.Checked:=true
  else if toami_taiou='leech' then radio_dl_leech.Checked:=true
  else if toami_taiou='ban' then radio_dl_ban.Checked:=true
  else radio_dl_block.Checked:=true;

  if renqueue_taiou='block' then radio_wq_block.Checked:=true
  else if renqueue_taiou='leech' then radio_wq_leech.Checked:=true
  else if renqueue_taiou='ban' then radio_wq_ban.Checked:=true
  else radio_wq_block.Checked:=true;

  Label141.Visible:=radio_dl_ban.Checked;
  Label143.Visible:=radio_wq_ban.Checked;
  edit_toami_bantime.Visible:=radio_dl_ban.Checked;
  edit_wq_bantime.Visible:=radio_wq_ban.Checked;

  Label146.Visible:=cb_autoban_incomplete.Checked;
  edit_incomplete_bantime.Visible:=cb_autoban_incomplete.Checked;

  edit_loginblock_port.Text:=loginblock_portnumber;
  Label147.Visible:=cb_loginblock_port.Checked;
  edit_loginblock_port.Visible:=cb_loginblock_port.Checked;

  Label148.Visible:=cb_enable_rating.Checked;
  edit_rating_threshold.Visible:=cb_enable_rating.Checked;
end;

procedure TSlavaNapSettings.sh_other4Show(Sender: TObject);
var
  ini: TIniFile;
begin
  SetTopText('ق̐ݒ3');
  SetChange(true);
  if b3_canclose=false3 then
    cb_WindowClose.Checked:=true
  else
    cb_WindowClose.Checked:=false;
  cb_regsoft_only.Checked:=regsoft_only;
  cb_allow_2get.Checked   :=allowed_clients[soft2get];
  cb_allow_lopster.Checked:=allowed_clients[softLopster];
  cb_allow_napchan.Checked:=allowed_clients[softNapchan];
  cb_allow_napster.Checked:=allowed_clients[softNapster];
  cb_allow_teknap.Checked :=allowed_clients[softTekNap];
  cb_allow_utatane.Checked:=allowed_clients[softUtatane];
  cb_allow_winmx.Checked  :=allowed_clients[softWinMX];
  cb_allow_xnap.Checked   :=allowed_clients[softXNap];
  cb_allow_other.checked:=allowed_clients[softUnknown];
  edit_allow_sign0.Text:=allowed_custom[0];
  edit_allow_sign1.Text:=allowed_custom[1];
  edit_allow_sign2.Text:=allowed_custom[2];
  edit_allow_sign3.Text:=allowed_custom[3];
  edit_allow_sign4.Text:=allowed_custom[4];
  edit_allow_sign0.Visible:=cb_allow_other.Checked;
  edit_allow_sign1.Visible:=cb_allow_other.Checked;
  edit_allow_sign2.Visible:=cb_allow_other.Checked;
  edit_allow_sign3.Visible:=cb_allow_other.Checked;
  edit_allow_sign4.Visible:=cb_allow_other.Checked;
  cb_2byte_id_enabled.Checked:=id_2byte_enabled;
  cb_2byte_channel_enabled.Checked:=channel_2byte_enabled;
  cb_whois_gethost.Checked:=whois_gethost;
  cb_suggest_dbrowse.Checked:=suggest_dbrowse;
  cb_enable_trapport.Checked:=enable_trapport;
  ini:=TIniFile.Create(Applicationdir+'config');
  try
    edit_ul_gethost_max_resolving_cnt.Value:=ini.ReadInteger('Interface','UsersListHideRemoteHostMaxResolvingCount',3);
    edit_trapport.Text:=ini.ReadString('Other2','TrapPort','8888 8875 7743');
   finally
    ini.Free;
  end;
  edit_trapport.Visible:=cb_enable_trapport.Checked;
end;

procedure TSlavaNapSettings.sh_reportShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_REPORT));
 SetChange(true);
 cb_report_old_enable.Checked:=old_report_enabled;
 edit_report_old_port.Value:=old_report_port;
 cb_report_new_enabled.Checked:=new_report_enabled;
 edit_report_new_port.Value:=new_report_port;
 cb_report_new_hidehub.Checked:=new_report_hide_hub;
end;

procedure TSlavaNapSettings.sh_minshareShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_MINSHARE));
 SetChange(true);
 edit_minshare_minshare.Value:=minshare;
 edit_minshare_delay.Value:=minshare_delay div 60000;
 cb_minshare_ban.Checked:=minshare_ban;
 cb_minshare_banip.Checked:=minshare_banip;
 edit_minshare_bantime.Value:=minshare_bantime div 60;
 cb_minshare_onlyfull.checked:=minshare_fullonly;
 cb_minshare_full10.Checked:=minshare_only10;
 edit_minshare_minsharesize.Value:=minshare_size div MegaByte;
 cb_minshare_onlyfullClick(nil);
 cb_minshare_kickchat.Checked:=minshare_kickchat;
 cb_minshare_wallop.Checked:=wallop_serverban;
end;

procedure TSlavaNapSettings.sh_motdShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_MOTD));
 SetChange(true);
 edit_motd.Lines.Clear;
 try
  edit_motd.Lines.LoadFromFile(ApplicationDir+'motd');
  except
 end;
end;

procedure TSlavaNapSettings.sh_colorsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_COLORS));
 SetChange(true);
 edit_color_bg.ColorValue:=slBackground;
 edit_color_text.ColorValue:=slText;
 edit_color_chat.ColorValue:=slChatMessage;
 edit_color_mychat.ColorValue:=slChatMyMessage;
 edit_color_channelchat.ColorValue:=slChannelMessage;
 edit_color_mychannelchat.ColorValue:=slChannelMyMessage;
 edit_color_emote.ColorValue:=slChannelEmote;
 edit_color_myemote.ColorValue:=slChannelMyEmote;
 edit_color_join.ColorValue:=slChannelJoin;
 edit_color_part.ColorValue:=slChannelPart;
 edit_color_topic.ColorValue:=slTopic;
 edit_color_debug.ColorValue:=slDebugData;
 edit_color_error.ColorValue:=slError;
 edit_color_wallop.ColorValue:=slWallop;
 edit_color_announce.ColorValue:=slAnnounce;
 edit_color_online.ColorValue:=slOnline;
 edit_color_offline.ColorValue:=slOffline;
 edit_color_search.ColorValue:=slSearch;
 edit_color_remotesearch.ColorValue:=slRemoteSearch;
 edit_color_transfer.ColorValue:=slTransfer;
 edit_color_napigator.ColorValue:=slNapigator;
 edit_color_dagsta.ColorValue:=slDagsta;
 edit_color_pong.ColorValue:=slPong;
 edit_color_whowas.ColorValue:=slWhoWas;
end;

procedure TSlavaNapSettings.btn_changeClick(Sender: TObject);
var
 ini: TIniFile;
 reg: TRegistry;
 i: Integer;
begin
 if pages.ActivePage=sh_main then
 try
   cons_reg_user:=edit_main_remoteadmin.Text;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteString('Server','Ports',edit_main_ports.Text);
   ini.WriteString('Server','ReportHost',edit_main_host.Text);
   ini.WriteInteger('Server','ServerHandle',edit_main_handle.Value);
   ini.WriteString('Server','SocketsInterface',edit_main_listenip.Text);
   ini.Free;
  except
 end else if pages.ActivePage=sh_colors then
 try
   slBackground:=edit_color_bg.ColorValue;
   slText:=edit_color_text.ColorValue;
   slChatMessage:=edit_color_chat.ColorValue;
   slChatMyMessage:=edit_color_mychat.ColorValue;
   slChannelMessage:=edit_color_channelchat.ColorValue;
   slChannelMyMessage:=edit_color_mychannelchat.ColorValue;
   slChannelEmote:=edit_color_emote.ColorValue;
   slChannelMyEmote:=edit_color_myemote.ColorValue;
   slChannelJoin:=edit_color_join.ColorValue;
   slChannelPart:=edit_color_part.ColorValue;
   slTopic:=edit_color_topic.ColorValue;
   slDebugData:=edit_color_debug.ColorValue;
   slError:=edit_color_error.ColorValue;
   slWallop:=edit_color_wallop.ColorValue;
   slAnnounce:=edit_color_announce.ColorValue;
   slOnline:=edit_color_online.ColorValue;
   slOffline:=edit_color_offline.ColorValue;
   slSearch:=edit_color_search.ColorValue;
   slRemoteSearch:=edit_color_remotesearch.ColorValue;
   slTransfer:=edit_color_transfer.ColorValue;
   slNapigator:=edit_color_napigator.ColorValue;
   slDagsta:=edit_color_dagsta.ColorValue;
   slPong:=edit_color_pong.ColorValue;
   slWhoWas:=edit_color_whowas.ColorValue;
   ChangeColors;
   if running then SlavaNapWindow.SetColors(true);
  except
 end else if pages.ActivePage=sh_users then
 try
   registered_only:=cb_users_reg_only.Checked;
   allow_register:=cb_users_reg_allow.Checked;
   max_users:=edit_users_limit.Value;
   max_clones:=edit_users_clones.Value;
   timeout_login:=Int64(edit_users_logintimeout.Value) * 1000;
   max_accept:=edit_users_maxaccept.Value;
   accept_remote_users:=not cb_users_noremote.Checked;
   redirect_cqex:=cb_users_redirectcqex.Checked;
   banmail:=edit_users_banmail.Text;
   redirect_url:=edit_users_redirecturl.Text;
   reconnect_delay:=cb_users_reconnect.Checked;
  except
 end else if pages.ActivePage=sh_limits then
 try
   stats_delay:=Int64(edit_limits_stats.Value) * 1000;
   max_hotlist:=edit_limits_hotlist.Value;
   max_ignorelist:=edit_limits_ignored.Value;
   block_wantqueue:=cb_limits_blockwinmxqueue.Checked;
   bandwidth_maxdown:=edit_limits_maxdown.Value;
   bandwidth_maxup:=edit_limits_maxup.Value;
   bandwidth_limitservers:=not cb_limits_limitservers.Checked;
   memory_limit:=1048576 * Int64(edit_limits_memory.Value);
  except
 end else if pages.ActivePage=sh_log then
 try
   log_login:=cb_log_login.Checked;
   log_napigator:=cb_log_napigator.Checked;
   log_dagsta:=cb_log_dagsta.Checked;
   log_search:=cb_log_search.Checked;
   log_transfers:=cb_log_transfers.Checked;
//   log_links:=cb_log_links.Checked;
   log_to_file:=cb_log_save.Checked;
   log_commands:=cb_log_users.Checked;
   log_servercommands:=cb_log_servers.Checked;
   save_stats:=cb_log_serverstats.Checked;
   clear_serverstats:=cb_log_clearserverstats.Checked;
   clear_clientstats:=cb_log_clearclientstats.Checked;
   log_console_data:=cb_log_console.Checked;
  except
 end else if pages.ActivePage=sh_share then
 try
   maxshare:=edit_share_max.Value;
   maxshare_total:=edit_share_maxtotal.Value;
   minfilename:=edit_share_filename.Value;
   minduration:=edit_share_duration.Value;
   allow_share:=not cb_share_disable.checked;
   shareinform:=cb_share_inform.Checked;
   share_nomodem:=cb_share_nomodem.Checked;
   maxshareindex:=edit_share_maxindex.Value;
   share_checkdup:=cb_share_checkdup.Checked;
  except
 end else if pages.ActivePage=sh_share_mp3 then
 try
   ext_mp3:=edit_mp3_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_mp3:=edit_mp3_max.Value;
   minfilesize_mp3:=Int64(edit_mp3_minsize.Value) * 1024;
   maxfilesize_mp3:=Int64(edit_mp3_maxsize.Value) * 1024;
   share_320:=cb_mp3_320.Checked;
   share_256:=cb_mp3_256.checked;
   share_224:=cb_mp3_224.checked;
   share_192:=cb_mp3_192.checked;
   share_160:=cb_mp3_160.checked;
   share_128:=cb_mp3_128.checked;
   share_112:=cb_mp3_112.checked;
   share_96:=cb_mp3_96.checked;
   share_80:=cb_mp3_80.checked;
   share_64:=cb_mp3_64.checked;
   share_56:=cb_mp3_56.checked;
   share_48:=cb_mp3_48.checked;
   share_40:=cb_mp3_40.checked;
   share_32:=cb_mp3_32.checked;
   share_24:=cb_mp3_24.checked;
   share_unknown:=cb_mp3_0.checked;
  except
 end else if pages.ActivePage=sh_share_audio then
 try
   ext_audio:=edit_audio_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_audio:=edit_audio_max.Value;
   minfilesize_audio:=Int64(edit_audio_minsize.Value) * 1024;
   maxfilesize_audio:=Int64(edit_audio_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_video then
 try
   ext_video:=edit_video_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_video:=edit_video_max.Value;
   minfilesize_video:=Int64(edit_video_minsize.Value) * 1024;
   maxfilesize_video:=Int64(edit_video_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_images then
 try
   ext_image:=edit_images_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_image:=edit_images_max.Value;
   minfilesize_image:=Int64(edit_images_minsize.Value) * 1024;
   maxfilesize_image:=Int64(edit_images_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_apps then
 try
   ext_app:=edit_apps_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_app:=edit_apps_max.Value;
   minfilesize_app:=Int64(edit_apps_minsize.Value) * 1024;
   maxfilesize_app:=Int64(edit_apps_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_cd then
 try
   ext_cd:=edit_cd_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_cd:=edit_cd_max.Value;
   minfilesize_cd:=Int64(edit_cd_minsize.Value) * 1024;
   maxfilesize_cd:=Int64(edit_cd_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_text then
 try
   ext_text:=edit_text_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_text:=edit_text_max.Value;
   minfilesize_text:=Int64(edit_text_minsize.Value) * 1024;
   maxfilesize_text:=Int64(edit_text_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_search then
 try
   defsearchresults:=edit_search_defsearch.Value;
   maxsearchresults:=edit_search_maxsearch.Value;
   maxbrowseresults:=edit_search_maxbrowse.Value;
   maxremotebrowse:=edit_search_maxremotebrowse.Value;
   flood_max_searches:=edit_search_searchespm.Value;
   disableremotesearch:=cb_search_disable_remote.Checked;
   maxremotesearchresults:=edit_search_maxremote.Value;
  except
 end else if pages.ActivePage=sh_channels then
 try
   allow_create_channels:=cb_channels_allowcreate.Checked;
   max_channels:=edit_channels_max.Value;
   max_channels_total:=edit_channels_max2.Value;
   block_cqex_chat:=cb_channels_blockcqex.Checked;
   old_opsay:=cb_channels_oldwallop.Checked;
   max_privmsg_len:=edit_channels_maxprivmessage.Value;
   max_channelmsg_len:=edit_channels_maxmessage.Value;
   show_operators:=cb_channels_showops.checked;
   prevent_shouting:=cb_channels_preventshout.Checked;
   flood_enable:=cb_channels_floodenable.Checked;
   flood_max_user_message:=edit_channels_flood_user.Value;
   flood_max_same_message:=edit_channels_flood_same.Value;
   flood_warning:=cb_channels_flood_warn.Checked;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteBool('Channels','TimeStamp',cb_channels_timestamp.Checked);
   ini.WriteBool('Channels','IRCStyle',cb_channels_irc.Checked);
   ini.WriteBool('Channels','LowerCase',cb_channels_low.Checked);
   ini.Free;
  except
 end else if pages.ActivePage=sh_interface then
 try
   cpu_usage:=edit_interface_cpu.Value;
   cpu_disable:=cb_interface_nocpu.Checked;
   switch_chat:=not cb_interface_noswitch.Checked;
   chat_flash:=cb_interface_chatflash.Checked;
   chat_mini:=cb_interface_chatmini.Checked;
   wallop_im:=cb_interface_wallop.Checked;
   if cb_interface_systray.Checked<>SlavaNapwindow.tray.active then
   begin
     SlavaNapWindow.tray.active:=cb_interface_systray.Checked;
     if not SlavaNapWindow.Visible then
      SlavaNapWindow.Show;
   end;
   reg:=TRegistry.Create;
   try
    reg.RootKey:=HKEY_LOCAL_MACHINE;
    reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run',true);
    if cb_interface_startup.Checked then reg.WriteString('SlavaNap',Application.Exename+' -hide')
    else reg.DeleteValue('SlavaNap');
    except
   end;
   reg.Free;
  except
 end else if pages.ActivePage=sh_levels then
 try
   levels[0]:=edit_level_0.Text;
   levels[1]:=edit_level_1.Text;
   levels[2]:=edit_level_2.Text;
   levels[3]:=edit_level_3.Text;
   levels[4]:=edit_level_4.Text;
   levels[5]:=edit_level_5.Text;
  except
 end else if pages.ActivePage=sh_napigator then
 try
   napigator_host:=edit_napigator_host.Text;
   napigator_port:=edit_napigator_port.Text;
   napigator_user:=edit_napigator_user.Text;
   napigator_myport:=edit_napigator_myport.Value;
   napigator_enabled:=cb_napigator_enabled.Checked;
   napigator_myip:=trim(edit_napigator_myip.Text);
   napigator_autodisconnect:=cb_napigator_autodisconnect.Checked;
   napigator_delay:=edit_napigator_delay.Value * 60000;
  except
 end else if pages.ActivePage=sh_dagsta then
 try
   dagsta_host:=edit_dagsta_host.Text;
   dagsta_port:=edit_dagsta_port.Text;
   dagsta_user:=edit_dagsta_user.Text;
   dagsta_myport:=edit_dagsta_myport.Value;
   dagsta_enabled:=cb_dagsta_enabled.Checked;
   dagsta_myip:=trim(edit_dagsta_myip.Text);
   dagsta_autodisconnect:=cb_dagsta_autodisconnect.Checked;
   dagsta_delay:=edit_dagsta_delay.Value * 60000;
  except
 end else if pages.ActivePage=sh_blocked then
 try
   blocked_clients[softNapster]:=cb_block_napster.Checked;
   blocked_clients[softAudioGnome]:=cb_block_audiognome.Checked;
   blocked_clients[softWinMX]:=cb_block_winmx.Checked;
   blocked_clients[softGnomePlus]:=cb_block_gnomeplus.Checked;
   blocked_clients[softAmster]:=cb_block_amster.Checked;
   blocked_clients[softFileNavigator]:=cb_block_filenavigator.Checked;
   blocked_clients[softCQEX]:=cb_block_cqex.Checked;
   blocked_clients[softSunshineUN]:=cb_block_sunshineun.checked;
   blocked_clients[softTekNap]:=cb_block_teknap.checked;
   blocked_clients[softNap]:=cb_block_nap.Checked;
   blocked_clients[softMacNap]:=cb_block_macnap.Checked;
   blocked_clients[softMP3Rage]:=cb_block_mp3rage.Checked;
   blocked_clients[softXNap]:=cb_block_xnap.Checked;
   blocked_clients[softSpotlight]:=cb_block_spotlight.Checked;
   blocked_clients[softNFS]:=cb_block_nfs.Checked;
   blocked_clients[softDMNapster]:=cb_block_dmnapster.checked;
   blocked_clients[softKNapster]:=cb_block_knapster.Checked;
   blocked_clients[softLopster]:=cb_block_lopster.Checked;
   blocked_clients[softRapigator]:=cb_block_rapigator.Checked;
   blocked_clients[softSwaptor]:=cb_block_swaptor.Checked;
   blocked_clients[softDagsta]:=cb_block_dagsta.Checked;
   blocked_clients[softDrumbeat]:=cb_block_drumbeat.Checked;
   blocked_clients[softFloodster]:=cb_block_floodster.Checked;
   blocked_clients[softUnknown]:=cb_block_other.checked;
   blocked_message:=edit_block_message.Text;
   blocked_custom[0]:=AnsiLowerCase(edit_block_sign0.Text);
   blocked_custom[1]:=AnsiLowerCase(edit_block_sign1.Text);
   blocked_custom[2]:=AnsiLowerCase(edit_block_sign2.Text);
   blocked_custom[3]:=AnsiLowerCase(edit_block_sign3.Text);
   blocked_custom[4]:=AnsiLowerCase(edit_block_sign4.Text);
   blocked_custom[5]:=AnsiLowerCase(edit_block_sign5.Text);
   smart_block_winmx:=cb_block_smartwinmx.Checked;
   limit_mx:=cb_block_limitMX.Checked;
   quota_mx:=edit_MX_quota.value;
   if cb_block_custommessage.Checked then blocked_messagetype:=blckCustom
   else if cb_block_nomessage.Checked then blocked_messagetype:=blckNone
   else blocked_messagetype:=blckDefault;
  except
 end else if pages.ActivePage=sh_console then
 try
   if not check_name(edit_console_user.Text,true) then
   begin
     ShowMessage('Invalid user name');
     exit;
   end;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteString('Console','User',edit_console_user.Text);
   ini.Free;
   if running then
   if Ord(cons.data^.speed)<>edit_console_speed.ItemIndex then
    cmd_list.AddDoubleCmd(MSG_CLIENT_CHANGE_SPEED,0,IntToStr(edit_console_speed.ItemIndex),'');
  except
 end else if pages.ActivePage=sh_links then
 try
   if cb_link_all.checked then allow_link:=linkAll
   else if cb_link_none.checked then allow_link:=linkNone
   else if cb_link_list2.Checked then allow_link:=linkCustom
   else allow_link:=linkList;
   allowed_servers:=lowercase(edit_link_list.Text);
   network_hub:=cb_link_hub.Checked;
   hub_syncreg:=cb_link_syncreg.Checked;
   hub_syncban:=cb_link_syncban.Checked;
   autolink_only1:=cb_link_noautoconnect.Checked;
   restrict_outgoing:=cb_link_restrictoutgoing.Checked;
   outgoing_list:=lowercase(edit_link_outgoinglist.Text);
  except
 end else if pages.ActivePage=sh_links2 then
 try
   search_noforward_results:=cb_link2_lagnosearch.Checked;
   search_noforward_requests:=cb_link2_lagnosearchreq.Checked;
   browse_noforward_results:=cb_link2_lagnobrowse.Checked;
   browse_noforward_requests:=cb_link2_lagnobrowsereq.Checked;
  except
 end else if pages.ActivePage=sh_sockets then
 try
   sockets_users_default:=cb_sockets_users_def.Checked;
   sockets_users_send:=edit_sockets_users_send.Value;
   sockets_users_recv:=edit_sockets_users_recv.Value;
   sockets_servers_default:=cb_sockets_servers_def.Checked;
   sockets_servers_send:=edit_sockets_servers_send.Value;
   sockets_servers_recv:=edit_sockets_servers_recv.Value;
  except
 end else if pages.ActivePage=sh_other then
 try
   ann_enabled:=cb_ann_enable.Checked;
   ann_imenabled:=cb_ann_imenable.Checked;
   ann_delay:=edit_ann_delay.Value;
   ann_user:=edit_ann_user.Text;
   for i:=0 to max_announcement do
    ann_messages[i]:='';
   for i:=0 to edit_ann_messages.Lines.Count-1 do
    if Trim(edit_ann_messages.Lines.Strings[i])<>'' then
     ann_messages[i]:=Trim(edit_ann_messages.Lines.Strings[i]);
  except
 end else if pages.ActivePage=sh_other2 then
 try
   loginim_enabled:=cb_loginim_enable.Checked;
   loginim_user:=edit_loginim_user.Text;
   force_enter:=cb_channels_forceenter.Checked;
   force_enter_channel:=edit_channels_forceenter.Text;
   old_force_enter:=cb_channels_old_forceenter.Checked;
   force_enter_furiwake:=cb_force_enter_furiwake.Checked;
   mx3_auto_im:=cb_mx3_auto_im.Checked;
   mx3_auto_im_text:=edit_mx3_auto_im.Text;
   restrict_searchresult_per_user:=cb_restrict_searchresult_per_user.Checked;
   max_searchresult_per_user:=edit_max_searchresult_per_user.Value;
   for i:=0 to max_loginim do
    loginim[i]:='';
   for i:=0 to edit_loginim.Lines.Count-1 do
    if Trim(edit_loginim.Lines.Strings[i])<>'' then
     loginim[i]:=Trim(edit_loginim.Lines.Strings[i]);
   dengon_enabled:=cb_dengon_enable.Checked;
   check_loginpass:=cb_users_loginpass.Checked;
   loginpass:=edit_users_loginpass.Text;
   search_domshare:=edit_search_domshare.Value;
   search_domsharesize:=Int64(edit_search_domsharesize.Value) * MegaByte;
   search_searchblockshare:=edit_search_searchblockshare.Value;
   search_searchblocksharesize:=Int64(edit_search_searchblocksharesize.Value) * MegaByte;
   searchblock_chknum:=cb_searchblock_chknum.Checked;
   searchblock_chksize:=cb_searchblock_chksize.Checked;
   searchblock_logic_and:=radio_searchblock_and.Checked and radio_searchblock_and.Enabled;
   browsedlblock_chknum:=cb_browsedlblock_chknum.Checked;
   browsedlblock_chksize:=cb_browsedlblock_chksize.Checked;
   browsedlblock_logic_and:=radio_domblock_and.Checked and radio_domblock_and.Enabled;
  except
 end else if pages.ActivePage=sh_other3 then
 try
   nocount_text:=cb_nocount_text.Checked;
   share_matchedfile_only:=cb_share_matchedfile_only.Checked;
   folder_depth:=edit_folder_depth.Value;
   toami_bantime:=GetBanID(edit_toami_bantime);
   wq_bantime:=GetBanID(edit_wq_bantime);
   incomplete_bantime:=GetBanID(edit_incomplete_bantime);
   flood_max_wantqueue:=edit_search_wantqueuep3m.Value;
   flood_max_dlrequests:=edit_toami_judge.Value;
   autoban_incomplete:=cb_autoban_incomplete.Checked;
   loginblock_port:=cb_loginblock_port.Checked;
   loginblock_portnumber:=edit_loginblock_port.Text;
   local2global_level:=cb_l2b_level.Checked;
   enable_rating:=cb_enable_rating.Checked;
   rating_threshold:=edit_rating_threshold.Value;
   enable_inflections:=cb_inflections.Checked;
   if enable_inflections then
     LoadWordSet;
   local2global_log:=cb_l2b_log.Checked;
   if radio_dl_block.Checked then toami_taiou:='block'
   else if radio_dl_leech.Checked then toami_taiou:='leech'
   else if radio_dl_ban.Checked then toami_taiou:='ban';
   if radio_wq_block.Checked then renqueue_taiou:='block'
   else if radio_wq_leech.Checked then renqueue_taiou:='leech'
   else if radio_wq_ban.Checked then renqueue_taiou:='ban';
  except
 end else if pages.ActivePage=sh_other4 then
 try
   if cb_WindowClose.Checked=true then
   begin
     b3_canclose:=false3;
     closing:=false;
   end else if cb_WindowClose.Checked=false then
   begin
     b3_canclose:=true3;
     closing:=true;
   end;
   regsoft_only:=cb_regsoft_only.Checked;
   allowed_clients[soft2get]       :=cb_allow_2get.Checked;
   allowed_clients[softLopster]    :=cb_allow_lopster.Checked;
   allowed_clients[softNapchan]    :=cb_allow_napchan.Checked;
   allowed_clients[softNapster]    :=cb_allow_napster.Checked;
   allowed_clients[softTekNap]     :=cb_allow_teknap.Checked;
   allowed_clients[softUtatane]    :=cb_allow_utatane.Checked;
   allowed_clients[softWinMX]:=cb_allow_winmx.Checked;
   allowed_clients[softWinMXJap]   :=cb_allow_winmx.Checked;//`FbN{bNXőΉ
   allowed_clients[softXNap]       :=cb_allow_xnap.Checked;
   allowed_clients[softUnknown]    :=cb_allow_other.Checked;
   allowed_custom[0]:=edit_allow_sign0.Text;
   allowed_custom[1]:=edit_allow_sign1.Text;
   allowed_custom[2]:=edit_allow_sign2.Text;
   allowed_custom[3]:=edit_allow_sign3.Text;
   allowed_custom[4]:=edit_allow_sign4.Text;
   id_2byte_enabled:=cb_2byte_id_enabled.Checked;
   channel_2byte_enabled:=cb_2byte_channel_enabled.Checked;
   whois_gethost:=cb_whois_gethost.Checked;
   suggest_dbrowse:=cb_suggest_dbrowse.Checked;
   enable_trapport:=cb_enable_trapport.Checked;
   ini:=TIniFile.Create(Applicationdir+'config');
   try
     ini.WriteInteger('Interface','UsersListHideRemoteHostMaxResolvingCount',edit_ul_gethost_max_resolving_cnt.Value);
     ini.WriteString('Other2','TrapPort',edit_trapport.Text);
    finally
     ini.Free;
   end;
  except
 end else if pages.ActivePage=sh_report then
 try
   old_report_enabled:=cb_report_old_enable.Checked;
   old_report_port:=edit_report_old_port.Value;
   new_report_enabled:=cb_report_new_enabled.Checked;
   new_report_port:=edit_report_new_port.Value;
   new_report_hide_hub:=cb_report_new_hidehub.Checked;
  except
 end else if pages.ActivePage=sh_minshare then
 try
   minshare:=edit_minshare_minshare.Value;
   minshare_delay:=Int64(edit_minshare_delay.Value) * 60000;
   minshare_ban:=cb_minshare_ban.Checked;
   minshare_banip:=cb_minshare_banip.Checked;
   minshare_bantime:=edit_minshare_bantime.Value * 60;
   minshare_fullonly:=cb_minshare_onlyfull.checked;
   minshare_size:=Int64(edit_minshare_minsharesize.Value) * MegaByte;
   minshare_only10:=cb_minshare_full10.Checked;
   minshare_kickchat:=cb_minshare_kickchat.Checked;
   wallop_serverban:=cb_minshare_wallop.Checked;
  except
 end else if pages.ActivePage=sh_motd then
 try
   edit_motd.Lines.SaveToFile(ApplicationDir+'motd');
   if running then
    cmd_list.AddDoubleCmd(MSG_CMD_MOTDCHANGE,0,'','');
  except
 end;
 btn_restoreClick(nil);
end;

procedure TSlavaNapSettings.btn_level_defaultClick(Sender: TObject);
begin
 edit_level_0.Text:='Leech';
 edit_level_1.Text:='User';
 edit_level_2.Text:='Moderator';
 edit_level_3.Text:='Admin';
 edit_level_4.Text:='Elite';
 edit_level_5.Text:='Console';
 btn_changeClick(nil);
end;

procedure TSlavaNapSettings.btn_napigator_disconnectClick(Sender: TObject);
begin
 if not running then exit;
 if napigator_socket<>INVALID_SOCKET then
   TCPSocket_Free(napigator_socket);
end;

procedure TSlavaNapSettings.btn_napigator_passwordClick(Sender: TObject);
begin
 if Sender=btn_napigator_password then
  SlavaNapEdit.Ask(SE_NAPIGATORPASS)
 else
  SlavaNapEdit.Ask(SE_DAGSTAPASS); 
end;

procedure TSlavaNapSettings.cb_log_serverstatsClick(Sender: TObject);
begin
 cb_log_clearserverstats.Visible:=cb_log_serverstats.Checked;
end;

procedure TSlavaNapSettings.cb_block_custommessageClick(Sender: TObject);
begin
 lbl_block_message.Visible:=cb_block_custommessage.Checked;
 edit_block_message.Visible:=cb_block_custommessage.checked;
end;

procedure TSlavaNapSettings.cb_search_disable_remoteClick(Sender: TObject);
begin
 lbl_search_maxremote.Visible:=not cb_search_disable_remote.Checked;
 edit_search_maxremote.Visible:=not cb_search_disable_remote.Checked;
end;

procedure TSlavaNapSettings.cb_sockets_users_defClick(Sender: TObject);
begin
 edit_sockets_users_send.Visible:=not cb_sockets_users_def.Checked;
 edit_sockets_users_recv.Visible:=not cb_sockets_users_def.Checked;
 lbl_sockets_users_send.Visible:=not cb_sockets_users_def.Checked;
 lbl_sockets_users_recv.Visible:=not cb_sockets_users_def.Checked;
end;

procedure TSlavaNapSettings.cb_sockets_servers_defClick(Sender: TObject);
begin
 edit_sockets_servers_send.Visible:=not cb_sockets_servers_def.Checked;
 edit_sockets_servers_recv.Visible:=not cb_sockets_servers_def.Checked;
 lbl_sockets_servers_send.Visible:=not cb_sockets_servers_def.Checked;
 lbl_sockets_servers_recv.Visible:=not cb_sockets_servers_def.Checked;
end;

procedure TSlavaNapSettings.cb_block_winmxClick(Sender: TObject);
begin
 cb_block_smartwinmx.Visible:=cb_block_winmx.Checked;
 cb_block_limitMX.visible:=not cb_block_winmx.checked;
 lbl_limitMX.visible:= cb_block_limitMX.checked and not cb_block_winmx.checked;
 edit_MX_quota.visible:= cb_block_limitMX.checked and not cb_block_winmx.checked;
end;

procedure TSlavaNapSettings.cb_minshare_onlyfullClick(Sender: TObject);
begin
 cb_minshare_full10.Visible:=cb_minshare_onlyfull.Checked;
end;

procedure TSlavaNapSettings.ChangeColors;
begin
 tree.Color:=slBackground;
 tree.Font.Color:=slText;
end;

procedure TSlavaNapSettings.btn_colors_defaultClick(Sender: TObject);
begin
 slBackground:=$FFFFFF;
 slText:=0;
 slError:=$0000FF;
 slWallop:=$A06000;
 slAnnounce:=$A00060;
 slWhowas:=$600060;
 slPong:=$600060;
 slOffline:=$603000;
 slOnline:=$A06000;
 slDebugData:=$000060;
 slNapigator:=$006000;
 slDagsta:=$008000;
 slSearch:=$A000A0;
 slRemoteSearch:=$A000A0;
 slTransfer:=$600060;
 slTopic:=$B00060;
 slChannelMessage:=0;
 slChannelMyMessage:=$404040;
 slChannelEmote:=$606000;
 slChannelMyEmote:=$808000;
 slChannelJoin:=$A06000;
 slChannelPart:=$603000;
 slChatMessage:=$A00000;
 slChatMyMessage:=0;
 ChangeColors;
 if running then SlavaNapWindow.SetColors(true);
 btn_restoreClick(nil);
end;

procedure TSlavaNapSettings.btn_color_chClick(Sender: TObject);
var
 i: Integer;
 c: TColor;
begin
 if not (Sender is TSpeedButton) then exit;
 i:=(Sender as TSpeedButton).tag;
 if i=0 then exit;
 cd.tag:=i;
 case i of
   1:   c:=edit_color_bg.ColorValue;
   2:   c:=edit_color_chat.ColorValue;
   3:   c:=edit_color_mychat.ColorValue;
   4:   c:=edit_color_channelchat.ColorValue;
   5:   c:=edit_color_mychannelchat.ColorValue;
   6:   c:=edit_color_emote.ColorValue;
   7:   c:=edit_color_myemote.ColorValue;
   8:   c:=edit_color_join.ColorValue;
   9:   c:=edit_color_part.ColorValue;
   10:  c:=edit_color_topic.ColorValue;
   11:  c:=edit_color_debug.ColorValue;
   12:  c:=edit_color_text.ColorValue;
   13:  c:=edit_color_error.ColorValue;
   14:  c:=edit_color_wallop.ColorValue;
   15:  c:=edit_color_announce.ColorValue;
   16:  c:=edit_color_online.ColorValue;
   17:  c:=edit_color_offline.ColorValue;
   18:  c:=edit_color_search.ColorValue;
   19:  c:=edit_color_transfer.ColorValue;
   20:  c:=edit_color_napigator.ColorValue;
   21:  c:=edit_color_pong.ColorValue;
   22:  c:=edit_color_whowas.ColorValue;
   23:  c:=edit_color_dagsta.ColorValue;
   24:  c:=edit_color_remotesearch.ColorValue;
   else exit;
 end;
 cd.color:=c;
 if not cd.Execute then exit;
 c:=cd.color;
 case cd.tag of
   1:   edit_color_bg.ColorValue:=c;
   2:   edit_color_chat.ColorValue:=c;
   3:   edit_color_mychat.ColorValue:=c;
   4:   edit_color_channelchat.ColorValue:=c;
   5:   edit_color_mychannelchat.ColorValue:=c;
   6:   edit_color_emote.ColorValue:=c;
   7:   edit_color_myemote.ColorValue:=c;
   8:   edit_color_join.ColorValue:=c;
   9:   edit_color_part.ColorValue:=c;
   10:  edit_color_topic.ColorValue:=c;
   11:  edit_color_debug.ColorValue:=c;
   12:  edit_color_text.ColorValue:=c;
   13:  edit_color_error.ColorValue:=c;
   14:  edit_color_wallop.ColorValue:=c;
   15:  edit_color_announce.ColorValue:=c;
   16:  edit_color_online.ColorValue:=c;
   17:  edit_color_offline.ColorValue:=c;
   18:  edit_color_search.ColorValue:=c;
   19:  edit_color_transfer.ColorValue:=c;
   20:  edit_color_napigator.ColorValue:=c;
   21:  edit_color_pong.ColorValue:=c;
   22:  edit_color_whowas.ColorValue:=c;
   23:  edit_color_dagsta.ColorValue:=c;
   24:  edit_color_remotesearch.ColorValue:=c;
   else exit;
 end;
end;

procedure TSlavaNapSettings.cb_channels_floodenableClick(Sender: TObject);
begin
 lbl_flood1.Visible:=cb_channels_floodenable.Checked;
 lbl_flood2.Visible:=cb_channels_floodenable.Checked;
 edit_channels_flood_user.Visible:=cb_channels_floodenable.Checked;
 edit_channels_flood_same.Visible:=cb_channels_floodenable.Checked;
 cb_channels_flood_warn.Visible:=cb_channels_floodenable.Checked;
end;


procedure TSlavaNapSettings.btn_dagsta_disconnectClick(Sender: TObject);
begin
 if not running then exit;
 if dagsta_socket<>INVALID_SOCKET then
   TCPSocket_Free(dagsta_socket);
end;

procedure TSlavaNapSettings.Label137Click(Sender: TObject);
begin
 ShellExecute(Handle,PChar('open'),PChar('http://www.dagsta.com/?register'),nil,nil,SW_ShowNormal);
end;

procedure TSlavaNapSettings.cb_ann_enableClick(Sender: TObject);
begin
  cb_ann_imenable.Visible:=cb_ann_enable.Checked;
  if not cb_ann_enable.Checked then begin
    cb_ann_imenable.Checked:=false;
    ann_imenabled:=false;
  end;
end;

procedure TSlavaNapSettings.cb_searchblock_chknumClick(Sender: TObject);
begin
  edit_search_searchblockshare.Enabled:=cb_searchblock_chknum.Checked;
  if cb_searchblock_chknum.Checked and cb_searchblock_chksize.Checked then
  begin
    radio_searchblock_and.Enabled:=True;
    radio_searchblock_or.Enabled:=True;
  end
  else
  begin
    radio_searchblock_and.Enabled:=False;
    radio_searchblock_or.Enabled:=False;
  end;
end;

procedure TSlavaNapSettings.cb_searchblock_chksizeClick(Sender: TObject);
begin
  edit_search_searchblocksharesize.Enabled:=cb_searchblock_chksize.Checked;
  if cb_searchblock_chknum.Checked and cb_searchblock_chksize.Checked then
  begin
    radio_searchblock_and.Enabled:=True;
    radio_searchblock_or.Enabled:=True;
  end
  else
  begin
    radio_searchblock_and.Enabled:=False;
    radio_searchblock_or.Enabled:=False;
  end;
end;

procedure TSlavaNapSettings.cb_browsedlblock_chknumClick(Sender: TObject);
begin
  edit_search_domshare.Enabled:=cb_browsedlblock_chknum.Checked;
  if cb_browsedlblock_chknum.Checked and cb_browsedlblock_chksize.Checked then
  begin
    radio_domblock_and.Enabled:=True;
    radio_domblock_or.Enabled:=True;
  end
  else
  begin
    radio_domblock_and.Enabled:=False;
    radio_domblock_or.Enabled:=False;
  end;
end;

procedure TSlavaNapSettings.cb_browsedlblock_chksizeClick(Sender: TObject);
begin
  edit_search_domsharesize.Enabled:=cb_browsedlblock_chksize.Checked;
  if cb_browsedlblock_chknum.Checked and cb_browsedlblock_chksize.Checked then
  begin
    radio_domblock_and.Enabled:=True;
    radio_domblock_or.Enabled:=True;
  end
  else
  begin
    radio_domblock_and.Enabled:=False;
    radio_domblock_or.Enabled:=False;
  end;
end;

procedure TSlavaNapSettings.SetBanItems(control: TComboBox);
begin
 control.Items.Clear;
 control.Items.Add(GetLangI(LNG_BANS_TIME60));
 control.Items.Add(GetLangI(LNG_BANS_TIME300));
 control.Items.Add(GetLangI(LNG_BANS_TIME600));
 control.Items.Add(GetLangI(LNG_BANS_TIME1800));
 control.Items.Add(GetLangI(LNG_BANS_TIME3600));
 control.Items.Add(GetLangI(LNG_BANS_TIME10800));
 control.Items.Add(GetLangI(LNG_BANS_TIME43200));
 control.Items.Add(GetLangI(LNG_BANS_TIME86400));
 control.Items.Add(GetLangI(LNG_BANS_TIME259200));
 control.Items.Add(GetLangI(LNG_BANS_TIME604800));
 control.Items.Add(GetLangI(LNG_BANS_TIME1209600));
 control.Items.Add(GetLangI(LNG_BANS_TIME2678400));
 control.ItemIndex:=control.Items.Count-1;
 control.Items.Add(GetLangI(LNG_BANS_TIME5184000));
 control.Items.Add(GetLangI(LNG_BANS_TIME7776000));
 control.Items.Add(GetLangI(LNG_BANS_TIME31536000));
 control.Items.Add('iv');
 control.DropDownCount:=control.Items.Count;
end;

function  TSlavaNapSettings.GetBanID(control: TComboBox): Integer;
var
 t: Integer;
begin
 case control.ItemIndex of
  0: t:=60;
  1: t:=300;
  2: t:=600;
  3: t:=1800;
  4: t:=3600;
  5: t:=10800;
  6: t:=43200;
  7: t:=86400;
  8: t:=259200;
  9: t:=604800;
  10: t:=1209600;
  11: t:=2678400;
  12: t:=5184000;
  13: t:=7776000;
  14: t:=31536000;
  15: t:=0;
  else t:=def_ban_timeout;
 end;
 Result:=t;
end;

function  TSlavaNapSettings.GetBanIndex(t: Integer): Integer;
var
 itemindex: Integer;
begin
 case t of
        60: itemindex:=0;
       300: itemindex:=1;
       600: itemindex:=2;
      1800: itemindex:=3;
      3600: itemindex:=4;
     10800: itemindex:=5;
     43200: itemindex:=6;
     86400: itemindex:=7;
    259200: itemindex:=8;
    604800: itemindex:=9;
   1209600: itemindex:=10;
   2678400: itemindex:=11;
   5184000: itemindex:=12;
   7776000: itemindex:=13;
  31536000: itemindex:=14;
         0: itemindex:=15;
  else itemindex:=11;//31
 end;
 Result:=itemindex;
end;

procedure TSlavaNapSettings.radio_dlClick(Sender: TObject);
begin
  edit_toami_bantime.Visible:=radio_dl_ban.Checked;
  Label141.Visible:=radio_dl_ban.Checked;
end;

procedure TSlavaNapSettings.radio_wqClick(Sender: TObject);
begin
  edit_wq_bantime.Visible:=radio_wq_ban.Checked;
  Label143.Visible:=radio_wq_ban.Checked;
end;

procedure TSlavaNapSettings.cb_block_limitMXClick(Sender: TObject);
begin
 lbl_limitMX.visible:= cb_block_limitMX.checked;
 edit_MX_quota.visible:= cb_block_limitMX.checked;
end;

procedure TSlavaNapSettings.cb_autoban_incompleteClick(Sender: TObject);
begin
  edit_incomplete_bantime.Visible:=cb_autoban_incomplete.Checked;
  Label146.Visible:=cb_autoban_incomplete.Checked;
end;

procedure TSlavaNapSettings.cb_loginblock_portClick(Sender: TObject);
begin
  edit_loginblock_port.Visible:=cb_loginblock_port.Checked;
  Label147.Visible:=cb_loginblock_port.Checked;
end;

procedure TSlavaNapSettings.cb_enable_ratingClick(Sender: TObject);
begin
  edit_rating_threshold.Visible:=cb_enable_rating.Checked;
  Label148.Visible:=cb_enable_rating.Checked;
end;


procedure TSlavaNapSettings.cb_allow_otherClick(Sender: TObject);

begin
  edit_allow_sign0.Visible:=cb_allow_other.Checked;
  edit_allow_sign1.Visible:=cb_allow_other.Checked;
  edit_allow_sign2.Visible:=cb_allow_other.Checked;
  edit_allow_sign3.Visible:=cb_allow_other.Checked;
  edit_allow_sign4.Visible:=cb_allow_other.Checked;
end;

procedure TSlavaNapSettings.cb_channels_forceenterClick(Sender: TObject);
begin
  edit_channels_forceenter.Visible:=cb_channels_forceenter.Checked;
  cb_channels_old_forceenter.Visible:=cb_channels_forceenter.Checked;
  cb_force_enter_furiwake.Visible:=cb_channels_forceenter.Checked;
end;

procedure TSlavaNapSettings.cb_mx3_auto_IMClick(Sender: TObject);
begin
  edit_mx3_auto_IM.Visible:=cb_mx3_auto_IM.Checked;
end;

procedure TSlavaNapSettings.cb_enable_trapportClick(Sender: TObject);
begin
  edit_trapport.Visible:=cb_enable_trapport.Checked;
end;

end.


