{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: users

 Class for local and remote users

*********************************************************}
unit users;

interface

uses
 Windows, Classes, SysUtils, constants, stypes, blcksock, synsock, winsock, share,
 servers;

type
 TOnlineUser = record
  nick          : String;
  password      : String;
  software      : String;
  level         : TNapUserLevel;
  ip            : Cardinal;
  dataport      : Word;
  total_up, total_down: Word;
  uploads, downloads, max_up, queue: SmallInt;
  speed         : TNapSpeed;
  shared        : Word;
  server        : TServer;
  state         : TUserState;
  last_seen     : time_t;
  rating        : Integer;
 end;
 POnlineUser = ^TOnlineUser;
 TOnlineUserList = class(TList)
  function Add(Value: TOnlineUser): POnlineUser;
  function Insert(index: Integer; Value: TOnlineUser): POnlineUser;
  procedure Clear; override;
  procedure Delete(Index: Integer); overload;
  procedure Delete(nick: String); overload;
  function  FindUser(nick: String): Integer;
  function  FindUserRec(nick: String): POnlineUser;
  constructor Create;
  destructor Destroy; override;
 end;
 TOnlineUserDataBase = class(TObject)
  list          : Array[0..MAX_INDEX] of TOnlineUserList;
  constructor Create;
  destructor Destroy; override;
  function FindUser(nick: String): POnlineUser;
  function Add(rec: TOnlineUser): POnlineUser;
  procedure Delete(nick: String);
  function CountClones(ip: Cardinal): Integer;
  function CountItems: Integer;
 end;

procedure ResetOnlineRec(var rec: TOnlineUser);

implementation

var
 list_users: TList;
 total_users: Integer;

procedure DeleteUser(user: POnlineUser);
begin
 user^.nick:='';
 user^.password:='';
 user^.software:='';
 user^.server:=nil;
 user^.state:=[];
 list_users.Add(user);
end;

function CreateUser: POnlineUser;
var
 data: POnlineUser;
begin
 if list_users.count>0 then
 begin
   Result:=list_users.Items[list_users.count-1];
   list_users.Delete(list_users.Count-1);
 end
 else
 begin
   data:=AllocMem(sizeof(TOnlineUser));
   with data^ do
   begin
    Pointer(nick):=nil;
    Pointer(password):=nil;
    Pointer(software):=nil;
   end;
   Result:=data;
 end;
end;

procedure FreeUser(user: POnlineUser);
begin
 if user=nil then exit;
 Finalize(user^);
 FreeMem(user,sizeof(TOnlineUser));
end;

procedure FreeUsers;
var
 i: Integer;
begin
 for i:=0 to list_users.count-1 do
  FreeUser(list_users.Items[i]);
 list_users.Clear; 
end;

procedure ResetOnlineRec(var rec: TOnlineUser);
begin
 with rec do
 begin
   nick:='';
   password:='';
   software:='';
   level:=napUserUser;
   ip:=0;
   dataport:=0;
   uploads:=0;
   downloads:=0;
   total_up:=0;
   total_down:=0;
   max_up:=-1;
   queue:=-1;
   speed:=napSpeedUnknown;
   shared:=0;
   server:=nil;
   state:=[];
   last_seen:=GetTickCountT;
 end;
end;

function TOnlineUserList.Add(Value: TOnlineUser): POnlineUser;
var
 data: POnlineUser;
begin
 data:=CreateUser;
 with data^ do
 begin
  nick:=Value.nick;
  password:=Value.password;
  software:=Value.software;
  level:=value.level;
  ip:=Value.ip;
  dataport:=Value.dataport;
  uploads:=Value.uploads;
  downloads:=Value.downloads;
  total_up:=Value.total_up;
  total_down:=Value.total_down;
  max_up:=Value.max_up;
  queue:=Value.queue;
  speed:=Value.speed;
  shared:=Value.shared;
  server:=Value.server;
  state:=Value.state;
  last_seen:=Value.last_seen;
 end;
 inherited Add(data);
 Result:=data;
end;

function TOnlineUserList.Insert(index: Integer; Value: TOnlineUser): POnlineUser;
var
 data: POnlineUser;
begin
 data:=CreateUser;
 with data^ do
 begin
  nick:=Value.nick;
  password:=Value.password;
  software:=Value.software;
  level:=value.level;
  ip:=Value.ip;
  dataport:=Value.dataport;
  uploads:=Value.uploads;
  downloads:=Value.downloads;
  total_up:=Value.total_up;
  total_down:=Value.total_down;
  max_up:=Value.max_up;
  queue:=Value.queue;
  speed:=Value.speed;
  shared:=Value.shared;
  server:=Value.server;
  state:=Value.state;
  last_seen:=Value.last_seen;
 end;
 inherited Insert(index,data);
 Result:=data;
end;

procedure TOnlineUserList.Clear;
begin
 while count>0 do
  Delete(count-1);
 inherited Clear;
end;

procedure TOnlineUserList.Delete(Index: Integer);
begin
 if (Index<0) or (Index>=Count) then exit;
 if Items[Index]<>nil then
  DeleteUser(Items[Index]);
 inherited Delete(index);
end;

procedure TOnlineUserList.Delete(nick: String);
begin
 Delete(FindUser(nick));
end;

function  TOnlineUserList.FindUser(nick: String): Integer;
var
 i: Integer;
begin
 Result:=-1;
 nick:=AnsiLowerCase(nick);
 for i:=0 to count-1 do
  if AnsiLowerCase(POnlineUser(Items[i])^.nick)=nick then
  begin
    Result:=i;
    exit;
  end;
end;

function  TOnlineUserList.FindUserRec(nick: String): POnlineUser;
var
 i: Integer;
begin
 Result:=nil;
 nick:=AnsiLowerCase(nick);
 for i:=0 to count-1 do
  if AnsiLowerCase(POnlineUser(Items[i])^.nick)=nick then
  begin
    Result:=Items[i];
    exit;
  end;
end;

constructor TOnlineUserList.Create;
begin
 inherited Create;
end;

destructor TOnlineUserList.Destroy;
begin
 Clear;
 inherited Destroy;
end;

constructor TOnlineUserDataBase.Create;
var
 i: Integer;
begin
 inherited Create;
 for i:=0 to MAX_INDEX do
  list[i]:=TOnlineUserList.Create;
end;

destructor TOnlineUserDataBase.Destroy;
var
 i: Integer;
begin
 for i:=0 to MAX_INDEX do
  list[i].Free;
 inherited Destroy; 
end;

function TOnlineUserDataBase.FindUser(nick: String): POnlineUser;
var
 i: Integer;
begin
 i:=GetCharIndex(nick);
 if i=-1 then Result:=nil
 else Result:=list[i].FindUserRec(nick);
end;

function TOnlineUserDataBase.Add(rec: TOnlineUser): POnlineUser;
var
 i: Integer;
begin
 i:=GetCharIndex(rec.nick);
 if i=-1 then Result:=nil
 else Result:=list[i].Add(rec);
end;

procedure TOnlineUserDataBase.Delete(nick: String);
var
 i: Integer;
begin
 i:=GetCharIndex(nick);
 if i<>-1 then list[i].Delete(nick);
end;

function TOnlineUserDataBase.CountClones(ip: Cardinal): Integer;
var
 i,j,k: Integer;
begin
 k:=0;
 for i:=0 to MAX_INDEX do
  if list[i].count>0 then
   for j:=0 to list[i].count-1 do
    if POnlineUser(list[i].Items[j])^.ip=ip then
     if POnlineUser(list[i].Items[j])^.level<napUserModerator then inc(k);
 Result:=k;
end;

function TOnlineUserDataBase.CountItems: Integer;
var
 i,j: Integer;
begin
 j:=0;
 for i:=0 to MAX_INDEX do
  inc(j,list[i].count);
 Result:=j;
end;

initialization
begin
 list_users:=TList.Create;
 total_users:=0;
end;

finalization
begin
 FreeUsers;
 list_users.Free;
 total_users:=0;
end;

end.

