{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: console

 Handler for console user

*********************************************************}
unit console;

interface

uses
 SysUtils, Classes, graphics, zlib, slavasplitter, slavapanel, winsock,
 windows, constants, stypes, lang, blcksock, synsock, users, registered,
 localusers, servers, comctrls, slavastrings, mmsystem, class_cmdlist;

procedure ConsoleListRegistered;
procedure ConsoleListUsers;
procedure ConsoleListServers;
procedure ConsoleListChannels;
procedure ConsoleListBans;
procedure ConsoleListHotlist;
procedure ConsoleRefreshLists(switch_page: Boolean);
procedure ConsoleListLists(switch_page: Boolean);
procedure ConsoleReply(id: Integer; str: String);
procedure ConsoleAddServer(str: String);
procedure ConsoleServerProps(str: String);
procedure ConsoleUpdateServerProps(str: String);
procedure SendPrivateMyMessage(cmd: String);
procedure ConsoleSetCompress(cmd: String);
procedure ConsoleSetStartup(cmd: String);
procedure ConsoleSaveShared;

implementation

uses
 vars, mainform, handler, napigator, dagsta, thread, channels, channelform, bans,
 serverattr, chatform, whoisform, invitationform, share;

var
 hlist: TStringList;
 cmd: TNapCmd;
 im_log_file: TFileStream;

function CheckParams(n: Integer): Boolean;
begin
  SplitString(cmd.cmd,hlist);
  Result:=hlist.count>=n;
end;

procedure PlayChat(new_window: Boolean);
var
 i: Integer;
begin
 if not SlavaNapWindow.cb_log_sound.Checked then exit;
 if new_window then i:=1
 else i:=2;
 PlaySound(PChar(ApplicationDir+'newmsg'+IntToStr(i)+'.wav'), 0, SND_FILENAME or SND_ASYNC);
end;


procedure ConsoleSaveShared; // for debug only
var
 i,j: Integer;
 user: TLocalUser;
 sh: PShare;
 f: TFileStream;
 str: String;
begin
 try
  f:=TFileStream.Create(ApplicationDir+'shared.dat',fmCreate);
  except
   exit;
 end;
 str:='# format: user "filename" "short"';
 for i:=db_local.count-1 downto 0 do
 try
   user:=db_local.Items[i];
   if user.logged then
    if user.shared<>nil then
     if user.shared.Count>0 then
      for j:=0 to user.shared.count-1 do
      begin
        sh:=user.shared.Items[j];
        str:=user.nick+' '+AddStr(user.shared.GetFileName(j))+' '+AddStr(sh^.short)+#10;
        f.Write(str[1],Length(str));
      end;
  except
 end; 
 f.Free;
end;

procedure ConsoleListServers;
var
 item: TListItem;
 srv: TServer;
 i: Integer;
 str: String;
begin
 if not running then exit;
 SlavaNapWindow.btn_servers_refresh.Enabled:=true;
 SlavaNapWindow.mnu_srv_refresh.Enabled:=true;
 with SlavaNapWindow.list_servers do
 begin
   Items.BeginUpdate;
   Items.Clear;
   if db_servers<>nil then
   for i:=0 to db_servers.Count-1 do
   begin
     srv:=db_servers.Items[i];
     item:=Items.Add;
     item.Caption:=srv.host;
     item.SubItems.Add(IntToStr(srv.port));
     str:='';
     if srv.connected=conNotConnected then str:=GetLangI(LNG_SRV_DISCONNECTED)
     else if srv.connected=conConnected then
     begin
       if srv.logged=false then str:=GetLangI(LNG_SRV_LOGGING)
       else if srv.hub=nil then str:=GetLangI(LNG_SRV_LOGGED)
       else str:=GetLangI(LNG_SRV_HUB,GetServerName(srv.hub));
     end else if srv.connected=conConnecting then str:=GetLangI(LNG_SRV_CONNECTING)
     else str:=GetLangI(LNG_SRV_DISCONNECTED);
     item.SubItems.Add(str);
     if (srv.connected=conConnected) and (srv.hub=nil) then item.SubItems.Add(GetLangI(LNG_SLIST_LAGSEC,srv.CountLag))
     else item.SubItems.Add('');
     if srv.logged then item.SubItems.Add(IntToStr(srv.num_users)+'/'+IntToStr(srv.max_users))
     else item.SubItems.Add(''); 
     if srv.authentication=authResolve then item.SubItems.Add(GetLangI(LNG_SRV_RESOLVE))
     else item.SubItems.Add(GetLangI(LNG_SRV_PASSWORD));
     if srv.relink=0 then item.SubItems.Add('')
     else item.SubItems.Add(GetLangI(LNG_SRV_RELINKTIME,srv.relink div 60000));
     item.SubItems.Add(srv.comments);
   end;
   AlphaSort;
   Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure ConsoleListChannels;
var
 item: TListItem;
 ch: TChannel;
 i,j: Integer;
 str: String;
begin
 if not running then exit;
 SlavaNapWindow.btn_ch_refresh.Enabled:=true;
 SlavaNapWindow.mnu_ch_refresh.Enabled:=true;
 with SlavaNapWindow.list_channels do
 begin
   Items.BeginUpdate;
   Items.Clear;
   if db_channels<>nil then
   for i:=0 to db_channels.count-1 do
   begin
     ch:=db_channels.Items[i];
     item:=Items.Add;
     item.Caption:=ch.channel;
     item.SubItems.Add(IntToStr(ch.users.count));
     item.SubItems.Add(IntToStr(ch.limit));
     item.SubItems.Add(Level2Str(ch.level));
     str:='';
     if chRegistered in ch.state then str:=GetLangI(LNG_CH_REGISTERED);
     if chModerated in ch.state then
     begin
       if str<>'' then str:=str+', ';
       str:=str+GetLangI(LNG_CH_MODERATED);
     end;
     if chPrivate in ch.state then
     begin
       if str<>'' then str:=str+', ';
       str:=str+GetLangI(LNG_CH_PRIVATE);
     end;
     if chTopic in ch.state then
     begin
       if str<>'' then str:=str+', ';
       str:=str+GetLangI(LNG_CH_TOPIC);
     end;
     item.SubItems.Add(str);
     item.SubItems.Add(ch.topic);
     item.SubItems.Add(JoinString(ch.bans));
     item.SubItems.Add(JoinString(ch.ops));
     item.SubItems.Add(JoinString(ch.voices));
   end;
   AlphaSort;
   Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure ConsoleListBans;
var
 item: TListItem;
 i: Integer;
 b: PBan;
 str: String;
begin
 if not running then exit;
 if db_bans=nil then exit;
 str:=GetLangI(LNG_BANS_NEVER_EXPIRE);
 with SlavaNapWindow.list_bans do
 begin
   Items.BeginUpdate;
   Items.Clear;
   for i:=0 to db_bans.Count-1 do
   begin
     b:=db_bans.Items[i];
     item:=Items.Add;
     item.Caption:=b^.user;
     item.SubItems.Add(b^.ip);
     item.SubItems.Add(b^.admin);
     item.SubItems.Add(UnixTimeToStr(b^.time));
     if b^.expires>0 then
      item.SubItems.Add(UnixTimeToStr(b^.expires))
     else
      item.SubItems.Add(str);
     item.SubItems.Add(b^.reason);
   end;
   AlphaSort;
   Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure ConsoleRefreshLists(switch_page: Boolean);
var
 i: Integer;
begin
 if not running then exit;
 StrHash_Clear(cons_blocks);
 if db_blocks<>nil then
  for i:=0 to db_blocks.Count-1 do
   StrHash_Add(cons_blocks,JoinString(PStringHash(db_blocks.Items[i])^));
 StrHash_Copy(cons.ignored,cons_ignored);
 StrHash_Copy(db_friends,cons_friends);
 ConsoleListLists(switch_page);
end;

procedure ConsoleListLists(switch_page: Boolean);
var
 item: TListItem;
 i: Integer;
 list: TStringHash;
 t: PStringHashItem;
begin
 if not running then exit;
 case cons_list of
   consFriends:  list:=cons_friends;
   consIgnored:  list:=cons_ignored;
   consBlocks:   list:=cons_blocks;
 end;
 if switch_page then SlavaNapWindow.pages.ActivePage:=SlavaNapWindow.sh_list;
 with SlavaNapWindow.list_lists do
 begin
   Items.BeginUpdate;
   Items.Clear;
   t:=list.first;
   while t<>nil do
   begin
     item:=Items.Add;
     item.Caption:=t^.data;
     t:=t^.next;
   end;
   AlphaSort;
   Items.EndUpdate;
 end;
 // change items
 with SlavaNapWindow do
 begin
   case cons_list of
     consFriends: begin
                    lbl_list.Caption:=GetLangI(LNG_LBL_FRIENDS);
                    btn_list_refresh.Caption:=GetLangI(LNG_FBTN_REFRESH);
                    btn_list_delete.Caption:=GetLangI(LNG_FBTN_REMOVE);
                    edit_list_item.Hint:=GetLangI(LNG_FEDIT_HINT);
                    btn_list_add.Caption:=GetLangI(LNG_FBTN_ADD);
                    list_lists.Columns.Items[0].Caption:=GetLangI(LNG_FLIST_USER);
                    list_lists.PopupMenu:=popup_friends;
                  end;
     consIgnored: begin
                    lbl_list.Caption:=GetLangI(LNG_LBL_IGNORED);
                    btn_list_refresh.Caption:=GetLangI(LNG_IBTN_REFRESH);
                    btn_list_delete.Caption:=GetLangI(LNG_IBTN_REMOVE);
                    edit_list_item.Hint:=GetLangI(LNG_IEDIT_HINT);
                    btn_list_add.Caption:=GetLangI(LNG_IBTN_ADD);
                    list_lists.Columns.Items[0].Caption:=GetLangI(LNG_ILIST_USER);
                    list_lists.PopupMenu:=popup_ignored;
                  end;
     consBlocks:  begin
                    if share_matchedfile_only then
                    begin
                      lbl_list.Caption:='͋LłL[[h̃XgłBes͋󔒂ŋ؂ꂽ1ȏ̃L[[h܂݂܂B啶͋ʂ܂B';
                      btn_list_refresh.Caption:=GetLangI(LNG_BLBTN_REFRESH);
                      btn_list_delete.Caption:=GetLangI(LNG_BLBTN_REMOVE);
                      edit_list_item.Hint:='LL[[h͂ĂB';
                      btn_list_add.Caption:=GetLangI(LNG_BLBTN_ADD);
                      list_lists.Columns.Items[0].Caption:='LłL[[h';
                      list_lists.PopupMenu:=popup_blocks;
                      mnu_win_blocked.Caption:='Lt@C';
                      btn_tb_blocks.Caption:='LL[';
                      btn_tb_blocks.Hint:='LłL[[h̃Xg';
                      mnu_bl_delete.Caption:='LȂ';
                    end
                    else
                    begin
                      lbl_list.Caption:=GetLangI(LNG_LBL_BLOCKS);
                      btn_list_refresh.Caption:=GetLangI(LNG_BLBTN_REFRESH);
                      btn_list_delete.Caption:=GetLangI(LNG_BLBTN_REMOVE);
                      edit_list_item.Hint:=GetLangI(LNG_BLEDIT_HINT);
                      btn_list_add.Caption:=GetLangI(LNG_BLBTN_ADD);
                      list_lists.Columns.Items[0].Caption:=GetLangI(LNG_BLLIST_ITEM);
                      list_lists.PopupMenu:=popup_blocks;
                      mnu_win_blocked.Caption:=GetLangI(LNG_MENU_BLOCK);
                      btn_tb_blocks.Caption:=GetLangI(LNG_TB_BTN_BLOCKS);
                      btn_tb_blocks.Hint:=GetLangI(LNG_TB_BTN_BLOCKS_HINT);
                      mnu_bl_delete.Caption:=GetLangI(LNG_BMNU_DELETE);
                    end;
                  end;
   end;
   i:=btn_list_refresh.Left;
   btn_list_refresh.Width:=Canvas.TextWidth(btn_list_refresh.Caption)+20;
   inc(i,btn_list_refresh.Width);
   btn_list_delete.Left:=i;
   btn_list_delete.Width:=Canvas.TextWidth(btn_list_delete.Caption)+20;
   inc(i,btn_list_delete.Width);
   edit_list_item.Left:=i;
   edit_list_item.Text:='';
   inc(i,edit_list_item.Width);
   btn_list_add.Left:=i;
   btn_list_add.Width:=Canvas.TextWidth(btn_list_add.Caption)+20;
   if cons_list=consFriends then
   begin
     cb_list_sound.visible:=true;
     inc(i,btn_list_add.Width+10);
     cb_list_sound.Left:=i;
     cb_list_sound.Caption:=GetLangI(LNG_LIST_CB_SOUND);
     cb_list_sound.Width:=Canvas.TextWidth(cb_list_sound.Caption)+25;
   end
   else
     cb_list_sound.visible:=false;
   toolbarResize(nil);
 end;
end;

procedure ConsoleListHotlist;
var
 item: TListItem;
 i: Integer;
 user: POnlineUser;
 t: PStringHashItem;
begin
 if not running then exit;
 with SlavaNapWindow.list_hotlist do
 begin
  Items.BeginUpdate;
  Items.Clear;
  t:=cons.hotlist.first;
  while t<>nil do
  begin
    item:=Items.Add;
    item.Caption:=t^.data;
    user:=db_online.FindUser(t^.data);
    if user=nil then
    begin
      item.SubItems.Add(' '+GetLangI(LNG_HLIST_OFFLINE));
      item.SubItems.Add('');
    end
    else
    begin
      item.SubItems.Add(GetServerName(user^.server));
      item.SubItems.Add(Speed2Str(user^.speed));
    end;
    t:=t^.next;
  end;
  AlphaSort;
  Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure ConsoleListUsers;
var
 i,j,k: Integer;
 user: POnlineUser;
 loc: TLocalUser;
 item: TListItem;
 str,f: String;
 b: Boolean;
 t: time_t;
begin
 if not running then exit;
 SlavaNapWindow.btn_users_refresh.Enabled:=true;
 SlavaNapWindow.mnu_users_refresh.Enabled:=true;
 if db_online=nil then exit;
 f:=AnsiLowerCase(SlavaNapWindow.edit_users_filter.Text);
 if f='' then f:='*';
 with SlavaNapWindow.list_users do
 begin
  Items.BeginUpdate;
  Items.Clear;
  t:=GetTickCountT;
  for i:=0 to MAX_INDEX do
  for j:=0 to db_online.list[i].count-1 do
  begin
    user:=db_online.list[i].Items[j];
    b:=true;
    if SlavaNapWindow.cb_users_muzzled.Checked and (not (userMuzzled in user^.state)) then b:=false;
    if user^.level=napUserLeech then if not SlavaNapWindow.cb_users_leeches.Checked then b:=false;
    if user^.level=napUserUser then if not SlavaNapWindow.cb_users_users.Checked then b:=false;
    if user^.level>napUserUser then if not SlavaNapWindow.cb_users_mods.Checked then b:=false;
    if user^.server=nil then if not SlavaNapWindow.cb_users_local.checked then b:=false;
    if user^.server<>nil then if not SlavaNapWindow.cb_users_remote.Checked then b:=false;
    if b then b:=MatchesMaskEx(AnsiLowerCase(user^.nick),f);
    if b then
    begin // if matches
      item:=Items.Add;
      item.Caption:=user^.nick;
      item.SubItems.Add(Level2Str(user^.level));
      item.SubItems.Add(IntToStr(user^.shared));
      if user^.server=nil then begin//local user
        for k:=0 to db_local.Count-1 do
          if AnsiLowerCase(TLocalUser(db_local.Items[k]).nick)=AnsiLowerCase(user^.nick) then
          begin
            loc:=db_local.Items[k];
            item.SubItems.Add(IntToStr(loc.shared_size div (1024*1024)));
            if user^.shared>0 then
              item.SubItems.Add(IntToStr(loc.shared_size div user^.shared div (1024*1024)))
            else
              item.SubItems.Add('0');
            break;
          end;
      end
      else//remote user
      begin
        item.SubItems.Add('remote');
        item.SubItems.Add('remote');
      end;
      item.SubItems.Add(user^.software);
      item.SubItems.Add(Speed2Str(user^.speed));
      item.SubItems.Add(decode_ip(user^.ip));
      item.SubItems.Add(IntToStr(user^.dataport));
      item.SubItems.Add(Time2Str(t-user^.last_seen));
      item.SubItems.Add(IntToStr(user^.uploads));
      item.SubItems.Add(IntToStr(user^.downloads));
      str:=IntToStr(user^.uploads);
      if user^.max_up<>-1 then
       str:=str+' ('+IntToStr(user^.max_up)+' max)';
      str:=str+' / '+IntToStr(user^.downloads);
      item.SubItems.Add(str);
      item.SubItems.Add(IntToStr(user^.total_up));
      item.SubItems.Add(IntToStr(user^.total_down));
      item.SubItems.Add(IntToStr(user^.total_up)+' / '+IntToStr(user^.total_down));
      item.SubItems.Add(GetServerName(user^.server));
      str:='';
      if userMuzzled in user^.state then str:=str+GetLangI(LNG_LIST_MUZZLED);
      if userCloaked in user^.state then
      begin
        if str<>'' then str:=str+', ';
        str:=str+GetLangI(LNG_LIST_CLOAKED);
      end;
      if userChatting in user^.state then
      begin
        if str<>'' then str:=str+', ';
        str:=str+GetLangI(LNG_LIST_CHATTING);
      end;
      if FindLocalUser(user)<>nil then
      begin
        tmp_pos:=1379;
        if TLocalUser(FindLocalUser(user)).softwareID=softWinMXHidden then
          if str<>'' then str:=str+', WinMX'
        else
        {if (TLocalUser(FindLocalUser(user)).softwareID<>softWinMXNormal) and (TLocalUser(FindLocalUser(user)).softwareID<>softWinMXJap) and (not (locPingable in TLocalUser(FindLocalUser(user)).localstate)) and ((current_time-20000)>TLocalUser(FindLocalUser(user)).last_seen) then
        begin
         if str<>'' then str:=str+', WinMX??';
        end;}
        if str<>'' then str:=str+', ';
        if locPingable in TLocalUser(FindLocalUser(user)).localstate then
        begin
          if loc326 in TLocalUser(FindLocalUser(user)).detector then str:=str+'2get'
          else if loc10300 in TLocalUser(FindLocalUser(user)).detector then str:=str+'XNap';
          //else if not (loc208 in TLocalUser(FindLocalUser(user)).detector) then str:=str+'XNap??';
        end
        else if loc326 in TLocalUser(FindLocalUser(user)).detector then str:=str+'MX2.x'
        else if loc110 in TLocalUser(FindLocalUser(user)).detector then str:=str+'Napchan'
        else if loc208 in TLocalUser(FindLocalUser(user)).detector then str:=str+'Utatane'
        else if locMD5Zeros in TLocalUser(FindLocalUser(user)).detector then str:=str+'Utatane'
        else if locMD5NonZero in TLocalUser(FindLocalUser(user)).detector then str:=str+'MX3.x'
        else str:=str+'MX3.x??';
      end;
      item.SubItems.Add(str);
    end;
  end;
  AlphaSort;
  Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure ConsoleListRegistered;
var
 i,j: Integer;
 item: TListItem;
 reg: PRegisteredUser;
 b: Boolean;
 f, str: String;
begin
 if not running then exit;
 SlavaNapWindow.btn_reg_refresh.Enabled:=true;
 SlavaNapWindow.mnu_reg_refresh.Enabled:=true;
 if db_registered=nil then exit;
 f:=AnsiLowerCase(SlavaNapWindow.edit_reg_filter.Text);
 if f='' then f:='*';
 with SlavaNapWindow.list_registered do
 begin
   Items.BeginUpdate;
   Items.Clear;
   for i:=0 to MAX_INDEX do
   for j:=0 to db_registered.list[i].Count-1 do
   begin
     reg:=db_registered.list[i].Items[j];
     if reg^.level=napUserLeech then b:=SlavaNapWindow.cb_reg_leeches.Checked
     else if reg^.level=napUserUser then b:=SlavaNapWindow.cb_reg_users.Checked
     else b:=SlavaNapWindow.cb_reg_mods.Checked;
     if SlavaNapWindow.cb_reg_muzzled.Checked then b:=userMuzzled in reg^.state;
     if b then b:=MatchesMaskEx(AnsiLowerCase(reg^.nick),f);
     if b then
     begin
       item:=Items.Add;
       item.Caption:=reg^.nick;
       item.SubItems.Add(Level2Str(reg^.level));
       item.SubItems.Add(GetLangI(LNG_REG_TRANSFERS,reg^.downloads,reg^.uploads));
       item.SubItems.Add(decode_ip(reg^.last_ip));
       item.SubItems.Add(UnixTimeToStr(reg^.last_seen));
       str:='';
       if userMuzzled in reg^.state then str:=str+GetLangI(LNG_REG_MUZZLED);
       if userCloaked in reg^.state then
       begin
         if str<>'' then str:=str+', ';
         str:=str+GetLangI(LNG_REG_CLOAKED);
       end;
       item.SubItems.Add(str);
       item.ImageIndex:=Ord(reg^.level);
     end;
   end;
   AlphaSort;
   Items.EndUpdate;
 end;
 SlavaNapWindow.toolbarResize(nil);
end;

procedure Handler_JoinChannel;
var
 form: TSlavaNapChannelWindow;
begin
 if cons_channels=nil then exit;
 if SlavaNapWindow.FindChannelWindow(cmd.cmd)<>nil then exit;
 form:=SlavaNapWindow.CreateChannelWindow(cmd.cmd);
 if form=nil then exit;
end;

procedure Handler_ChannelAddUser;
var
 form: TSlavaNapChannelWindow;
 i: Integer;
 item: TListItem;
 user: POnlineUser;
begin
 if not CheckParams(4) then exit;;
 form:=SlavaNapWindow.FindChannelWindow(hlist.Strings[0]);
 if form=nil then exit;
 item:=nil;
 for i:=0 to form.users.items.count-1 do
  if form.users.items.Item[i].SubItems[0]=hlist.Strings[1] then
   item:=form.users.items.Item[i];
 form.users.Items.Beginupdate;
 if item=nil then
 begin
   item:=form.users.items.Add;
   item.SubItems.Add('');
 end;
 item.Caption:=GetLangI(LNG_CH_USERLIST,hlist.Strings[1],Speed2Str(TNapSpeed(StrToIntDef(hlist.Strings[3],0))),hlist.Strings[2]);
 item.SubItems[0]:=hlist.Strings[1];
 form.users.Items.Endupdate;
 user:=db_online.FindUser(hlist.Strings[1]);
 if user=nil then exit;
 if cmd.id=MSG_SERVER_JOIN then
  form.AddMessage(slChannelJoin,GetLangI(LNG_CH_JOIN,hlist.Strings[1],Speed2Str(TNapSpeed(StrToIntDef(hlist.Strings[3],0))),hlist.Strings[2],decode_ip(user^.ip)));
end;

procedure Handler_ChannelRemoveUser;
var
 form: TSlavaNapChannelWindow;
 i: Integer;
begin
 if not CheckParams(2) then exit;
 form:=SlavaNapWindow.FindchannelWindow(hlist.Strings[0]);
 if form=nil then exit;
 for i:=form.users.Items.Count-1 downto 0 do
  if form.users.Items.Item[i].SubItems[0]=hlist.Strings[1] then
   form.users.Items.Delete(i);
 form.AddMessage(slChannelPart,GetLangI(LNG_CH_PART,hlist.Strings[1]));
end;

procedure Handler_ChannelTopic;
var
 form: TSlavaNapChannelWindow;
begin
 if not CheckParams(1) then exit;
 form:=SlavaNapWindow.findChannelWindow(hlist.Strings[0]);
 if form=nil then exit;
 form.topic:=NextParamEx(cmd.cmd);
 form.Caption:=form.channel+': '+form.topic;
 form.AddMessage(slTopic,GetLangI(LNG_CH_CHTOPIC,form.topic));
end;

procedure Handler_ChannelEmote;
var
 form: TSlavaNapChannelWindow;
 str,str1: String;
begin
 if not CheckParams(3) then exit;
 form:=SlavaNapWindow.findChannelWindow(hlist.Strings[0]);
 if form=nil then exit;
 str:=hlist.Strings[1];
 if hlist.count=3 then str1:=hlist.Strings[2]
 else str1:=NextParamEx(cmd.cmd,2);
 if Length(str1)>1 then
  if (str1[1]='"') and (str1[Length(str1)]='"') then
   str1:=Copy(str1,2,Length(str1)-2);
 if str=cons.nick then form.AddMessage(slChannelMyEmote,' '+str+' '+str1)
 else form.AddMessage(slChannelEmote,' '+str+' '+str1);
end;

procedure Handler_ChannelMessage;
var
 form: TSlavaNapChannelWindow;
 str: String;
begin
 if not CheckParams(3) then exit;
 form:=SlavaNapWindow.findChannelWindow(hlist.Strings[0]);
 if form=nil then exit;
 str:=hlist.Strings[1];
 if str=cons.nick then form.AddMessage(slChannelMyMessage,'<'+str+'> '+NextParamEx(cmd.cmd,2))
 else form.AddMessage(slChannelMessage,'<'+str+'> '+NextParamEx(cmd.cmd,2));
end;

procedure Handler_PartChannel;
var
 form: TSlavaNapChannelWindow;
begin
 form:=SlavaNapWindow.FindChannelWindow(cmd.cmd);
 if form=nil then exit;
 form.Close;
end;

procedure Handler_Wallop;
var
 form: TSlavaNapChatWindow;
begin
 if not CheckParams(1) then exit;
 if wallop_im then
 if (not SlavaNapWindow.cb_log_away.Checked) or (SlavaNapWindow.cb_log_awaypopup.Checked) then
 begin
   form:=SlavaNapWindow.FindChatWindow(hlist.Strings[0]);
   if form=nil then
   begin
     PlayChat(true);
     form:=SlavaNapWindow.CreateChatWindow(hlist.Strings[0]);
   end
   else
     PlayChat(false);
   form.AddMessage(slChatMessage,'<wallop/'+hlist.Strings[0]+'> '+NextParamEx(cmd.cmd));
   exit;
 end;
 SlavaNapWindow.LogConsole(slWallop,'<'+FirstParam(cmd.cmd)+'> '+NextParamEx(cmd.cmd));
end;

procedure Handler_PrivateMessage;
var
 form: TSlavaNapChatWindow;
 str: String;
begin
 if not CheckParams(1) then exit;
 if not FileExists(ApplicationDir+'im.log') then
   try
    im_log_file:=TFileStream.Create(ApplicationDir+'im.log',fmCreate);
    im_log_file.Free;
    except
     im_log_file:=nil;
     exit;
   end;
 im_log_file:=nil;
 try
  im_log_file:=TFileStream.Create(ApplicationDir+'im.log',fmOpenWrite or fmShareDenyWrite);
  im_log_file.Seek(0,soFromEnd);
  except
   im_log_file:=nil;
   exit;
 end;
 str:='['+DateTimeToStr(now)+'] <'+cons.nick+''+hlist.Strings[0]+'> '+NextParam(cmd.cmd)+#13#10;
 im_log_file.Write(str[1],Length(str));
 im_log_file.Free;
 if SlavaNapWindow.cb_log_away.Checked then
 begin
   if SlavaNapWindow.cb_log_awaypopup.Checked then
    form:=SlavaNapWindow.CreateChatWindow(hlist.Strings[0])
   else
    form:=SlavaNapWindow.FindChatWindow(hlist.Strings[0]);
   if form<>nil then form.AddMessage(slChatMessage,'<'+hlist.Strings[0]+'> '+NextParamEx(cmd.cmd))
   else SlavaNapWindow.LogConsole(slChatMessage,'<'+hlist.Strings[0]+'> '+NextParamEx(cmd.cmd));
   if last_away_user=hlist.Strings[0] then
    if (GetTickCount-last_away_time)<15000 then exit;
   last_away_user:=hlist.Strings[0];
   last_away_time:=GetTickCount;
   cmd_list.AddDoubleCmd(MSG_CLIENT_PRIVMSG,0,hlist.Strings[0]+' '+SlavaNapWindow.edit_log_away.Text,'');
   exit;
 end;
 form:=SlavaNapWindow.FindChatWindow(hlist.Strings[0]);
 if form=nil then
 begin
  PlayChat(true);
  form:=SlavaNapWindow.CreateChatWindow(hlist.Strings[0]);
 end
 else
  PlayChat(false);
 if form=nil then exit;
 form.AddMessage(slChatMessage,'<'+hlist.Strings[0]+'> '+NextParamEx(cmd.cmd));
end;

procedure Handler_PrivateMyMessage(user,text: String);
var
 form: TSlavaNapChatWindow;
 str: String;
begin
 if not CheckParams(1) then exit;;
 if not FileExists(ApplicationDir+'im.log') then
   try
    im_log_file:=TFileStream.Create(ApplicationDir+'im.log',fmCreate);
    im_log_file.Free;
    except
     im_log_file:=nil;
     exit;
   end;
 im_log_file:=nil;
 try
  im_log_file:=TFileStream.Create(ApplicationDir+'im.log',fmOpenWrite or fmShareDenyWrite);
  im_log_file.Seek(0,soFromEnd);
  except
   im_log_file:=nil;
   exit;
 end;
 str:='['+DateTimeToStr(now)+'] <'+cons.nick+''+user+'> '+text+#13#10;
 im_log_file.Write(str[1],Length(str));
 im_log_file.Free;

 if FirstParam(text)='[m]' then exit;

 if SlavaNapWindow.cb_log_away.Checked then
 if text=SlavaNapWindow.edit_log_away.Text then
 begin
   form:=SlavaNapWindow.FindChatWindow(hlist.Strings[0]);
   if form=nil then exit;
 end;
 form:=SlavaNapWindow.CreateChatWindow(user);
 if form=nil then exit;
 form.AddMessage(slChatMyMessage,'<'+cons.nick+'> '+text);
end;

procedure SendPrivateMyMessage(cmd: String);
var
 str,str1: String;
begin
 str:=FirstParam(cmd);
 if str='' then exit;
 str1:=NextParamEx(cmd);
 Handler_PrivateMyMessage(str,str1);
end;

procedure ConsoleAddServer(str: String);
var
 host,port: String;
 srv: TServer;
 i: Integer;
begin
 i:=pos(':',str);
 if i=0 then
 begin
   host:=str;
   port:='8888';
 end
 else
 begin
   host:=copy(str,1,i-1);
   port:=copy(str,i+1,5);
 end;
 host:=lowercase(host);
 srv:=FindServer(host);
 if srv<>nil then exit;
 srv:=TServer.Create;
 srv.host:=host;
 srv.port:=StrToIntDef(port,8888);
 db_servers.Add(srv);
 ConsoleListServers; 
end;

procedure ConsoleServerProps(str: String);
begin
 if not running then exit;
 SlavaNapServerAttr.ShowServer(str);
end;

procedure ConsoleUpdateServerProps(str: String);
var
 srv: TServer;
begin
 if not running then exit;
 if SlavaNapServerAttr.server<>str then exit;
 srv:=FindServer(str);
 if srv=nil then exit;
 if srv.connected=conNotConnected then
 begin
   str:=lowercase(SlavaNapServerAttr.edit_host.text);
   if str<>srv.host then
    if FindServer(str)=nil then
     srv.host:=str;
   srv.port:=SlavaNapServerAttr.edit_port.Value;
 end;
 srv.forced_ip:=trim(SlavaNapServerAttr.edit_ip.Text);
 if SlavaNapServerAttr.cb_auth_resolve.Checked then srv.authentication:=authResolve
 else srv.authentication:=authPassword;
 srv.mypassword:=SlavaNapServerAttr.edit_mypass.Text;
 srv.remotepassword:=SlavaNapServerAttr.edit_remotepass.Text;
 if SlavaNapServerAttr.cb_comp_0.Checked then srv.compress:=zcNone
 else if SlavaNapServerAttr.cb_comp_1.Checked then srv.compress:=zcFastest
 else if SlavaNapServerAttr.cb_comp_2.Checked then srv.compress:=zcDefault
 else srv.compress:=zcMax;
 if SlavaNapServerAttr.cb_relink.Checked then
  srv.relink:=SlavaNapServerAttr.edit_relink.Value * 60000
 else
  srv.relink:=0;
 srv.comments:=SlavaNapServerAttr.edit_comments.Text;
 ConsoleListServers; 
end;

procedure ConsoleHotListOnline(str: String);
begin
 //
 if SlavaNapWindow.cb_hotlist_sound.Checked then PlaySound(PChar(ApplicationDir+'hotlistlogin.wav'), 0, SND_FILENAME or SND_ASYNC);
 ConsoleListHotlist;
end;

procedure ConsoleSetCompress(cmd: String);
var
 srv: TServer;
 comp: TZCompressionLevel;
begin
 SplitString(cmd,hlist);
 if hlist.count<2 then exit;
 comp:=TZCompressionLevel(StrToIntDef(hlist.Strings[1],3));
 srv:=FindServer(hlist.Strings[0]);
 if srv<>nil then srv.compress:=comp;
end;

procedure ConsoleSetStartup(cmd: String);
var
 srv: TServer;
 t: Cardinal;
begin
 SplitString(cmd,hlist);
 if hlist.count<2 then exit;
 t:=StrToIntDef(hlist.Strings[1],0);
 srv:=FindServer(hlist.Strings[0]);
 if srv<>nil then srv.relink:=t;
end;

procedure Handler_Whois;
var
 form: TSlavaNapWhois;
 str,str1: String;
 i,j: Integer;
begin
 SplitString(cmd.cmd,hlist);
 if hlist.count<17 then exit;
 form:=SlavaNapWindow.CreateWhoisWindow(hlist.Strings[0]);
 form.Caption:=GetLangI(LNG_WHOIS_CAPTION,hlist.Strings[0]);
 form.mnu_close.Caption:=GetLangI(LNG_WMENU_CLOSE);
 form.mnu_hotlist.Caption:=GetLangI(LNG_WMENU_HOTLIST);
 form.mnu_friend.Caption:=GetLangI(LNG_WMENU_FRIEND);
 form.mnu_ignore.Caption:=GetLangI(LNG_WMENU_IGNORE);
 form.mnu_message.caption:=GetLangI(LNG_WMENU_MESSAGE);
 str:='';
 str:=GetLangI(LNG_WHOIS_USER,hlist.Strings[0]); // user
 str:=str+GetLangI(LNG_WHOIS_LEVEL,hlist.Strings[1]); // level
 i:=StrToIntDef(hlist.Strings[2],0);
 j:=i div 3600; // hours
 i:=i mod 3600;
 if j>0 then str1:=IntToStr(j)+':'
 else str1:='';
 j:=i div 60; // mins
 i:=i mod 60; // sec
 if (str1<>'') and (j<10) then str1:=str1+'0'+IntToStr(j)+':'
 else str1:=str1+IntToStr(j)+':';
 if i<10 then str1:=str1+'0'+IntToStr(i)
 else str1:=str1+IntToStr(i);
 str:=str+GetLangI(LNG_WHOIS_TIME,str1); // time
 str:=str+GetLangI(LNG_WHOIS_CHANNELS,hlist.Strings[3]); // channels
 str:=str+GetLangI(LNG_WHOIS_STATUS,hlist.Strings[4]); // status
 str:=str+GetLangI(LNG_WHOIS_SHARED,hlist.Strings[5]); // shared
 str:=str+GetLangI(LNG_WHOIS_TRANSFERS,hlist.Strings[6],hlist.Strings[7]); // down/up
 str:=str+GetLangI(LNG_WHOIS_TOTAL,hlist.Strings[10],hlist.Strings[11]); // total
 str:=str+GetLangI(LNG_WHOIS_SPEED,Speed2Str(TNapSpeed(StrToIntDef(hlist.Strings[8],0)))); // speed
 str:=str+GetLangI(LNG_WHOIS_SOFTWARE,hlist.Strings[9]); // software
 str:=str+GetLangI(LNG_WHOIS_IP,hlist.Strings[12]); // IP
 if hlist.Strings[13]<>'0' then
  str:=str+GetLangI(LNG_WHOIS_PORT,hlist.Strings[13]); // port
 str:=str+GetLangI(LNG_WHOIS_DATAPORT,hlist.Strings[14]); // dataport
 str:=str+GetLangI(LNG_WHOIS_SERVER,hlist.Strings[16]); // server 
 form.log.text:=str;
 try
  form.Show;
  except
 end;
end;

procedure Handler_Whowas;
var
 str: String;
begin
 SplitString(cmd.cmd,hlist);
 if hlist.count<3 then exit;
 str:=GetLangI(LNG_WHOIS_WHOWAS,hlist.Strings[1],hlist.Strings[0]);
 SlavaNapWindow.LogConsole(slWhowas,str);
end;

procedure Handler_Invite;
begin
 SplitString(cmd.cmd,hlist);
 if hlist.count<3 then exit;
 SlavaNapInvitation.user:=hlist.Strings[0];
 SlavaNapInvitation.channel:=hlist.Strings[1];
 SlavaNapInvitation.topic:=hlist.Strings[2];
 try
  SlavaNapInvitation.Show;
  SlavaNapInvitation.btn_accept.SetFocus;
  except
 end; 
end;

procedure ConsoleReply(id: Integer; str: String);
begin
 if not running then exit;
 cmd.cmd:=str;
 cmd.id:=id;
 try
   case id of
     MSG_SERVER_JOIN_ACK: Handler_JoinChannel;
     MSG_SERVER_JOIN, MSG_SERVER_CHANNEL_USER_LIST: Handler_ChannelAddUser;
     MSG_SERVER_TOPIC: Handler_ChannelTopic;
     MSG_SERVER_EMOTE: Handler_ChannelEmote;
     MSG_SERVER_PUBLIC: Handler_ChannelMessage;
     MSG_CLIENT_PART: Handler_PartChannel;
     MSG_SERVER_PART: Handler_ChannelRemoveUser;
     MSG_SERVER_ERROR, MSG_SERVER_NOSUCH: slavaNapWindow.LogConsole(slError,str);
     MSG_SERVER_WALLOP: Handler_Wallop;
     MSG_SERVER_ANNOUNCE: SlavaNapWindow.LogConsole(slAnnounce,'<'+FirstParam(str)+'> '+NextParamEx(str));
     MSG_SERVER_USER_SIGNON: ConsoleHotListOnline(str);
     MSG_SERVER_USER_SIGNOFF: ConsoleListHotlist;
     MSG_CLIENT_PRIVMSG: Handler_PrivateMessage;
     MSG_SERVER_WHOWAS: Handler_Whowas;
     MSG_SERVER_WHOIS_RESPONSE: Handler_Whois;
     MSG_CLIENT_PING: cmd_list.AddDoubleCmd(MSG_CLIENT_PONG,0,str,'');
     MSG_CLIENT_PONG: SlavaNapWindow.LogConsole(slPong,GetLangI(LNG_CONSOLEPONG,FirstParam(str)));
     MSG_CLIENT_CHANNEL_INVITE: Handler_Invite;
     MSG_SERVER_CHANNEL_USER_LIST_END,
     214,207,208,301,322,323: begin end;
     else SlavaNapWindow.LogConsole(clBlack,'Reply ['+IntToStr(id)+'] : '+str);
   end;
  except
 end;
end;

initialization
begin
 hlist:=TStringList.Create;
end;

finalization
begin
 hlist.Free;
 hlist:=nil;
end;
end.
