{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: thread

 Class for main thread

*********************************************************}
unit thread;

interface

{$I defines.pas}

uses
 SysUtils, Classes, graphics, zlib, slavasplitter, slavapanel, winsock,
 windows, constants, stypes, lang, blcksock, synsock, users, registered,
 localusers, servers, slavastrings, share, class_doublecmdlist;

type
 TMainThread = class(TThread)
  last_sync: Cardinal;
  last_stats: Cardinal;
  last_period: Cardinal;
  last_period30: Cardinal;
  last_period180: Cardinal;
  cycle_start, cycle_delay: Cardinal;
  cons_update: Cardinal;
  constructor Create;
  destructor Destroy; override;
  procedure Execute; override;
  procedure ShutDown;
  procedure SyncClose;
//  procedure DoSync(t: Integer);
{$IFNDEF DISABLE_CPU_THROTTLE}
  procedure CheckSync;
{$ENDIF}
  procedure SyncData;
  procedure Check60;
  procedure Check30;
  procedure Check180;
  procedure CheckMinShare;
  procedure CheckBots;
  procedure SyncLog;
  procedure CreateSockets;
  function  Listen(var socket: HSocket; port: Integer): Boolean;
  procedure Accept; overload;
  procedure Accept(server: HSocket); overload;
  procedure AcceptOldReport;
  procedure AcceptNewReport;
  procedure AcceptRedirect(i: Integer);
  procedure CheckTimeouts;
  procedure CheckServers;
  procedure ReceiveData; overload;
  procedure ReceiveData(user: TLocalUser; counter, recurse: Integer); overload;
  procedure LoadBlocks;
  procedure SaveBlocks;
  procedure ProcessCmd(dcmd: TNapDoubleCmd);
  procedure SendWebPage(user: TLocalUser);
  procedure ResetSearchControl;
  procedure ResetWantQueueControl;
  procedure ResetDLRequestControl;
 end;

var
 MainThread: TMainThread;

{$IFNDEF DISABLE_CPU_THROTTLE}
procedure CheckSync;
{$ENDIF}

implementation

uses
 vars, mainform, handler, napigator, dagsta, console, channels, chanattr,
 modeform, memory_manager;

constructor TMainThread.Create;
var
 logfilename: String;
begin
 LogStartup('thread::create: creating main thread');
 ShortDateFormat := 'yyyymmdd';
 logfilename:=ApplicationDir+'server-'+DateToStr(now)+'.log';
 ShortDateFormat := 'yyyy/mm/dd';
 if not FileExists(logfilename) then
   try
    log_file:=TFileStream.Create(logfilename,fmCreate);
    log_file.Free;
    except
   end;
 LogStartup('thread::create: resetting server.log');
 log_file:=nil;
 try
  if log_to_file then begin
   log_file:=TFileStream.Create(logfilename,fmOpenWrite or fmShareDenyWrite);
   log_file.Seek(0,soFromEnd);
  end;
  except
   log_file:=nil;
   LogStartup('thread::create: cannot open "'+logfilename+'" !!!');
   DebugLog('Error: cannot open file '+logfilename);
 end;
 LogStartup('thread::create: resetting debug.log');
 try
  debug_file:=TFileStream.Create(ApplicationDir+'debug.log',fmCreate);
  debug_file.Free;
  except
 end;
 debug_file:=nil;
 try
  if log_to_file then
   debug_file:=TFileStream.Create(ApplicationDir+'debug.log',fmOpenWrite or fmShareDenyWrite);
  except
   debug_file:=nil;
   DebugLog('Error: cannot open file "debug.log"');
   LogStartup('thread::create: cannot open "debug.log" !!!"');
 end;
 LogStartup('thread::create: opening "serverstats"');
 if clear_serverstats or (not FileExists(ApplicationDir+'serverstats')) then
 try
  DeleteFile(PChar(ApplicationDir+'serverstats'));
  except
 end;
 LogStartup('thread::create: loading blocked files');
 LoadBlocks;
 LogStartup('thread::create: inherited Create(false);');
 inherited Create(false);
end;

destructor TMainThread.Destroy;
begin
 inherited Destroy;
end;

procedure TMainThread.ShutDown;
var
 i: Integer;
 user: TLocalUser;
 srv: TServer;
 ch: TChannel;
begin
DebugLog('ShutDown - start debug',true);
 try
  DisconnectNapigator(0);
  DisconnectDagsta(0);
  except
 end;
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 DebugLog('ShutDown - 1',true);
 StrHash_SaveToFile(cons.hotlist,ApplicationDir+'hotlist');
 StrHash_SaveToFile(cons.ignored,ApplicationDir+'ignored');
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 DebugLog('ShutDown - 2',true);
 for i:=db_local.count-1 downto 0 do
 try
   user:=db_local.Items[i];
   if user.logged then DisconnectUser(user,'','','ShutDown',true);
   if (i mod 10)=0 then
    if not cpu_disable then CheckSync;
  except
 end;
DebugLog('ShutDown - 3',true);
 for i:=0 to db_local.count-1 do
 try
  user:=db_local.Items[i];
  user.Free;
{$IFNDEF DISABLE_CPU_THROTTLE}
   if (i mod 10)=0 then CheckSync;
{$ENDIF}
  except
 end;
DebugLog('ShutDown - 4',true);
 db_local.Free;
 db_local:=nil;
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 for i:=0 to MAX_LISTEN_SOCKET do
  if server_socket[i]<>INVALID_SOCKET then
   TCPSocket_Free(server_socket[i]);
 for i:=0 to MAX_LISTEN_TRAPSOCKET do
  if trap_socket[i]<>INVALID_SOCKET then
  begin
   synsock.shutdown(trap_socket[i],SD_BOTH);
   synsock.closesocket(trap_socket[i]);
   trap_socket[i]:=INVALID_SOCKET;
   dec(sockets_count);
  end;
 for i:=0 to MAX_LISTEN_REDIRECT do
  if redirect_socket[i]<>INVALID_SOCKET then
  begin
   synsock.shutdown(redirect_socket[i],SD_BOTH);
   synsock.closesocket(redirect_socket[i]);
   redirect_socket[i]:=INVALID_SOCKET;
   dec(sockets_count);
  end;
DebugLog('ShutDown - 5',true);
 if old_report_socket<>INVALID_SOCKET then
  TCPSocket_Free(old_report_socket);
 if new_report_socket<>INVALID_SOCKET then
  TCPSocket_Free(new_report_socket);
DebugLog('ShutDown - 6',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 if napigator_socket<>INVALID_SOCKET then
  TCPSocket_Free(napigator_socket);
 if dagsta_socket<>INVALID_SOCKET then
  TCPSocket_Free(dagsta_socket);
 try
  SaveServers;
  except
 end;
DebugLog('ShutDown - 7',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 for i:=0 to db_servers.Count-1 do
 try
  srv:=db_servers.Items[i];
  srv.Free;
  except
 end;
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 try
  SaveChannels(ApplicationDir+'channels');
  except
 end;
DebugLog('ShutDown - 8',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 for i:=0 to db_channels.Count-1 do
 try
  ch:=db_channels.Items[i];
  ch.Free;
  except
 end;
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 try
  db_registered.SaveToFile(ApplicationDir+'users');
  except
 end;
DebugLog('ShutDown - 9',true);
 try
  db_bans.SaveToFile(ApplicationDir+'bans');
  except
 end;
 StrHash_SaveToFile(db_motd,ApplicationDir+'motd');
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 StrHash_SaveToFile(db_dengon,ApplicationDir+'dengon');
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 SaveWordSet;//`lbZ[Wϊf[^x[X̕ۑ
 DebugLog('ShutDown - 10',true);
 StrHash_SaveToFileSorted(db_friends,ApplicationDir+'friends');
 try
  SaveBlocks;
  except
 end;
 try
  db_software.Sort;
  db_software.SaveToFile(ApplicationDir+'clientstats');
  except
 end;
DebugLog('ShutDown - 11',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 db_channels.Free;
 db_channels:=nil;
 db_servers.Free;
 db_servers:=nil;
 db_online.Free;
 db_online:=nil;
 db_registered.Free;
 db_registered:=nil;
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 DebugLog('ShutDown - 12',true);
 db_bans.Free;
 db_bans:=nil;
 StrHash_Clear(db_motd);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 StrHash_Clear(db_dengon);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 StrHash_Clear(db_friends);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 StrHash_Clear(db_wordset_users);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 for i:=0 to db_wordset_styles.count-1 do
 begin
   StrHash_Clear(db_wordset_keys[i]);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 end;
 StrHash_Clear(db_wordset_styles);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 sync_reply_list.Free;
 sync_reply_list:=nil;
DebugLog('ShutDown - 13',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 StrHash_Clear(ext_mp3_list);
 StrHash_Clear(ext_audio_list);
 StrHash_Clear(ext_video_list);
 StrHash_Clear(ext_text_list);
 StrHash_Clear(ext_image_list);
 StrHash_Clear(ext_app_list);
 StrHash_Clear(ext_cd_list);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 for i:=0 to db_blocks.Count-1 do
  StrHash_Free(PStringHash(db_blocks.Items[i]));
DebugLog('ShutDown - 14',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 db_blocks.Free;
 db_blocks:=nil;
 db_software.Free;
 db_software:=nil;
 db_invitations.Free;
 db_invitations:=nil;
 db_whowas.Free;
 db_whowas:=nil;
 db_reconnect.Free;
 db_reconnect:=nil;
DebugLog('ShutDown - 15',true);
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 cmd_list.Free;
 cmd_list:=nil;
DebugLog('ShutDown - ok',true);
 if log_file<>nil then
 try
  log_file.Free;
  log_file:=nil;
  except
 end;
 if debug_file<>nil then
 try
  debug_file.Free;
  debug_file:=nil;
  except
 end;
end;

procedure TMainThread.Execute;
begin
  LogStartup('thread::execute: starting main thread');
  FreeOnTerminate:=true;
  Priority:=tpHigher;
  last_sync:=GetTickCount;
//  last_sync_check:=last_sync;
  last_stats:=last_sync;
  cycle_start:=last_sync;
  last_period:=last_sync;
  last_period30:=last_sync;
  last_period180:=last_sync;
  last_announcement:=last_sync;
  cons_update:=last_sync;
  bandwidth_lastcheck:=last_sync;
  bandwidth_up:=0;
  bandwidth_down:=0;
  LogStartup('thread::execute: first Synchronize(SyncLog);');
  Synchronize(SyncLog);
  LogStartup('thread::execute: creating sockets');
  CreateSockets;
{$IFNDEF DISABLE_CPU_THROTTLE}
  LogStartup('thread::execute: first CheckSync');
  CheckSync;
{$ENDIF}
  LogStartup('thread::execute: InitNapigator');
  InitNapigator;
  LogStartup('thread::execute: InitDagsta');
  InitDagsta;
  LogStartup('thread::execute: SyncLog');
  Synchronize(SyncLog);
  LogStartup('thread::execute: CountStats');
  CountStats;
  LogStartup('thread::execute: CheckBandwidthTime');
  CheckBandwidthTime;
  linking:=false;
  LogStartup('thread::execute: starting loop');
  while not Terminated do
  try
    if (GetTickCount-bandwidth_lastcheck)>BANDWIDTH_TIMEOUT then CheckBandwidthTime;
    sleep(5);
    if running then Synchronize(SyncData);
    if running then Accept;
    if running then CheckServers;
    if running then ReceiveData;
    sleep(10);
    if running then Accept;
    if running then Check30;
    if running then CheckServers;
    if running then Accept;
    if running then Synchronize(SyncData);
    if running then CheckNapigator;
    if running then CheckDagsta;
    if running then CheckTimeouts;
    sleep(5);
    if running then CheckBots;
    if running then CheckServers;
    if running then Check60;
    if not running then Terminate;
   except
  end;
  WriteAllServers(MSG_SRV_SHUTDOWN,'',restart_user);
  if num_servers>0 then CheckServers;
  LogStartup('thread::execute: ShutDown');
  ShutDown;
  LogStartup('thread::execute: SyncClose');
  Synchronize(SyncClose);
  LogStartup('thread::execute: end;');
end;

procedure TMainThread.SyncClose;
begin
 try
  SlavaNapWindow.Close;
  except
 end;
end;

{procedure TMainThread.DoSync(t: Integer);
begin
// if running then Synchronize(Sync);
 sleep(t);
 last_sync_check:=GetTickCount;
end;}

{$IFNDEF DISABLE_CPU_THROTTLE}
procedure CheckSync;
begin
 if (mainthread<>nil) then
  MainThread.CheckSync;
end;

procedure TMainThread.CheckSync;
var
 t: Cardinal;
begin
 if cpu_disable then exit;
// t:=GetTickCount-last_sync_check;
 t:=(GetTickCount xor 50) mod cpu_usage;
 if t>150 then exit;
 if t<10 then sleep(25)
 else if t<40 then sleep(10)
 else if t<80 then sleep(3)
 else sleep(0);
// last_sync_check:=GetTickCount;
end;

{procedure TMainThread.CheckSync;
var
 t: Cardinal;
begin
 thread.CheckSync;
 t:=GetTickCount-last_sync_check;
 if t>(cpu_usage*10) then DoSync(20)
 else if t>(cpu_usage*3) then DoSync(5)
 else if t>cpu_usage then DoSync(1)
 else sleep(0);
end;}

{$ENDIF}


procedure TMainThread.SyncLog;
var
 dcmd: TNapDoubleCmd;
begin
 if not running then exit;
 try
   while sync_reply_list.Count>0 do
   begin
     dcmd:=sync_reply_list.Cmd(0);
     sync_reply_list.Delete(0);
     case dcmd.id1 of
       MSG_SR_LOG:             SlavaNapWindow.LogMain(dcmd.id2,dcmd.cmd2,false);
       MSG_SR_CONSOLELOG:      SlavaNapWindow.LogConsole(dcmd.id2,dcmd.cmd2,false);
       MSG_SR_RESTART:         SlavaNapWindow.mnu_tray_restartClick(nil);
       MSG_SR_CONSOLEREPLY:    ConsoleReply(dcmd.id2,dcmd.cmd1);
     end;
   end;
  except
   try
    SlavaNapWindow.LogMain(slDebugData,'Exception in SyncLog');
    except
   end;
 end;
end;

procedure TMainThread.SyncData;
var
 dcmd: TNapDoubleCmd;
begin
 if not running then exit;
 try
   if not SlavaNapWindow.Timer1.enabled then
    if (GetTickCount-cons_update)>200 then
    begin
     SlavaNapWindow.Timer1Timer(nil);
     cons_update:=GetTickCount;
    end;
   SyncLog;
   while cmd_list.Count>0 do
   begin
     dcmd:=cmd_list.Cmd(0);
     cmd_list.Delete(0);
     try
      ProcessCmd(dcmd);
      except
       on E:Exception do
        DebugLog('Exception in SyncData (id1='+IntToStr(dcmd.id1)+') : '+E.Message);
     end;
   end;
  except
   try
    SlavaNapWindow.LogMain(slDebugData,'Exception in SyncData');
    except
   end;
 end;
end;

procedure TMainThread.ProcessCmd(dcmd: TNapDoubleCmd);
var
 ch: TChannel;
 logfilename: String;
begin
 case dcmd.id1 of
   MSG_CMD_SAVEDATA: begin
                       if not running then exit;
                       SlavaNapWindow.mnu_save.Enabled:=true;
                       Log(slDebugData,GetLangI(LNG_SAVINGDATA));
                       Synchronize(SyncLog);
                       db_registered.SaveToFile(ApplicationDir+'users');
                       db_bans.SaveToFile(ApplicationDir+'bans');
                       db_software.SaveToFile(ApplicationDir+'clientstats');
                       StrHash_SaveToFileSorted(db_friends,ApplicationDir+'friends');
                       SaveChannels(ApplicationDir+'channels');
                       StrHash_SaveToFile(db_motd,ApplicationDir+'motd');
                       StrHash_SaveToFile(db_dengon,ApplicationDir+'dengon');
                       StrHash_SaveToFile(cons.hotlist,ApplicationDir+'hotlist');
                       StrHash_SaveToFile(cons.ignored,ApplicationDir+'ignored');
                       SaveWordSet;//`lbZ[Wϊf[^x[X̕ۑ
                       SaveBlocks;
                       SaveServers;
                     end;
   MSG_CMD_RESETLOG: begin
                       ShortDateFormat := 'yyyymmdd';
                       logfilename:=ApplicationDir+'server-'+DateToStr(now)+'.log';
                       ShortDateFormat := 'yyyy/mm/dd';
                       try
                         if log_file<>nil then
                          log_file.Free;
                         log_file:=nil;
                        except
                       end;
                       try
                        log_file:=TFileStream.Create(logfilename,fmCreate);
                        log_file.Free;
                        except
                       end;
                       log_file:=nil;
                       try
                        if log_to_file then
                         log_file:=TFileStream.Create(logfilename,fmOpenWrite or fmShareDenyWrite);
                        except
                         log_file:=nil;
                         DebugLog('Error: cannot reset file '+logfilename);
                       end;
                       // resetting debug file
                       try
                         if debug_file<>nil then
                          debug_file.Free;
                         debug_file:=nil;
                        except
                       end;
                       try
                        debug_file:=TFileStream.Create(ApplicationDir+'debug.log',fmCreate);
                        debug_file.Free;
                        except
                       end;
                       debug_file:=nil;
                       try
                        if log_to_file then
                         debug_file:=TFileStream.Create(ApplicationDir+'debug.log',fmOpenWrite or fmShareDenyWrite);
                        except
                         debug_file:=nil;
                         DebugLog('Error: cannot reset file "debug.log"');
                       end;
                     end;
   MSG_CMD_RELOADCHMOTD: begin
                       ch:=FindChannel(dcmd.cmd1);
                       if ch<>nil then
                       begin
                        if not StrHash_LoadFromFile(ch.motd,ApplicationDir+'chmotd.'+ch.channel) then
                         ch.DefaultMotd;                        
                       end;
                     end;
   MSG_CMD_REFRESHTYPES: begin
                       SplitString(lowercase(ext_mp3),ext_mp3_list);
                       SplitString(lowercase(ext_audio),ext_audio_list);
                       SplitString(lowercase(ext_video),ext_video_list);
                       SplitString(lowercase(ext_text),ext_text_list);
                       SplitString(lowercase(ext_image),ext_image_list);
                       SplitString(lowercase(ext_app),ext_app_list);
                       SplitString(lowercase(ext_cd),ext_cd_list);
                     end;
   MSG_CMD_GETMODE:  if running then
                     begin
                       SlavaNapWindow.btn_log_mode.enabled:=true;
                       SlavaNapMode.ShowForm;
                     end;
   MSG_CMD_MOTDCHANGE: StrHash_LoadFromFile(db_motd,ApplicationDir+'motd');
   MSG_CMD_LISTREGISTERED:  ConsoleListRegistered;
   MSG_CMD_LISTUSERS: ConsoleListUsers;
   MSG_CMD_LISTSERVERS: ConsoleListServers;
   MSG_CMD_LISTCHANNELS: ConsoleListChannels;
   MSG_CMD_LISTBANS: ConsoleListBans;
   MSG_CMD_LISTHOTLIST: ConsoleListHotlist;
   MSG_CMD_REFRESHLISTS: ConsoleRefreshLists(dcmd.cmd1='');
   MSG_CMD_SETNAPIGATORPASS: napigator_password:=dcmd.cmd1;
   MSG_CMD_SETDAGSTAPASS: dagsta_password:=dcmd.cmd1;
   MSG_CMD_CHANNELPROPS: SlavaNapChannelAttr.ShowChannel(dcmd.cmd1);
   MSG_CMD_WALLOP: Wallop(MSG_SERVER_NOSUCH,wallopServer,dcmd.cmd1,true);
   MSG_CMD_ADDSERVER: ConsoleAddServer(dcmd.cmd1);
   MSG_CMD_SERVERPROPS: ConsoleServerProps(dcmd.cmd1);
   MSG_CMD_UPDATESERVERPROPS: ConsoleUpdateServerProps(dcmd.cmd1);
   MSG_CLIENT_PRIVMSG: begin
                         gcmd.id:=dcmd.id1;
                         gcmd.cmd:=dcmd.cmd1;
                         ProcessCommand(cons,queryNormal);
                         SendPrivateMyMessage(dcmd.cmd1);
                       end;
   MSG_CMD_SETCOMPRESS: ConsoleSetCompress(dcmd.cmd1);
   MSG_CMD_SETSTARTUP: ConsoleSetStartup(dcmd.cmd1);
   MSG_CMD_SAVESHARED: ConsoleSaveShared;
   MSG_CMD_SAVEWORDSET: SaveWordSet;//`lbZ[Wϊf[^x[X̕ۑ
   else  gcmd.id:=dcmd.id1;
         gcmd.cmd:=dcmd.cmd1;
         ProcessCommand(cons,queryNormal);
 end;
end;

procedure TMainThread.CreateSockets;
var
 i: Integer;
begin
 for i:=0 to MAX_LISTEN_SOCKET do
  if server_port[i]<>0 then
  try
    server_socket[i]:=TCPSocket_Create;
    if not Listen(server_socket[i],server_port[i]) then
     TCPSocket_Free(server_socket[i]);
    Synchronize(SyncLog);
   except
   on E:Exception do
    DebugLog('Exception in TMainThread::CreateSockets : '+E.Message);
  end;
  tmp_pos:=12262;
  if enable_trapport then
  for i:=0 to MAX_LISTEN_TRAPSOCKET do
  if trap_port[i]<>0 then
  try
    trap_socket[i]:=synsock.socket(PF_INET,integer(SOCK_STREAM),IPPROTO_TCP);
    inc(sockets_count);
    if not Listen(trap_socket[i],trap_port[i]) then
      if trap_socket[i]<>INVALID_SOCKET then
      begin
        synsock.shutdown(trap_socket[i],SD_BOTH);
        synsock.closesocket(trap_socket[i]);
        trap_socket[i]:=INVALID_SOCKET;
        dec(sockets_count);
      end;
    Synchronize(SyncLog);
  except
  on E:Exception do
    DebugLog('Exception in TMainThread::CreateSockets (pos='+IntToStr(tmp_pos)+') : '+E.Message);
  end;
  tmp_pos:=12263;
  if enable_redirect then
  for i:=0 to MAX_LISTEN_REDIRECT do
  if redirect_port[i]<>0 then
  try
    redirect_socket[i]:=synsock.socket(PF_INET,integer(SOCK_STREAM),IPPROTO_TCP);
    inc(sockets_count);
    if not Listen(redirect_socket[i],redirect_port[i]) then
     if redirect_socket[i]<>INVALID_SOCKET then
     begin
      synsock.Shutdown(redirect_socket[i],SD_BOTH);
      synsock.CloseSocket(redirect_socket[i]);
      redirect_socket[i]:=INVALID_SOCKET;
      dec(sockets_count);
     end;
    Synchronize(SyncLog);
  except
  on E:Exception do
    DebugLog('Exception in TMainThread::CreateSockets (pos='+IntToStr(tmp_pos)+') : '+E.Message);
  end;
  if old_report_enabled then
  try
   old_report_socket:=TCPSocket_Create;
   if not Listen(old_report_socket,old_report_port) then
    TCPSocket_Free(old_report_socket);
   except
   on E:Exception do
    DebugLog('Exception in TMainThread::CreateSockets (2) : '+E.Message);
  end;
  if new_report_enabled then
  try
   new_report_socket:=TCPSocket_Create;
   if not Listen(new_report_socket,new_report_port) then
    TCPSocket_Free(new_report_socket);
   except
   on E:Exception do
    DebugLog('Exception in TMainThread::CreateSockets (3) : '+E.Message);
  end;
  Synchronize(SyncLog);
end;

function TMainThread.Listen(var socket: HSocket; port: Integer): Boolean;
var
 last_error: Integer;
begin
 if socket=INVALID_SOCKET then
  socket:=TCPSocket_Create;
// TCPSocket_SetLinger(socket,true,0);
 TCPSocket_Bind(socket,listen_interface,IntToStr(port));
 last_error:=TCPSocket_SockCheck(TCPSocket_Listen(socket));
 if last_error=0 then
 begin
  if socket=stats_socket then
   log(slText,GetLangT(LNG_SERVER_LISTENSTATS,port))
  else
   log(slText,GetLangT(LNG_SERVER_LISTEN,port));
  TCPSocket_Block(socket,false);
  Result:=true;
 end
 else
 begin
  log(slError,GetLangT(LNG_SERVER_LISTENERR,port));
  Result:=false;
 end;
end;

procedure TMainThread.Accept;
var
 i,j,last_error: Integer;
begin
 try
  if enable_redirect then
  for i:=0 to MAX_LISTEN_REDIRECT do
   if redirect_socket[i]<>INVALID_SOCKET then
     while TCPSocket_CanRead(redirect_socket[i],0,last_error) do
      AcceptRedirect(i);
  if old_report_socket<>INVALID_SOCKET then
   while TCPSocket_CanRead(old_report_socket,0,last_error) do
    AcceptOldReport;
  if new_report_socket<>INVALID_SOCKET then
   while TCPSocket_CanRead(new_report_socket,0,last_error) do
    AcceptNewReport;
  j:=0;
{$IFNDEF DISABLE_CPU_THROTTLE}
  CheckSync;
{$ENDIF}
  for i:=0 to MAX_LISTEN_SOCKET do
   if server_socket[i]<>INVALID_SOCKET then
     while TCPSocket_CanRead(server_socket[i],0,last_error) do
     begin
       Accept(server_socket[i]);
{$IFNDEF DISABLE_CPU_THROTTLE}
       CheckSync;
{$ENDIF}
       inc(j);
       if max_accept>0 then
        if j>=max_accept then exit;
     end;
  if enable_trapport then
  for i:=0 to MAX_LISTEN_TRAPSOCKET do
   if trap_socket[i]<>INVALID_SOCKET then
     while TCPSocket_CanRead(trap_socket[i],0,last_error) do
     begin
      Accept(trap_socket[i]);
{$IFNDEF DISABLE_CPU_THROTTLE}
      CheckSync;
{$ENDIF}
     end;
   except
   DebugLog('Exception in Accept 1');
 end;
end;

procedure TMainThread.Accept(server: HSocket);
var
 user: TLocalUser;
 h: HSocket;
 i: Integer;
 local_ip: Cardinal;
 sin: TSockAddrIn;
begin
 try
   i:=0;
   h:=TCPSocket_Accept(server);
   i:=1;
   if h=SOCKET_ERROR then exit;
   if h=INVALID_SOCKET then exit;
   i:=2;
//   sin:=TCPSocket_GetRemoteSin(h);
//   remote_ip:=decode_ip(sin.sin_addr.S_addr);
   sin:=TCPSocket_GetLocalSin(h);
   local_ip:=sin.sin_addr.S_addr;
   i:=3;
   user:=CreateLocalUser;
   user.socket:=h;
   if not sockets_users_default then
   begin
     TCPSocket_SetSizeRecvBuffer(h,sockets_users_recv);
     TCPSocket_SetSizeSendBuffer(h,sockets_users_send);
   end;
   i:=4;
   TCPSocket_Block(h,false);
   TCPSocket_KeepAlive(h,true);
   i:=6;
   if cons.data^.ip=0 then
   begin
    i:=8;
    cons.data^.ip:=local_ip;
    i:=9;
   end;
   i:=10;
   db_local.Add(user);
   i:=11;
{$IFNDEF DISABLE_CPU_THROTTLE}
   CheckSync;
{$ENDIF}
  except
   DebugLog('Exception in Accept 2.  i='+IntToStr(i));
 end;
end;

procedure TMainThread.AcceptRedirect(i: Integer);
var
 user: TLocalUser;
 h: TSocket;
 j,k: Integer;
 user_percentage: Integer;
 str: String;
 srv: TServer;
 sin: TSockAddrIn;
begin
 try
  j:=0;
  h:=TCPSocket_Accept(redirect_socket[i]);
  j:=1;
  if h=SOCKET_ERROR then exit;
  j:=2;
  if h=INVALID_SOCKET then exit;
  j:=3;
  user:=CreateLocalUser;
  j:=4;
  user.socket:=h;
  j:=5;
  TCPSocket_Block(h,false);
  j:=6;
  sin:=TCPSocket_GetLocalSin(h);
  j:=7;
  user_percentage:=0;
  for k:=0 to db_servers.Count-1 do
  begin
    srv:=db_servers.Items[k];
    if (srv.max_users>9) or (not new_report_hide_hub) then
    if srv.logged then
      if (srv.max_users div srv.num_users)>user_percentage then
        str:=srv.host+':'+IntToStr(srv.port)+#13;
  end;
  if (total_users_limit div total_users)>user_percentage then
    str:=servername_t+':'+IntToStr(server_port[0])+#13;
  j:=8;
  synsock.Send(h,str[1],Length(str),0);
  j:=9;
  synsock.shutdown(h,SD_BOTH);
  j:=10;
  synsock.closesocket(h);
  j:=11;
  dec(sockets_count);
 except
  DebugLog('Exception in AcceptRedirect.  j='+IntToStr(j));
 end;
end;

procedure TMainThread.AcceptOldReport;
var
 user: TLocalUser;
 h: TSocket;
 i: Integer;
 str: String;
 sin: TSockAddrIn;
begin
 try
   i:=0;
   h:=TCPSocket_Accept(old_report_socket);
   i:=1;
   if h=SOCKET_ERROR then exit;
   if h=INVALID_SOCKET then exit;
   i:=2;
   user:=CreateLocalUser;
   i:=3;
   user.socket:=h;
   i:=5;
   TCPSocket_Block(h,false);
   i:=6;
   sin:=TCPSocket_GetLocalSin(h);
   i:=7;
{   if cons.data^.ip=0 then
   begin
    i:=8;
    cons.data^.ip:=sin.sin_addr.S_addr;
    i:=9;
   end;}
   i:=10;
   db_local.Add(user);
   i:=11;
   user.localstate:=user.localstate+[locWriteOnly];
   i:=12;
   str:=IntToStr(total_users)+' '+IntToStr(total_files)+' 0.00 '+IntToStr(total_bytes)+' 0';
   i:=13;
   user.WriteData(str);  
  except
   DebugLog('Exception in AcceptOldReport.  i='+IntToStr(i));
 end;
end;

procedure TMainThread.AcceptNewReport;
var
 user: TLocalUser;
 h: TSocket;
 i,j: Integer;
 str: String;
 srv: TServer;
 list: TStringList;
 sin: TSockAddrIn;
begin
 try
   i:=0;
   h:=TCPSocket_Accept(new_report_socket);
   i:=1;
   if h=SOCKET_ERROR then exit;
   if h=INVALID_SOCKET then exit;
   i:=2;
   user:=CreateLocalUser;
   i:=4;
   user.socket:=h;
   i:=5;
   TCPSocket_Block(h,false);
   i:=6;
   sin:=TCPSocket_GetLocalSin(h);
   i:=7;
{   if cons.data^.ip=0 then
   begin
    i:=8;
    cons.data^.ip:=sin.sin_addr.S_addr;
    i:=9;
   end;}
   i:=10;
   db_local.Add(user);
   i:=11;
   user.localstate:=user.localstate+[locWriteOnly];
   i:=12;
   list:=CreateStringList;
   if (max_users>9) or (not new_report_hide_hub) then
   begin
    str:=servername_t+' '+IntToStr(napigator_myport)+' '+IntToStr(local_users)+' '+IntToStr(max_users)+' '+IntToStr(local_files)+' '+IntToStr(local_bytes div GigaByte)+' '+cons.nick;
    list.Add(str);
   end;
   for j:=0 to db_servers.Count-1 do
   begin
     srv:=db_servers.Items[j];
     if srv.logged then
     if (srv.max_users>9) or (not new_report_hide_hub) then
     begin
       str:=srv.host+' '+IntToStr(srv.port)+' '+IntToStr(srv.num_users)+' '+IntToStr(srv.max_users)+' '+IntToStr(srv.num_files)+' '+IntToStr(srv.num_bytes div GigaByte)+' '+srv.console;
       list.Add(str);
     end;
   end;
   list.Sort;
   str:=IntToStr(list.count)+' '+IntToStr(total_users)+' '+IntToStr(total_users_limit)+' '+IntToStr(total_files)+' '+IntToStr(total_bytes div GigaByte);
   list.Insert(0,str);
   i:=13;
   user.WriteData(list.Text);
   i:=14;
   FreeStringList(list);
  except
   DebugLog('Exception in AcceptNewReport.  i='+IntToStr(i));
 end;
end;

procedure TMainThread.SendWebPage(user: TLocalUser);
begin
 user.localstate:=user.localstate+[locWriteOnly];
 if redirect_url='' then
 begin
   user.WriteData('HTTP/1.0 200 OK'#13#10'Server: Apache/1.3.22'#13#10'Connection: close'#13#10);
   user.WriteData('Content-Type: text/html'#13#10#13#10);
   user.WriteData('<HTML><HEAD>'#13#10+
         '<TITLE>403 Forbidden</TITLE>'#13#10+
         '</HEAD><BODY>'#13#10+
         '<H1>Forbidden</H1>'#13#10+
         'You don''t have permission to access this server.<P>'#13#10+
         '<HR>'#13#10+
         '<ADDRESS>Apache/1.3.22 Server at localhost Port '+IntToStr(server_port[0])+'</ADDRESS>'#13#10+
         '</BODY></HTML>');
 end
 else
 begin
   user.WriteData('HTTP/1.0 301 Moved Permanently'#13#10'Server: Apache/1.3.22'#13#10'Connection: close'#13#10);
   user.WriteData('Location: '+redirect_url+#13#10#13#10);
   {user.WriteData('Content-Type: text/html'#13#10#13#10);
   user.WriteData('<HTML><HEAD>'#13#10+
         '<TITLE>Moved</TITLE>'#13#10+
         '</HEAD><BODY>'#13#10+
         'This site moved to <a href="'+redirect_url+'">'+redirect_url+'</a>.'+
         '</BODY></HTML>');}
 end;
end;

procedure TMainThread.CheckBots;
var
 t: Cardinal;
 str: String;
 loc: TLocalUser;
 i,j,k: Integer;
begin
 t:=GetTickCount;
 if (t-last_announcement)>(ann_delay*1000) then
 begin // announcements bot
   last_announcement:=t;
   if ann_enabled then
   begin
     j:=0;
     for i:=0 to max_announcement do
      if ann_messages[i]<>'' then inc(j);
     if j>0 then
     begin
      k:=random(j); if k=j then k:=0;
      j:=0;
      str:='';
      for i:=0 to max_announcement do
       if ann_messages[i]<>'' then
       begin
        if k=j then str:=ann_messages[i];
        inc(j);
       end;
      if str<>'' then
      for i:=0 to db_local.count-1 do
      begin
        loc:=db_local.Items[i];
{$IFNDEF DISABLE_CPU_THROTTLE}
        if ((i mod 20)=0) then CheckSync;
{$ENDIF}
        if loc.logged then
         if not (userHideAnnouncements in loc.data^.state) then
         begin
          loc.Exec(MSG_SERVER_ANNOUNCE,ann_user+' '+str);
          if ann_imenabled then loc.Exec(MSG_SERVER_PRIVMSG,ann_user+' '+str);
         end;
      end;
     end;
   end;
 end;
end;

procedure TMainThread.CheckMinShare;
var
 i,j,num: Integer;
 loc: TLocalUser;
 t: Cardinal;
begin
 if minshare_fullonly and (local_users<(max_users-5)) then exit;
 if (minshare<1) and (minshare_size<1) then exit;
 t:=GetTickCount-minshare_delay;
 num:=0;
 for i:=0 to db_local.count-1 do
 begin
   loc:=db_local.Items[i];
{$IFNDEF DISABLE_CPU_THROTTLE}
   if ((i mod 30)=0) then CheckSync;
{$ENDIF}
   if loc.logged then
    if loc.last_seen<t then
     if loc.level<napUserModerator then
     if minshare_kickchat or (not (userChatting in loc.data^.state)) then
     begin
       j:=0;
       if (minshare_size>0) and (loc.shared_size<minshare_size) then j:=1;
       if (minshare>0) and (loc.data^.shared<minshare) then j:=2;
       if j<>0 then
       if not StrHash_FindString(db_friends,loc.nick,true) then
//       if not StrHash_FindString(db_friends,decode_ip(loc.ip),false) then
       begin
         if j=1 then
         begin // minshare by size
           loc.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_MINSHARE3,minshare_size div MegaByte,loc.shared_size div MegaByte));
           if minshare_ban then
           begin
             if minshare_banip then
              BanUser(decode_ip(loc.ip),servername_t,minshare_bantime,GetLangT(LNG_MINSHARE_REASON2,loc.shared_size div MegaByte,servername_t),true)
             else
              BanUser(loc.nick,servername_t,minshare_bantime,GetLangT(LNG_MINSHARE_REASON2,loc.shared_size div MegaByte,servername_t),true);
           end;
           AddReconnector(decode_ip(loc.ip));
           DisconnectUser(loc,'',GetLangT(LNG_MINSHARE4,loc.nick,loc.software,loc.shared_size div MegaByte),'CheckMinShare',false);
         end
         else
         begin // minshare by number of files
           loc.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_MINSHARE,minshare,loc.data^.shared));
           if minshare_ban then
           begin
            if minshare_banip then
             BanUser(decode_ip(loc.ip),servername_t,minshare_bantime,GetLangT(LNG_MINSHARE_REASON,loc.data^.shared,servername_t),true)
            else
             BanUser(loc.nick,servername_t,minshare_bantime,GetLangT(LNG_MINSHARE_REASON,loc.data^.shared,servername_t),true);
           end;
           AddReconnector(decode_ip(loc.ip));
           DisconnectUser(loc,'',GetLangT(LNG_MINSHARE2,loc.nick,loc.software,loc.data^.shared),'CheckMinShare',false);
         end;
         inc(num);
         if minshare_fullonly and minshare_only10 then
          if num>=10 then exit;
       end;
     end;
 end;
end;

procedure TMainThread.Check180;
var
 loc: TLocalUser;
 i: Integer;
begin
 if (GetTickCount-last_period180)<180000 then exit;
 inc(last_period180,180000);
 db_whowas.Clear;
 ResetWantQueueControl;
 ResetDLRequestControl;
 //db_reconnect.Clear;//fredtest
 if num_servers>0 then
  for i:=0 to db_local.count-1 do
  begin
    loc:=db_local.Items[i];
{$IFNDEF DISABLE_CPU_THROTTLE}
    if ((i mod 50)=0) then CheckSync;
{$ENDIF}
    if loc.logged then
    begin
      if locNeedsUpdate in loc.localstate then
       if loc.data<>nil then
        UpdateUser(loc.data);
      loc.localstate:=loc.localstate-[locNeedsUpdate];
    end;
  end;
 ExpireLists;
end;

procedure TMainThread.Check30;
var
 i: Integer;
 srv: TServer;
 t: Cardinal;
begin
 if (GetTickCount-last_period30)<30000 then exit;
 inc(last_period30,30000);
 db_reconnect.Clear;//fredtest- look up :-b
 CheckMinShare;
 CountStats;
 t:=GetTickCount;
 if (not autolink_only1) or (num_servers=0) then
 for i:=0 to db_servers.count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.connected=conNotConnected then
    if srv.relink>0 then
     if (t-srv.login_start)>srv.relink then
     begin
       Handler_ServerConnect(srv,true);
       Check180;
       exit;
     end;
 end;
 Check180;
end;

procedure TMainThread.Check60;
var
 str: String;
 list: TStringList;
 i: Integer;
 f: TFileStream;
 srv: TServer;
begin
 if (GetTickCount-last_period)<60000 then exit;
 inc(last_period,60000);
 db_bans.Expire;
 CountStats;
 WriteAllServers(MSG_SERVER_STATS,'',IntToStr(local_users)+' '+IntToStr(local_files)+' '+IntToStr(local_bytes)+' '+IntToStr(max_users));
{$IFNDEF DISABLE_CPU_THROTTLE}
 CheckSync;
{$ENDIF}
 ResetSearchControl;
 linking:=false;
 for i:=0 to db_servers.count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.connected=conConnecting then linking:=true
   else if (srv.connected=conConnected) and (srv.logged=false) then linking:=true;
 end;
 inc(total_bytes_in,bytes_in);
 last_bytes_in:=bytes_in;
 bytes_in:=0;
 inc(total_bytes_out,bytes_out);
 last_bytes_out:=bytes_out;
 bytes_out:=0;
 inc(total_searches,num_searches);
 last_searches:=num_searches;
 num_searches:=0;
 inc(total_transfers,num_transfers);
 last_transfers:=num_transfers;
 num_transfers:=0;
 last_login:=num_login;
 num_login:=0;
 last_rejects:=num_rejects;
 num_rejects:=0;
 if not save_stats then exit;
 try
  if not FileExists(ApplicationDir+'serverstats') then
   f:=TFileStream.Create(ApplicationDir+'serverstats',fmCreate)
  else
   f:=TFileStream.Create(ApplicationDir+'serverstats',fmOpenWrite or fmShareDenyWrite);
  f.Seek(0,soFromEnd);
  except
   DebugLog('Error: cannot open file "serverstats"');
   exit;
 end;
 list:=CreateStringList;
 list.Add(DateToStr(now));  // date
 list.Add(TimeToStr(now));  // time
 list.Add(IntToStr((GetTickCount-start_time) div 1000)); // time online in seconds
 list.Add(IntToStr(local_users)); // local users
 list.Add(IntToStr(local_files)); // local files
 list.Add(IntToStr(local_bytes)); // local size
 list.Add(IntToStr(total_users)); // total users
 list.Add(IntToStr(total_files)); // total files
 list.Add(IntToStr(total_bytes)); // total bytes
 list.Add(IntToStr(last_login)); // logins for the last minute
 list.Add(IntToStr(last_rejects)); // rejects for the last minute
 list.Add(IntToStr(last_searches)); // searches for the last minute
 list.Add(IntToStr(last_transfers)); // transfers for the last minute
 list.Add(IntToStr(AllocMemSize)); // memory used in bytes
 list.Add(IntToStr(sockets_count)); // used sockets
 list.Add(IntToStr(last_bytes_in)); // bytes in
 list.Add(IntToStr(last_bytes_out)); // bytes out
 list.Add(IntToStr(num_servers)); // linked servers
 str:=list.Strings[0];
 for i:=1 to list.count-1 do str:=str+','+Trim(list.Strings[i]);
 str:=str+#10;
 FreeStringList(list);
 try
  f.Write(str[1],Length(str));
  f.Free;
  except
 end; 
end;

procedure TMainThread.CheckServers;
var
 i: Integer;
 srv: TServer;
begin
 for i:=0 to db_servers.Count-1 do
 begin
{$IFNDEF DISABLE_CPU_THROTTLE}
   CheckSync;
{$ENDIF}
   srv:=db_servers.Items[i];
   num_processed:=0;
   if srv.connected=conConnected then srv.Flush;
   if srv.connected=conConnected then srv.Receive(0);
   if srv.connected=conConnected then srv.Flush;
   if (srv.connected=conConnected) and (srv.logged=false) then
    if (GetTickCount-srv.login_start)>MAX_LOGIN_TIMEOUT then
    begin
      DisconnectServer(srv,false,false,'CheckServers');
      Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKERRLOGIN,srv.host),true);
    end;
 end;
end;

procedure TMainThread.CheckTimeouts;
var
 i: Integer;
 user: TLocalUser;
 t: Cardinal;
begin
 t:=GetTickCount;
 try
   for i:=db_local.count-1 downto 0 do
   begin
     user:=db_local.Items[i];
{$IFNDEF DISABLE_CPU_THROTTLE}
     if ((i mod 30)=0) then CheckSync;
{$ENDIF}
     if user<>cons then
     begin
       if user.socket=INVALID_SOCKET then
       try
        FreeLocalUser(user);
        db_local.Delete(i);
        except
         on E:Exception do
         DebugLog('Exception in TMainThread::CheckData (1) : '+E.Message);
       end
       else
        if not user.logged then
         if (t-user.last_seen)>timeout_login then
         try
          FreeLocalUser(user);
          db_local.Delete(i);
         except
          on E:Exception do
           DebugLog('Exception in TMainThread::CheckData (2) : '+E.Message);
         end;
     end;    
   end;
  except
   DebugLog('Exception in CheckTimeouts');
 end;
end;

procedure TMainThread.ReceiveData;
var
 i, dv, dm, dm2: Integer;
 user: TLocalUser;
begin
 try
   if db_local.count>1000 then dv:=300
   else if db_local.count>50 then dv:=db_local.count div 3
   else dv:=20;
   dm:=dv div 2;
   dm2:=1;
   for i:=0 to db_local.count-1 do
   begin
{$IFNDEF DISABLE_CPU_THROTTLE}
     if ((i mod 20)=0) then CheckSync;
{$ENDIF}
     if (i mod 100)=70 then CheckServers;
     if (i mod dv)=dm2 then
      if sync_reply_list.Count>0 then
        Synchronize(SyncLog);
     if (i mod dv)=dm then
        Synchronize(SyncData);
     user:=db_local.Items[i];
     if user<>cons then
       begin
         if user.last_seen<>0 then
           ReceiveData(user,0,0);
         if not running then exit;
       end;
   end;
   if (GetTickCount-last_stats)>stats_delay then
   begin
    last_stats:=GetTickCount;
    CountStats;
    for i:=0 to db_local.Count-1 do
    begin
{$IFNDEF DISABLE_CPU_THROTTLE}
     if ((i mod 30)=0) then CheckSync;
{$ENDIF}
     user:=db_local.Items[i];
     if user<>cons then
      if user.logged then
       user.Exec(MSG_SERVER_STATS,IntToStr(total_users)+' '+IntToStr(total_files)+' '+IntToStr(total_bytes div 1073741824)); // +' GB '+IntToStr(user.data^.shared)
    end;
   end;
  except
   DebugLog('Exception in ReceiveData 1');
 end;
end;

procedure TMainThread.ReceiveData(user: TLocalUser; counter, recurse: Integer);
var
 i,num,len,recv_max,rev,tag,old_mem,new_mem: Integer;
 last_error: Integer;
begin
 num:=0; // debug variable
 try
   if user=nil then exit;
   num:=1;
   if user.socket=INVALID_SOCKET then exit;
   if user.last_seen=0 then exit;
   if user.logged then
    if user.searches_count>0 then
     if (GetTickCount-user.last_search_time)>timeout_remote_search then
     begin
       num:=2;
       user.searches_count:=0;
       user.Exec(MSG_SERVER_SEARCH_END,'');
       num:=3;
     end;
   num:=4;
   user.Flush;
   num:=5;
   if (user.logged=true) and (CanReceive(false)=false) then exit;
   if user.last_seen=0 then exit;
   if locWriteOnly in user.localstate then exit;
   num:=6;
   if Length(user.recv_buf)=0 then SetLength(user.recv_buf,RECV_BUF_SIZE_DEF);
   num:=7;
   while true do
   begin
     num:=8;
     if not running then exit;
     if user.last_seen=0 then exit;
     if user.socket=INVALID_SOCKET then exit;
     if (user.logged=true) and (CanReceive(false)=false) then exit;
     num:=9;
     if counter>=MAX_COMMANDS_PER_CYCLE then exit;
     if linking then if counter>=MAX_COMMANDS_PER_CYCLE2 then exit;
     if TCPSocket_CanRead(user.socket,0,last_error) then
     begin
       num:=10;
       recv_max:=Length(user.recv_buf)-user.recv_len;
       num:=11;
       if recv_max=0 then
       begin // increase buffer
         num:=12;
         if user.recv_len>(RECV_BUF_SIZE_MAX-4) then
         begin
           num:=13;
           DisconnectUser(user,'',GetLangT(LNG_DISCONNECT_INVCMD,user.nick,user.software+', '+decode_ip(user.ip)),'ReceiveData (1)',true);
           exit;
         end;
         num:=14;
         SetLength(user.recv_buf,user.recv_len+RECV_BUF_SIZE_MIN); // increase buffer length if needed
         inc(recv_max,RECV_BUF_SIZE_MIN);
         num:=15;
       end;
       num:=16;
       len:=TCPSocket_RecvBuffer(user.socket,PChar(@user.recv_buf[user.recv_len+1]),recv_max,last_error);
       num:=17;
       if last_error=WSAEWOULDBLOCK then exit;
       num:=19;
       if last_error<>0 then
       begin
         num:=20;
         DisconnectUser(user,'',GetLangT(LNG_DISCONNECT_SOCKETERR,user.nick,user.software,IntToStr(last_error),GetErrorDesc(last_error)),'ReceiveData (2)',true);
         exit;
       end;
       num:=21;
       inc(user.recv_len,len);
       inc(bytes_in,len);
       inc(bandwidth_down,len);
     end
     else if last_error<>0 then
      if last_error<>WSAEWOULDBLOCK then
      begin
        DisconnectUser(user,'',GetLangT(LNG_DISCONNECT_SOCKETERR,user.nick,user.software,IntToStr(last_error),GetErrorDesc(last_error)),'ReceiveData (2a)',true);
        exit;
      end;
     num:=22;
     if user.recv_len<4 then exit;
     if locSwapBytes in user.localstate then
      len:=Ord(user.recv_buf[2])+256*Ord(user.recv_buf[1])
     else
     begin
      num:=23;
      len:=Ord(user.recv_buf[1])+256*Ord(user.recv_buf[2]);
      rev:=Ord(user.recv_buf[4])+256*Ord(user.recv_buf[3]);
      num:=24;
      if not user.logged then
      begin
        if (rev=2) or (rev=4) or (rev=6) or (rev=7) or (rev=11) or (rev=920) then
        begin // checking for big-endian (possible senders: Napster 10.3+, linked server, some buggy client)
          num:=25;
          user.localstate:=user.localstate+[locSwapBytes];
          len:=Ord(user.recv_buf[2])+256*Ord(user.recv_buf[1]);
          num:=26;
        end
        else
        begin // checking HTTP client
         if (Copy(user.recv_buf,1,3)='GET') or (Copy(user.recv_buf,1,4)='POST') then
         begin // web server
           SendWebPage(user);
           exit;
         end;
        end;
      end;
      num:=27;
     end;
     num:=28;
     if len>(RECV_BUF_SIZE_MAX-4) then
     begin
       num:=29;
       DisconnectUser(user,'',GetLangT(LNG_DISCONNECT_INVCMD,user.nick,user.software+', '+decode_ip(user.ip)),'ReceiveData (3)',true);
       exit;
     end;
     num:=30;
     if (len+4)>Length(user.recv_buf) then
     begin // increase buffer
       num:=31;
       tag:=((len+4) div RECV_BUF_SIZE_MIN);
       num:=32;
       SetLength(user.recv_buf,tag*RECV_BUF_SIZE_MIN);
       num:=33;
       if recurse>=MAX_RECURSE then exit;
       num:=34;
       ReceiveData(user,counter,recurse+1);
       exit;
     end;
     num:=35;
     if user.recv_len<(len+4) then exit;
     num:=36;
     while len<(user.recv_len-3) do // processing received buffer
     begin
       num:=37;
       if user.recv_len<4 then exit;
       if (user.recv_len-4)<len then exit;
       num:=38;
       if locSwapBytes in user.localstate then
        tag:=Ord(user.recv_buf[4])+256*Ord(user.recv_buf[3])
       else
        tag:=Ord(user.recv_buf[3])+256*Ord(user.recv_buf[4]);
       num:=39;
       SetLength(gcmd.cmd,len);
       num:=40;
       if len>0 then Move(user.recv_buf[5],gcmd.cmd[1],len);
       num:=41;
       Move(user.recv_buf[len+5],user.recv_buf[1],user.recv_len-len-4);
       num:=42;
       dec(user.recv_len,len+4);
       num:=43;
       try
        {$IFDEF CHECK_LEAK}
        old_mem:=AllocMemSize;
        {$ENDIF}
        gcmd.id:=tag;
        if gcmd.id=870 then inc(counter,3)
        else if gcmd.id=200 then
        begin
         if num_servers>0 then
          inc(counter,5)
         else
          inc(counter,1);
        end;
        if not ProcessCommand(user,queryNormal) then
        begin
          {$IFDEF CHECK_LEAK}
          new_mem:=AllocMemSize;
          if (new_mem-old_mem)>POSSIBLE_LEAK then
           DebugLog('Possible leak in ProcessCommand(1,'+IntToStr(tag)+','+gcmd.cmd+'): '+IntToStr(new_mem-old_mem)+' bytes allocated');
          {$ENDIF}
          exit;
        end;
        {$IFDEF CHECK_LEAK}
        new_mem:=AllocMemSize;
        if (new_mem-old_mem)>POSSIBLE_LEAK then
         DebugLog('Possible leak in ProcessCommand(2,'+IntToStr(tag)+','+gcmd.cmd+'): '+IntToStr(new_mem-old_mem)+' bytes allocated');
        {$ENDIF}
        except
         on E:Exception do
         begin
          DebugLog('Exception in TMainThread::ReceiveData (tag='+IntToStr(tag)+') : '+E.Message);
          {$IFDEF CHECK_LEAK}
          new_mem:=AllocMemSize;
          if (new_mem-old_mem)>POSSIBLE_LEAK then
           DebugLog('Possible leak in ProcessCommand(3,'+IntToStr(tag)+','+gcmd.cmd+'): '+IntToStr(new_mem-old_mem)+' bytes allocated');
          {$ENDIF} 
          exit;
         end;
       end;
       num:=44;
{$IFNDEF DISABLE_CPU_THROTTLE}
       CheckSync;
{$ENDIF}
       num:=45;
       if user.last_seen=0 then exit;
       inc(counter);
       num:=46;
       if (counter>=MAX_COMMANDS_PER_CYCLE) or (linking and (counter>=MAX_COMMANDS_PER_CYCLE2)) then
       begin
        num:=47;
        exit;
       end;
       num:=48;
       if user.recv_len>3 then
       begin
         num:=49;
         if locSwapBytes in user.localstate then
          len:=Ord(user.recv_buf[2])+256*Ord(user.recv_buf[1])
         else
          len:=Ord(user.recv_buf[1])+256*Ord(user.recv_buf[2]);
         num:=50;
         if (len+4)>Length(user.recv_buf) then
         begin
           num:=51;
           if len>(RECV_BUF_SIZE_MAX-4) then
           begin
             num:=52;
             DisconnectUser(user,'',GetLangT(LNG_DISCONNECT_INVCMD,user.nick,user.software+', '+decode_ip(user.ip)),'ReceiveData (4)',true);
             exit;
           end;
           num:=53;
           tag:=((len+4) div RECV_BUF_SIZE_MIN);
           SetLength(user.recv_buf,tag*RECV_BUF_SIZE_MIN); // increase buffer length if needed
           num:=54;
           if recurse>=MAX_RECURSE then exit;
           ReceiveData(user,counter,recurse+1);
           num:=55;
           exit;
         end;
         num:=56;
       end
       else
        len:=user.recv_len+1;
       num:=57;
     end; // loop
     num:=58;
   end;
   num:=59;
  except
   DebugLog('Exception in ReceiveData 2  num='+IntToStr(num)+' i='+IntToStr(i)+' len='+IntToStr(len)+' recv_max='+IntToStr(recv_max)+' rev='+IntToStr(rev)+' tag='+IntToStr(tag));
 end;
end;

procedure TMainThread.LoadBlocks;
var
 i: Integer;
 list: TStringList;
 hash: PStringHash;
begin
 list:=CreateStringList;
 try
  list.LoadFromFile(ApplicationDir+'block');
  except
   FreeStringList(list);
   exit;
 end;
 for i:=0 to list.Count-1 do
 if Length(list.Strings[i])>1 then
 if list.Strings[i][1]<>'#' then
 begin
   hash:=StrHash_Create;
   SplitString(StripString(AnsiLowerCase(list.Strings[i])),hash^);
   db_blocks.Add(hash);
 end;
 FreeStringList(list);
end;

procedure TMainThread.SaveBlocks;
var
 list: TStringList;
 str: String;
 i,j: Integer;
 hash: PStringHash;
begin
 list:=CreateStringList;
 for i:=0 to db_blocks.Count-1 do
 begin
   hash:=db_blocks.Items[i];
   str:=JoinString(hash^);
   if Length(str)>0 then
    list.Add(str);
 end;
 list.Sort;
 list.Insert(0,'# ! ̃t@C͎T[o[Vbg_EƂ㏑܂B');
 list.Insert(1,'# ҏWɃT[o[ғĂȂƂmFĂB');
 list.Insert(2,'#');
 list.Insert(3,'# L珜Ot@C̃XgłB');
 list.Insert(4,'# es͐K\ŋLq܂B');
 list.Insert(5,'# 啶/͋ʂ܂B');
 list.Insert(6,'#');
 list.Insert(7,'# : alanis morissette');
 list.Insert(8,'# "sample.block"t@CŏOt@C̕W̃Xg܂.');
 list.Insert(9,'#');
 try
  list.SaveToFile(ApplicationDir+'block');
  except
 end;
 FreeStringList(list);
end;

procedure TMainThread.ResetSearchControl;
var
 i: Integer;
 loc: TLocalUser;
begin
 for i:=db_local.count-1 downto 0 do
 try
   loc:=db_local.Items[i];
   if loc.logged then
    if loc.searchespm<>999 then
     loc.searchespm:=0;
  except
 end;
end;

procedure TMainThread.ResetWantQueueControl;
var
 i: Integer;
 loc: TLocalUser;
begin
 for i:=db_local.count-1 downto 0 do
 try
   loc:=db_local.Items[i];
   if loc.logged then
    if loc.wantqueuep3m<>999 then
     loc.wantqueuep3m:=0;
  except
 end;
end;

procedure TMainThread.ResetDLRequestControl;
var
 i: Integer;
 loc: TLocalUser;
begin
 for i:=db_local.count-1 downto 0 do
 try
   loc:=db_local.Items[i];
   if loc.logged then
    if loc.dlrequestsp3m<>999 then
     loc.dlrequestsp3m:=0;
  except
 end;
end;

end.
