{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: vars

 Global variables

*********************************************************}
unit vars;

interface

uses
 SysUtils, Classes, Classes2, graphics, zlibex, slavasplitter, slavapanel, winsock,
 windows, constants, stypes, bans, blcksock, synsock, users, localusers,
 registered, servers, slavastrings, class_cmdlist, class_cmdexlist,
 class_doublecmdlist, class_cmd2list;

type TWQBlockMethod = (block,leech,ban);

var
 running, restarting, showform, closing, win98: Boolean;
 ApplicationDir: String;
 // server main variables
 server_socket: Array[0..MAX_LISTEN_SOCKET] of HSocket;
 server_port: Array[0..MAX_LISTEN_SOCKET] of Integer;
 servername_t, servername_i: String; // 2 variables instead of one to make it thread-safe
 serveralias: String;
 myserverhandle: Integer;
 listen_interface: String;
 sync_reply_list: TNapDoubleCmdList;
 cmd_list: TNapDoubleCmdList;
 log_file, debug_file: TFileStream;
 start_time: Cardinal;
 start_time_t: time_t;
 cpu_usage: Integer;
 cpu_disable: Boolean;
 friend_sound: Boolean;
 meta_enabled  : boolean;
 meta_port  : integer;
 // options
 language: String;
 null_password: String;
 // limits and settings
 registered_only: Boolean;
 allow_register: Boolean;
 accept_remote_users: Boolean;
 max_users: Integer;
 stats_delay: Cardinal;
 max_hotlist: Integer;
 max_ignorelist: Integer;
 max_clones: Integer;
 memory_limit: Integer;
 defsearchresults: Integer;
 maxsearchresults: Integer;
 maxremotesearchresults: Integer;
 disableremotesearch: Boolean;
 maxbrowseresults: Integer;
 maxremotebrowse: Integer;
 search_noforward_results, search_noforward_requests: Boolean;
 browse_noforward_results, browse_noforward_requests: Boolean;
 timeout_remote_search: Cardinal;
 linking: Boolean;
 max_users_per_minute, users_per_minute: Integer;
 allow_create_channels: Boolean;
 redirect_cqex: Boolean;
 old_opsay: Boolean;
 max_channels, max_channels_total: Integer;
 block_cqex_chat: Boolean;
 bytes_in, bytes_out, total_bytes_in, total_bytes_out: Int64;
 last_bytes_in, last_bytes_out: Int64;
 total_searches, num_searches, last_searches, successful_searches, total_search_results: Int64;
 total_transfers, num_transfers, last_transfers: Int64;
 total_browses, num_browses, last_browses, total_browse_results: Int64;
 num_login, last_login: Integer;
 num_rejects, last_rejects: Integer;
 num_servers, direct_links: Integer;
 num_processed: Integer;
 blocked_clients: Array[0..softUnknown] of Boolean;
 blocked_clients_desc: Array[0..29] of PChar = ('Napster', 'audioGnome', 'WinMX (normal)', 'GnomePlus',
 'Amster', 'FileNavigator', 'CQEX', 'SunshineUN', 'Teknap', 'Nap', 'MacNap', 'MP3Rage', 'XNap', 'Spotlight',
 'NFS', 'DMNapster', 'KNapster', 'Lopster', 'Rapigator', 'Swaptor', 'Dagsta', 'Floodster', 'Drumbeat',
 'WinMX (changed)', 'MlDonkey', 'Napigator', 'Opennap', 'Nap v0.8', 'WinMX (Japanese)', 'Other');
 blocked_custom: Array[0..MAX_CUSTOM_BLOCK] of String;
 blocked_messagetype: TBlockedMessageType;
 blocked_message: String;
 limit_mx, mx_useping: Boolean;
 quota_mx: Integer;
 mx_users: Integer;
 mx_ban: Integer;
 ban_fakemx: Boolean;
 allow_link: TAllowLinkType;
 allowed_servers: String;
 restrict_outgoing: Boolean;
 outgoing_list: String;
 switch_chat: Boolean;
 sockets_users_default: Boolean;
 sockets_users_send, sockets_users_recv: Integer;
 sockets_servers_default: Boolean;
 sockets_servers_send, sockets_servers_recv: Integer;
 max_privmsg_len, max_channelmsg_len: Integer;
 show_operators: Boolean;
 network_hub: Boolean;
 hub_syncreg, hub_syncban, hub_syncblock: Boolean;
 wallop_serverban: Boolean;
 banmail: String;
 redirect_url: String;
 channels_irc, channels_low, channels_timestamp: Boolean;
 autolink_only1: Boolean;
 restart_user: String;
 prevent_shouting: Boolean;
 chat_flash, chat_mini, wallop_im, wallop_sound: Boolean;
 reconnect_delay: Boolean;
 ping_users: Boolean;
 true_stats: Boolean;
 max_servers_enabled: Boolean;
 max_servers: Integer;
 remote_admin_ok: Boolean;
 remote_adminpass: String;
 // lists
 db_online: TOnlineUsers;
 db_local: TMyList;
 db_servers: TMyList;
 db_blocks: TMyList;
 db_registered: TRegUserDataBase;
 db_bans: TBanList;
 db_motd: TStringHash;
 db_friends: TStringHash;
 db_channels: TMyList;
 db_software: TNapCmd2List;
 db_invitations: TNapCmdExList;
 db_reconnect: TMyStringList; // for reconnectors
 db_whowas: TNapCmdExList;
 db_ips: TNapCmdExList;
 db_ips_local: String;
 db_closed: TNapCmd2List; // list of closed sockets
 db_dirs: TNapCmdList;
 // console
 cons: TLocalUser;
 cons_channels: TMyList;
 cons_chat: TMyList;
 cons_whois: TMyList;
 cons_blocks: TStringHash;
 cons_friends: TStringHash;
 cons_ignored: TStringHash;
 cons_list: TConsoleList;
 cons_reg_user: String;
 cons_autojoin1, cons_autojoin2, cons_autojoin3: String;
 // interface
 b3_canclose: Bool3;
 allow_multiple_instances, startup_hide: Boolean;
 last_away_user: String;
 last_away_time: Cardinal;
 isHide: array [0..30] of Boolean;//list_users column visibility
 // log
 log_to_file, log_console_data: Boolean;
 save_stats: Boolean;
 clear_serverstats,
 clear_clientstats: Boolean;
 log_commands: Boolean;
 log_servercommands: Boolean;
 log_napigator: Boolean;
 log_dagsta: Boolean;
 log_login: Boolean;
 log_search: Boolean;
 log_browse: Boolean;
 log_transfers: Boolean;
// log_links: Boolean;
 // timeouts
 timeout_login: Cardinal;
 current_time: Cardinal;
 current_time_t: time_t;
 // statistics
 local_users, total_users, local_users_max, total_users_limit, total_users_max: Integer;
 local_files, total_files, local_files_max, total_files_max,
 local_bytes, total_bytes, local_bytes_max, total_bytes_max: Int64;
 total_connections: Integer;
 // sharing
 allow_share, shareinform: Boolean;
 share_nomodem, share_checkdup: Boolean;
 minshare, maxshare: Integer;
 minfilename: Integer;
 minduration: Integer;
 share_auto_friendadd_minimum: Integer;
 auto_friendadd: Boolean;
 maxshareindex: Integer;
 maxshare_total: Int64;
 maxshare_audio,maxshare_video,maxshare_image,maxshare_app,maxshare_cd,maxshare_text,maxshare_mp3: Integer;
 minfilesize_audio,maxfilesize_audio,
 minfilesize_video,maxfilesize_video,
 minfilesize_image,maxfilesize_image,
 minfilesize_app,maxfilesize_app,
 minfilesize_cd,maxfilesize_cd,
 minfilesize_text,maxfilesize_text,
 minfilesize_mp3,maxfilesize_mp3: Int64;
 ext_mp3, ext_audio, ext_video, ext_text, ext_image, ext_app, ext_cd: String;
 ext_mp3_list, ext_audio_list, ext_video_list, ext_app_list, ext_image_list, ext_cd_list, ext_text_list: TStringHash;
 share_320,share_256,share_224,share_192,share_160,share_128,share_112,share_96,share_80,share_64,share_56,share_48,share_40,share_32,share_24,share_unknown: Boolean;
 // blocklist
 block_allowshare, block_allowshare_admins, block_checkmods: Boolean; 
 // napigator
 stats_socket: HSocket;
 napigator_socket: HSocket;
 napigator_host: String;
 napigator_port: String;
 napigator_user: String;
 napigator_password: String;
 napigator_salt: String;
 napigator_myport: Integer;
 napigator_enabled: Boolean;
 napigator_myip: String;
 napigator_autodisconnect: Boolean;
 napigator_delay: Cardinal;
 napigator_fake_ip: Boolean;
 dagsta_socket: HSocket;
 dagsta_host: String;
 dagsta_port: String;
 dagsta_user: String;
 dagsta_password: String;
 dagsta_salt: String;
 dagsta_myport: Integer;
 dagsta_enabled: Boolean;
 dagsta_myip: String;
 dagsta_autodisconnect: Boolean;
 dagsta_delay: Cardinal;
 // bots
 ann_enabled: Boolean;
 ann_delay, last_announcement: Cardinal;
 ann_user: String;
 ann_messages: Array[0..MAX_ANNOUNCEMENT] of String;
 old_report_enabled: Boolean;
 old_report_socket: HSocket;
 old_report_port: Integer;
 new_report_enabled: Boolean;
 new_report_socket: HSocket;
 meta_socket: HSocket;
 new_report_port: Integer;
 new_report_hide_hub: Boolean;
 minshare_delay: Cardinal;
 minshare_ban: Boolean;
 minshare_banip: Boolean;
 minshare_bantime: Integer; // seconds
 minshare_size: Int64;
 minshare_fullonly: Boolean;
 minshare_only10: Boolean;
 minshare_kickchat: Boolean;
 // bandwith limits
 bandwidth_up, bandwidth_down, bandwidth_maxup, bandwidth_maxdown, bandwidth_allowedup, bandwidth_alloweddown: Integer;
 bandwidth_limitservers, bandwidth_limited: Boolean;
 bandwidth_lastcheck: Cardinal;
 // flood control
 flood_max_user_message: Integer;
 flood_max_same_message: Integer;
 flood_warning: Boolean;
 flood_enable: Boolean;
 flood_max_searches: Integer;
 // from handler.pas
 tmp_pos: Integer; // debug variable. shows position of exception. assign unique digit - last used digit should be written at last line of handler.pas
 // for checksync.pas
 check_sync_t: Integer;
 // colors
 slError,
 slWallop,
 slAnnounce,
 slWhowas,
 slPong,
 slOffline,
 slOnline,
 slDebugData,
 slNapigator,
 slDagsta,
 slSearch,
 slBrowse,
 slTransfer,
 slTopic,
 slChannelMessage,
 slChannelMyMessage,
 slChannelEmote,
 slChannelMyEmote,
 slChannelJoin,
 slChannelPart,
 slChatMessage,
 slChatMyMessage,
 slBackground,
 slText: Integer;
 // other
 searchblock_chkfiles: Boolean;
 searchblock_chksize: Boolean;
 searchblock_hard: Boolean;
 searchblock_files: Integer;
 searchblock_size: Int64;
 domblock_chkfiles: Boolean;
 domblock_chksize: Boolean;
 domblock_hard: Boolean;
 domblock_files: Integer;
 domblock_size: Int64;
 dlfloodblock_count: Integer;
 dlfloodblock_method: TWQBlockMethod;//(block,leech,ban)
 dlfloodblock_bantime: Cardinal;
 wqfloodblock_count: Integer;
 wqfloodblock_method: TWQBlockMethod;//(block,leech,ban)
 wqfloodblock_bantime: Cardinal;
 nocount_text: Boolean;
 autoban_incomplete: Boolean;
 disable_fakeext: Boolean;
 fakeext: String;
 fakeext_list: TStringHash;
 enable_trapport: Boolean;
 trap_socket: Array[0..MAX_LISTEN_TRAPSOCKET] of HSocket;
 trap_port: Array[0..MAX_LISTEN_TRAPSOCKET] of Integer;
 cons_browse: TMyList;
 block_transferport: Boolean;
 blocked_transferport: String;
 blocked_transferport_list: TStringHash;
 share_matchedfile_only: Boolean;
 enable_loginim: Boolean;
 loginimbot: String;
 loginim: Array[0..MAX_LOGINIM] of String;
 force_enter: Boolean;
 force_enter_channel: String;
implementation

procedure CheckWindows;
var
 OSVersionInfo: TOSVersionInfo;
begin
 OSVersionInfo.dwOSVersionInfoSize:=SizeOf(OSVersionInfo);
 GetVersionEx(OSVersionInfo);
 win98:=OSVersionInfo.dwPlatformId=1;
end;

initialization
 CheckWindows;
end.
