{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: languages

 Form for selecting language

*********************************************************}
unit languages;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  IniFiles, ComCtrls, ExtCtrls, StdCtrls, Classes;

type
  TSlavaNapLanguage = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    ksoOfficePanel1: TPanel;
    btn_ok: TButton;
    btn_cancel: TButton;
    list: TListView;
    procedure FormShow(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    modal: Boolean;
    procedure CreateParams(Var params: TCreateParams);override;
  end;

var
  SlavaNapLanguage: TSlavaNapLanguage;

procedure SetFont(font: TFont; fontsize: Integer=0);

implementation

uses mainform, vars, stypes, lang;

{$R *.DFM}

procedure SetFont(font: TFont;fontsize: Integer=0);
var
  charset: String;
begin
  if font=nil then exit;
  charset:=UpperCase(GetLangI(LNG_FONT_CHARSET));
  if charset='ANSI_CHARSET'             then font.Charset:=ANSI_CHARSET
  else if charset='DEFAULT_CHARSET'     then font.Charset:=DEFAULT_CHARSET
  else if charset='SHIFTJIS_CHARSET'    then font.Charset:=SHIFTJIS_CHARSET
  else if charset='HANGEUL_CHARSET'     then font.Charset:=HANGEUL_CHARSET
  else if charset='JOHAB_CHARSET'       then font.Charset:=JOHAB_CHARSET
  else if charset='GB2312_CHARSET'      then font.Charset:=GB2312_CHARSET
  else if charset='CHINESEBIG5_CHARSET' then font.Charset:=CHINESEBIG5_CHARSET
  else if charset='GREEK_CHARSET'       then font.Charset:=GREEK_CHARSET
  else if charset='TURKISH_CHARSET'     then font.Charset:=TURKISH_CHARSET
  else if charset='VIETNAMESE_CHARSET'  then font.Charset:=VIETNAMESE_CHARSET
  else if charset='HEBREW_CHARSET'      then font.Charset:=HEBREW_CHARSET
  else if charset='ARABIC_CHARSET'      then font.Charset:=ARABIC_CHARSET
  else if charset='BALTIC_CHARSET'      then font.Charset:=BALTIC_CHARSET
  else if charset='RUSSIAN_CHARSET'     then font.Charset:=RUSSIAN_CHARSET
  else if charset='THAI_CHARSET'        then font.Charset:=THAI_CHARSET
  else if charset='EASTEUROPE_CHARSET'  then font.Charset:=EASTEUROPE_CHARSET
  else if charset='OEM_CHARSET'         then font.Charset:=OEM_CHARSET;
  if fontsize=0 then fontsize:=StrToIntDef(GetLangI(LNG_FONT_SIZE),0);
  if fontsize<>0 then font.Size:=fontsize;
  font.Name:=GetLangI(LNG_FONT_NAME);
end;

procedure TSlavaNapLanguage.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
   params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapLanguage.FormShow(Sender: TObject);
var
 i: Integer;
 item: TListItem;
 rec: TSearchRec;
 str, fname, lang, comments, ver: String;
 ini: TIniFile;
begin
 btn_cancel.Visible:=not modal;
 if language='' then language:='english';
 with list do
 begin
   Items.BeginUpdate;
   Items.Clear;
   i:=FindFirst(ApplicationDir+'*.lng',faAnyFile,rec);
   while i=0 do
   begin
     if (rec.attr and faDirectory)=0 then
      if rec.name<>'.' then
       if rec.name<>'..' then
       begin
         str:=AnsiLowerCase(ExtractFileName(rec.name));
         str:=Copy(str,1,Length(str)-4);
         fname:=str;
         lang:='';
         comments:='';
         ver:='';
         try
          ini:=TIniFile.Create(ApplicationDir+fname+'.lng');
          lang:=ini.ReadString('Version','Language','');
          comments:=ini.ReadString('Version','Comments','');
          ver:=ini.ReadString('Version','Version','');
          ini.Free;
          except
         end;
         if fname<>'' then
          if lang<>'' then
           if comments<>'' then
           begin
            item:=Items.Add;
            item.Caption:=lang;
            item.SubItems.Add(fname+'.lng');
            item.SubItems.Add(ver);
            item.SubItems.Add(comments);
            item.SubItems.Add(fname);
            if fname=language then
             item.Selected:=true;
           end;
       end;
     i:=FindNext(rec);
   end;
   FindClose(rec);
   Items.EndUpdate;
 end;
end;

procedure TSlavaNapLanguage.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapLanguage.btn_okClick(Sender: TObject);
begin
 if list.Selected<>nil then
  language:=list.Selected.SubItems[3]
 else if list.Items.Count>0 then
  language:=list.Items[0].SubItems[3];
 Close;
 if btn_cancel.Visible and running then
 begin
  LoadLanguage(language);
  SlavaNapWindow.ChangeInterface;
 end;
end;

end.
