{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: serverattr

 Server attributes window

*********************************************************}
unit serverattr;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, Classes;

type
  TSlavaNapServerAttr = class(TForm)
    btn_ok: TButton;
    btn_cancel: TButton;
    lbl_host: TLabel;
    edit_host: TEdit;
    lbl_port: TLabel;
    box_auth: TGroupBox;
    edit_port: TSpinEdit;
    cb_auth_resolve: TRadioButton;
    edit_ip: TEdit;
    lbl_ip: TLabel;
    lbl_ipinfo: TLabel;
    cb_auth_password: TRadioButton;
    lbl_auth_mypass: TLabel;
    lbl_auth_remotepass: TLabel;
    edit_mypass: TEdit;
    edit_remotepass: TEdit;
    box_compress: TGroupBox;
    cb_comp_0: TRadioButton;
    cb_comp_1: TRadioButton;
    cb_comp_2: TRadioButton;
    cb_comp_3: TRadioButton;
    cb_relink: TCheckBox;
    edit_relink: TSpinEdit;
    lbl_comments: TLabel;
    edit_comments: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    server: String;
    procedure ShowServer(str: String);
  end;

var
  SlavaNapServerAttr: TSlavaNapServerAttr;

implementation

uses
 servers, stypes, vars, mainform, zlibex, lang, constants, languages;

{$R *.DFM}

procedure TSlavaNapServerAttr.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
end;

procedure TSlavaNapServerAttr.FormShow(Sender: TObject);
var
 i,j: Integer;
begin
 SetFont(Self.Font);
 Caption:=GetLangI(LNG_EDITSRV_CAPTION,server);
 lbl_host.Caption:=GetLangI(LNG_EDITSRV_HOST);
 lbl_port.Caption:=GetLangI(LNG_EDITSRV_PORT);
 lbl_ipinfo.Caption:=GetLangI(LNG_EDITSRV_IPINFO);
 lbl_ip.Caption:=GetLangI(LNG_EDITSRV_IPTEXT);
 box_auth.Caption:=' '+GetLangI(LNG_EDITSRV_BOX)+' ';
 cb_auth_resolve.Caption:=GetLangI(LNG_EDITSRV_RESOLVE);
 cb_auth_password.Caption:=GetLangI(LNG_EDITSRV_PASSWORD);
 lbl_auth_mypass.Caption:=GetLangI(LNG_EDITSRV_MYPASS);
 lbl_auth_remotepass.Caption:=GetLangI(LNG_EDITSRV_REMOTEPASS);
 box_compress.Caption:=' '+GetLangI(LNG_EDITSRV_BOX2)+' ';
 cb_comp_0.Caption:=GetLangI(LNG_EDITSRV_COMP0);
 cb_comp_1.Caption:=GetLangI(LNG_EDITSRV_COMP1);
 cb_comp_2.Caption:=GetLangI(LNG_EDITSRV_COMP2);
 cb_comp_3.Caption:=GetLangI(LNG_EDITSRV_COMP3);
 lbl_comments.Caption:=GetLangI(LNG_EDITSRV_COMMENTS);
 cb_relink.Caption:=GetLangI(LNG_EDITSRV_RELINK);
 btn_ok.Caption:=GetLangI(LNG_EDITSRV_OK);
 btn_cancel.Caption:=GetLangI(LNG_EDITSRV_CANCEL);
 i:=max(lbl_host.Width,lbl_port.Width)+lbl_host.Left+8;
 j:=edit_host.Left+edit_host.Width; // right border
 edit_host.Left:=i;
 edit_host.Width:=j-i;
 edit_port.Left:=i;
 edit_port.Width:=j-i;
 i:=lbl_ip.Left+lbl_ip.Width+8;
 edit_ip.Left:=i;
 edit_ip.Width:=j-i;
 i:=lbl_comments.Left+lbl_comments.Width+8;
 edit_comments.Left:=i;
 edit_comments.Width:=j-i;
 i:=Canvas.TextWidth(cb_relink.Caption)+20;
 cb_relink.Width:=i;
 inc(i,cb_relink.Left+8);
 edit_relink.Left:=i;
 edit_relink.Width:=j-i;
 j:=edit_mypass.Left+edit_mypass.Width;
 i:=max(lbl_auth_mypass.Width,lbl_auth_remotepass.Width)+lbl_auth_mypass.Left+8;
 edit_mypass.Left:=i;
 edit_mypass.Width:=j-i;
 edit_remotepass.Left:=i;
 edit_remotepass.Width:=j-i;
end;

procedure TSlavaNapServerAttr.ShowServer(str: String);
var
 srv: TServer;
begin
 try
  Hide;
  except
 end;
 if not running then exit;
 server:=str;
 srv:=FindServer(str,false);
 if srv=nil then exit;
 edit_host.Text:=srv.host;
 edit_port.Value:=srv.port;
 edit_ip.Text:=srv.forced_ip;
 if srv.authentication=authPassword then
  cb_auth_password.Checked:=true
 else
  cb_auth_resolve.Checked:=true;
 edit_mypass.Text:=srv.mypassword;
 edit_remotepass.Text:=srv.remotepassword;
 case srv.compress of
  zcMax: cb_comp_3.Checked:=true;
  zcDefault: cb_comp_2.Checked:=true;
  zcFastest: cb_comp_1.Checked:=true;
  else cb_comp_0.Checked:=true;
 end;
 cb_relink.Checked:=srv.relink>0;
 edit_relink.Value:=srv.relink div 60000;
 edit_comments.Text:=srv.comments;
 if srv.connected=conNotConnected then
 begin
   edit_host.ReadOnly:=false;
   edit_port.ReadOnly:=false;
 end
 else
 begin
   edit_host.ReadOnly:=true;
   edit_port.ReadOnly:=true;
 end;
 try
  Show;
  if srv.connected=conNotConnected then
   edit_host.SetFocus
  else
   edit_ip.SetFocus;
  except
 end;
end;

procedure TSlavaNapServerAttr.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapServerAttr.btn_okClick(Sender: TObject);
begin
 Hide;
 if not running then exit;
 cmd_list.AddDoubleCmd(MSG_CMD_UPDATESERVERPROPS,0,server,'');
end;

end.
