{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: chatform

 Private messages window

*********************************************************}
unit chatform;

interface

uses
  Windows, Messages, SysUtils, Classes, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OfficeEdit, ExtCtrls, SlavaPanel, ComCtrls, Menus;

type
  TSlavaNapChatWindow = class(TForm)
    panel_bottom: TSlavaPanel;
    edit: TEdit;
    panel_left: TSlavaPanel;
    log: TRichEdit;
    MainMenu1: TMainMenu;
    mnu_close: TMenuItem;
    mnu_hotlist: TMenuItem;
    mnu_friend: TMenuItem;
    mnu_whois: TMenuItem;
    mnu_ignore: TMenuItem;
    Timer1: TTimer;
    popup_log: TPopupMenu;
    mnu_log_clear: TMenuItem;
    mnu_log_copy: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure panel_bottomResize(Sender: TObject);
    procedure logChange(Sender: TObject);
    procedure CreateParams(Var params: TCreateParams); override;
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure editKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure mnu_draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect;
      Selected: Boolean);
    procedure mnu_closeClick(Sender: TObject);
    procedure mnu_hotlistClick(Sender: TObject);
    procedure mnu_friendClick(Sender: TObject);
    procedure mnu_whoisClick(Sender: TObject);
    procedure mnu_ignoreClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MyWndProc(var Message: TMessage);
    procedure logMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mnu_log_clearClick(Sender: TObject);
    procedure mnu_log_copyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    user: String;
    history   : TMyStringList;
    last      : Integer;
    flash_count: Integer;
    procedure AddMessage(color: Integer; text: String);
    procedure ChangeColors;
  end;

var
  SlavaNapChatWindow: TSlavaNapChatWindow;

implementation

uses stypes, vars, constants, lang, slavamenu, languages;

{$R *.DFM}

procedure TSlavaNapChatWindow.panel_bottomResize(Sender: TObject);
var
 i,j: Integer;
begin
 edit.Width:=panel_bottom.width-4;
end;

procedure TSlavaNapChatWindow.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapChatWindow.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 history:=TMyStringList.Create;
 WindowProc:=MyWndProc;
 flash_count:=100;
 SetActiveWindow(Handle);
 log.lines.clear;
 edit.text:='';
 SetFont(Self.Font);
 ChangeColors;
 if chat_mini then WindowState:=wsMinimized;
end;

procedure TSlavaNapChatWindow.logChange(Sender: TObject);
var
 c1: TRichEdit;
begin
 if Sender is TRichEdit then
 begin
  c1:=Sender as TRichEdit;
  c1.SelStart := c1.Perform(EM_LINEINDEX, c1.Lines.Count, 0);
  c1.Perform(EM_SCROLLCARET, 0, 0);
  exit;
 end;
end;

procedure TSlavaNapChatWindow.editKeyPress(Sender: TObject;
  var Key: Char);
begin
 if Key=#13 then Key:=#0;
end;

procedure TSlavaNapChatWindow.AddMessage(color: Integer; text: String);
begin
 try
   if log.Lines.Count>300 then
   begin
     log.Lines.BeginUpdate;
     while log.Lines.Count>300 do
      log.Lines.Delete(0);
     log.Lines.EndUpdate;
   end;
   log.SelLength:=0;
   log.SelStart:=Length(log.Text);
   log.SelAttributes.Color:=color;
   //log.Lines.Add(GetLogTime+text);
   log.Lines.Add(text);
   logChange(log);
   if chat_flash then
    flash_count:=0;
  except
 end;
 try
  if switch_chat then
   edit.SetFocus;
  except
 end;
end;

procedure TSlavaNapChatWindow.FormDestroy(Sender: TObject);
var
 i: Integer;
begin
 history.Free;
 history:=nil;
 if cons_chat<>nil then
  for i:=cons_chat.Count-1 downto 0 do
   if cons_chat.Items[i]=self then
    cons_chat.Delete(i);
end;

procedure TSlavaNapChatWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapChatWindow.editKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
 str: String;
 b: Boolean;
begin
 case Key of
   13: try
           if not running then exit;
           str:=edit.text;
           cmd_list.AddDoubleCmd(MSG_CLIENT_PRIVMSG,0,user+' '+str,'');
           Last:=History.Add(str)+1;
           if History.Count>100 then
           begin
            History.Delete(0);
            dec(Last);
           end;
           edit.Text:='';
          except
        end;
   38:  begin // up
           if Last>0 then
           begin
             dec(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
            if History.Count>0 then
            begin
             str:=History.Strings[0];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
            end;
        end;
   40:  begin // down
           if Last<(History.Count-1) then
           begin
             inc(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
           begin
            Last:=History.Count;
            edit.Text:='';
           end;
        end;
 end;
end;

procedure TSlavaNapChatWindow.mnu_draw(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
 SlavaDrawMainMenu(self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapChatWindow.mnu_closeClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapChatWindow.mnu_hotlistClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST,0,user,'');
end;

procedure TSlavaNapChatWindow.mnu_friendClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_FRIENDS,0,'add '+user,'');
end;

procedure TSlavaNapChatWindow.mnu_whoisClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_WHOIS,0,user,'');
end;

procedure TSlavaNapChatWindow.mnu_ignoreClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_IGNORE_USER,0,user,'');
end;

procedure TSlavaNapChatWindow.FormShow(Sender: TObject);
begin
 mnu_close.Caption:=GetLangI(LNG_CMNU_CLOSE);
 mnu_hotlist.Caption:=GetLangI(LNG_CMNU_HOTLIST);
 mnu_friend.Caption:=GetLangI(LNG_CMNU_FRIEND);
 mnu_whois.Caption:=GetLangI(LNG_CMNU_WHOIS);
 mnu_ignore.Caption:=GetLangI(LNG_CMNU_IGNORE);
 mnu_log_clear.Caption:=GetLangI(LNG_MENU_CLEAR);
 mnu_log_copy.Caption:=GetLangI(LNG_MENU_COPY);
end;

procedure TSlavaNapChatWindow.FormResize(Sender: TObject);
begin
 try
  log.Invalidate;
  except
 end;
end;

procedure TSlavaNapChatWindow.Timer1Timer(Sender: TObject);
begin
 if flash_count<11 then
  FlashWindow(handle,not Active);
 if flash_count=11 then
  FlashWindow(handle,false); 
 inc(flash_count);
end;

procedure TSlavaNapChatWindow.FormActivate(Sender: TObject);
begin
 flash_count:=100;
end;

procedure TSlavaNapChatWindow.MyWndProc(var Message: TMessage);
begin
 WndProc(Message);
 if Message.Msg = WM_ACTIVATE then
   flash_count:=100;
end;

procedure TSlavaNapChatWindow.ChangeColors;
begin
 log.Color:=slBackground;
 log.Font.Color:=slText;
 edit.Color:=slBackground;
 edit.Font.Color:=slText;
end;

procedure TSlavaNapChatWindow.logMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if Button=mbRight then
 begin
   popup_log.Popup(mouse.cursorpos.X,mouse.cursorpos.y);
 end;
end;

procedure TSlavaNapChatWindow.mnu_log_clearClick(Sender: TObject);
begin
 log.Lines.Clear;
end;

procedure TSlavaNapChatWindow.mnu_log_copyClick(Sender: TObject);
begin
 log.CopyToClipboard;
end;

end.
 