{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: lang

 Functions for language handling

*********************************************************}
unit lang;

interface

uses
 SysUtils, Classes2, windows, inifiles, constants;

const
 LNG_UNKNOWN                 = '`';
 LNG_LOG_STARTING            = 0;
 LNG_SERVER_LISTEN           = 1;
 LNG_SERVER_LISTENERR        = 2;
 LNG_INVALIDCOMMAND          = 3;
 LNG_INVALIDARGS             = 4;
 LNG_ACCESS                  = 5;
 LNG_NOTLOGGED               = 6;
 LNG_LOGGED                  = 7;
 LNG_NOUSER                  = 8;
 LNG_OFFLINE                 = 9;
 LNG_REMOTE                  = 10;
 LNG_GHOST                   = 11;
 LNG_INVALIDNICK             = 12;
 LNG_INVALIDPASS             = 13;
 LNG_REGISTERED              = 14;
 LNG_USERSLIMIT              = 15;
 LNG_INVSPEED                = 16;
 LNG_REGISTEREDONLY          = 17;
 LNG_USERONLINE              = 18;
 LNG_USEROFFLINE             = 19;
 LNG_LEVEL                   = 20;
 LNG_USEROFFLINE2            = 21;
 LNG_BANNED2                 = 22;
 LNG_USERREGISTER            = 23;
 LNG_MAXCLONES               = 24;
 LNG_NAPIGATOR_ERROR         = 25;
 LNG_NAPIGATOR_REPLY         = 26;
 LNG_NAPIGATOR_SEND          = 27;
 LNG_NAPIGATOR_RESOLVED      = 28;
 LNG_NAPIGATOR_DISCONNECT    = 29;
 LNG_NAPIGATOR_NORESOLVE     = 30;
 LNG_NAPIGATOR_CONNECTED     = 31;
 LNG_NAPIGATOR_CONNECTING    = 32;
 LNG_NAPIGATOR_NOCONNECT     = 33;
 LNG_NAPIGATOR_NOWELCOME     = 34;
 LNG_SERVER_LISTENSTATS      = 35;
 LNG_DISCONNECT_INVCMD       = 36;
 LNG_DISCONNECT_SOCKETERR    = 37;
 LNG_DISCONNECT_SENDTIMEOUT  = 38;
 LNG_INVALIDLEVEL            = 39;
 LNG_LEVEL2                  = 40;
 LNG_LEVEL3                  = 41;
 LNG_KILLED                  = 42;
 LNG_NUKED                   = 43;
 LNG_KICK                    = 44;
 LNG_NUKE                    = 45;
 LNG_SHARE_SHORT             = 46;
 LNG_SHARE_BITRATE           = 47;
 LNG_SHARE_FREQ              = 48;
 LNG_SHARE_ERROR             = 49;
 LNG_SHARE_TIME              = 50;
 LNG_SHARE_LIMIT             = 51;
 LNG_SHARE_TOTAL_LIMIT       = 52;
 LNG_SHARE_MEMORY_LIMIT      = 53;
 LNG_MEMORYLIMIT             = 54;
 LNG_SHARE_SMALL             = 55;
 LNG_SHARE_LARGE             = 56;
 LNG_NOSHARE_BITRATE         = 57;
 LNG_SHARE_10300             = 58;
 LNG_SEARCHLOG3              = 59;
 LNG_TRANSFERLOG3            = 60;
 LNG_TRANSFERLOG4            = 61;
 LNG_TRANSFERLOG5            = 62;
 LNG_FIREWALL                = 63;
 LNG_BROWSEMOD               = 64;
 LNG_TB_BTN_LOG              = 65;
 LNG_TB_BTN_USERS            = 66;
 LNG_TB_BTN_SERVERS          = 67;
 LNG_TB_BTN_CHANNELS         = 68;
 LNG_TB_BTN_FRIENDS          = 69;
 LNG_TB_BTN_BANS             = 70;
 LNG_TB_BTN_HOTLIST          = 71;
 LNG_TB_BTN_IGNORE           = 72;
 LNG_TB_BTN_BLOCKS           = 73;
 LNG_TB_BTN_CONSOLEONLINE    = 74;
 LNG_TB_BTN_REGISTERED       = 75;
 LNG_TB_BTN_LOG_HINT         = 76;
 LNG_TB_BTN_USERS_HINT       = 77;
 LNG_TB_BTN_REGISTERED_HINT  = 78;
 LNG_TB_BTN_SERVERS_HINT     = 79;
 LNG_TB_BTN_CHANNELS_HINT    = 80;
 LNG_TB_BTN_FRIENDS_HINT     = 81;
 LNG_TB_BTN_BANS_HINT        = 82;
 LNG_TB_BTN_HOTLIST_HINT     = 83;
 LNG_TB_BTN_IGNORE_HINT      = 84;
 LNG_TB_BTN_BLOCKS_HINT      = 85;
 LNG_TB_BTN_CONSOLEONLINE_HINT = 86;
 LNG_TB_TOOLBAR_TOTAL        = 87;
 LNG_REG_TRANSFERS           = 88;
 LNG_REG_MUZZLED             = 89;
 LNG_CHANNELMODERATED        = 90;
 LNG_CHANNELOPERATOR         = 91;
 LNG_CHANNELOPERATOR2        = 92;
 LNG_INVALIDCHANNEL          = 93;
 LNG_NOCREATE                = 94;
 LNG_CHANNELLIMIT2           = 95;
 LNG_CHANNELLIMIT            = 96;
 LNG_NOCHANNEL               = 97;
 LNG_CHALREADYBANNED         = 98;
 LNG_CHBANNED                = 99;
 LNG_CHUNBANNED              = 100;
 LNG_TOOMUCHMX               = 101;
 LNG_IPREQMOD                = 102;
 LNG_WHOISMOD                = 103;
 LNG_SAVINGDATA              = 104;
 LNG_LEVEL1                  = 105;
 LNG_FRIENDLOGIN             = 106;
 LNG_ITEMSLISTED             = 107;
 LNG_SRV_PASSWORDSRESET      = 108;
 LNG_CHJOINED                = 110;
 LNG_INVITE                  = 111;
 LNG_MUZZLE1                 = 112;
 LNG_UNMUZZLE1               = 113;
 LNG_MUZZLE3                 = 114;
 LNG_UNMUZZLE3               = 115;
 LNG_MUZZLE                  = 116;
 LNG_FLOODMUZZLE             = 117;
 LNG_UNMUZZLE                = 118;
 LNG_MUZZLEEXPIRE            = 119;
 LNG_CANTTALK                = 120;
 LNG_ALTERSPEED              = 121;
 LNG_ERRCLOAKED              = 122;
 LNG_ERRUNCLOAK              = 123;
 LNG_CLOAKED                 = 124;
 LNG_UNCLOAKED               = 125;
 LNG_CHPASS2                 = 126;
 LNG_CLEARCHANNEL            = 127;
 LNG_CHLEVEL                 = 128;
 LNG_LIMIT                   = 129;
 LNG_CHKICK                  = 130;
 LNG_NOVAR                   = 131;
 LNG_BADVAR                  = 132;
 LNG_CHANGEVAR               = 133;
 LNG_MENU_SERVER             = 134;
 LNG_MENU_SETTINGS           = 135;
 LNG_MENU_LANGUAGES          = 136;
 LNG_MENU_RESTART            = 137;
 LNG_MENU_EXIT               = 138;
 LNG_MENU_LOG                = 139;
 LNG_MENU_CLEAR              = 140;
 LNG_MENU_LOGIN              = 141;
 LNG_MENU_NAPIGATOR          = 142;
 LNG_MENU_RESET              = 143;
 LNG_MENU_SEARCH             = 144;
 LNG_MENU_TRANSFER           = 145;
 LNG_MENU_BLOCK              = 146;
 LNG_MENU_WINDOW             = 147;
 LNG_MENU_LOGWIN             = 148;
 LNG_MENU_USERS              = 149;
 LNG_MENU_SERVERS            = 150;
 LNG_MENU_CHANNELS           = 151;
 LNG_MENU_FRIENDS            = 152;
 LNG_MENU_BANS               = 153;
 LNG_MENU_HOTLIST            = 154;
 LNG_MENU_IGNORE             = 155;
 LNG_MENU_HELP               = 156;
 LNG_MENU_FAQ                = 157;
 LNG_MENU_MANUAL             = 158;
 LNG_MENU_FORUMS             = 159;
 LNG_MENU_UPDATE             = 160;
 LNG_MENU_ABOUT              = 161;
 LNG_MENU_SHOW               = 162;
 LNG_MENU_HIDE               = 163;
 LNG_USERS_LABEL             = 164;
 LNG_LIST_MUZZLED            = 165;
 LNG_LIST_CONSOLE            = 166;
 LNG_LIST_HEADER_NAME        = 167;
 LNG_LIST_HEADER_LEVEL       = 168;
 LNG_LIST_HEADER_SHARED      = 169;
 LNG_LIST_HEADER_SOFTWARE    = 170;
 LNG_LIST_HEADER_SPEED       = 171;
 LNG_LIST_HEADER_IP          = 172;
 LNG_LIST_HEADER_PORT        = 173;
 LNG_LIST_HEADER_SERVER      = 174;
 LNG_REG_USER                = 175;
 LNG_REG_LEVEL               = 176;
 LNG_REG_TRANSFERS2          = 177;
 LNG_REG_IP                  = 178;
 LNG_REG_TIME                = 179;
 LNG_LIST_BTN_MODS           = 180;
 LNG_LIST_BTN_USERS          = 181;
 LNG_LIST_BTN_LEECH          = 182;
 LNG_LIST_BTN_MUZZLED        = 183;
 LNG_LIST_BTN_LOCAL          = 184;
 LNG_LIST_BTN_REMOTE         = 185;
 LNG_OK                      = 186;
 LNG_CANCEL                  = 187;
 LNG_USERSERVER              = 188;
 LNG_REGEXISTS               = 189;
 LNG_REGOK2                  = 190;
 LNG_CHANOP                  = 191;
 LNG_CHNOOPS                 = 192;
 LNG_INVALIDNICK2            = 193;
 LNG_CHANOP2                 = 194;
 LNG_CHANOP3                 = 195;
 LNG_CHANDEOP                = 196;
 LNG_CHANDEOP2               = 197;
 LNG_CHANDEOP3               = 198;
 LNG_CHANDEOP4               = 199;
 LNG_DROPCHANNEL             = 200;
 LNG_UNKNOWNCHMODE           = 201;
 LNG_NOMODERATE              = 203;
 LNG_VOICE                   = 204;
 LNG_VOICE2                  = 205;
 LNG_VOICE3                  = 206;
 LNG_VOICE4                  = 207;
 LNG_DEVOICE                 = 208;
 LNG_DEVOICE2                = 209;
 LNG_DEVOICE3                = 210;
 LNG_DEVOICE4                = 211;
 LNG_DEVOICE5                = 212;
 LNG_ADDFRIEND               = 213;
 LNG_REMOVEFRIEND            = 214;
 LNG_CHLIMIT                 = 215;
 LNG_CHLEVEL2                = 216;
 LNG_CLIENTBLOCK             = 217;
 LNG_MENU_SAVE               = 218;
 LNG_LIST_BTN_KICK           = 219;
 LNG_LIST_BTN_NUKE           = 220;
 LNG_LIST_BTN_MUZZLE         = 221;
 LNG_LIST_BTN_REFRESH        = 222;
 LNG_LIST_BTN_BAN            = 223;
 LNG_LIST_DEFREASON          = 225;
 LNG_LIST_REASONHINT         = 226;
 LNG_LIST_MENU_REFRESH       = 227;
 LNG_LIST_MENU_KILL          = 228;
 LNG_LIST_MENU_NUKE          = 229;
 LNG_LIST_MENU_MUZZLE        = 230;
 LNG_LIST_MENU_BAN           = 231;
 LNG_LIST_MENU_LEVEL         = 233;
 LNG_LIST_MENU_SPEED         = 234;
 LNG_LIST_MENU_IM            = 235;
 LNG_LIST_MENU_SELALL        = 236;
 LNG_LIST_MENU_SELNONE       = 237;
 LNG_LIST_MENU_COPYNAME      = 238;
 LNG_LIST_MENU_WHOIS         = 239;
 LNG_LIST_MENU_FRIEND        = 240;
 LNG_LIST_MENU_HOTLIST       = 241;
 LNG_LIST_MENU_IGNORE        = 242;
 LNG_REG_LABEL               = 243;
 LNG_REG_BTN_MODS            = 244;
 LNG_REG_BTN_USERS           = 245;
 LNG_REG_BTN_LEECH           = 246;
 LNG_REG_BTN_MUZZLED         = 247;
 LNG_REG_BTN_REFRESH         = 248;
 LNG_REG_DEFREASON           = 249;
 LNG_REG_REASONHINT          = 250;
 LNG_REG_BTN_NUKE            = 251;
 LNG_REG_BTN_BAN             = 252;
 LNG_REG_BTN_BANIP           = 253;
 LNG_REG_MENU_REFRESH        = 254;
 LNG_REG_MENU_NUKE           = 255;
 LNG_REG_MENU_BAN            = 256;
 LNG_REG_MENU_BANIP          = 257;
 LNG_REG_MENU_LEVEL          = 258;
 LNG_REG_MENU_SELALL         = 259;
 LNG_REG_MENU_SELNONE        = 260;
 LNG_REG_MENU_COPYNAME       = 261;
 LNG_CH_LABEL                = 262;
 LNG_CLIST_NAME              = 263;
 LNG_CLIST_USERS             = 264;
 LNG_CLIST_MAXUSERS          = 265;
 LNG_CLIST_LEVEL             = 266;
 LNG_CLIST_STATUS            = 267;
 LNG_CLIST_TOPIC             = 268;
 LNG_CLIST_BANS              = 269;
 LNG_CLIST_OPS               = 270;
 LNG_CLIST_VOICES            = 271;
 LNG_CBTN_REFRESH            = 272;
 LNG_CBTN_JOIN               = 273;
 LNG_CBTN_PROPS              = 274;
 LNG_CBTN_ADD                = 275;
 LNG_CBTN_DELETE             = 276;
 LNG_CH_REASONHINT           = 277;
 LNG_EDIT_NAPIGATOR          = 278;
 LNG_EDIT_ADDCHANNEL         = 279;
 LNG_CH_REGISTERED           = 280;
 LNG_CH_MODERATED            = 281;
 LNG_CH_PRIVATE              = 282;
 LNG_CH_TOPIC                = 283;
 LNG_CMENU_REFRESH           = 284;
 LNG_CMENU_JOIN              = 285;
 LNG_CMENU_DELETE            = 286;
 LNG_CMENU_CLEAR             = 287;
 LNG_CMENU_ADD               = 288;
 LNG_CMENU_PROPS             = 289;
 LNG_CMENU_TOPIC             = 290;
 LNG_CMENU_SELECTALL         = 291;
 LNG_CMENU_SELECTNONE        = 292;
 LNG_CMENU_COPYNAME          = 293;
 LNG_CH_CHTOPIC              = 294;
 LNG_CH_JOIN                 = 295;
 LNG_CH_PART                 = 296;
 LNG_CH_USERLIST             = 297;
 LNG_CHCREATED               = 298;
 LNG_EDITCH_CAPTION          = 299;
 LNG_EDITCH_TOPIC            = 300;
 LNG_EDITCH_LIMIT            = 301;
 LNG_EDITCH_LEVEL            = 302;
 LNG_EDITCH_MOTD             = 303;
 LNG_EDITCH_OK               = 304;
 LNG_EDITCH_CANCEL           = 305;
 LNG_EDITCH_ATTR             = 306;
 LNG_EDITCH_REGISTERED       = 307;
 LNG_EDITCH_PRIVATE          = 308;
 LNG_EDITCH_MODERATED        = 309;
 LNG_EDITCH_TOPICATTR        = 310;
 LNG_BANS_NEVER_EXPIRE       = 311;
 LNG_BANS_LABEL              = 312;
 LNG_BBTN_REFRESH            = 313;
 LNG_BBTN_BAN                = 314;
 LNG_BBTN_UNBAN              = 315;
 LNG_BLIST_NAME              = 316;
 LNG_BLIST_IP                = 317;
 LNG_BLIST_ADMIN             = 318;
 LNG_BLIST_TIMESET           = 319;
 LNG_BLIST_EXPIRES           = 320;
 LNG_BLIST_REASON            = 321;
 LNG_BANS_BANHINT            = 322;
 LNG_BANS_REASONHINT         = 323;
 LNG_LINKED                  = 324;
 LNG_LINKREQ                 = 325;
 LNG_SLIST_HOST              = 326;
 LNG_SLIST_PORT              = 327;
 LNG_SLIST_STATUS            = 328;
 LNG_SLIST_AUTH              = 329;
 LNG_SLIST_USERS             = 330;
 LNG_SLIST_RELINK            = 331;
 LNG_SLIST_COMMENTS          = 332;
 LNG_SERVERS_LABEL           = 333;
 LNG_SRV_DISCONNECTED        = 334;
 LNG_SRV_LOGGED              = 335;
 LNG_SRV_HUB                 = 336;
 LNG_SRV_CONNECTING          = 337;
 LNG_SRV_LOGGING             = 338;
 LNG_SRV_PASSWORD            = 339;
 LNG_SRV_RESOLVE             = 340;
 LNG_SBTN_REFRESH            = 341;
 LNG_DELINK                  = 342;
 LNG_LINKERRRESOLVE          = 343;
 LNG_LINKERRCONNECT          = 344;
 LNG_LINKCONNECTED           = 345;
 LNG_LINKBADVERSION          = 346;
 LNG_LINKBADVERSION2         = 347;
 LNG_LINKNOLIST              = 348;
 LNG_LINKNOLIST2             = 349;
 LNG_LINKLOGGED              = 350;
 LNG_LINKLOGGED2             = 351;
 LNG_LINKLOGGING             = 352;
 LNG_LINKLOGGING2            = 353;
 LNG_LINKNOLINK              = 354;
 LNG_LINKNOLINK2             = 355;
 LNG_LINKINVHANDLE           = 356;
 LNG_LINKINVHANDLE2          = 357;
 LNG_LINKINVHANDLE3          = 358;
 LNG_LINKINVIP               = 359;
 LNG_LINKINVIP2              = 360;
 LNG_LINKERRLOGIN            = 361;
 LNG_DELINKHUB               = 362;
 LNG_LINKINVPASS             = 363;
 LNG_LINKINVPASS2            = 364;
 LNG_LINKSRVLOGGED           = 365;
 LNG_LINKSRVLOGGED2          = 366;
 LNG_LINKLOGINERR            = 367;
 LNG_SERVERGHOST             = 368;
 LNG_LINKINVCONSOLE          = 369;
 LNG_SBTN_CONNECT2           = 370;
 LNG_SBTN_DISCONNECT         = 371;
 LNG_NOSUCHSERVER            = 372;
 LNG_CANTDELINK              = 373;
 LNG_DELINKREQ               = 374;
 LNG_VOICE5                  = 375;
 LNG_VOICE6                  = 376;
 LNG_CHANOP4                 = 377;
 LNG_LINKSRVLOGGED3          = 378;
 LNG_INVLINKHANDLE           = 379;
 LNG_LINKINVHANDLE4          = 380;
 LNG_SEARCHLOG4              = 381;
 LNG_DELINK2                 = 382;
 LNG_LBL_IGNORED             = 383;
 LNG_IBTN_REFRESH            = 384;
 LNG_IBTN_ADD                = 385;
 LNG_IBTN_REMOVE             = 386;
 LNG_ILIST_USER              = 387;
 LNG_IEDIT_HINT              = 388;
 LNG_LBL_FRIENDS             = 389;
 LNG_FBTN_REFRESH            = 390;
 LNG_FBTN_ADD                = 391;
 LNG_FBTN_REMOVE             = 392;
 LNG_FLIST_USER              = 393;
 LNG_FEDIT_HINT              = 394;
 LNG_LBL_BLOCKS              = 395;
 LNG_BLBTN_REFRESH           = 396;
 LNG_BLBTN_ADD               = 397;
 LNG_BLBTN_REMOVE            = 398;
 LNG_BLLIST_ITEM             = 399;
 LNG_BLEDIT_HINT             = 400;
 LNG_SBTN_DELETE             = 401;
 LNG_SBTN_ADD                = 402;
 LNG_SBTN_PROPS              = 403;
 LNG_SHOST_HINT              = 404;
 LNG_EDITSRV_CAPTION         = 405;
 LNG_EDITSRV_HOST            = 406;
 LNG_EDITSRV_PORT            = 407;
 LNG_EDITSRV_IPINFO          = 408;
 LNG_EDITSRV_IPTEXT          = 409;
 LNG_EDITSRV_BOX             = 410;
 LNG_EDITSRV_RESOLVE         = 411;
 LNG_EDITSRV_PASSWORD        = 412;
 LNG_EDITSRV_MYPASS          = 413;
 LNG_EDITSRV_REMOTEPASS      = 414;
 LNG_EDITSRV_BOX2            = 415;
 LNG_EDITSRV_COMP0           = 416;
 LNG_EDITSRV_COMP1           = 417;
 LNG_EDITSRV_COMP2           = 418;
 LNG_EDITSRV_COMP3           = 419;
 LNG_EDITSRV_COMMENTS        = 420;
 LNG_EDITSRV_RELINK          = 421;
 LNG_EDITSRV_OK              = 422;
 LNG_EDITSRV_CANCEL          = 423;
 LNG_REMOVESERVER            = 424;
 LNG_CANTREMOVE              = 425;
 LNG_LINKREQ2                = 426;
 LNG_SRV_RELINKTIME          = 427;
 LNG_MENU_WEB                = 428;
 LNG_HLIST_NAME              = 429;
 LNG_HLIST_SERVER            = 430;
 LNG_HLIST_SPEED             = 431;
 LNG_HBTN_REFRESH            = 432;
 LNG_HBTN_ADD                = 433;
 LNG_HBTN_DELETE             = 434;
 LNG_HEDIT_HINT              = 435;
 LNG_HLIST_OFFLINE           = 436;
 LNG_LABEL_HOTLIST           = 437;
 LNG_MENU_REGISTERED         = 438;
 LNG_BANS_TIME60             = 443;
 LNG_BANS_TIME300            = 444;
 LNG_BANS_TIME600            = 445;
 LNG_BANS_TIME1800           = 446;
 LNG_BANS_TIME3600           = 447;
 LNG_BANS_TIME10800          = 448;
 LNG_BANS_TIME43200          = 449;
 LNG_BANS_TIME86400          = 450;
 LNG_BANS_TIME259200         = 451;
 LNG_BANS_TIME604800         = 452;
 LNG_BANS_TIME1209600        = 453;
 LNG_BANS_TIME2678400        = 454;
 LNG_BANS_TIME5184000        = 455;
 LNG_BANS_TIME7776000        = 456;
 LNG_BANS_TIME31536000       = 457;
 LNG_REG_HINT_USER           = 459;
 LNG_REG_HINT_PASSWORD       = 460;
 LNG_REG_HINT_LEVEL          = 461;
 LNG_REG_BTN_REGISTER        = 462;
 LNG_LIST_HINT_BAN           = 463;
 LNG_REG_HINT_BAN            = 464;
 LNG_NUKEMSG                 = 465;
 LNG_KICKMSG                 = 466;
 LNG_KICKMSG2                = 467;
 LNG_SLIST_LAG               = 468;
 LNG_SLIST_LAGSEC            = 469;
 LNG_SBTN_AUTOREFRESH        = 470;
 LNG_LOG_LABEL               = 471;
 LNG_LOG_CLEAR               = 472;
 LNG_CHAT                    = 473;
 LNG_CMNU_CLOSE              = 474;
 LNG_CMNU_HOTLIST            = 475;
 LNG_CMNU_FRIEND             = 476;
 LNG_CMNU_WHOIS              = 477;
 LNG_CMNU_IGNORE             = 478;
 LNG_LIST_BTN_KICKBAN        = 479;
 LNG_LIST_MENU_KICKBAN       = 480;
 LNG_ST_BYTES                = 481;
 LNG_ST_TIME                 = 482;
 LNG_ST_LOCAL                = 483;
 LNG_ST_LOCALMAX             = 484;
 LNG_ST_TOTAL                = 485;
 LNG_ST_TOTALMAX             = 486;
 LNG_ST_LASTTRANSFER         = 487;
 LNG_ST_LASTDATA             = 488;
 LNG_ST_TOTALTRANSFER        = 489;
 LNG_ST_TOTALDATA            = 490;
 LNG_MINSHARE                = 491;
 LNG_MINSHARE2               = 492;
 LNG_MINSHARE_REASON         = 493;
 LNG_ST_NOLINK               = 495;
 LNG_ST_LINK                 = 496;
 LNG_MINSHARE3               = 497;
 LNG_MINSHARE4               = 498;
 LNG_MINSHARE_REASON2        = 499;
 LNG_DISCONNECT_WINMX        = 502;
 LNG_BLOCKEDWINMX            = 503;
 LNG_REASON_WINMXBAN          = 504;
 LNG_SMENU_REFRESH           = 505;
 LNG_SMENU_CONNECT2          = 506;
 LNG_SMENU_DISCONNECT        = 507;
 LNG_SMENU_DELETE            = 508;
 LNG_SMENU_COMP              = 509;
 LNG_SMENU_COMP0             = 510;
 LNG_SMENU_COMP1             = 511;
 LNG_SMENU_COMP2             = 512;
 LNG_SMENU_COMP3             = 513;
 LNG_SMENU_STARTUP           = 514;
 LNG_SMENU_STARTUP2          = 515;
 LNG_SMENU_LINK300           = 516;
 LNG_SMENU_LINK600           = 517;
 LNG_SMENU_LINK900           = 518;
 LNG_SMENU_LINK1200          = 519;
 LNG_SMENU_LINK1800          = 520;
 LNG_SMENU_PROPS             = 521;
 LNG_SMENU_SELECTALL         = 522;
 LNG_SMENU_SELECTNONE        = 523;
 LNG_SMENU_COPYNAME          = 524;
 LNG_BANEXPCHANGE            = 525;
 LNG_BANREASONCHANGE         = 526;
 LNG_WHOIS_CAPTION           = 527;
 LNG_WHOIS_USER              = 528;
 LNG_WHOIS_LEVEL             = 529;
 LNG_WHOIS_TIME              = 530;
 LNG_WHOIS_CHANNELS          = 531;
 LNG_WHOIS_STATUS            = 532;
 LNG_WHOIS_SHARED            = 533;
 LNG_WHOIS_TRANSFERS         = 534;
 LNG_WHOIS_SPEED             = 535;
 LNG_WHOIS_SOFTWARE          = 536;
 LNG_WHOIS_TOTAL             = 537;
 LNG_WHOIS_IP                = 538;
 LNG_WHOIS_PORT              = 539;
 LNG_WHOIS_DATAPORT          = 540;
 LNG_WHOIS_SERVER            = 541;
 LNG_WHOIS_WHOWAS            = 542;
 LNG_BMENU_REFRESH           = 543;
 LNG_BMENU_UNBAN             = 544;
 LNG_BMENU_COPYUSER          = 545;
 LNG_BMENU_COPYIP            = 546;
 LNG_BMENU_COPYBAN           = 547;
 LNG_BMENU_COPYADMIN         = 548;
 LNG_BMENU_COPYREASON        = 549;
 LNG_BMENU_SELALL            = 550;
 LNG_BMENU_SELNONE           = 551;
 LNG_HMENU_REFRESH           = 552;
 LNG_HMENU_IM                = 553;
 LNG_HMENU_WHOIS             = 554;
 LNG_HMENU_FRIEND            = 555;
 LNG_HMENU_DELETE            = 556;
 LNG_HMENU_SELALL            = 557;
 LNG_HMENU_SELNONE           = 558;
 LNG_HMENU_COPYNAME          = 559;
 LNG_IMENU_REFRESH           = 560;
 LNG_IMENU_DELETE            = 561;
 LNG_IMENU_SELALL            = 562;
 LNG_IMENU_SELNONE           = 563;
 LNG_IMENU_COPYNAME          = 564;
 LNG_FMENU_REFRESH           = 565;
 LNG_FMENU_DELETE            = 566;
 LNG_FMENU_SELALL            = 567;
 LNG_FMENU_SELNONE           = 568;
 LNG_FMENU_COPYNAME          = 569;
 LNG_BMNU_REFRESH            = 570;
 LNG_BMNU_DELETE             = 571;
 LNG_BMNU_SELALL             = 572;
 LNG_BMNU_SELNONE            = 573;
 LNG_BMNU_COPYNAME           = 574;
 LNG_WMENU_CLOSE             = 575;
 LNG_WMENU_HOTLIST           = 576;
 LNG_WMENU_FRIEND            = 577;
 LNG_WMENU_IGNORE            = 578;
 LNG_WMENU_MESSAGE           = 579;
 LNG_CHMNU_IM                = 580;
 LNG_CHMNU_WHOIS             = 581;
 LNG_CHMNU_OP                = 582;
 LNG_CHMNU_DEOP              = 583;
 LNG_CHMNU_VOICE             = 584;
 LNG_CHMNU_UNVOICE           = 585;
 LNG_CHMNU_BAN               = 586;
 LNG_CHMNU_BANIP             = 587;
 LNG_CHMNU_KICK              = 588;
 LNG_CHMNU_COPYNAME          = 589;
 LNG_ST_BPS                  = 590;
 LNG_LIST_CLOAKED            = 591;
 LNG_LIST_CHATTING           = 592;
 LNG_CONSOLEPONG             = 593;
 LNG_NAPIGATOR_AUTODISCONNECT = 594;
 LNG_CMENU_CLEARBANS         = 595;
 LNG_BANNED3                 = 596;
 LNG_ST_BANDWIDTHLIMIT       = 597;
 LNG_BANDWIDTHLIMIT          = 598;
 LNG_INV_CAPTION             = 599;
 LNG_INV_NAME                = 600;
 LNG_INV_TOPIC               = 601;
 LNG_INV_ACCEPT              = 602;
 LNG_INV_DENY                = 603;
 LNG_INV_IGNORE              = 604;
 LNG_INV_WHOIS               = 605;
 LNG_INV_HOTLIST             = 606;
 LNG_INV_PRIVMSG             = 607;
 LNG_INV_MESSAGE             = 608;
 LNG_S_ITEM_MAIN             = 609;
 LNG_S_TEXT_MAIN             = 610;
 LNG_S_ITEM_USERS            = 611;
 LNG_S_TEXT_USERS            = 612;
 LNG_S_ITEM_LIMITS           = 613;
 LNG_S_TEXT_LIMITS           = 614;
 LNG_S_ITEM_INTERFACE        = 615;
 LNG_S_TEXT_INTERFACE        = 616;
 LNG_S_ITEM_LOG              = 617;
 LNG_S_TEXT_LOG              = 618;
 LNG_S_ITEM_SHARE            = 619;
 LNG_S_TEXT_SHARE            = 620;
 LNG_S_ITEM_SHARE_MP3        = 621;
 LNG_S_TEXT_SHARE_MP3        = 622;
 LNG_S_ITEM_SHARE_AUDIO      = 623;
 LNG_S_TEXT_SHARE_AUDIO      = 624;
 LNG_S_ITEM_SHARE_VIDEO      = 625;
 LNG_S_TEXT_SHARE_VIDEO      = 626;
 LNG_S_ITEM_SHARE_IMAGES     = 627;
 LNG_S_TEXT_SHARE_IMAGES     = 628;
 LNG_S_ITEM_SHARE_APP        = 629;
 LNG_S_TEXT_SHARE_APP        = 630;
 LNG_S_ITEM_SHARE_CD         = 631;
 LNG_S_TEXT_SHARE_CD         = 632;
 LNG_S_ITEM_SHARE_TEXT       = 633;
 LNG_S_TEXT_SHARE_TEXT       = 634;
 LNG_S_ITEM_NAPIGATOR        = 635;
 LNG_S_TEXT_NAPIGATOR        = 636;
 LNG_S_ITEM_SEARCH           = 637;
 LNG_S_TEXT_SEARCH           = 638;
 LNG_S_ITEM_LEVELS           = 639;
 LNG_S_TEXT_LEVELS           = 640;
 LNG_S_ITEM_CHANNELS         = 641;
 LNG_S_TEXT_CHANNELS         = 642;
 LNG_S_ITEM_CONSOLE          = 643;
 LNG_S_TEXT_CONSOLE          = 644;
 LNG_S_ITEM_BLOCKED          = 645;
 LNG_S_TEXT_BLOCKED          = 646;
 LNG_S_ITEM_LINKS            = 647;
 LNG_S_TEXT_LINKS            = 648;
 LNG_S_ITEM_SOCKETS          = 649;
 LNG_S_TEXT_SOCKETS          = 650;
 LNG_S_ITEM_OTHER            = 651;
 LNG_S_TEXT_OTHER            = 652;
 LNG_S_ITEM_REPORT           = 653;
 LNG_S_TEXT_REPORT           = 654;
 LNG_S_ITEM_MINSHARE         = 655;
 LNG_S_TEXT_MINSHARE         = 656;
 LNG_S_ITEM_MOTD             = 657;
 LNG_S_TEXT_MOTD             = 658;
 LNG_S_CAPTION               = 659;
 LNG_S_BTN_CHANGE            = 660;
 LNG_S_BTN_SAVE              = 661;
 LNG_S_BTN_RESTORE           = 662;
 LNG_S_BTN_CLOSE             = 663;
 LNG_S_LBL_NOTE              = 664;
 LNG_S_LBL_CHANGE            = 665;
 LNG_S_LBL_SAVE              = 666;
 LNG_FLOODWARN               = 667;
 LNG_FLOODMUZZLE1            = 668;
 LNG_FLOODMUZZLE2            = 669;
 LNG_S_ITEM_COLORS           = 670;
 LNG_S_TEXT_COLORS           = 671;
 LNG_LOG_CB_AWAY             = 672;
 LNG_LOG_LBL_AWAY            = 673;
 LNG_LOG_MODE                = 674;
 LNG_MODE_ERROR              = 675;
 LNG_MODE_ANNOUNCE           = 676;
 LNG_MODE_MBAN               = 677;
 LNG_MODE_CHANGE             = 678;
 LNG_MODE_KILL               = 679;
 LNG_MODE_LEVEL              = 680;
 LNG_MODE_SERVER             = 681;
 LNG_MODE_MUZZLE             = 682;
 LNG_MODE_PORT               = 683;
 LNG_MODE_WALLOP             = 684;
 LNG_MODE_CLOAK              = 685;
 LNG_MODE_FLOOD              = 686;
 LNG_MODE_MSG                = 687;
 LNG_MODE_WHOIS              = 688;
 LNG_MODE_BROWSE             = 689;
 LNG_MODE_FRIEND             = 690;
 LNG_MODE_CHANNEL            = 691;
 LNG_MODE_REGISTER           = 692;
 LNG_MODE_VAR                = 693;
 LNG_MODE_OK                 = 694;
 LNG_MODE_ALL                = 695;
 LNG_MODE_NONE               = 696;
 LNG_MODE_CANCEL             = 697;
 LNG_MODE_CAPTION            = 698;
 LNG_ACCESSREG               = 699;
 LNG_LINKNOLIST3             = 700;
 LNG_LINKNOLIST1             = 701;
 LNG_S_ITEM_LINKS2           = 702;
 LNG_S_TEXT_LINKS2           = 703;
 LNG_OUTGOINGRESTRICTED      = 704;
 LNG_CHTOPIC                 = 705;
 LNG_RECONNECT               = 706;
 LNG_LOG_CB_AWAYPOPUP        = 707;
 LNG_LIST_EDIT_FILTER_HINT   = 708;
 LNG_LIST_HEADER_TIME        = 709;
 LNG_LIST_HEADER_TRANSFERS   = 710;
 LNG_LIST_HEADER_TOTAL       = 711;
 LNG_LIST_BTN_MODE           = 712;
 LNG_LIST_MNU2_LEVEL         = 713;
 LNG_LIST_MNU2_SHARED        = 714;
 LNG_LIST_MNU2_SOFT          = 715;
 LNG_LIST_MNU2_SPEED         = 716;
 LNG_LIST_MNU2_IP            = 717;
 LNG_LIST_MNU2_PORT          = 718;
 LNG_LIST_MNU2_TIME          = 719;
 LNG_LIST_MNU2_TRANSFERS     = 720;
 LNG_LIST_MNU2_TOTAL         = 721;
 LNG_LIST_MNU2_SERVER        = 722;
 LNG_LOG_CB_SOUND            = 723;
 LNG_LINKINVCONSOLE2         = 724;
 LNG_LINKINVCONSOLE3         = 725;
 LNG_REG_EDIT_FILTER_HINT    = 726;
 LNG_REG_CLOAKED             = 727;
 LNG_EDIT_DAGSTA             = 728;
 LNG_S_ITEM_DAGSTA           = 729;
 LNG_S_TEXT_DAGSTA           = 730;
 LNG_DAGSTA_CONNECTED        = 731;
 LNG_DAGSTA_ERROR            = 732;
 LNG_DAGSTA_REPLY            = 733;
 LNG_DAGSTA_SEND             = 734;
 LNG_DAGSTA_DISCONNECT       = 735;
 LNG_DAGSTA_CONNECTING       = 736;
 LNG_DAGSTA_NOCONNECT        = 737;
 LNG_DAGSTA_NORESOLVE        = 738;
 LNG_DAGSTA_RESOLVED         = 739;
 LNG_DAGSTA_NOWELCOME        = 740;
 LNG_DAGSTA_AUTODISCONNECT   = 741;
 LNG_MENU_DAGSTA             = 742;
 LNG_BROWSEFAIL              = 743;
 LNG_BROWSELEECH             = 744;
 LNG_BROWSEFIREWALL          = 745;
 LNG_OFFLINE2                = 746;
 LNG_LINKING                 = 747;
 LNG_INVALIDSOFTWARE         = 748;
 LNG_ALREADYREGISTERED       = 749;
 LNG_LIST_MENU_REGISTER      = 750;
 LNG_LIST_BTN_REGISTER       = 751;
 LNG_CANTKILL                = 752;
 LNG_KILLSERVER              = 753;
 LNG_MODE_PING               = 754;
 LNG_LIST_BTN_BANIP          = 755;
 LNG_LIST_MENU_BANIP         = 756;
 LNG_LIST_BTN_KICKBANIP      = 757;
 LNG_LIST_MENU_KICKBANIP     = 758;
 LNG_MENU_COPY               = 759;
 LNG_LOG_PAUSE               = 760;
 LNG_LOG_RESUME              = 761;
 LNG_SHAREFILESFIRST         = 762;
 LNG_SHAREMEGSFIRST          = 763;
 LNG_LIST_CB_SOUND           = 764;
 LNG_HLIST_CB_SOUND          = 765;
 LNG_SLIST_ALIAS             = 766;
 LNG_SLIST_REDIRECTS         = 767;
 LNG_BLBTN_RELOAD            = 768;
 LNG_LIST_NOPONG             = 769;
 LNG_S_ITEM_BLOCKEDMX        = 770;
 LNG_S_TEXT_BLOCKEDMX        = 771;
 LNG_LIST_WINMXH             = 772;
 LNG_MENU_BROWSE             = 773;
 LNG_BROWSELOG1              = 774;
 LNG_BROWSELOG2              = 775;
 LNG_S_ITEM_BLOCKS           = 776;
 LNG_S_TEXT_BLOCKS           = 777;
 LNG_SAMENIC                 = 778;
 LNG_BLIST_LASTATTEMPT       = 779;
 LNG_BLIST_USING             = 780;
 LNG_BLIST_TRIES             = 781;
 LNG_LNGFILE_VERSION         = 782;
 LNG_MSGFILE_VERSION         = 783;
 LNG_INVALIDLNGFILE          = 784;
 LNG_FLOODMUZZLE3            = 785;
 LNG_UNREGISTER              = 786;
 LNG_MODE_MBANCONN           = 787;
 LNG_MODE_SBAN               = 788;
 LNG_MODE_SBANCONN           = 789;
 LNG_MODE_LEECH              = 790;
 LNG_MODE_SAMENIC            = 791;
 LNG_BANS_UNBANREASONHINT    = 792;
 LNG_REG_BTN_UNREGISTER      = 793;
 LNG_REG_MENU_UNREGISTER     = 794;
 LNG_CHMNU_LEVEL             = 795;
 LNG_CHMNU_MUZZLE            = 796;
 LNG_CHMNU_FRIENDS           = 797;
 LNG_LINKMAXSERVERS          = 798;
 LNG_LINKMAXSERVERS2         = 799;
 LNG_OFFLINE3                = 800;
 LNG_S_ITEM_OTHER2           = 801;
 LNG_S_TEXT_OTHER2           = 802;
 LNG_S_ITEM_OTHER3           = 803;
 LNG_S_TEXT_OTHER3           = 804;
 LNG_S_ITEM_OTHER4           = 805;
 LNG_S_TEXT_OTHER4           = 806;
 LNG_BRMNU_CHARSET                             = 807;
 LNG_BRMNU_CHARSET_SHIFTJIS                    = 808;
 LNG_BRMNU_CHARSET_CHINESEBIG5                 = 809;
 LNG_BRMNU_CHARSET_GB2312                      = 810;
 LNG_BRMNU_CHARSET_HANGEUL                     = 811;
 LNG_BRMNU_CHARSET_EASTEUROPE                  = 812;
 LNG_BRMNU_CHARSET_RUSSIAN                     = 813;

 LNG_S_SHMAIN_LABEL1                           = 1001;
 LNG_S_SHMAIN_LABEL3                           = 1002;
 LNG_S_SHMAIN_LABEL4                           = 1003;
 LNG_S_SHMAIN_LABEL66                          = 1004;
 LNG_S_SHMAIN_LABEL67                          = 1005;
 LNG_S_SHMAIN_LABEL75                          = 1006;
 LNG_S_SHMAIN_LABEL76                          = 1007;
 LNG_S_SHMAIN_LBL_HANDLE                       = 1008;
 LNG_S_SHMAIN_LABEL127                         = 1009;
 LNG_S_SHMAIN_LABEL138                         = 1010;
 LNG_S_SHUSERS_LABEL5                          = 1021;
 LNG_S_SHUSERS_LABEL9                          = 1022;
 LNG_S_SHUSERS_LABEL12                         = 1023;
 LNG_S_SHUSERS_LABEL79                         = 1024;
 LNG_S_SHUSERS_LABEL2                          = 1025;
 LNG_S_SHUSERS_LABEL128                        = 1026;
 LNG_S_SHUSERS_CB_USERS_REG_ONLY               = 1027;
 LNG_S_SHUSERS_CB_USERS_REG_ALLOW              = 1028;
 LNG_S_SHUSERS_CB_USERS_NOREMOTE               = 1029;
 LNG_S_SHUSERS_CB_USERS_REDIRECTCQEX           = 1030;
 LNG_S_SHUSERS_CB_USERS_RECONNECT              = 1031;
 LNG_S_SHLIMITS_LABEL6                         = 1041;
 LNG_S_SHLIMITS_LABEL7                         = 1042;
 LNG_S_SHLIMITS_LABEL8                         = 1043;
 LNG_S_SHLIMITS_LABEL99                        = 1044;
 LNG_S_SHLIMITS_LABEL100                       = 1045;
 LNG_S_SHLIMITS_LABEL10                        = 1046;
 LNG_S_SHLIMITS_LABEL11                        = 1047;
 LNG_S_SHLIMITS_CB_LIMITS_LIMITSERVERS         = 1048;
 LNG_S_SHINTERFACE_LABEL77                     = 1061;
 LNG_S_SHINTERFACE_LABEL78                     = 1062;
 LNG_S_SHINTERFACE_LABEL152                    = 1063;
 LNG_S_SHINTERFACE_CB_INTERFACE_STARTUP        = 1064;
 LNG_S_SHINTERFACE_CB_INTERFACE_NOSWITCH       = 1065;
 LNG_S_SHINTERFACE_CB_INTERFACE_CHATFLASH      = 1066;
 LNG_S_SHINTERFACE_CB_INTERFACE_SYSTRAY        = 1067;
 LNG_S_SHINTERFACE_CB_INTERFACE_CHATMINI       = 1068;
 LNG_S_SHINTERFACE_CB_INTERFACE_WALLOP         = 1069;
 LNG_S_SHINTERFACE_CB_INTERFACE_NOCPU          = 1070;
 LNG_S_SHINTERFACE_CB_INTERFACE_WALLOPSOUND    = 1071;
 LNG_S_SHINTERFACE_CB_INTERFACE_REMOTEADMINOK  = 1072;
 LNG_S_SHLOG_CB_LOG_LOGIN                      = 1091;
 LNG_S_SHLOG_CB_LOG_NAPIGATOR                  = 1092;
 LNG_S_SHLOG_CB_LOG_SEARCH                     = 1093;
 LNG_S_SHLOG_CB_LOG_TRANSFERS                  = 1094;
 LNG_S_SHLOG_CB_LOG_USERS                      = 1095;
 LNG_S_SHLOG_CB_LOG_SAVE                       = 1096;
 LNG_S_SHLOG_CB_LOG_SERVERS                    = 1097;
 LNG_S_SHLOG_CB_LOG_SERVERSTATS                = 1098;
 LNG_S_SHLOG_CB_LOG_CLEARSERVERSTATS           = 1099;
 LNG_S_SHLOG_CB_LOG_CLEARCLIENTSTATS           = 1100;
 LNG_S_SHLOG_CB_LOG_CONSOLE                    = 1101;
 LNG_S_SHLOG_CB_LOG_DAGSTA                     = 1102;
 LNG_S_SHLOG_CB_LOG_BROWSE                     = 1103;
 LNG_S_SHSHARE_LABEL13                         = 1121;
 LNG_S_SHSHARE_LABEL14                         = 1122;
 LNG_S_SHSHARE_LABEL15                         = 1123;
 LNG_S_SHSHARE_LABEL16                         = 1124;
 LNG_S_SHSHARE_LABEL101                        = 1125;
 LNG_S_SHSHARE_LABEL149                        = 1126;
 LNG_S_SHSHARE_LABEL150                        = 1127;
 LNG_S_SHSHARE_CB_SHARE_DISABLE                = 1128;
 LNG_S_SHSHARE_CB_SHARE_INFORM                 = 1129;
 LNG_S_SHSHARE_CB_SHARE_NOMODEM                = 1130;
 LNG_S_SHSHARE_CB_SHARE_CHECKDUP               = 1131;
 LNG_S_SHSHARE_CB_SHARE_FRIENDADD              = 1132;
 LNG_S_SHSHAREMP3_LABEL17                      = 1151;
 LNG_S_SHSHAREMP3_LABEL18                      = 1152;
 LNG_S_SHSHAREMP3_LABEL19                      = 1153;
 LNG_S_SHSHAREMP3_LABEL20                      = 1154;
 LNG_S_SHSHAREMP3_LABEL45                      = 1155;
 LNG_S_SHSHAREMP3_LABEL46                      = 1156;
 LNG_S_SHSHAREMP3_CB_MP3_320                   = 1157;
 LNG_S_SHSHAREMP3_CB_MP3_256                   = 1158;
 LNG_S_SHSHAREMP3_CB_MP3_224                   = 1159;
 LNG_S_SHSHAREMP3_CB_MP3_192                   = 1160;
 LNG_S_SHSHAREMP3_CB_MP3_160                   = 1161;
 LNG_S_SHSHAREMP3_CB_MP3_128                   = 1162;
 LNG_S_SHSHAREMP3_CB_MP3_112                   = 1163;
 LNG_S_SHSHAREMP3_CB_MP3_96                    = 1164;
 LNG_S_SHSHAREMP3_CB_MP3_80                    = 1165;
 LNG_S_SHSHAREMP3_CB_MP3_64                    = 1166;
 LNG_S_SHSHAREMP3_CB_MP3_56                    = 1167;
 LNG_S_SHSHAREMP3_CB_MP3_48                    = 1168;
 LNG_S_SHSHAREMP3_CB_MP3_40                    = 1169;
 LNG_S_SHSHAREMP3_CB_MP3_32                    = 1170;
 LNG_S_SHSHAREMP3_CB_MP3_24                    = 1171;
 LNG_S_SHSHAREMP3_CB_MP3_0                     = 1172;
 LNG_S_SHSHAREAUDIO_LABEL21                    = 1191;
 LNG_S_SHSHAREAUDIO_LABEL22                    = 1192;
 LNG_S_SHSHAREAUDIO_LABEL23                    = 1193;
 LNG_S_SHSHAREAUDIO_LABEL24                    = 1194;
 LNG_S_SHSHAREVIDEO_LABEL25                    = 1201;
 LNG_S_SHSHAREVIDEO_LABEL26                    = 1202;
 LNG_S_SHSHAREVIDEO_LABEL27                    = 1203;
 LNG_S_SHSHAREVIDEO_LABEL28                    = 1204;
 LNG_S_SHSHAREIMAGES_LABEL29                   = 1221;
 LNG_S_SHSHAREIMAGES_LABEL30                   = 1222;
 LNG_S_SHSHAREIMAGES_LABEL31                   = 1223;
 LNG_S_SHSHAREIMAGES_LABEL32                   = 1224;
 LNG_S_SHSHAREAPPS_LABEL33                     = 1241;
 LNG_S_SHSHAREAPPS_LABEL34                     = 1242;
 LNG_S_SHSHAREAPPS_LABEL35                     = 1243;
 LNG_S_SHSHAREAPPS_LABEL36                     = 1244;
 LNG_S_SHSHARECD_LABEL37                       = 1261;
 LNG_S_SHSHARECD_LABEL38                       = 1262;
 LNG_S_SHSHARECD_LABEL39                       = 1263;
 LNG_S_SHSHARECD_LABEL40                       = 1264;
 LNG_S_SHSHARETEXT_LABEL41                     = 1281;
 LNG_S_SHSHARETEXT_LABEL42                     = 1282;
 LNG_S_SHSHARETEXT_LABEL43                     = 1283;
 LNG_S_SHSHARETEXT_LABEL44                     = 1284;
 LNG_S_SHNAPIGATOR_LABEL61                     = 1301;
 LNG_S_SHNAPIGATOR_LABEL62                     = 1302;
 LNG_S_SHNAPIGATOR_LABEL63                     = 1303;
 LNG_S_SHNAPIGATOR_LABEL64                     = 1304;
 LNG_S_SHNAPIGATOR_LABEL65                     = 1305;
 LNG_S_SHNAPIGATOR_LABEL73                     = 1306;
 LNG_S_SHNAPIGATOR_LABEL97                     = 1307;
 LNG_S_SHNAPIGATOR_LABEL126                    = 1308;
 LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_PASSWORD      = 1309;
 LNG_S_SHNAPIGATOR_CB_NAPIGATOR_ENABLED        = 1310;
 LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_DISCONNECT    = 1311;
 LNG_S_SHNAPIGATOR_CB_NAPIGATOR_AUTODISCONNECT = 1312;
 LNG_S_SHSEARCH_LABEL47                        = 1331;
 LNG_S_SHSEARCH_LABEL48                        = 1332;
 LNG_S_SHSEARCH_LABEL49                        = 1333;
 LNG_S_SHSEARCH_LABEL50                        = 1334;
 LNG_S_SHSEARCH_LABEL72                        = 1335;
 LNG_S_SHSEARCH_LBL_SEARCH_MAXREMOTE           = 1336;
 LNG_S_SHSEARCH_CB_SEARCH_DISABLE_REMOTE       = 1337;
 LNG_S_SHLEVELS_LABEL54                        = 1351;
 LNG_S_SHLEVELS_LABEL55                        = 1352;
 LNG_S_SHLEVELS_LABEL56                        = 1353;
 LNG_S_SHLEVELS_LABEL57                        = 1354;
 LNG_S_SHLEVELS_LABEL58                        = 1355;
 LNG_S_SHLEVELS_LABEL59                        = 1356;
 LNG_S_SHLEVELS_LABEL60                        = 1357;
 LNG_S_SHLEVELS_LABEL102                       = 1358;
 LNG_S_SHLEVELS_BTN_LEVEL_DEFAULT              = 1359;
 LNG_S_SHCHANNELS_LABEL52                      = 1371;
 LNG_S_SHCHANNELS_LABEL53                      = 1372;
 LNG_S_SHCHANNELS_LABEL82                      = 1373;
 LNG_S_SHCHANNELS_LABEL83                      = 1374;
 LNG_S_SHCHANNELS_LBL_FLOOD1                   = 1375;
 LNG_S_SHCHANNELS_LBL_FLOOD2                   = 1376;
 LNG_S_SHCHANNELS_CB_CHANNELS_ALLOWCREATE      = 1377;
 LNG_S_SHCHANNELS_CB_CHANNELS_BLOCKCQEX        = 1378;
 LNG_S_SHCHANNELS_CB_CHANNELS_OLDWALLOP        = 1379;
 LNG_S_SHCHANNELS_CB_CHANNELS_SHOWOPS          = 1380;
 LNG_S_SHCHANNELS_CB_CHANNELS_TIMESTAMP        = 1381;
 LNG_S_SHCHANNELS_CB_CHANNELS_LOW              = 1382;
 LNG_S_SHCHANNELS_CB_CHANNELS_PREVENTSHOUT     = 1383;
 LNG_S_SHCHANNELS_CB_CHANNELS_FLOOD_WARN       = 1384;
 LNG_S_SHCHANNELS_CB_CHANNELS_FLOODENABLE      = 1385;
 LNG_S_SHCONSOLE_LABEL69                       = 1401;
 LNG_S_SHCONSOLE_LABEL70                       = 1402;
 LNG_S_SHCONSOLE_LABEL71                       = 1403;
 LNG_S_SHCONSOLE_LABEL144                      = 1404;
 LNG_S_SHCONSOLE_LABEL145                      = 1405;
 LNG_S_SHCONSOLE_LABEL146                      = 1406;
 LNG_S_SHCONSOLE_LABEL147                      = 1407;
 LNG_S_SHBLOCKED_LABEL68                       = 1421;
 LNG_S_SHBLOCKED_CB_BLOCK_NAPSTER              = 1422;
 LNG_S_SHBLOCKED_CB_BLOCK_AUDIOGNOME           = 1423;
 LNG_S_SHBLOCKED_CB_BLOCK_GNOMEPLUS            = 1424;
 LNG_S_SHBLOCKED_CB_BLOCK_AMSTER               = 1425;
 LNG_S_SHBLOCKED_CB_BLOCK_FILENAVIGATOR        = 1426;
 LNG_S_SHBLOCKED_CB_BLOCK_CQEX                 = 1427;
 LNG_S_SHBLOCKED_CB_BLOCK_SUNSHINEUN           = 1428;
 LNG_S_SHBLOCKED_CB_BLOCK_TEKNAP               = 1429;
 LNG_S_SHBLOCKED_CB_BLOCK_NAP                  = 1430;
 LNG_S_SHBLOCKED_CB_BLOCK_MACNAP               = 1431;
 LNG_S_SHBLOCKED_CB_BLOCK_MP3RAGE              = 1432;
 LNG_S_SHBLOCKED_CB_BLOCK_XNAP                 = 1433;
 LNG_S_SHBLOCKED_CB_BLOCK_SPOTLIGHT            = 1434;
 LNG_S_SHBLOCKED_CB_BLOCK_NFS                  = 1435;
 LNG_S_SHBLOCKED_CB_BLOCK_DMNAPSTER            = 1436;
 LNG_S_SHBLOCKED_CB_BLOCK_KNAPSTER             = 1437;
 LNG_S_SHBLOCKED_CB_BLOCK_LOPSTER              = 1438;
 LNG_S_SHBLOCKED_CB_BLOCK_RAPIGATOR            = 1439;
 LNG_S_SHBLOCKED_CB_BLOCK_SWAPTOR              = 1440;
 LNG_S_SHBLOCKED_CB_BLOCK_OTHER                = 1441;
 LNG_S_SHBLOCKED_LABEL74                       = 1442;
 LNG_S_SHBLOCKED_CB_BLOCK_DAGSTA               = 1443;
 LNG_S_SHBLOCKED_CB_BLOCK_FLOODSTER            = 1444;
 LNG_S_SHBLOCKED_CB_BLOCK_DRUMBEAT             = 1445;
 LNG_S_SHBLOCKED_CB_BLOCK_CUSTOMMESSAGE        = 1446;
 LNG_S_SHBLOCKED_CB_BLOCK_DEFAULTMESSAGE       = 1447;
 LNG_S_SHBLOCKED_CB_BLOCK_NOMESSAGE            = 1448;
 LNG_S_SHBLOCKED_LBL_BLOCK_MESSAGE             = 1449;
 LNG_S_SHBLOCKED_CB_BLOCK_MLDONKEY             = 1450;
 LNG_S_SHBLOCKED_CB_BLOCK_NAPIGATOR            = 1451;
 LNG_S_SHBLOCKED_CB_BLOCK_NAP08                = 1452;
 LNG_S_SHBLOCKED_CB_BLOCK_OPENNAP              = 1453;
 LNG_S_SHLINKS_LABEL98                         = 1471;
 LNG_S_SHLINKS_LABEL139                        = 1472;
 LNG_S_SHLINKS_LABEL141                        = 1473;
 LNG_S_SHLINKS_LABEL151                        = 1474;
 LNG_S_SHLINKS_CB_LINK_ALL                     = 1475;
 LNG_S_SHLINKS_CB_LINK_LIST                    = 1476;
 LNG_S_SHLINKS_CB_LINK_LIST2                   = 1477;
 LNG_S_SHLINKS_CB_LINK_NONE                    = 1478;
 LNG_S_SHLINKS_CB_LINK_HUB                     = 1479;
 LNG_S_SHLINKS_CB_LINK_SYNCREG                 = 1480;
 LNG_S_SHLINKS_CB_LINK_NOAUTOCONNECT           = 1481;
 LNG_S_SHLINKS_CB_LINK_SYNCBAN                 = 1482;
 LNG_S_SHLINKS_CB_LINK_RESTRICTOUTGOING        = 1483;
 LNG_S_SHLINKS_CB_META_ENABLED                 = 1484;
 LNG_S_SHLINKS_CB_LINK_SYNCBLOCK               = 1485;
 LNG_S_SHLINKS_CB_LINK_MAXSERVERS              = 1486;
 LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_SEND        = 1501;
 LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_RECV        = 1502;
 LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_SEND      = 1503;
 LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_RECV      = 1504;
 LNG_S_SHSOCKETS_LABEL81                       = 1505;
 LNG_S_SHSOCKETS_CB_SOCKETS_USERS_DEF          = 1506;
 LNG_S_SHSOCKETS_CB_SOCKETS_SERVERS_DEF        = 1507;
 LNG_S_SHREPORT_LABEL148                       = 1521;
 LNG_S_SHREPORT_CB_REPORT_OLD_ENABLE           = 1522;
 LNG_S_SHREPORT_LABEL89                        = 1523;
 LNG_S_SHREPORT_CB_REPORT_NEW_ENABLED          = 1524;
 LNG_S_SHREPORT_CB_REPORT_NEW_HIDEHUB          = 1525;
 LNG_S_SHREPORT_LABEL90                        = 1526;
 LNG_S_SHREPORT_CB_REPORT_TRUESTATS            = 1527;
 LNG_S_SHREPORT_KSOOFFICEGROUPBOX2             = 1528;
 LNG_S_SHREPORT_KSOOFFICEGROUPBOX3             = 1529;
 LNG_S_SHOTHER_LABEL84                         = 1541;
 LNG_S_SHOTHER_CB_ANN_ENABLE                   = 1542;
 LNG_S_SHOTHER_LABEL85                         = 1543;
 LNG_S_SHOTHER_LABEL86                         = 1544;
 LNG_S_SHOTHER_LABEL87                         = 1545;
 LNG_S_SHOTHER_LABEL88                         = 1546;
 LNG_S_SHOTHER_KSOOFFICEGROUPBOX1              = 1547;
 LNG_S_SHMINSHARE_LABEL91                      = 1561;
 LNG_S_SHMINSHARE_LABEL92                      = 1562;
 LNG_S_SHMINSHARE_LABEL93                      = 1563;
 LNG_S_SHMINSHARE_LABEL94                      = 1564;
 LNG_S_SHMINSHARE_LABEL95                      = 1565;
 LNG_S_SHMINSHARE_LABEL160                     = 1566;
 LNG_S_SHMINSHARE_CB_MINSHARE_BAN              = 1567;
 LNG_S_SHMINSHARE_CB_MINSHARE_ONLYFULL         = 1568;
 LNG_S_SHMINSHARE_CB_MINSHARE_BANIP            = 1569;
 LNG_S_SHMINSHARE_CB_MINSHARE_FULL10           = 1570;
 LNG_S_SHMINSHARE_CB_MINSHARE_KICKCHAT         = 1571;
 LNG_S_SHMINSHARE_CB_MINSHARE_WALLOP           = 1572;
 LNG_S_SHMOTD_LABEL96                          = 1591;
 LNG_S_SHCOLORS_LABEL104                       = 1601;
 LNG_S_SHCOLORS_LABEL105                       = 1602;
 LNG_S_SHCOLORS_LABEL106                       = 1603;
 LNG_S_SHCOLORS_LABEL107                       = 1604;
 LNG_S_SHCOLORS_LABEL108                       = 1605;
 LNG_S_SHCOLORS_LABEL109                       = 1606;
 LNG_S_SHCOLORS_LABEL110                       = 1607;
 LNG_S_SHCOLORS_LABEL111                       = 1608;
 LNG_S_SHCOLORS_LABEL112                       = 1609;
 LNG_S_SHCOLORS_LABEL113                       = 1610;
 LNG_S_SHCOLORS_LABEL114                       = 1611;
 LNG_S_SHCOLORS_LABEL115                       = 1612;
 LNG_S_SHCOLORS_LABEL116                       = 1613;
 LNG_S_SHCOLORS_LABEL117                       = 1614;
 LNG_S_SHCOLORS_LABEL118                       = 1615;
 LNG_S_SHCOLORS_LABEL119                       = 1616;
 LNG_S_SHCOLORS_LABEL120                       = 1617;
 LNG_S_SHCOLORS_LABEL121                       = 1618;
 LNG_S_SHCOLORS_LABEL122                       = 1619;
 LNG_S_SHCOLORS_LABEL123                       = 1620;
 LNG_S_SHCOLORS_LABEL124                       = 1621;
 LNG_S_SHCOLORS_LABEL125                       = 1622;
 LNG_S_SHCOLORS_LABEL136                       = 1623;
 LNG_S_SHCOLORS_LABEL51                        = 1624;
 LNG_S_SHCOLORS_BTN_COLORS_DEFAULT             = 1625;
 LNG_S_SHLINKS2_LABEL80                        = 1641;
 LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCH           = 1642;
 LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCHREQ        = 1643;
 LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSE           = 1644;
 LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSEREQ        = 1645;
 LNG_S_SHDAGSTA_LABEL103                       = 1661;
 LNG_S_SHDAGSTA_LABEL129                       = 1662;
 LNG_S_SHDAGSTA_LABEL130                       = 1663;
 LNG_S_SHDAGSTA_LABEL131                       = 1664;
 LNG_S_SHDAGSTA_LABEL132                       = 1665;
 LNG_S_SHDAGSTA_LABEL133                       = 1666;
 LNG_S_SHDAGSTA_LABEL134                       = 1667;
 LNG_S_SHDAGSTA_LABEL135                       = 1668;
 LNG_S_SHDAGSTA_LABEL137                       = 1669;
 LNG_S_SHDAGSTA_BTN_DAGSTA_PASSWORD            = 1670;
 LNG_S_SHDAGSTA_CB_DAGSTA_ENABLED              = 1671;
 LNG_S_SHDAGSTA_BTN_DAGSTA_DISCONNECT          = 1672;
 LNG_S_SHDAGSTA_CB_DAGSTA_AUTODISCONNECT       = 1673;
 LNG_S_SHBLOCKEDWINMX_LBL_BLOCKMX_PERCENTAGE   = 1691;
 LNG_S_SHBLOCKEDWINMX_LABEL140                 = 1692;
 LNG_S_SHBLOCKEDWINMX_LABEL142                 = 1693;
 LNG_S_SHBLOCKEDWINMX_LABEL143                 = 1694;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_NORMAL        = 1695;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_LIMIT         = 1696;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_DETECT        = 1697;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_JAP           = 1698;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_PONG          = 1699;
 LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_BAN           = 1700;
 LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE          = 1711;
 LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE_ADMINS   = 1712;
 LNG_S_SHBLOCKS_CB_BLOCKS_CHECKMODS            = 1713;
 LNG_FONT_CHARSET                              = 1731;
 LNG_FONT_SIZE                                 = 1732;
 LNG_FONT_NAME                                 = 1733;
 LNG_S_SHOTHER2_LABEL153                       = 1751;
 LNG_S_SHOTHER2_LABEL154                       = 1752;
 LNG_S_SHOTHER2_GB_SEARCHBLOCK                 = 1753;
 LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKFILES        = 1754;
 LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKSIZE         = 1755;
 LNG_S_SHOTHER2_RD_SEARCHBLOCK_HARD            = 1756;
 LNG_S_SHOTHER2_RD_SEARCHBLOCK_NORMAL          = 1757;
 LNG_S_SHOTHER2_GB_DOMBLOCK                    = 1758;
 LNG_S_SHOTHER2_CB_DOMBLOCK_CHKFILES           = 1759;
 LNG_S_SHOTHER2_CB_DOMBLOCK_CHKSIZE            = 1760;
 LNG_S_SHOTHER2_RD_DOMBLOCK_HARD               = 1761;
 LNG_S_SHOTHER2_RD_DOMBLOCK_NORMAL             = 1762;
 LNG_S_SHOTHER2_GB_DLFLOODBLOCK                = 1763;
 LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BAN            = 1764;
 LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BLOCK          = 1765;
 LNG_S_SHOTHER2_RD_DLFLOODBLOCK_LEECH          = 1766;
 LNG_S_SHOTHER2_GB_WQFLOODBLOCK                = 1767;
 LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BAN            = 1768;
 LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BLOCK          = 1769;
 LNG_S_SHOTHER2_RD_WQFLOODBLOCK_LEECH          = 1770;
 LNG_S_SHOTHER2_CB_NOCOUNT_TEXT                = 1771;
 LNG_S_SHOTHER2_CB_AUTOBAN_INCOMPLETE          = 1772;
 LNG_S_SHOTHER2_CB_DISABLE_FAKEEXT             = 1773;
 LNG_S_SHOTHER2_CB_ENABLE_TRAPPORT             = 1774;
 LNG_S_SHOTHER2_CB_BLOCK_TRANSFERPORT          = 1775;
 LNG_S_SHOTHER2_CB_SHARE_MATCHEDFILE_ONLY      = 1776;
 LNG_S_SHOTHER3_LABEL156                       = 1791;
 LNG_S_SHOTHER3_LABEL157                       = 1792;
 LNG_S_SHOTHER3_LABEL158                       = 1793;
 LNG_S_SHOTHER3_LABEL159                       = 1794;
 LNG_S_SHOTHER3_GROUPBOX1                      = 1795;
 LNG_S_SHOTHER3_CB_ENABLE_LOGINIM              = 1796;
 LNG_S_SHOTHER3_LABEL155                       = 1797;
 LNG_S_SHOTHER3_CB_CHANNELS_FORCEENTER         = 1798;
 LNG_S_SHOTHER3_CB_ALLOW_2BYTENAME             = 1799;
 LNG_S_SHOTHER3_CB_CHECK_LOGINPASS             = 1801;
 LNG_S_SHOTHER3_CB_ENABLE_MSGSERV              = 1802;
 LNG_S_SHOTHER3_CB_RESTRICT_HITPERUSER         = 1803;
 LNG_S_SHOTHER3_CB_REFRESH_SERVERS             = 1804;
 LNG_S_SHOTHER3_RD_XBUTTON_ATTR                = 1805;
 LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS1         = 1806;
 LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS2         = 1807;
 LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS3         = 1808;
 LNG_S_SHOTHER3_CB_KILL_IDLEUSER               = 1809;
 LNG_S_SHOTHER3_LABEL161                       = 1810;
 LNG_S_SHOTHER3_LABEL162                       = 1811;
 LNG_S_SHOTHER3_CB_MINSHARE_NOBLOCKACT         = 1812;
 LNG_S_SHOTHER3_CB_DENY_LISTALL_FOR_USERS      = 1813;
 LNG_S_SHOTHER3_CB_BLOCK_WEIRD_XNAPFILE        = 1814;
 LNG_S_SHOTHER3_CB_SUGGEST_DBROWSE             = 1815;
 LNG_S_SHOTHER4_CB_REGSOFT_ONLY                = 1821;
 LNG_S_SHOTHER4_CB_ALLOW_NAPSTER               = 1822;
 LNG_S_SHOTHER4_CB_ALLOW_WINMX                 = 1823;
 LNG_S_SHOTHER4_CB_ALLOW_NAPCHAN               = 1824;
 LNG_S_SHOTHER4_CB_ALLOW_TEKNAP                = 1825;
 LNG_S_SHOTHER4_CB_ALLOW_LOPSTER               = 1826;
 LNG_S_SHOTHER4_CB_ALLOW_XNAP                  = 1827;
 LNG_S_SHOTHER4_CB_ALLOW_UTATANE               = 1828;
 LNG_S_SHOTHER4_CB_ALLOW_2GET                  = 1829;
 LNG_S_SHOTHER4_CB_ALLOW_OTHER                 = 1830;
 LNG_S_SHOTHER4_LABEL163                       = 1831;
 LNG_MAX                                       = 1840;//832;

 // strings that shouldn't be translated
 STR_NOTIMPLEMENTED         = 'R}h [%d] '+SLAVANAP_VERSION_SHORT+'ł̓T|[g܂B';
 STR_DEFAULTTOPIC           = '悤%s`lցI'; // default channel topic
 STR_BAN_NUKE               = 'AJEg폜܂B'; // default reason for bans via 'nuke' command
 STR_SERVER_SHUT_DOWN       = 'T[o[Vbg_EĂ܂... ΂炭҂';
 STR_SERVER_SHUT_DOWN2      = '15bȓɃVbg_EȂx "Vbg_E"(܂"ċN")ĂB';
 STR_DEBUGCOMMAND           = 'Received command [%d] "%s" (%s)';
 STR_DEBUGCOMMAND_X         = 'Received compressed command [%d] "%s" (%s)';
 STR_DEBUGCOMMAND_NEW       = 'Received command [%d] "%s" (%s) (big-endian)';
 STR_DEBUGSEND              = 'Sending command [%d] "%s" (%s)';
 STR_DEBUGSEND_NEW          = 'Sending command [%d] "%s" (%s) (big-endian)';
 STR_DEBUGCOMMAND2          = 'Recv [%d] "%s" (%s)';
 STR_DEBUGCOMMAND2_NEW      = 'Recv [%d] "%s" (%s) (big-endian)';
 STR_INVALIDCOMMAND3        = 'Invalid command [%d] "%s" (server %s)';
 STR_INVALIDCOMMAND2        = 'Invalid command [%d] "%s" (%s)'; // [%d] - ID, "%s" - command text, (%s) - software
 STR_INVALIDCOMMAND2_NEW    = 'Invalid command [%d] "%s" (%s) (big-endian)'; // [%d] - ID, "%s" - command text, (%s) - software
 STR_INVALIDVERSION         = 'T[o[o[W(%s)܂B[go[W"%s"łB';
 STR_INVALIDSERVERHOST      = 'T[o[zXg܂B';
 STR_SELFCONNECT            = 'T[o[zXg܂Bgɐڑ悤ƂĂ܂񂩁HH';
 STR_INVALIDRESOLVE         = 'T[o[zXg܂BȂIP%sŁA%s IP%słBzXgIPꍇ̓[gT[o[łȂ̃T[o[̔F؂"pX[h`FbN"ɕύXĂB';
 STR_INVALIDRESOLVE2        = 'T[o[zXg܂B%sIPł܂BzXgIPꍇ̓[gT[o[łȂ̃T[o[̔F؂"pX[h`FbN"ɕύXĂB';
 STR_INVALIDSERVERPASS      = 'pX[h܂B';
 STR_NOINCOMING             = '̃T[o[͊ÕT[o[ڑ󂯓܂B';
 STR_MESSAGE                = '* ';
 STR_REMOTEMESSAGE          = '(%s) * ';

 // channel built-in commands. should NOT be translated

 STR_CHSTR_LIST             = '">help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWN          = '"%s"͕sȃR}hłB">help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWNADMIN     = '"%s"͕sȃR}hłB">admin help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWNSERVER    = '"%s"͕sȃR}hłB">server help"ŃR}hꗗ܂B';
 STR_CHSTR_BAN              = ': >ban <user>';
 STR_CHSTR_BANIP            = ': >banip <user>';
 STR_CHSTR_UNBAN            = ': >unban <user>';
 STR_CHSTR_OP               = ': >op <user> [<user2> ...]';
 STR_CHSTR_DEOP             = ': >deop <user> [<user2> ...]';
 STR_CHSTR_KICK             = ': >kick <user> [reason]';
 STR_CHSTR_VOICE            = ': >voice <user> [<user2> ...]';
 STR_CHSTR_UNVOICE          = ': >unvoice <user> [<user2> ...]';
 STR_CHSTR_WHOIS            = ': >whois <user>';
 STR_CHSTR_INVITE           = ': >invite <user>';
 STR_CHSTR_REMOVE           = ': >remove <channel> [reason]';
 STR_CHSTR_SHOWSERVER       = ': >showserver <user>';
 STR_CHSTR_A_REGISTER       = ': >admin register <user> [<password> [<email> [<level>]]]';
 STR_CHSTR_A_BAN            = ': >admin ban <user!ip> [reason]';
 STR_CHSTR_A_UNBAN          = ': >admin unban <user!ip>';
 STR_CHSTR_A_FRIENDS        = ': >admin friends add|remove|list [user]';
 STR_CHSTR_A_REDIRECT       = ': >admin redirect <server> <port>';
 STR_CHSTR_A_CYCLE          = ': >admin cycle <metaserver>';
 STR_CHSTR_A_IP             = ': >admin ip <user>';
 STR_CHSTR_A_KILL           = ': >admin kill <jerk> [reason]';
 STR_CHSTR_A_UNREGISTER     = ': >admin unregister <nic> [reason]';
 STR_CHSTR_A_NUKE           = ': >admin nuke <user> [reason]';
 STR_CHSTR_A_MUZZLE         = ': >admin muzzle <user> [reason]';
 STR_CHSTR_A_UNMUZZLE       = ': >admin unmuzzle <user> [reason]';
 STR_CHSTR_A_LEVEL          = ': >admin level <user> <level>';
 STR_CHSTR_S_PING           = ': >server ping <server> [<server2> ...]';
 STR_CHSTR_S_REMOVE         = ': >server remove <server>';
 STR_CHSTR_S_CONNECT        = ': >server connect <server>[:<port>]';
 STR_CHSTR_S_DISCONNECT     = ': >server disconnect <server>';

 // help
 STR_CHHLP_MAIN             = SLAVANAP_FULL+' help.';
 STR_CHHLP_HELPLIST         = 'płR}ḧꗗ :';
 STR_CHHLP_HELPLISTADMIN    = 'płTuR}ḧꗗ :';
 STR_CHHLP_HELPLISTSERVER   = 'płTuR}ḧꗗ :';
 STR_CHHLP_BAN              = '>ban <user> '#9#9#9'- ̃`l烆[U[֎~';
 STR_CHHLP_BANIP            = '>banip <user> '#9#9#9'- IPw肵ē֎~';
 STR_CHHLP_BANCLEAR         = '>banclear '#9#9#9'- ֎~ׂĉ';
 STR_CHHLP_BANLIST          = '>banlist '#9#9#9#9'- `l̓֎~҂ꗗ';
 STR_CHHLP_CLS              = '>cls '#9#9#9#9'- ʂNA';
 STR_CHHLP_HELP             = '>help '#9#9#9#9'- ̃bZ[W\';
 STR_CHHLP_OPSAY            = '>opsay <message> '#9#9'- ̃`lׂ̂ẴIy[^[ɃbZ[W𑗂';
 STR_CHHLP_OPEMOTE          = '>opemote <message> '#9#9'- ̃`lׂ̂ẴIy[^[ɊbZ[W𑗂';
 STR_CHHLP_UNBAN            = '>unban <user> '#9#9#9'- [U[̓֎~';
 STR_CHHLP_OP               = '>op <user> [<user2> ...] '#9#9'- ̃`l̃Iy[^[ɂ';
 STR_CHHLP_OPLIST           = '>oplist '#9#9#9#9'- ׂẴIy[^[̈ꗗ("User"x̐l̂)';
 STR_CHHLP_DEOP             = '>deop <user> [<user2> ...] '#9#9'- ̃`l̃Iy[^[͂';
 STR_CHHLP_PART             = '>part '#9#9#9#9'- ̃`lގ';
 STR_CHHLP_EMOTE            = '>me <message> '#9#9#9'- emote(\)';
 STR_CHHLP_KICK             = '>kick <user> [reason] '#9#9'- ̃`l烆[U[Ǖ';
 STR_CHHLP_TOPIC            = '>topic [topic] '#9#9#9'- VgsbNݒ';
 STR_CHHLP_DROP             = '>drop [reason] '#9#9#9'- ̃`l폜';
 STR_CHHLP_REMOVE           = '>remove <channel> [reason] '#9'- ̃`l폜';
 STR_CHHLP_CLEAR            = '>clear [reason] '#9#9#9'- ̃`l炷ׂẴ[U[Ǖ';
 STR_CHHLP_VOICE            = '>voice <user> [<user2> ...] '#9#9'- [U[ɂ̃`lł̔^';
 STR_CHHLP_UNVOICE          = '>unvoice <user> [<user2> ...] '#9'- グ';
 STR_CHHLP_WHOIS            = '>whois <user> '#9#9#9'- [U[̏擾';
 STR_CHHLP_MODE             = '>mode [+|- <mode> ...] '#9#9'- `l[h̕ύX';
 STR_CHHLP_RAW              = '>raw <number> [arguments ...] '#9'- R}hԍŎw肵Ďs';
 STR_CHHLP_LIMIT            = '>limit <number> '#9#9#9'- `l̒ݒ';
 STR_CHHLP_LEVEL            = '>level <level> '#9#9#9'- `lɓłŒ჆[U[xݒ';
 STR_CHHLP_INVITE           = '>invite <user> '#9#9#9'- [U[`lɏ';
 STR_CHHLP_USERMODE         = '>usermode [+|- <mode> ...] '#9#9'- Ȃ̃[hύX. ">usermode help" Ń[hꗗ';
 STR_CHHLP_SHOWSERVER       = '>showserver <user> '#9#9'- [U[OCĂT[o[\';
 STR_CHHLP_LISTFRIENDS      = '>listfriends '#9#9#9'- FlXg\';
 STR_CHHLP_MSG              = '>msg <user> <message> '#9#9'- vCx[gbZ[W(IM)𑗐M';
 STR_CHHLP_CONSOLE          = '>console '#9#9#9'- T[o[̐[[U[̖O\';
 STR_CHHLP_VERSION          = '>version '#9#9#9'- T[o[\tgEFÃo[W\';
 STR_CHHLP_ADMIN            = '>admin <sub-command> [<args>...] '#9'- ǗҗpR}h. ">admin help" ŏڍ';
 STR_CHHLP_SERVER           = '>server <sub-command> [<args>...] '#9'- T[o[ÑR}h. ">server help" ŏڍ';
 STR_CHHLP_GHOST            = '>ghost [<user>] '#9#9#9'- ȂƓIPŃS[XgɂȂĂ郆[U[ؒf';
 STR_CHHLP_A_REGISTER       = '>admin register <name> [<password> <email> <level>] '#9'- [U[̐VKo^';
 STR_CHHLP_A_REGLIST        = '>admin reglist '#9#9#9'- o^ς݃[U[̈ꗗ\';
 STR_CHHLP_A_BAN            = '>admin ban <user!ip> [reason] '#9'- [U[OC֎~';
 STR_CHHLP_A_BANLIST        = '>admin banlist '#9#9#9'- OC֎~҂̈ꗗ';
 STR_CHHLP_A_UNBAN          = '>admin unban <user!ip> '#9#9'- [U[̃OC֎~';
 STR_CHHLP_A_FRIENDS        = '>admin friends add|remove|list [user] '#9'- Flǉ/폜/ꗗ';
 STR_CHHLP_A_ANNOUNCE       = '>admin announce <message> '#9'- ׂẴ[U[ɃAiEX';
 STR_CHHLP_A_WALLOP         = '>admin wallop <message> '#9#9'- ׂĂmods+ɃbZ[W𑗂';
 STR_CHHLP_A_REDIRECT       = '>admin redirect <server> <port> '#9'- ̃T[o[ɂׂẴ[U[_CNg (قƂǂ̃NCAgŃT|[gĂ܂)';
 STR_CHHLP_A_CYCLE          = '>admin cycle <metaserver> '#9'- ^T[o[ɂׂẴ[U[_CNg (قƂǂ̃NCAgŃT|[gĂ܂)';
 STR_CHHLP_A_SOFTWARE       = '>admin software '#9#9#9'- NCAg̓v\';
 STR_CHHLP_A_IP             = '>admin ip <user> '#9#9#9'- [U[IP擾';
 STR_CHHLP_A_VARIABLE       = '>admin set <variable> [value] '#9'- T[o[ϐ̕ύX';
 STR_CHHLP_A_VARIABLE2      = '>admin set <variable> '#9#9'- T[o[ϐ擾';
 STR_CHHLP_A_REMOTEVARIABLE = '>admin setremote <server> [variable] [value]'#9'- [gT[o[ϐ̕\/ύX';
 STR_CHHLP_A_REMOTEVARIABLE2= '>admin setremote <server> [variable] '#9'- [gT[o[ϐ̕\';
 STR_CHHLP_A_ALLREMOTEVARIABLE = '>admin setallremote <variable> [value] '#9'- ׂẴ[gT[o[̕ϐ̕\/ύX';
 STR_CHHLP_A_ALLREMOTEVARIABLE2 = '>admin setallremote <variable> '#9#9'- ׂẴ[gT[o[̕ϐ̕\';
 STR_CHHLP_A_KILL           = '>admin kill <jerk> [reason] '#9#9'- [U[ؒf';
 STR_CHHLP_A_NUKE           = '>admin nuke <user> [reason] '#9'- [U[̃AJEg폜';
 STR_CHHLP_A_MUZZLE         = '>admin muzzle <user> [reason] '#9'- [U[𔭌֎~';
 STR_CHHLP_A_UNMUZZLE       = '>admin unmuzzle <user> [reason] '#9'- [U[̔֎~';
 STR_CHHLP_A_LEVEL          = '>admin level <user> <level> '#9'- [U[x̕ύX';
 STR_CHHLP_A_CLOAK          = '>admin cloak [1|0] '#9#9'- N[N';
 STR_CHHLP_A_BLOCK          = '>admin block <somekeyword> '#9'- w肵L[[hubN';
 STR_CHHLP_A_BLOCKS         = '>admin blocks '#9#9#9'- ubNĂL[[hꗗ';
 STR_CHHLP_A_UNBLOCK        = '>admin unblock <somekeyword> '#9'- w肵L[[h̃ubN';
 STR_CHHLP_A_BLOCKED        = '>admin blocked '#9#9#9'- Ot@CL悤Ƃ[U[̈ꗗ';
 STR_CHHLP_A_CLIENTBLOCKS   = '>admin clientblocks '#9#9#9'- ubNĂNCAg̈ꗗ';
 STR_CHHLP_A_SERVERMSG      = '>admin servermsg <user> <message> '#9'- <Server>̖OŃ[U[ɓvCx[gbZ[W𑗐M';
 STR_CHHLP_A_UNREGISTER     = '>admin unregister <user> [reason] '#9'- [U[̓o^ (nuke̐ؒfȂ)';
 STR_CHHLP_S_VERSION        = '>server version '#9#9#9'- T[o[o[W̎擾';
 STR_CHHLP_S_PING           = '>server ping <server> [<server2> ...] '#9'- T[o[ping';
 STR_CHHLP_S_PINGALL        = '>server pingall '#9#9#9'- ׂẴNT[o[ping';
 STR_CHHLP_S_REMOVE         = '>server remove <server> '#9#9'- ꗗT[o[폜';
 STR_CHHLP_S_REBOOT         = '>server reboot <password> '#9#9'- T[o[PCċN';
 STR_CHHLP_S_RESTART        = '>server restart '#9#9#9'- SlavaNapċN';
 STR_CHHLP_S_CONNECT        = '>server connect <server>[:<port>] '#9'- T[o[N';
 STR_CHHLP_S_DISCONNECT     = '>server disconnect <server> '#9'- T[o[ؒf';
 STR_CHHLP_S_CONSOLE        = '>server console '#9#9#9'- [[U[̖O擾';
 STR_CHHLP_S_LINKS          = '>server links '#9#9#9'- NT[o[ꗗ';
 STR_CHHLP_S_LIST           = '>server list '#9#9#9'- T[o[̈ꗗ\';
 STR_CHHLP_S_LAG            = '>server lag '#9#9#9'- NT[o[̒x\';
 STR_CHHLP_S_SETPASSWORDS   = '>server setpasswords <whatever> '#9'- XgɂST[o["my password"̒l<whatever>ɕύX';
 STR_CHHLP_S_STATS          = '>server stats '#9#9#9'- T[o[̓v\';
 STR_CHHLP_S_ALLOWED        = '>server allowed '#9#9#9'- [gadmin+NłT[o[̈ꗗ\';


procedure LoadLanguage(name: String='');
function  GetLangEx(str: String; arg1: String; arg2: String=''; arg3: string=''; arg4: string=''; arg5: String=''): String;
// should be accessed from main thread
function  GetLangT(id: Integer): String; overload;
function  GetLangT(id: Integer; arg: String): String; overload;
function  GetLangT(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangT(id: Integer; i: Integer): String; overload;
function  GetLangT(id: Integer; i1,i2: Integer): String; overload;
function  GetLangT(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangT(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangT(id: Integer; arg1,arg2: String; i:Integer): String; overload;
// should be accessed from interface
function  GetLangI(id: Integer): String; overload;
function  GetLangI(id: Integer; arg: String): String; overload;
function  GetLangI(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangI(id: Integer; i: Integer): String; overload;
function  GetLangI(id: Integer; i1,i2: Integer): String; overload;
function  GetLangI(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangI(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangI(id: Integer; arg1,arg2: String; i:Integer): String; overload;
// should be accessed from other threads
function  GetLangE(id: Integer): String; overload;
function  GetLangE(id: Integer; arg: String): String; overload;
function  GetLangE(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangE(id: Integer; i: Integer): String; overload;
function  GetLangE(id: Integer; i1,i2: Integer): String; overload;
function  GetLangE(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangE(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangE(id: Integer; arg1,arg2: String; i:Integer): String; overload;


implementation

uses
 stypes, vars;

var
 // using 3 lists because compiling with Delphi 4. in d4 strings are not thread-safe
 language_t: TMyStringList; // accessed from main thread
 language_i: TMyStringList; // accessed from interface
 language_e: TMyStringList; // accessed from other threads

procedure InitLanguage;
var
 i: Integer;
begin
 language_t:=TMyStringList.Create;
 for i:=0 to LNG_MAX do
  language_t.Add(LNG_UNKNOWN);
 language_i:=TMyStringList.Create;
 for i:=0 to LNG_MAX do
  language_i.Add(LNG_UNKNOWN);
 language_e:=TMyStringList.Create;
 for i:=0 to LNG_MAX do
  language_e.Add(LNG_UNKNOWN);
end;

procedure DestroyLanguage;
begin
 language_t.Free;
 language_t:=nil;
 language_i.Free;
 language_i:=nil;
 language_e.Free;
 language_e:=nil;
end;

function  GetLangEx(str: String; arg1: String; arg2: String=''; arg3: string=''; arg4: string=''; arg5: String=''): String;
var
 i: Array[1..5] of Integer;
 len,j: Integer;
begin
 i[1]:=pos('$1',str);
 i[2]:=pos('$2',str);
 i[3]:=pos('$3',str);
 i[4]:=pos('$4',str);
 i[5]:=pos('$5',str);
 if i[1]>0 then
 begin // arg1
   system.delete(str,i[1],2);
   len:=Length(arg1);
   system.insert(arg1,str,i[1]);
   for j:=2 to 5 do
    if i[j]>=i[1] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[2]>0 then
 begin // arg2
   system.delete(str,i[2],2);
   len:=Length(arg2);
   system.insert(arg2,str,i[2]);
   for j:=3 to 5 do
    if i[j]>=i[2] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[3]>0 then
 begin // arg3
   system.delete(str,i[3],2);
   len:=Length(arg3);
   system.insert(arg3,str,i[3]);
   for j:=4 to 5 do
    if i[j]>=i[3] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[4]>0 then
 begin // arg4
   system.delete(str,i[4],2);
   len:=Length(arg4);
   system.insert(arg4,str,i[4]);
   if i[5]>=i[4] then
   begin
    dec(i[5],2);
    inc(i[5],len);
   end;
 end;
 if i[5]>0 then
 begin // arg5
   system.delete(str,i[5],2);
   system.insert(arg5,str,i[5]);
 end;
 Result:=str;
end;

// from main thread:

function  GetLangT(id: Integer; i: Integer): String;
begin
  Result:=GetLangT(id,IntToStr(i));
end;

function  GetLangT(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangT(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangT(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangT(id,IntToStr(i),arg);
end;

function  GetLangT(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangT(id,arg,IntToStr(i));
end;

function  GetLangT(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangT(id,arg1,arg2,IntToStr(i));
end;

// from interface:

function  GetLangI(id: Integer; i: Integer): String;
begin
  Result:=GetLangI(id,IntToStr(i));
end;

function  GetLangI(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangI(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangI(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangI(id,IntToStr(i),arg);
end;

function  GetLangI(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangI(id,arg,IntToStr(i));
end;

function  GetLangI(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangI(id,arg1,arg2,IntToStr(i));
end;

// from other threads:

function  GetLangE(id: Integer; i: Integer): String;
begin
  Result:=GetLangE(id,IntToStr(i));
end;

function  GetLangE(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangE(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangE(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangE(id,IntToStr(i),arg);
end;

function  GetLangE(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangE(id,arg,IntToStr(i));
end;

function  GetLangE(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangE(id,arg1,arg2,IntToStr(i));
end;

// other functions

function UnEscape(str: String): String;
begin
 ReplaceString(str,'\t',#9);
 ReplaceString(str,'\n',#10);
 Result:=str;
end;

procedure GetIni(ini: TIniFile; num: Integer; section, variable: String);
var
 str: String;
begin
 try
  if language_t=nil then exit;
  str:=ini.ReadString(section,variable,language_t.Strings[num]);
  language_t.Strings[num]:=str;
  language_i.Strings[num]:=str;
  language_e.Strings[num]:=str;
  except
 end;
end;

procedure SetConstant(num: Integer; str: String);
begin
 try
  if language_t=nil then exit;
  language_t.Strings[num]:=str;
  language_i.Strings[num]:=str;
  language_e.Strings[num]:=str;
  except
 end;
end;

procedure LoadLanguage(name: String='');
var
 ini: TIniFile;
begin
 if name='' then name:='english';
 try // log and console messages
  ini:=TIniFile.Create(ApplicationDir+name+'.lng');
  GetIni(ini,LNG_LNGFILE_VERSION          ,'Version','BUILD');
  GetIni(ini,LNG_LOG_STARTING             ,'Log','SERVER_INIT');
  GetIni(ini,LNG_SERVER_LISTEN            ,'Log','SERVER_LISTEN');
  GetIni(ini,LNG_SERVER_LISTENERR         ,'Log','SERVER_LISTENERR');
  GetIni(ini,LNG_USERONLINE               ,'Log','USERONLINE');
  GetIni(ini,LNG_USEROFFLINE              ,'Log','USEROFFLINE');
  GetIni(ini,LNG_USEROFFLINE2             ,'Log','USEROFFLINE2');
  GetIni(ini,LNG_USERREGISTER             ,'Log','USERREGISTER');
  GetIni(ini,LNG_SERVER_LISTENSTATS       ,'Log','SERVER_LISTENSTATS');
  GetIni(ini,LNG_DISCONNECT_INVCMD        ,'Log','DISCONNECT_INVCMD');
  GetIni(ini,LNG_DISCONNECT_SOCKETERR     ,'Log','DISCONNECT_SOCKETERR');
  GetIni(ini,LNG_DISCONNECT_SENDTIMEOUT   ,'Log','DISCONNECT_SENDTIMEOUT');
  GetIni(ini,LNG_DISCONNECT_WINMX         ,'Log','DISCONNECT_WINMX');
  GetIni(ini,LNG_KILLED                   ,'Log','KILLED');
  GetIni(ini,LNG_NUKED                    ,'Log','NUKED');
  GetIni(ini,LNG_SEARCHLOG3               ,'Log','SEARCHLOG3');
  GetIni(ini,LNG_SEARCHLOG4               ,'Log','SEARCHLOG4');
  GetIni(ini,LNG_BROWSELOG1               ,'Log','BROWSELOG1');
  GetIni(ini,LNG_BROWSELOG2               ,'Log','BROWSELOG2');
  GetIni(ini,LNG_TRANSFERLOG3             ,'Log','TRANSFERLOG3');
  GetIni(ini,LNG_TRANSFERLOG4             ,'Log','TRANSFERLOG4');
  GetIni(ini,LNG_TRANSFERLOG5             ,'Log','TRANSFERLOG5');
  GetIni(ini,LNG_SAVINGDATA               ,'Log','SAVINGDATA');
  GetIni(ini,LNG_SERVERGHOST              ,'Log','SERVERGHOST');
  GetIni(ini,LNG_MINSHARE2                ,'Log','MINSHARE2');
  GetIni(ini,LNG_MINSHARE4                ,'Log','MINSHARE4');
  GetIni(ini,LNG_CONSOLEPONG              ,'Log','CONSOLEPONG');
  GetIni(ini,LNG_INVALIDLNGFILE           ,'Log','INVALIDLNGFILE');
  GetIni(ini,LNG_CHAT                     ,'Chat','CAPTION');
  GetIni(ini,LNG_CMNU_CLOSE               ,'Chat','MNU_CLOSE');
  GetIni(ini,LNG_CMNU_HOTLIST             ,'Chat','MNU_HOTLIST');
  GetIni(ini,LNG_CMNU_FRIEND              ,'Chat','MNU_FRIEND');
  GetIni(ini,LNG_CMNU_WHOIS               ,'Chat','MNU_WHOIS');
  GetIni(ini,LNG_CMNU_IGNORE              ,'Chat','MNU_IGNORE');
  GetIni(ini,LNG_TB_BTN_LOG               ,'Toolbar','BTN_LOG');
  GetIni(ini,LNG_TB_BTN_USERS             ,'Toolbar','BTN_USERS');
  GetIni(ini,LNG_TB_BTN_SERVERS           ,'Toolbar','BTN_SERVERS');
  GetIni(ini,LNG_TB_BTN_CHANNELS          ,'Toolbar','BTN_CHANNELS');
  GetIni(ini,LNG_TB_BTN_FRIENDS           ,'Toolbar','BTN_FRIENDS');
  GetIni(ini,LNG_TB_BTN_BANS              ,'Toolbar','BTN_BANS');
  GetIni(ini,LNG_TB_BTN_HOTLIST           ,'Toolbar','BTN_HOTLIST');
  GetIni(ini,LNG_TB_BTN_IGNORE            ,'Toolbar','BTN_IGNORE');
  GetIni(ini,LNG_TB_BTN_BLOCKS            ,'Toolbar','BTN_BLOCKS');
  GetIni(ini,LNG_TB_BTN_CONSOLEONLINE     ,'Toolbar','BTN_CONSOLEONLINE');
  GetIni(ini,LNG_TB_BTN_REGISTERED        ,'Toolbar','BTN_REGISTERED');
  GetIni(ini,LNG_TB_BTN_LOG_HINT          ,'Toolbar','BTN_LOG_HINT');
  GetIni(ini,LNG_TB_BTN_USERS_HINT        ,'Toolbar','BTN_USERS_HINT');
  GetIni(ini,LNG_TB_BTN_REGISTERED_HINT   ,'Toolbar','BTN_REGISTERED_HINT');
  GetIni(ini,LNG_TB_BTN_SERVERS_HINT      ,'Toolbar','BTN_SERVERS_HINT');
  GetIni(ini,LNG_TB_BTN_CHANNELS_HINT     ,'Toolbar','BTN_CHANNELS_HINT');
  GetIni(ini,LNG_TB_BTN_FRIENDS_HINT      ,'Toolbar','BTN_FRIENDS_HINT');
  GetIni(ini,LNG_TB_BTN_BANS_HINT         ,'Toolbar','BTN_BANS_HINT');
  GetIni(ini,LNG_TB_BTN_HOTLIST_HINT      ,'Toolbar','BTN_HOTLIST_HINT');
  GetIni(ini,LNG_TB_BTN_IGNORE_HINT       ,'Toolbar','BTN_IGNORE_HINT');
  GetIni(ini,LNG_TB_BTN_BLOCKS_HINT       ,'Toolbar','BTN_BLOCKS_HINT');
  GetIni(ini,LNG_TB_BTN_CONSOLEONLINE_HINT,'Toolbar','BTN_CONSOLEONLINE_HINT');
  GetIni(ini,LNG_TB_TOOLBAR_TOTAL         ,'Toolbar','TOOLBAR_TOTAL');
  GetIni(ini,LNG_MENU_SERVER              ,'Menu','MENU_SERVER');
  GetIni(ini,LNG_MENU_SETTINGS            ,'Menu','MENU_SETTINGS');
  GetIni(ini,LNG_MENU_LANGUAGES           ,'Menu','MENU_LANGUAGES');
  GetIni(ini,LNG_MENU_SAVE                ,'Menu','MENU_SAVE');
  GetIni(ini,LNG_MENU_RESTART             ,'Menu','MENU_RESTART');
  GetIni(ini,LNG_MENU_EXIT                ,'Menu','MENU_EXIT');
  GetIni(ini,LNG_MENU_LOG                 ,'Menu','MENU_LOG');
  GetIni(ini,LNG_MENU_CLEAR               ,'Menu','MENU_CLEAR');
  GetIni(ini,LNG_MENU_COPY                ,'Menu','MENU_COPY');
  GetIni(ini,LNG_MENU_LOGIN               ,'Menu','MENU_LOGIN');
  GetIni(ini,LNG_MENU_NAPIGATOR           ,'Menu','MENU_NAPIGATOR');
  GetIni(ini,LNG_MENU_DAGSTA              ,'Menu','MENU_DAGSTA');
  GetIni(ini,LNG_MENU_SEARCH              ,'Menu','MENU_SEARCH');
  GetIni(ini,LNG_MENU_BROWSE              ,'Menu','MENU_BROWSE');
  GetIni(ini,LNG_MENU_TRANSFER            ,'Menu','MENU_TRANSFER');
  GetIni(ini,LNG_MENU_RESET               ,'Menu','MENU_RESET');
  GetIni(ini,LNG_MENU_WINDOW              ,'Menu','MENU_WINDOW');
  GetIni(ini,LNG_MENU_BLOCK               ,'Menu','MENU_BLOCK');
  GetIni(ini,LNG_MENU_REGISTERED          ,'Menu','MENU_REGISTERED');
  GetIni(ini,LNG_MENU_LOGWIN              ,'Menu','MENU_LOGWIN');
  GetIni(ini,LNG_MENU_USERS               ,'Menu','MENU_USERS');
  GetIni(ini,LNG_MENU_SERVERS             ,'Menu','MENU_SERVERS');
  GetIni(ini,LNG_MENU_CHANNELS            ,'Menu','MENU_CHANNELS');
  GetIni(ini,LNG_MENU_FRIENDS             ,'Menu','MENU_FRIENDS');
  GetIni(ini,LNG_MENU_BANS                ,'Menu','MENU_BANS');
  GetIni(ini,LNG_MENU_HOTLIST             ,'Menu','MENU_HOTLIST');
  GetIni(ini,LNG_MENU_IGNORE              ,'Menu','MENU_IGNORE');
  GetIni(ini,LNG_MENU_HELP                ,'Menu','MENU_HELP');
  GetIni(ini,LNG_MENU_FAQ                 ,'Menu','MENU_FAQ');
  GetIni(ini,LNG_MENU_MANUAL              ,'Menu','MENU_MANUAL');
  GetIni(ini,LNG_MENU_FORUMS              ,'Menu','MENU_FORUMS');
  GetIni(ini,LNG_MENU_UPDATE              ,'Menu','MENU_UPDATE');
  GetIni(ini,LNG_MENU_ABOUT               ,'Menu','MENU_ABOUT');
  GetIni(ini,LNG_MENU_SHOW                ,'Menu','MENU_SHOW');
  GetIni(ini,LNG_MENU_HIDE                ,'Menu','MENU_HIDE');
  GetIni(ini,LNG_MENU_WEB                 ,'Menu','MENU_WEB');
  GetIni(ini,LNG_USERS_LABEL              ,'Users','LABEL');
  GetIni(ini,LNG_LIST_MUZZLED             ,'Users','LIST_MUZZLED');
  GetIni(ini,LNG_LIST_CONSOLE             ,'Users','LIST_CONSOLE');
  GetIni(ini,LNG_LIST_CLOAKED             ,'Users','LIST_CLOAKED');
  GetIni(ini,LNG_LIST_CHATTING            ,'Users','LIST_CHATTING');
  GetIni(ini,LNG_LIST_NOPONG              ,'Users','LIST_NOPONG');
  GetIni(ini,LNG_LIST_WINMXH              ,'Users','LIST_WINMXH');
  GetIni(ini,LNG_LIST_HEADER_NAME         ,'Users','LIST_HEADER_NAME');
  GetIni(ini,LNG_LIST_HEADER_LEVEL        ,'Users','LIST_HEADER_LEVEL');
  GetIni(ini,LNG_LIST_HEADER_SHARED       ,'Users','LIST_HEADER_SHARED');
  GetIni(ini,LNG_LIST_HEADER_SOFTWARE     ,'Users','LIST_HEADER_SOFTWARE');
  GetIni(ini,LNG_LIST_HEADER_SPEED        ,'Users','LIST_HEADER_SPEED');
  GetIni(ini,LNG_LIST_HEADER_IP           ,'Users','LIST_HEADER_IP');
  GetIni(ini,LNG_LIST_HEADER_PORT         ,'Users','LIST_HEADER_PORT');
  GetIni(ini,LNG_LIST_HEADER_SERVER       ,'Users','LIST_HEADER_SERVER');
  GetIni(ini,LNG_LIST_HEADER_TIME         ,'Users','LIST_HEADER_TIME');
  GetIni(ini,LNG_LIST_HEADER_TRANSFERS    ,'Users','LIST_HEADER_TRANSFERS');
  GetIni(ini,LNG_LIST_HEADER_TOTAL        ,'Users','LIST_HEADER_TOTAL');
  GetIni(ini,LNG_LIST_BTN_MODE            ,'Users','LIST_BTN_MODE');
  GetIni(ini,LNG_LIST_BTN_MODS            ,'Users','LIST_BTN_MODS');
  GetIni(ini,LNG_LIST_BTN_USERS           ,'Users','LIST_BTN_USERS');
  GetIni(ini,LNG_LIST_BTN_LEECH           ,'Users','LIST_BTN_LEECH');
  GetIni(ini,LNG_LIST_BTN_MUZZLED         ,'Users','LIST_BTN_MUZZLED');
  GetIni(ini,LNG_LIST_BTN_LOCAL           ,'Users','LIST_BTN_LOCAL');
  GetIni(ini,LNG_LIST_BTN_REMOTE          ,'Users','LIST_BTN_REMOTE');
  GetIni(ini,LNG_LIST_BTN_KICK            ,'Users','LIST_BTN_KICK');
  GetIni(ini,LNG_LIST_BTN_NUKE            ,'Users','LIST_BTN_NUKE');
  GetIni(ini,LNG_LIST_BTN_MUZZLE          ,'Users','LIST_BTN_MUZZLE');
  GetIni(ini,LNG_LIST_BTN_REFRESH         ,'Users','LIST_BTN_REFRESH');
  GetIni(ini,LNG_LIST_BTN_BAN             ,'Users','LIST_BTN_BAN');
  GetIni(ini,LNG_LIST_BTN_BANIP           ,'Users','LIST_BTN_BANIP');
  GetIni(ini,LNG_LIST_BTN_KICKBAN         ,'Users','LIST_BTN_KICKBAN');
  GetIni(ini,LNG_LIST_BTN_KICKBANIP       ,'Users','LIST_BTN_KICKBANIP');
  GetIni(ini,LNG_LIST_BTN_REGISTER        ,'Users','LIST_BTN_REGISTER');
  GetIni(ini,LNG_LIST_DEFREASON           ,'Users','LIST_DEFREASON');
  GetIni(ini,LNG_LIST_REASONHINT          ,'Users','LIST_REASONHINT');
  GetIni(ini,LNG_LIST_MENU_REFRESH        ,'Users','LIST_MENU_REFRESH');
  GetIni(ini,LNG_LIST_MENU_KILL           ,'Users','LIST_MENU_KILL');
  GetIni(ini,LNG_LIST_MENU_NUKE           ,'Users','LIST_MENU_NUKE');
  GetIni(ini,LNG_LIST_MENU_MUZZLE         ,'Users','LIST_MENU_MUZZLE');
  GetIni(ini,LNG_LIST_MENU_BAN            ,'Users','LIST_MENU_BAN');
  GetIni(ini,LNG_LIST_MENU_BANIP          ,'Users','LIST_MENU_BANIP');
  GetIni(ini,LNG_LIST_MENU_KICKBAN        ,'Users','LIST_MENU_KICKBAN');
  GetIni(ini,LNG_LIST_MENU_KICKBANIP      ,'Users','LIST_MENU_KICKBANIP');
  GetIni(ini,LNG_LIST_MENU_REGISTER       ,'Users','LIST_MENU_REGISTER');
  GetIni(ini,LNG_LIST_MENU_LEVEL          ,'Users','LIST_MENU_LEVEL');
  GetIni(ini,LNG_LIST_MENU_SPEED          ,'Users','LIST_MENU_SPEED');
  GetIni(ini,LNG_LIST_MENU_IM             ,'Users','LIST_MENU_IM');
  GetIni(ini,LNG_LIST_MENU_SELALL         ,'Users','LIST_MENU_SELALL');
  GetIni(ini,LNG_LIST_MENU_SELNONE        ,'Users','LIST_MENU_SELNONE');
  GetIni(ini,LNG_LIST_MENU_COPYNAME       ,'Users','LIST_MENU_COPYNAME');
  GetIni(ini,LNG_LIST_MENU_WHOIS          ,'Users','LIST_MENU_WHOIS');
  GetIni(ini,LNG_LIST_MENU_FRIEND         ,'Users','LIST_MENU_FRIEND');
  GetIni(ini,LNG_LIST_MENU_HOTLIST        ,'Users','LIST_MENU_HOTLIST');
  GetIni(ini,LNG_LIST_MENU_IGNORE         ,'Users','LIST_MENU_IGNORE');
  GetIni(ini,LNG_LIST_MNU2_LEVEL          ,'Users','LIST_MNU2_LEVEL');
  GetIni(ini,LNG_LIST_MNU2_SHARED         ,'Users','LIST_MNU2_SHARED');
  GetIni(ini,LNG_LIST_MNU2_SOFT           ,'Users','LIST_MNU2_SOFT');
  GetIni(ini,LNG_LIST_MNU2_SPEED          ,'Users','LIST_MNU2_SPEED');
  GetIni(ini,LNG_LIST_MNU2_IP             ,'Users','LIST_MNU2_IP');
  GetIni(ini,LNG_LIST_MNU2_PORT           ,'Users','LIST_MNU2_PORT');
  GetIni(ini,LNG_LIST_MNU2_TIME           ,'Users','LIST_MNU2_TIME');
  GetIni(ini,LNG_LIST_MNU2_TRANSFERS      ,'Users','LIST_MNU2_TRANSFERS');
  GetIni(ini,LNG_LIST_MNU2_TOTAL          ,'Users','LIST_MNU2_TOTAL');
  GetIni(ini,LNG_LIST_MNU2_SERVER         ,'Users','LIST_MNU2_SERVER');
  GetIni(ini,LNG_LIST_HINT_BAN            ,'Users','LIST_HINT_BAN');
  GetIni(ini,LNG_LIST_EDIT_FILTER_HINT    ,'Users','LIST_EDIT_FILTER_HINT');
  GetIni(ini,LNG_OK                       ,'Interface','OK');
  GetIni(ini,LNG_CANCEL                   ,'Interface','CANCEL');
  GetIni(ini,LNG_LOG_LABEL                ,'LogWin','LABEL');
  GetIni(ini,LNG_LOG_CLEAR                ,'LogWin','CLEAR');
  GetIni(ini,LNG_LOG_MODE                 ,'LogWin','MODE');
  GetIni(ini,LNG_LOG_PAUSE                ,'LogWin','PAUSE');
  GetIni(ini,LNG_LOG_RESUME               ,'LogWin','RESUME');
  GetIni(ini,LNG_LOG_CB_AWAY              ,'LogWin','CB_AWAY');
  GetIni(ini,LNG_LOG_LBL_AWAY             ,'LogWin','LBL_AWAY');
  GetIni(ini,LNG_LOG_CB_AWAYPOPUP         ,'LogWin','CB_AWAYPOPUP');
  GetIni(ini,LNG_LOG_CB_SOUND             ,'LogWin','CB_SOUND');
  GetIni(ini,LNG_MODE_ERROR               ,'UserMode','ERROR');
  GetIni(ini,LNG_MODE_ANNOUNCE            ,'UserMode','ANNOUNCE');
  GetIni(ini,LNG_MODE_MBAN                ,'UserMode','MBAN');
  GetIni(ini,LNG_MODE_MBANCONN            ,'UserMode','MBANCONN');
  GetIni(ini,LNG_MODE_SBAN                ,'UserMode','SBAN');
  GetIni(ini,LNG_MODE_SBANCONN            ,'UserMode','SBANCONN');
  GetIni(ini,LNG_MODE_CHANGE              ,'UserMode','CHANGE');
  GetIni(ini,LNG_MODE_KILL                ,'UserMode','KILL');
  GetIni(ini,LNG_MODE_LEVEL               ,'UserMode','LEVEL');
  GetIni(ini,LNG_MODE_SERVER              ,'UserMode','SERVER');
  GetIni(ini,LNG_MODE_MUZZLE              ,'UserMode','MUZZLE');
  GetIni(ini,LNG_MODE_PORT                ,'UserMode','PORT');
  GetIni(ini,LNG_MODE_WALLOP              ,'UserMode','WALLOP');
  GetIni(ini,LNG_MODE_CLOAK               ,'UserMode','CLOAK');
  GetIni(ini,LNG_MODE_FLOOD               ,'UserMode','FLOOD');
  GetIni(ini,LNG_MODE_MSG                 ,'UserMode','MSG');
  GetIni(ini,LNG_MODE_WHOIS               ,'UserMode','WHOIS');
  GetIni(ini,LNG_MODE_BROWSE              ,'UserMode','BROWSE');
  GetIni(ini,LNG_MODE_FRIEND              ,'UserMode','FRIEND');
  GetIni(ini,LNG_MODE_CHANNEL             ,'UserMode','CHANNEL');
  GetIni(ini,LNG_MODE_REGISTER            ,'UserMode','REGISTER');
  GetIni(ini,LNG_MODE_VAR                 ,'UserMode','VAR');
  GetIni(ini,LNG_MODE_PING                ,'UserMode','PING');
  GetIni(ini,LNG_MODE_LEECH               ,'UserMode','LEECH');
  GetIni(ini,LNG_MODE_SAMENIC             ,'UserMode','SAMENIC');
  GetIni(ini,LNG_MODE_OK                  ,'UserMode','OK');
  GetIni(ini,LNG_MODE_ALL                 ,'UserMode','ALL');
  GetIni(ini,LNG_MODE_NONE                ,'UserMode','NONE');
  GetIni(ini,LNG_MODE_CANCEL              ,'UserMode','CANCEL');
  GetIni(ini,LNG_MODE_CAPTION             ,'UserMode','CAPTION');
  GetIni(ini,LNG_ST_BYTES                 ,'Status','ST_BYTES');
  GetIni(ini,LNG_ST_TIME                  ,'Status','ST_TIME');
  GetIni(ini,LNG_ST_LOCAL                 ,'Status','ST_LOCAL');
  GetIni(ini,LNG_ST_LOCALMAX              ,'Status','ST_LOCALMAX');
  GetIni(ini,LNG_ST_TOTAL                 ,'Status','ST_TOTAL');
  GetIni(ini,LNG_ST_TOTALMAX              ,'Status','ST_TOTALMAX');
  GetIni(ini,LNG_ST_LASTTRANSFER          ,'Status','ST_LASTTRANSFER');
  Getini(ini,LNG_ST_LASTDATA              ,'Status','ST_LASTDATA');
  GetIni(ini,LNG_ST_TOTALTRANSFER         ,'Status','ST_TOTALTRANSFER');
  GetIni(ini,LNG_ST_TOTALDATA             ,'Status','ST_TOTALDATA');
  GetIni(ini,LNG_ST_NOLINK                ,'Status','ST_NOLINK');
  GetIni(ini,LNG_ST_LINK                  ,'Status','ST_LINK');
  GetIni(ini,LNG_ST_BPS                   ,'Status','ST_BPS');
  GetIni(ini,LNG_ST_BANDWIDTHLIMIT        ,'Status','ST_BANDWIDTHLIMIT');
  GetIni(ini,LNG_REG_TRANSFERS            ,'Registered','TRANSFERS');
  GetIni(ini,LNG_REG_MUZZLED              ,'Registered','MUZZLED');
  GetIni(ini,LNG_REG_USER                 ,'Registered','REG_USER');
  GetIni(ini,LNG_REG_LEVEL                ,'Registered','REG_LEVEL');
  GetIni(ini,LNG_REG_TRANSFERS2           ,'Registered','REG_TRANSFERS');
  GetIni(ini,LNG_REG_IP                   ,'Registered','REG_IP');
  GetIni(ini,LNG_REG_TIME                 ,'Registered','REG_TIME');
  GetIni(ini,LNG_REG_LABEL                ,'Registered','LABEL');
  GetIni(ini,LNG_REG_BTN_MODS             ,'Registered','REG_BTN_MODS');
  GetIni(ini,LNG_REG_BTN_USERS            ,'Registered','REG_BTN_USERS');
  GetIni(ini,LNG_REG_BTN_LEECH            ,'Registered','REG_BTN_LEECH');
  GetIni(ini,LNG_REG_BTN_MUZZLED          ,'Registered','REG_BTN_MUZZLED');
  GetIni(ini,LNG_REG_BTN_REFRESH          ,'Registered','REG_BTN_REFRESH');
  GetIni(ini,LNG_REG_DEFREASON            ,'Registered','REG_DEFREASON');
  GetIni(ini,LNG_REG_REASONHINT           ,'Registered','REG_REASONHINT');
  Getini(ini,LNG_REG_BTN_NUKE             ,'Registered','REG_BTN_NUKE');
  Getini(ini,LNG_REG_BTN_UNREGISTER       ,'Registered','REG_BTN_UNREGISTER');
  GetIni(ini,LNG_REG_BTN_BAN              ,'Registered','REG_BTN_BAN');
  GetIni(ini,LNG_REG_BTN_BANIP            ,'Registered','REG_BTN_BANIP');
  GetIni(ini,LNG_REG_MENU_REFRESH         ,'Registered','REG_MENU_REFRESH');
  GetIni(ini,LNG_REG_MENU_UNREGISTER      ,'Registered','REG_MENU_UNREGISTER');
  GetIni(ini,LNG_REG_MENU_NUKE            ,'Registered','REG_MENU_NUKE');
  GetIni(ini,LNG_REG_MENU_BAN             ,'Registered','REG_MENU_BAN');
  GetIni(ini,LNG_REG_MENU_BANIP           ,'Registered','REG_MENU_BANIP');
  GetIni(ini,LNG_REG_MENU_LEVEL           ,'Registered','REG_MENU_LEVEL');
  GetIni(ini,LNG_REG_MENU_SELALL          ,'Registered','REG_MENU_SELALL');
  GetIni(ini,LNG_REG_MENU_SELNONE         ,'Registered','REG_MENU_SELNONE');
  GetIni(ini,LNG_REG_MENU_COPYNAME        ,'Registered','REG_MENU_COPYNAME');
  GetIni(ini,LNG_REG_HINT_USER            ,'Registered','REG_HINT_USER');
  GetIni(ini,LNG_REG_HINT_PASSWORD        ,'Registered','REG_HINT_PASSWORD');
  GetIni(ini,LNG_REG_HINT_LEVEL           ,'Registered','REG_HINT_LEVEL');
  GetIni(ini,LNG_REG_BTN_REGISTER         ,'Registered','REG_BTN_REGISTER');
  GetIni(ini,LNG_REG_HINT_BAN             ,'Registered','REG_HINT_BAN');
  GetIni(ini,LNG_REG_EDIT_FILTER_HINT     ,'Registered','REG_EDIT_FILTER_HINT');
  GetIni(ini,LNG_REG_CLOAKED              ,'Registered','CLOAKED');
  GetIni(ini,LNG_CH_LABEL                 ,'Channels','LABEL');
  GetIni(ini,LNG_CLIST_NAME               ,'Channels','CLIST_NAME');
  GetIni(ini,LNG_CLIST_USERS              ,'Channels','CLIST_USERS');
  GetIni(ini,LNG_CLIST_MAXUSERS           ,'Channels','CLIST_MAXUSERS');
  GetIni(ini,LNG_CLIST_LEVEL              ,'Channels','CLIST_LEVEL');
  GetIni(ini,LNG_CLIST_STATUS             ,'Channels','CLIST_STATUS');
  GetIni(ini,LNG_CLIST_TOPIC              ,'Channels','CLIST_TOPIC');
  GetIni(ini,LNG_CLIST_BANS               ,'Channels','CLIST_BANS');
  GetIni(ini,LNG_CLIST_OPS                ,'Channels','CLIST_OPS');
  GetIni(ini,LNG_CLIST_VOICES             ,'Channels','CLIST_VOICES');
  GetIni(ini,LNG_CBTN_REFRESH             ,'Channels','CBTN_REFRESH');
  GetIni(ini,LNG_CBTN_JOIN                ,'Channels','CBTN_JOIN');
  GetIni(ini,LNG_CBTN_PROPS               ,'Channels','CBTN_PROPS');
  GetIni(ini,LNG_CBTN_ADD                 ,'Channels','CBTN_ADD');
  GetIni(ini,LNG_CBTN_DELETE              ,'Channels','CBTN_DELETE');
  GetIni(ini,LNG_CH_REASONHINT            ,'Channels','CH_REASONHINT');
  GetIni(ini,LNG_CH_REGISTERED            ,'Channels','CH_REGISTERED');
  GetIni(ini,LNG_CH_MODERATED             ,'Channels','CH_MODERATED');
  GetIni(ini,LNG_CH_PRIVATE               ,'Channels','CH_PRIVATE');
  GetIni(ini,LNG_CH_TOPIC                 ,'Channels','CH_TOPIC');
  GetIni(ini,LNG_CMENU_REFRESH            ,'Channels','CMENU_REFRESH');
  GetIni(ini,LNG_CMENU_JOIN               ,'Channels','CMENU_JOIN');
  GetIni(ini,LNG_CMENU_DELETE             ,'Channels','CMENU_DELETE');
  GetIni(ini,LNG_CMENU_CLEAR              ,'Channels','CMENU_CLEAR');
  GetIni(ini,LNG_CMENU_ADD                ,'Channels','CMENU_ADD');
  GetIni(ini,LNG_CMENU_PROPS              ,'Channels','CMENU_PROPS');
  GetIni(ini,LNG_CMENU_TOPIC              ,'Channels','CMENU_TOPIC');
  GetIni(ini,LNG_CMENU_SELECTALL          ,'Channels','CMENU_SELECTALL');
  GetIni(ini,LNG_CMENU_SELECTNONE         ,'Channels','CMENU_SELECTNONE');
  GetIni(ini,LNG_CMENU_COPYNAME           ,'Channels','CMENU_COPYNAME');
  GetIni(ini,LNG_CMENU_CLEARBANS          ,'Channels','CMENU_CLEARBANS');
  GetIni(ini,LNG_CH_CHTOPIC               ,'Channels','CHTOPIC');
  GetIni(ini,LNG_CH_JOIN                  ,'Channels','CHJOIN');
  GetIni(ini,LNG_CH_PART                  ,'Channels','CHPART');
  GetIni(ini,LNG_CH_USERLIST              ,'Channels','CHUSERLIST');
  GetIni(ini,LNG_CHMNU_IM                 ,'Channels','CHMNU_IM');
  GetIni(ini,LNG_CHMNU_WHOIS              ,'Channels','CHMNU_WHOIS');
  GetIni(ini,LNG_CHMNU_FRIENDS            ,'Channels','CHMNU_FRIENDS');
  GetIni(ini,LNG_CHMNU_OP                 ,'Channels','CHMNU_OP');
  GetIni(ini,LNG_CHMNU_DEOP               ,'Channels','CHMNU_DEOP');
  GetIni(ini,LNG_CHMNU_VOICE              ,'Channels','CHMNU_VOICE');
  GetIni(ini,LNG_CHMNU_UNVOICE            ,'Channels','CHMNU_UNVOICE');
  GetIni(ini,LNG_CHMNU_MUZZLE             ,'Channels','CHMNU_MUZZLE');
  GetIni(ini,LNG_CHMNU_BAN                ,'Channels','CHMNU_BAN');
  GetIni(ini,LNG_CHMNU_BANIP              ,'Channels','CHMNU_BANIP');
  GetIni(ini,LNG_CHMNU_KICK               ,'Channels','CHMNU_KICK');
  GetIni(ini,LNG_CHMNU_LEVEL              ,'Channels','CHMNU_LEVEL');
  GetIni(ini,LNG_CHMNU_COPYNAME           ,'Channels','CHMNU_COPYNAME');
  GetIni(ini,LNG_NAPIGATOR_ERROR          ,'Napigator','ERROR');
  GetIni(ini,LNG_NAPIGATOR_REPLY          ,'Napigator','REPLY');
  GetIni(ini,LNG_NAPIGATOR_SEND           ,'Napigator','SEND');
  GetIni(ini,LNG_NAPIGATOR_DISCONNECT     ,'Napigator','DISCONNECT');
  GetIni(ini,LNG_NAPIGATOR_CONNECTED      ,'Napigator','CONNECTED');
  GetIni(ini,LNG_NAPIGATOR_CONNECTING     ,'Napigator','CONNECTING');
  GetIni(ini,LNG_NAPIGATOR_NOCONNECT      ,'Napigator','NOCONNECT');
  GetIni(ini,LNG_NAPIGATOR_NOWELCOME      ,'Napigator','NOWELCOME');
  GetIni(ini,LNG_NAPIGATOR_NORESOLVE      ,'Napigator','NORESOLVE');
  Getini(ini,LNG_NAPIGATOR_RESOLVED       ,'Napigator','RESOLVED');
  GetIni(ini,LNG_NAPIGATOR_AUTODISCONNECT ,'Napigator','AUTODISCONNECT');
  GetIni(ini,LNG_DAGSTA_ERROR             ,'Dagsta','ERROR');
  GetIni(ini,LNG_DAGSTA_REPLY             ,'Dagsta','REPLY');
  GetIni(ini,LNG_DAGSTA_SEND              ,'Dagsta','SEND');
  GetIni(ini,LNG_DAGSTA_DISCONNECT        ,'Dagsta','DISCONNECT');
  GetIni(ini,LNG_DAGSTA_CONNECTED         ,'Dagsta','CONNECTED');
  GetIni(ini,LNG_DAGSTA_CONNECTING        ,'Dagsta','CONNECTING');
  GetIni(ini,LNG_DAGSTA_NOCONNECT         ,'Dagsta','NOCONNECT');
  GetIni(ini,LNG_DAGSTA_NOWELCOME         ,'Dagsta','NOWELCOME');
  GetIni(ini,LNG_DAGSTA_NORESOLVE         ,'Dagsta','NORESOLVE');
  Getini(ini,LNG_DAGSTA_RESOLVED          ,'Dagsta','RESOLVED');
  GetIni(ini,LNG_DAGSTA_AUTODISCONNECT    ,'Dagsta','AUTODISCONNECT');
  GetIni(ini,LNG_EDIT_NAPIGATOR           ,'Edit','NAPIGATOR');
  GetIni(ini,LNG_EDIT_DAGSTA              ,'Edit','DAGSTA');
  GetIni(ini,LNG_EDIT_ADDCHANNEL          ,'Edit','ADDCHANNEL');
  GetIni(ini,LNG_EDITCH_CAPTION           ,'EditCh','EDITCH_CAPTION');
  GetIni(ini,LNG_EDITCH_TOPIC             ,'EditCh','EDITCH_TOPIC');
  GetIni(ini,LNG_EDITCH_LIMIT             ,'EditCh','EDITCH_LIMIT');
  GetIni(ini,LNG_EDITCH_LEVEL             ,'EditCh','EDITCH_LEVEL');
  GetIni(ini,LNG_EDITCH_MOTD              ,'EditCh','EDITCH_MOTD');
  GetIni(ini,LNG_EDITCH_OK                ,'EditCh','EDITCH_OK');
  GetIni(ini,LNG_EDITCH_CANCEL            ,'EditCh','EDITCH_CANCEL');
  GetIni(ini,LNG_EDITCH_ATTR              ,'EditCh','EDITCH_ATTR');
  GetIni(ini,LNG_EDITCH_REGISTERED        ,'EditCh','EDITCH_REGISTERED');
  Getini(ini,LNG_EDITCH_PRIVATE           ,'EditCh','EDITCH_PRIVATE');
  GetIni(ini,LNG_EDITCH_MODERATED         ,'EditCh','EDITCH_MODERATED');
  GetIni(ini,LNG_EDITCH_TOPICATTR         ,'EditCh','EDITCH_TOPICATTR');
  GetIni(ini,LNG_BANS_NEVER_EXPIRE        ,'Bans','BANS_NEVER_EXPIRE');
  GetIni(ini,LNG_BANS_LABEL               ,'Bans','LABEL');
  GetIni(ini,LNG_BBTN_REFRESH             ,'Bans','BBTN_REFRESH');
  GetIni(ini,LNG_BBTN_BAN                 ,'Bans','BBTN_BAN');
  GetIni(ini,LNG_BLIST_NAME               ,'Bans','BLIST_NAME');
  GetIni(ini,LNG_BLIST_IP                 ,'Bans','BLIST_IP');
  GetIni(ini,LNG_BLIST_ADMIN              ,'Bans','BLIST_ADMIN');
  GetIni(ini,LNG_BLIST_TIMESET            ,'Bans','BLIST_TIMESET');
  GetIni(ini,LNG_BLIST_EXPIRES            ,'Bans','BLIST_EXPIRES');
  GetIni(ini,LNG_BLIST_REASON             ,'Bans','BLIST_REASON');
  GetIni(ini,LNG_BLIST_LASTATTEMPT        ,'Bans','BLIST_LASTATTEMPT');
  GetIni(ini,LNG_BLIST_USING              ,'Bans','BLIST_USING');
  GetIni(ini,LNG_BLIST_TRIES              ,'Bans','BLIST_TRIES');
  GetIni(ini,LNG_BANS_BANHINT             ,'Bans','BANS_BANHINT');
  GetIni(ini,LNG_BBTN_UNBAN               ,'Bans','BBTN_UNBAN');
  GetIni(ini,LNG_BANS_REASONHINT          ,'Bans','BANS_REASONHINT');
  GetIni(ini,LNG_BANS_UNBANREASONHINT     ,'Bans','BANS_UNBANREASONHINT');
  GetIni(ini,LNG_BANS_TIME60              ,'Bans','BANS_TIME60');
  GetIni(ini,LNG_BANS_TIME300             ,'Bans','BANS_TIME300');
  GetIni(ini,LNG_BANS_TIME600             ,'Bans','BANS_TIME600');
  GetIni(ini,LNG_BANS_TIME1800            ,'Bans','BANS_TIME1800');
  GetIni(ini,LNG_BANS_TIME3600            ,'Bans','BANS_TIME3600');
  GetIni(ini,LNG_BANS_TIME10800           ,'Bans','BANS_TIME10800');
  GetIni(ini,LNG_BANS_TIME43200           ,'Bans','BANS_TIME43200');
  GetIni(ini,LNG_BANS_TIME86400           ,'Bans','BANS_TIME86400');
  GetIni(ini,LNG_BANS_TIME259200          ,'Bans','BANS_TIME259200');
  GetIni(ini,LNG_BANS_TIME604800          ,'Bans','BANS_TIME604800');
  GetIni(ini,LNG_BANS_TIME1209600         ,'Bans','BANS_TIME1209600');
  GetIni(ini,LNG_BANS_TIME2678400         ,'Bans','BANS_TIME2678400');
  GetIni(ini,LNG_BANS_TIME5184000         ,'Bans','BANS_TIME5184000');
  GetIni(ini,LNG_BANS_TIME7776000         ,'Bans','BANS_TIME7776000');
  GetIni(ini,LNG_BANS_TIME31536000        ,'Bans','BANS_TIME31536000');
  GetIni(ini,LNG_BMENU_REFRESH            ,'Bans','BMENU_REFRESH');
  GetIni(ini,LNG_BMENU_UNBAN              ,'Bans','BMENU_UNBAN');
  GetIni(ini,LNG_BMENU_COPYUSER           ,'Bans','BMENU_COPYUSER');
  GetIni(ini,LNG_BMENU_COPYIP             ,'Bans','BMENU_COPYIP');
  GetIni(ini,LNG_BMENU_COPYBAN            ,'Bans','BMENU_COPYBAN');
  GetIni(ini,LNG_BMENU_COPYADMIN          ,'Bans','BMENU_COPYADMIN');
  GetIni(ini,LNG_BMENU_COPYREASON         ,'Bans','BMENU_COPYREASON');
  GetIni(ini,LNG_BMENU_SELALL             ,'Bans','BMENU_SELALL');
  GetIni(ini,LNG_BMENU_SELNONE            ,'Bans','BMENU_SELNONE');
  GetIni(ini,LNG_SERVERS_LABEL            ,'Servers','LABEL');
  GetIni(ini,LNG_SLIST_HOST               ,'Servers','SLIST_HOST');
  GetIni(ini,LNG_SLIST_PORT               ,'Servers','SLIST_PORT');
  GetIni(ini,LNG_SLIST_STATUS             ,'Servers','SLIST_STATUS');
  GetIni(ini,LNG_SLIST_AUTH               ,'Servers','SLIST_AUTH');
  GetIni(ini,LNG_SLIST_RELINK             ,'Servers','SLIST_RELINK');
  GetIni(ini,LNG_SLIST_COMMENTS           ,'Servers','SLIST_COMMENTS');
  GetIni(ini,LNG_SLIST_USERS              ,'Servers','SLIST_USERS');
  GetIni(ini,LNG_SLIST_LAG                ,'Servers','SLIST_LAG');
  GetIni(ini,LNG_SLIST_LAGSEC             ,'Servers','SLIST_LAGSEC');
  GetIni(ini,LNG_SLIST_ALIAS              ,'Servers','SLIST_ALIAS');
  GetIni(ini,LNG_SLIST_REDIRECTS          ,'Servers','SLIST_REDIRECTS');
  GetIni(ini,LNG_SRV_DISCONNECTED         ,'Servers','SRV_DISCONNECTED');
  GetIni(ini,LNG_SRV_LOGGED               ,'Servers','SRV_LOGGED');
  GetIni(ini,LNG_SRV_HUB                  ,'Servers','SRV_HUB');
  GetIni(ini,LNG_SRV_CONNECTING           ,'Servers','SRV_CONNECTING');
  GetIni(ini,LNG_SRV_LOGGING              ,'Servers','SRV_LOGGING');
  GetIni(ini,LNG_SRV_RESOLVE              ,'Servers','SRV_RESOLVE');
  GetIni(ini,LNG_SRV_PASSWORD             ,'Servers','SRV_PASSWORD');
  GetIni(ini,LNG_SRV_PASSWORDSRESET       ,'Servers','SRV_PASSWORDSRESET');
  GetIni(ini,LNG_SRV_RELINKTIME           ,'Servers','SRV_RELINKTIME');
  GetIni(ini,LNG_SBTN_REFRESH             ,'Servers','SBTN_REFRESH');
  GetIni(ini,LNG_SBTN_CONNECT2            ,'Servers','SBTN_CONNECT2');
  GetIni(ini,LNG_SBTN_DISCONNECT          ,'Servers','SBTN_DISCONNECT');
  GetIni(ini,LNG_SBTN_DELETE              ,'Servers','SBTN_DELETE');
  GetIni(ini,LNG_SBTN_ADD                 ,'Servers','SBTN_ADD');
  GetIni(ini,LNG_SBTN_PROPS               ,'Servers','SBTN_PROPS');
  GetIni(ini,LNG_SBTN_AUTOREFRESH         ,'Servers','SBTN_AUTOREFRESH');
  GetIni(ini,LNG_SHOST_HINT               ,'Servers','SHOST_HINT');
  GetIni(ini,LNG_SMENU_REFRESH            ,'Servers','SMENU_REFRESH');
  GetIni(ini,LNG_SMENU_CONNECT2           ,'Servers','SMENU_CONNECT2');
  GetIni(ini,LNG_SMENU_DISCONNECT         ,'Servers','SMENU_DISCONNECT');
  GetIni(ini,LNG_SMENU_DELETE             ,'Servers','SMENU_DELETE');
  GetIni(ini,LNG_SMENU_COMP               ,'Servers','SMENU_COMP');
  GetIni(ini,LNG_SMENU_COMP0              ,'Servers','SMENU_COMP0');
  GetIni(ini,LNG_SMENU_COMP1              ,'Servers','SMENU_COMP1');
  GetIni(ini,LNG_SMENU_COMP2              ,'Servers','SMENU_COMP2');
  GetIni(ini,LNG_SMENU_COMP3              ,'Servers','SMENU_COMP3');
  GetIni(ini,LNG_SMENU_STARTUP            ,'Servers','SMENU_STARTUP');
  GetIni(ini,LNG_SMENU_STARTUP2           ,'Servers','SMENU_STARTUP2');
  GetIni(ini,LNG_SMENU_LINK300            ,'Servers','SMENU_LINK300');
  GetIni(ini,LNG_SMENU_LINK600            ,'Servers','SMENU_LINK600');
  GetIni(ini,LNG_SMENU_LINK900            ,'Servers','SMENU_LINK900');
  GetIni(ini,LNG_SMENU_LINK1200           ,'Servers','SMENU_LINK1200');
  GetIni(ini,LNG_SMENU_LINK1800           ,'Servers','SMENU_LINK1800');
  GetIni(ini,LNG_SMENU_PROPS              ,'Servers','SMENU_PROPS');
  GetIni(ini,LNG_SMENU_SELECTALL          ,'Servers','SMENU_SELECTALL');
  GetIni(ini,LNG_SMENU_SELECTNONE         ,'Servers','SMENU_SELECTNONE');
  GetIni(ini,LNG_SMENU_COPYNAME           ,'Servers','SMENU_COPYNAME');
  GetIni(ini,LNG_EDITSRV_CAPTION          ,'EditServer','EDITSRV_CAPTION');
  GetIni(ini,LNG_EDITSRV_HOST             ,'EditServer','EDITSRV_HOST');
  GetIni(ini,LNG_EDITSRV_PORT             ,'EditServer','EDITSRV_PORT');
  GetIni(ini,LNG_EDITSRV_IPINFO           ,'EditServer','EDITSRV_IPINFO');
  GetIni(ini,LNG_EDITSRV_IPTEXT           ,'EditServer','EDITSRV_IPTEXT');
  GetIni(ini,LNG_EDITSRV_BOX              ,'EditServer','EDITSRV_BOX');
  Getini(ini,LNG_EDITSRV_RESOLVE          ,'EditServer','EDITSRV_RESOLVE');
  GetIni(ini,LNG_EDITSRV_PASSWORD         ,'EditServer','EDITSRV_PASSWORD');
  GetIni(ini,LNG_EDITSRV_MYPASS           ,'EditServer','EDITSRV_MYPASS');
  GetIni(ini,LNG_EDITSRV_REMOTEPASS       ,'EditServer','EDITSRV_REMOTEPASS');
  GetIni(ini,LNG_EDITSRV_BOX2             ,'EditServer','EDITSRV_BOX2');
  GetIni(ini,LNG_EDITSRV_COMP0            ,'EditServer','EDITSRV_COMP0');
  GetIni(ini,LNG_EDITSRV_COMP1            ,'EditServer','EDITSRV_COMP1');
  GetIni(ini,LNG_EDITSRV_COMP2            ,'EditServer','EDITSRV_COMP2');
  GetIni(ini,LNG_EDITSRV_COMP3            ,'EditServer','EDITSRV_COMP3');
  GetIni(ini,LNG_EDITSRV_COMMENTS         ,'EditServer','EDITSRV_COMMENTS');
  GetIni(ini,LNG_EDITSRV_RELINK           ,'EditServer','EDITSRV_RELINK');
  GetIni(ini,LNG_EDITSRV_OK               ,'EditServer','EDITSRV_OK');
  GetIni(ini,LNG_EDITSRV_CANCEL           ,'EditServer','EDITSRV_CANCEL');
  GetIni(ini,LNG_LBL_IGNORED              ,'Ignored','LABEL');
  GetIni(ini,LNG_IBTN_REFRESH             ,'Ignored','IBTN_REFRESH');
  GetIni(ini,LNG_IBTN_ADD                 ,'Ignored','IBTN_ADD');
  GetIni(ini,LNG_IBTN_REMOVE              ,'Ignored','IBTN_REMOVE');
  GetIni(ini,LNG_ILIST_USER               ,'Ignored','ILIST_USER');
  GetIni(ini,LNG_IEDIT_HINT               ,'Ignored','IEDIT_HINT');
  GetIni(ini,LNG_IMENU_REFRESH            ,'Ignored','IMENU_REFRESH');
  GetIni(ini,LNG_IMENU_DELETE             ,'Ignored','IMENU_DELETE');
  GetIni(ini,LNG_IMENU_SELALL             ,'Ignored','IMENU_SELALL');
  GetIni(ini,LNG_IMENU_SELNONE            ,'Ignored','IMENU_SELNONE');
  GetIni(ini,LNG_IMENU_COPYNAME           ,'Ignored','IMENU_COPYNAME');
  GetIni(ini,LNG_LBL_FRIENDS              ,'Friends','LABEL');
  GetIni(ini,LNG_FBTN_REFRESH             ,'Friends','FBTN_REFRESH');
  GetIni(ini,LNG_FBTN_ADD                 ,'Friends','FBTN_ADD');
  GetIni(ini,LNG_FBTN_REMOVE              ,'Friends','FBTN_REMOVE');
  GetIni(ini,LNG_FLIST_USER               ,'Friends','FLIST_USER');
  GetIni(ini,LNG_FEDIT_HINT               ,'Friends','FEDIT_HINT');
  GetIni(ini,LNG_FMENU_REFRESH            ,'Friends','FMENU_REFRESH');
  GetIni(ini,LNG_FMENU_DELETE             ,'Friends','FMENU_DELETE');
  GetIni(ini,LNG_FMENU_SELALL             ,'Friends','FMENU_SELALL');
  GetIni(ini,LNG_FMENU_SELNONE            ,'Friends','FMENU_SELNONE');
  GetIni(ini,LNG_FMENU_COPYNAME           ,'Friends','FMENU_COPYNAME');
  GetIni(ini,LNG_LIST_CB_SOUND            ,'Friends','CB_SOUND');
  GetIni(ini,LNG_LBL_BLOCKS               ,'Blocks','LABEL');
  GetIni(ini,LNG_BLBTN_REFRESH            ,'Blocks','BLBTN_REFRESH');
  GetIni(ini,LNG_BLBTN_ADD                ,'Blocks','BLBTN_ADD');
  GetIni(ini,LNG_BLBTN_RELOAD             ,'Blocks','BLBTN_RELOAD');
  GetIni(ini,LNG_BLBTN_REMOVE             ,'Blocks','BLBTN_REMOVE');
  GetIni(ini,LNG_BLLIST_ITEM              ,'Blocks','BLLIST_ITEM');
  GetIni(ini,LNG_BLEDIT_HINT              ,'Blocks','BLEDIT_HINT');
  GetIni(ini,LNG_BMNU_REFRESH             ,'Blocks','BMNU_REFRESH');
  GetIni(ini,LNG_BMNU_DELETE              ,'Blocks','BMNU_DELETE');
  GetIni(ini,LNG_BMNU_SELALL              ,'Blocks','BMNU_SELALL');
  GetIni(ini,LNG_BMNU_SELNONE             ,'Blocks','BMNU_SELNONE');
  GetIni(ini,LNG_BMNU_COPYNAME            ,'Blocks','BMNU_COPYNAME');
  GetIni(ini,LNG_HLIST_NAME               ,'HotList','HLIST_NAME');
  GetIni(ini,LNG_HLIST_SERVER             ,'HotList','HLIST_SERVER');
  GetIni(ini,LNG_HLIST_SPEED              ,'HotList','HLIST_SPEED');
  GetIni(ini,LNG_HBTN_REFRESH             ,'HotList','HBTN_REFRESH');
  GetIni(ini,LNG_HBTN_ADD                 ,'HotList','HBTN_ADD');
  GetIni(ini,LNG_HBTN_DELETE              ,'HotList','HBTN_DELETE');
  GetIni(ini,LNG_HEDIT_HINT               ,'HotList','HEDIT_HINT');
  GetIni(ini,LNG_HLIST_OFFLINE            ,'HotList','HLIST_OFFLINE');
  GetIni(ini,LNG_LABEL_HOTLIST            ,'HotList','LABEL');
  GetIni(ini,LNG_HMENU_REFRESH            ,'HotList','HMENU_REFRESH');
  GetIni(ini,LNG_HMENU_IM                 ,'HotList','HMENU_IM');
  GetIni(ini,LNG_HMENU_WHOIS              ,'HotList','HMENU_WHOIS');
  GetIni(ini,LNG_HMENU_FRIEND             ,'HotList','HMENU_FRIEND');
  GetIni(ini,LNG_HMENU_DELETE             ,'HotList','HMENU_DELETE');
  GetIni(ini,LNG_HMENU_SELALL             ,'HotList','HMENU_SELALL');
  GetIni(ini,LNG_HMENU_SELNONE            ,'HotList','HMENU_SELNONE');
  GetIni(ini,LNG_HMENU_COPYNAME           ,'HotList','HMENU_COPYNAME');
  GetIni(ini,LNG_HLIST_CB_SOUND           ,'Hotlist','CB_SOUND');
  GetIni(ini,LNG_WHOIS_CAPTION            ,'Whois','CAPTION');
  GetIni(ini,LNG_WHOIS_USER               ,'Whois','USER');
  GetIni(ini,LNG_WHOIS_LEVEL              ,'Whois','LEVEL');
  GetIni(ini,LNG_WHOIS_TIME               ,'Whois','TIME');
  GetIni(ini,LNG_WHOIS_CHANNELS           ,'Whois','CHANNELS');
  GetIni(ini,LNG_WHOIS_STATUS             ,'Whois','STATUS');
  GetIni(ini,LNG_WHOIS_SHARED             ,'Whois','SHARED');
  GetIni(ini,LNG_WHOIS_TRANSFERS          ,'Whois','TRANSFERS');
  GetIni(ini,LNG_WHOIS_SPEED              ,'Whois','SPEED');
  GetIni(ini,LNG_WHOIS_SOFTWARE           ,'Whois','SOFTWARE');
  GetIni(ini,LNG_WHOIS_TOTAL              ,'Whois','TOTAL');
  GetIni(ini,LNG_WHOIS_IP                 ,'Whois','IP');
  GetIni(ini,LNG_WHOIS_PORT               ,'Whois','PORT');
  GetIni(ini,LNG_WHOIS_DATAPORT           ,'Whois','DATAPORT');
  GetIni(ini,LNG_WHOIS_SERVER             ,'Whois','SERVER');
  GetIni(ini,LNG_WHOIS_WHOWAS             ,'Whois','WHOWAS');
  GetIni(ini,LNG_WMENU_CLOSE              ,'Whois','WMENU_CLOSE');
  GetIni(ini,LNG_WMENU_HOTLIST            ,'Whois','WMENU_HOTLIST');
  GetIni(ini,LNG_WMENU_FRIEND             ,'Whois','WMENU_FRIEND');
  GetIni(ini,LNG_WMENU_IGNORE             ,'Whois','WMENU_IGNORE');
  GetIni(ini,LNG_WMENU_MESSAGE            ,'Whois','WMENU_MESSAGE');
  GetIni(ini,LNG_INV_CAPTION              ,'Invite','INV_CAPTION');
  GetIni(ini,LNG_INV_NAME                 ,'Invite','INV_NAME');
  GetIni(ini,LNG_INV_TOPIC                ,'Invite','INV_TOPIC');
  GetIni(ini,LNG_INV_ACCEPT               ,'Invite','INV_ACCEPT');
  GetIni(ini,LNG_INV_DENY                 ,'Invite','INV_DENY');
  GetIni(ini,LNG_INV_IGNORE               ,'Invite','INV_IGNORE');
  GetIni(ini,LNG_INV_WHOIS                ,'Invite','INV_WHOIS');
  GetIni(ini,LNG_INV_HOTLIST              ,'Invite','INV_HOTLIST');
  GetIni(ini,LNG_INV_PRIVMSG              ,'Invite','INV_PRIVMSG');
  GetIni(ini,LNG_INV_MESSAGE              ,'Invite','INV_MESSAGE');
  GetIni(ini,LNG_S_ITEM_MAIN              ,'Settings','S_ITEM_MAIN');
  GetIni(ini,LNG_S_TEXT_MAIN              ,'Settings','S_TEXT_MAIN');
  GetIni(ini,LNG_S_ITEM_USERS             ,'Settings','S_ITEM_USERS');
  GetIni(ini,LNG_S_TEXT_USERS             ,'Settings','S_TEXT_USERS');
  GetIni(ini,LNG_S_ITEM_LIMITS            ,'Settings','S_ITEM_LIMITS');
  GetIni(ini,LNG_S_TEXT_LIMITS            ,'Settings','S_TEXT_LIMITS');
  GetIni(ini,LNG_S_ITEM_INTERFACE         ,'Settings','S_ITEM_INTERFACE');
  GetIni(ini,LNG_S_TEXT_INTERFACE         ,'Settings','S_TEXT_INTERFACE');
  GetIni(ini,LNG_S_ITEM_LOG               ,'Settings','S_ITEM_LOG');
  GetIni(ini,LNG_S_TEXT_LOG               ,'Settings','S_TEXT_LOG');
  GetIni(ini,LNG_S_ITEM_SHARE             ,'Settings','S_ITEM_SHARE');
  GetIni(ini,LNG_S_TEXT_SHARE             ,'Settings','S_TEXT_SHARE');
  GetIni(ini,LNG_S_ITEM_SHARE_MP3         ,'Settings','S_ITEM_SHARE_MP3');
  GetIni(ini,LNG_S_TEXT_SHARE_MP3         ,'Settings','S_TEXT_SHARE_MP3');
  GetIni(ini,LNG_S_ITEM_SHARE_AUDIO       ,'Settings','S_ITEM_SHARE_AUDIO');
  GetIni(ini,LNG_S_TEXT_SHARE_AUDIO       ,'Settings','S_TEXT_SHARE_AUDIO');
  GetIni(ini,LNG_S_ITEM_SHARE_VIDEO       ,'Settings','S_ITEM_SHARE_VIDEO');
  GetIni(ini,LNG_S_TEXT_SHARE_VIDEO       ,'Settings','S_TEXT_SHARE_VIDEO');
  GetIni(ini,LNG_S_ITEM_SHARE_IMAGES      ,'Settings','S_ITEM_SHARE_IMAGES');
  GetIni(ini,LNG_S_TEXT_SHARE_IMAGES      ,'Settings','S_TEXT_SHARE_IMAGES');
  GetIni(ini,LNG_S_ITEM_SHARE_APP         ,'Settings','S_ITEM_SHARE_APP');
  GetIni(ini,LNG_S_TEXT_SHARE_APP         ,'Settings','S_TEXT_SHARE_APP');
  GetIni(ini,LNG_S_ITEM_SHARE_CD          ,'Settings','S_ITEM_SHARE_CD');
  GetIni(ini,LNG_S_TEXT_SHARE_CD          ,'Settings','S_TEXT_SHARE_CD');
  GetIni(ini,LNG_S_ITEM_SHARE_TEXT        ,'Settings','S_ITEM_SHARE_TEXT');
  GetIni(ini,LNG_S_TEXT_SHARE_TEXT        ,'Settings','S_TEXT_SHARE_TEXT');
  GetIni(ini,LNG_S_ITEM_NAPIGATOR         ,'Settings','S_ITEM_NAPIGATOR');
  GetIni(ini,LNG_S_TEXT_NAPIGATOR         ,'Settings','S_TEXT_NAPIGATOR');
  GetIni(ini,LNG_S_ITEM_DAGSTA            ,'Settings','S_ITEM_DAGSTA');
  GetIni(ini,LNG_S_TEXT_DAGSTA            ,'Settings','S_TEXT_DAGSTA');
  GetIni(ini,LNG_S_ITEM_SEARCH            ,'Settings','S_ITEM_SEARCH');
  GetIni(ini,LNG_S_TEXT_SEARCH            ,'Settings','S_TEXT_SEARCH');
  GetIni(ini,LNG_S_ITEM_LEVELS            ,'Settings','S_ITEM_LEVELS');
  GetIni(ini,LNG_S_TEXT_LEVELS            ,'Settings','S_TEXT_LEVELS');
  GetIni(ini,LNG_S_ITEM_CHANNELS          ,'Settings','S_ITEM_CHANNELS');
  GetIni(ini,LNG_S_TEXT_CHANNELS          ,'Settings','S_TEXT_CHANNELS');
  GetIni(ini,LNG_S_ITEM_CONSOLE           ,'Settings','S_ITEM_CONSOLE');
  GetIni(ini,LNG_S_TEXT_CONSOLE           ,'Settings','S_TEXT_CONSOLE');
  GetIni(ini,LNG_S_ITEM_BLOCKED           ,'Settings','S_ITEM_BLOCKED');
  GetIni(ini,LNG_S_TEXT_BLOCKED           ,'Settings','S_TEXT_BLOCKED');
  GetIni(ini,LNG_S_ITEM_BLOCKEDMX         ,'Settings','S_ITEM_BLOCKEDMX');
  GetIni(ini,LNG_S_TEXT_BLOCKEDMX         ,'Settings','S_TEXT_BLOCKEDMX');
  GetIni(ini,LNG_S_ITEM_LINKS             ,'Settings','S_ITEM_LINKS');
  GetIni(ini,LNG_S_TEXT_LINKS             ,'Settings','S_TEXT_LINKS');
  GetIni(ini,LNG_S_ITEM_LINKS2            ,'Settings','S_ITEM_LINKS2');
  GetIni(ini,LNG_S_TEXT_LINKS2            ,'Settings','S_TEXT_LINKS2');
  GetIni(ini,LNG_S_ITEM_SOCKETS           ,'Settings','S_ITEM_SOCKETS');
  GetIni(ini,LNG_S_TEXT_SOCKETS           ,'Settings','S_TEXT_SOCKETS');
  GetIni(ini,LNG_S_ITEM_OTHER             ,'Settings','S_ITEM_OTHER');
  GetIni(ini,LNG_S_TEXT_OTHER             ,'Settings','S_TEXT_OTHER');
  GetIni(ini,LNG_S_ITEM_REPORT            ,'Settings','S_ITEM_REPORT');
  GetIni(ini,LNG_S_TEXT_REPORT            ,'Settings','S_TEXT_REPORT');
  GetIni(ini,LNG_S_ITEM_MINSHARE          ,'Settings','S_ITEM_MINSHARE');
  GetIni(ini,LNG_S_TEXT_MINSHARE          ,'Settings','S_TEXT_MINSHARE');
  GetIni(ini,LNG_S_ITEM_MOTD              ,'Settings','S_ITEM_MOTD');
  GetIni(ini,LNG_S_TEXT_MOTD              ,'Settings','S_TEXT_MOTD');
  GetIni(ini,LNG_S_ITEM_COLORS            ,'Settings','S_ITEM_COLORS');
  GetIni(ini,LNG_S_TEXT_COLORS            ,'Settings','S_TEXT_COLORS');
  Getini(ini,LNG_S_CAPTION                ,'Settings','S_CAPTION');
  GetIni(ini,LNG_S_BTN_CHANGE             ,'Settings','S_BTN_CHANGE');
  GetIni(ini,LNG_S_BTN_SAVE               ,'Settings','S_BTN_SAVE');
  GetIni(ini,LNG_S_BTN_RESTORE            ,'Settings','S_BTN_RESTORE');
  GetIni(ini,LNG_S_BTN_CLOSE              ,'Settings','S_BTN_CLOSE');
  GetIni(ini,LNG_S_LBL_NOTE               ,'Settings','S_LBL_NOTE');
  Getini(ini,LNG_S_LBL_CHANGE             ,'Settings','S_LBL_CHANGE');
  GetIni(ini,LNG_S_LBL_SAVE               ,'Settings','S_LBL_SAVE');
  GetIni(ini,LNG_S_ITEM_BLOCKS            ,'Settings','S_ITEM_BLOCKS');
  GetIni(ini,LNG_S_TEXT_BLOCKS            ,'Settings','S_TEXT_BLOCKS');
  GetIni(ini,LNG_S_ITEM_OTHER2            ,'Settings','S_ITEM_OTHER2');
  GetIni(ini,LNG_S_TEXT_OTHER2            ,'Settings','S_TEXT_OTHER2');
  GetIni(ini,LNG_S_ITEM_OTHER3            ,'Settings','S_ITEM_OTHER3');
  GetIni(ini,LNG_S_TEXT_OTHER3            ,'Settings','S_TEXT_OTHER3');
  GetIni(ini,LNG_S_ITEM_OTHER4            ,'Settings','S_ITEM_OTHER4');
  GetIni(ini,LNG_S_TEXT_OTHER4            ,'Settings','S_TEXT_OTHER4');
  GetIni(ini,LNG_BRMNU_CHARSET                              ,'Browse','BRMNU_CHARSET');
  GetIni(ini,LNG_BRMNU_CHARSET_SHIFTJIS                     ,'Browse','BRMNU_CHARSET_SHIFTJIS');
  GetIni(ini,LNG_BRMNU_CHARSET_CHINESEBIG5                  ,'Browse','BRMNU_CHARSET_CHINESEBIG5');
  GetIni(ini,LNG_BRMNU_CHARSET_GB2312                       ,'Browse','BRMNU_CHARSET_GB2312');
  GetIni(ini,LNG_BRMNU_CHARSET_HANGEUL                      ,'Browse','BRMNU_CHARSET_HANGEUL');
  GetIni(ini,LNG_BRMNU_CHARSET_EASTEUROPE                   ,'Browse','BRMNU_CHARSET_EASTEUROPE');
  GetIni(ini,LNG_BRMNU_CHARSET_RUSSIAN                      ,'Browse','BRMNU_CHARSET_RUSSIAN');
  //additional strings in TSlavaNapSettings
  GetIni(ini,LNG_S_SHMAIN_LABEL1                            ,'Settings','S_SHMAIN_LABEL1');
  GetIni(ini,LNG_S_SHMAIN_LABEL3                            ,'Settings','S_SHMAIN_LABEL3');
  GetIni(ini,LNG_S_SHMAIN_LABEL4                            ,'Settings','S_SHMAIN_LABEL4');
  GetIni(ini,LNG_S_SHMAIN_LABEL66                           ,'Settings','S_SHMAIN_LABEL66');
  GetIni(ini,LNG_S_SHMAIN_LABEL67                           ,'Settings','S_SHMAIN_LABEL67');
  GetIni(ini,LNG_S_SHMAIN_LABEL75                           ,'Settings','S_SHMAIN_LABEL75');
  GetIni(ini,LNG_S_SHMAIN_LABEL76                           ,'Settings','S_SHMAIN_LABEL76');
  GetIni(ini,LNG_S_SHMAIN_LBL_HANDLE                        ,'Settings','S_SHMAIN_LBL_HANDLE');
  GetIni(ini,LNG_S_SHMAIN_LABEL127                          ,'Settings','S_SHMAIN_LABEL127');
  GetIni(ini,LNG_S_SHMAIN_LABEL138                          ,'Settings','S_SHMAIN_LABEL138');
  GetIni(ini,LNG_S_SHUSERS_LABEL5                           ,'Settings','S_SHUSERS_LABEL5');
  GetIni(ini,LNG_S_SHUSERS_LABEL9                           ,'Settings','S_SHUSERS_LABEL9');
  GetIni(ini,LNG_S_SHUSERS_LABEL12                          ,'Settings','S_SHUSERS_LABEL12');
  GetIni(ini,LNG_S_SHUSERS_LABEL79                          ,'Settings','S_SHUSERS_LABEL79');
  GetIni(ini,LNG_S_SHUSERS_LABEL2                           ,'Settings','S_SHUSERS_LABEL2');
  GetIni(ini,LNG_S_SHUSERS_LABEL128                         ,'Settings','S_SHUSERS_LABEL128');
  GetIni(ini,LNG_S_SHUSERS_CB_USERS_REG_ONLY                ,'Settings','S_SHUSERS_CB_USERS_REG_ONLY');
  GetIni(ini,LNG_S_SHUSERS_CB_USERS_REG_ALLOW               ,'Settings','S_SHUSERS_CB_USERS_REG_ALLOW');
  GetIni(ini,LNG_S_SHUSERS_CB_USERS_NOREMOTE                ,'Settings','S_SHUSERS_CB_USERS_NOREMOTE');
  GetIni(ini,LNG_S_SHUSERS_CB_USERS_REDIRECTCQEX            ,'Settings','S_SHUSERS_CB_USERS_REDIRECTCQEX');
  GetIni(ini,LNG_S_SHUSERS_CB_USERS_RECONNECT               ,'Settings','S_SHUSERS_CB_USERS_RECONNECT');
  GetIni(ini,LNG_S_SHLIMITS_LABEL6                          ,'Settings','S_SHLIMITS_LABEL6');
  GetIni(ini,LNG_S_SHLIMITS_LABEL7                          ,'Settings','S_SHLIMITS_LABEL7');
  GetIni(ini,LNG_S_SHLIMITS_LABEL8                          ,'Settings','S_SHLIMITS_LABEL8');
  GetIni(ini,LNG_S_SHLIMITS_LABEL99                         ,'Settings','S_SHLIMITS_LABEL99');
  GetIni(ini,LNG_S_SHLIMITS_LABEL100                        ,'Settings','S_SHLIMITS_LABEL100');
  GetIni(ini,LNG_S_SHLIMITS_LABEL10                         ,'Settings','S_SHLIMITS_LABEL10');
  GetIni(ini,LNG_S_SHLIMITS_LABEL11                         ,'Settings','S_SHLIMITS_LABEL11');
  GetIni(ini,LNG_S_SHLIMITS_CB_LIMITS_LIMITSERVERS          ,'Settings','S_SHLIMITS_CB_LIMITS_LIMITSERVERS');
  GetIni(ini,LNG_S_SHINTERFACE_LABEL77                      ,'Settings','S_SHINTERFACE_LABEL77');
  GetIni(ini,LNG_S_SHINTERFACE_LABEL78                      ,'Settings','S_SHINTERFACE_LABEL78');
  GetIni(ini,LNG_S_SHINTERFACE_LABEL152                     ,'Settings','S_SHINTERFACE_LABEL152');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_STARTUP         ,'Settings','S_SHINTERFACE_CB_INTERFACE_STARTUP');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_NOSWITCH        ,'Settings','S_SHINTERFACE_CB_INTERFACE_NOSWITCH');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_CHATFLASH       ,'Settings','S_SHINTERFACE_CB_INTERFACE_CHATFLASH');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_SYSTRAY         ,'Settings','S_SHINTERFACE_CB_INTERFACE_SYSTRAY');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_CHATMINI        ,'Settings','S_SHINTERFACE_CB_INTERFACE_CHATMINI');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_WALLOP          ,'Settings','S_SHINTERFACE_CB_INTERFACE_WALLOP');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_NOCPU           ,'Settings','S_SHINTERFACE_CB_INTERFACE_NOCPU');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_WALLOPSOUND     ,'Settings','S_SHINTERFACE_CB_INTERFACE_WALLOPSOUND');
  GetIni(ini,LNG_S_SHINTERFACE_CB_INTERFACE_REMOTEADMINOK   ,'Settings','S_SHINTERFACE_CB_INTERFACE_REMOTEADMINOK');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_LOGIN                       ,'Settings','S_SHLOG_CB_LOG_LOGIN');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_NAPIGATOR                   ,'Settings','S_SHLOG_CB_LOG_NAPIGATOR');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_SEARCH                      ,'Settings','S_SHLOG_CB_LOG_SEARCH');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_TRANSFERS                   ,'Settings','S_SHLOG_CB_LOG_TRANSFERS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_USERS                       ,'Settings','S_SHLOG_CB_LOG_USERS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_SAVE                        ,'Settings','S_SHLOG_CB_LOG_SAVE');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_SERVERS                     ,'Settings','S_SHLOG_CB_LOG_SERVERS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_SERVERSTATS                 ,'Settings','S_SHLOG_CB_LOG_SERVERSTATS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_CLEARSERVERSTATS            ,'Settings','S_SHLOG_CB_LOG_CLEARSERVERSTATS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_CLEARCLIENTSTATS            ,'Settings','S_SHLOG_CB_LOG_CLEARCLIENTSTATS');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_CONSOLE                     ,'Settings','S_SHLOG_CB_LOG_CONSOLE');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_DAGSTA                      ,'Settings','S_SHLOG_CB_LOG_DAGSTA');
  GetIni(ini,LNG_S_SHLOG_CB_LOG_BROWSE                      ,'Settings','S_SHLOG_CB_LOG_BROWSE');
  GetIni(ini,LNG_S_SHSHARE_LABEL13                          ,'Settings','S_SHSHARE_LABEL13');
  GetIni(ini,LNG_S_SHSHARE_LABEL14                          ,'Settings','S_SHSHARE_LABEL14');
  GetIni(ini,LNG_S_SHSHARE_LABEL15                          ,'Settings','S_SHSHARE_LABEL15');
  GetIni(ini,LNG_S_SHSHARE_LABEL16                          ,'Settings','S_SHSHARE_LABEL16');
  GetIni(ini,LNG_S_SHSHARE_LABEL101                         ,'Settings','S_SHSHARE_LABEL101');
  GetIni(ini,LNG_S_SHSHARE_LABEL149                         ,'Settings','S_SHSHARE_LABEL149');
  GetIni(ini,LNG_S_SHSHARE_LABEL150                         ,'Settings','S_SHSHARE_LABEL150');
  GetIni(ini,LNG_S_SHSHARE_CB_SHARE_DISABLE                 ,'Settings','S_SHSHARE_CB_SHARE_DISABLE');
  GetIni(ini,LNG_S_SHSHARE_CB_SHARE_INFORM                  ,'Settings','S_SHSHARE_CB_SHARE_INFORM');
  GetIni(ini,LNG_S_SHSHARE_CB_SHARE_NOMODEM                 ,'Settings','S_SHSHARE_CB_SHARE_NOMODEM');
  GetIni(ini,LNG_S_SHSHARE_CB_SHARE_CHECKDUP                ,'Settings','S_SHSHARE_CB_SHARE_CHECKDUP');
  GetIni(ini,LNG_S_SHSHARE_CB_SHARE_FRIENDADD               ,'Settings','S_SHSHARE_CB_SHARE_FRIENDADD');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL17                       ,'Settings','S_SHSHAREMP3_LABEL17');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL18                       ,'Settings','S_SHSHAREMP3_LABEL18');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL19                       ,'Settings','S_SHSHAREMP3_LABEL19');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL20                       ,'Settings','S_SHSHAREMP3_LABEL20');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL45                       ,'Settings','S_SHSHAREMP3_LABEL45');
  GetIni(ini,LNG_S_SHSHAREMP3_LABEL46                       ,'Settings','S_SHSHAREMP3_LABEL46');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_320                    ,'Settings','S_SHSHAREMP3_CB_MP3_320');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_256                    ,'Settings','S_SHSHAREMP3_CB_MP3_256');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_224                    ,'Settings','S_SHSHAREMP3_CB_MP3_224');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_192                    ,'Settings','S_SHSHAREMP3_CB_MP3_192');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_160                    ,'Settings','S_SHSHAREMP3_CB_MP3_160');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_128                    ,'Settings','S_SHSHAREMP3_CB_MP3_128');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_112                    ,'Settings','S_SHSHAREMP3_CB_MP3_112');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_96                     ,'Settings','S_SHSHAREMP3_CB_MP3_96');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_80                     ,'Settings','S_SHSHAREMP3_CB_MP3_80');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_64                     ,'Settings','S_SHSHAREMP3_CB_MP3_64');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_56                     ,'Settings','S_SHSHAREMP3_CB_MP3_56');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_48                     ,'Settings','S_SHSHAREMP3_CB_MP3_48');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_40                     ,'Settings','S_SHSHAREMP3_CB_MP3_40');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_32                     ,'Settings','S_SHSHAREMP3_CB_MP3_32');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_24                     ,'Settings','S_SHSHAREMP3_CB_MP3_24');
  GetIni(ini,LNG_S_SHSHAREMP3_CB_MP3_0                      ,'Settings','S_SHSHAREMP3_CB_MP3_0');
  GetIni(ini,LNG_S_SHSHAREAUDIO_LABEL21                     ,'Settings','S_SHSHAREAUDIO_LABEL21');
  GetIni(ini,LNG_S_SHSHAREAUDIO_LABEL22                     ,'Settings','S_SHSHAREAUDIO_LABEL22');
  GetIni(ini,LNG_S_SHSHAREAUDIO_LABEL23                     ,'Settings','S_SHSHAREAUDIO_LABEL23');
  GetIni(ini,LNG_S_SHSHAREAUDIO_LABEL24                     ,'Settings','S_SHSHAREAUDIO_LABEL24');
  GetIni(ini,LNG_S_SHSHAREVIDEO_LABEL25                     ,'Settings','S_SHSHAREVIDEO_LABEL25');
  GetIni(ini,LNG_S_SHSHAREVIDEO_LABEL26                     ,'Settings','S_SHSHAREVIDEO_LABEL26');
  GetIni(ini,LNG_S_SHSHAREVIDEO_LABEL27                     ,'Settings','S_SHSHAREVIDEO_LABEL27');
  GetIni(ini,LNG_S_SHSHAREVIDEO_LABEL28                     ,'Settings','S_SHSHAREVIDEO_LABEL28');
  GetIni(ini,LNG_S_SHSHAREIMAGES_LABEL29                    ,'Settings','S_SHSHAREIMAGES_LABEL29');
  GetIni(ini,LNG_S_SHSHAREIMAGES_LABEL30                    ,'Settings','S_SHSHAREIMAGES_LABEL30');
  GetIni(ini,LNG_S_SHSHAREIMAGES_LABEL31                    ,'Settings','S_SHSHAREIMAGES_LABEL31');
  GetIni(ini,LNG_S_SHSHAREIMAGES_LABEL32                    ,'Settings','S_SHSHAREIMAGES_LABEL32');
  GetIni(ini,LNG_S_SHSHAREAPPS_LABEL33                      ,'Settings','S_SHSHAREAPPS_LABEL33');
  GetIni(ini,LNG_S_SHSHAREAPPS_LABEL34                      ,'Settings','S_SHSHAREAPPS_LABEL34');
  GetIni(ini,LNG_S_SHSHAREAPPS_LABEL35                      ,'Settings','S_SHSHAREAPPS_LABEL35');
  GetIni(ini,LNG_S_SHSHAREAPPS_LABEL36                      ,'Settings','S_SHSHAREAPPS_LABEL36');
  GetIni(ini,LNG_S_SHSHARECD_LABEL37                        ,'Settings','S_SHSHARECD_LABEL37');
  GetIni(ini,LNG_S_SHSHARECD_LABEL38                        ,'Settings','S_SHSHARECD_LABEL38');
  GetIni(ini,LNG_S_SHSHARECD_LABEL39                        ,'Settings','S_SHSHARECD_LABEL39');
  GetIni(ini,LNG_S_SHSHARECD_LABEL40                        ,'Settings','S_SHSHARECD_LABEL40');
  GetIni(ini,LNG_S_SHSHARETEXT_LABEL41                      ,'Settings','S_SHSHARETEXT_LABEL41');
  GetIni(ini,LNG_S_SHSHARETEXT_LABEL42                      ,'Settings','S_SHSHARETEXT_LABEL42');
  GetIni(ini,LNG_S_SHSHARETEXT_LABEL43                      ,'Settings','S_SHSHARETEXT_LABEL43');
  GetIni(ini,LNG_S_SHSHARETEXT_LABEL44                      ,'Settings','S_SHSHARETEXT_LABEL44');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL61                      ,'Settings','S_SHNAPIGATOR_LABEL61');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL62                      ,'Settings','S_SHNAPIGATOR_LABEL62');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL63                      ,'Settings','S_SHNAPIGATOR_LABEL63');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL64                      ,'Settings','S_SHNAPIGATOR_LABEL64');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL65                      ,'Settings','S_SHNAPIGATOR_LABEL65');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL73                      ,'Settings','S_SHNAPIGATOR_LABEL73');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL97                      ,'Settings','S_SHNAPIGATOR_LABEL97');
  GetIni(ini,LNG_S_SHNAPIGATOR_LABEL126                     ,'Settings','S_SHNAPIGATOR_LABEL126');
  GetIni(ini,LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_PASSWORD       ,'Settings','S_SHNAPIGATOR_BTN_NAPIGATOR_PASSWORD');
  GetIni(ini,LNG_S_SHNAPIGATOR_CB_NAPIGATOR_ENABLED         ,'Settings','S_SHNAPIGATOR_CB_NAPIGATOR_ENABLED');
  GetIni(ini,LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_DISCONNECT     ,'Settings','S_SHNAPIGATOR_BTN_NAPIGATOR_DISCONNECT');
  GetIni(ini,LNG_S_SHNAPIGATOR_CB_NAPIGATOR_AUTODISCONNECT  ,'Settings','S_SHNAPIGATOR_CB_NAPIGATOR_AUTODISCONNECT');
  GetIni(ini,LNG_S_SHSEARCH_LABEL47                         ,'Settings','S_SHSEARCH_LABEL47');
  GetIni(ini,LNG_S_SHSEARCH_LABEL48                         ,'Settings','S_SHSEARCH_LABEL48');
  GetIni(ini,LNG_S_SHSEARCH_LABEL49                         ,'Settings','S_SHSEARCH_LABEL49');
  GetIni(ini,LNG_S_SHSEARCH_LABEL50                         ,'Settings','S_SHSEARCH_LABEL50');
  GetIni(ini,LNG_S_SHSEARCH_LABEL72                         ,'Settings','S_SHSEARCH_LABEL72');
  GetIni(ini,LNG_S_SHSEARCH_LBL_SEARCH_MAXREMOTE            ,'Settings','S_SHSEARCH_LBL_SEARCH_MAXREMOTE');
  GetIni(ini,LNG_S_SHSEARCH_CB_SEARCH_DISABLE_REMOTE        ,'Settings','S_SHSEARCH_CB_SEARCH_DISABLE_REMOTE');
  GetIni(ini,LNG_S_SHLEVELS_LABEL54                         ,'Settings','S_SHLEVELS_LABEL54');
  GetIni(ini,LNG_S_SHLEVELS_LABEL55                         ,'Settings','S_SHLEVELS_LABEL55');
  GetIni(ini,LNG_S_SHLEVELS_LABEL56                         ,'Settings','S_SHLEVELS_LABEL56');
  GetIni(ini,LNG_S_SHLEVELS_LABEL57                         ,'Settings','S_SHLEVELS_LABEL57');
  GetIni(ini,LNG_S_SHLEVELS_LABEL58                         ,'Settings','S_SHLEVELS_LABEL58');
  GetIni(ini,LNG_S_SHLEVELS_LABEL59                         ,'Settings','S_SHLEVELS_LABEL59');
  GetIni(ini,LNG_S_SHLEVELS_LABEL60                         ,'Settings','S_SHLEVELS_LABEL60');
  GetIni(ini,LNG_S_SHLEVELS_LABEL102                        ,'Settings','S_SHLEVELS_LABEL102');
  GetIni(ini,LNG_S_SHLEVELS_BTN_LEVEL_DEFAULT               ,'Settings','S_SHLEVELS_BTN_LEVEL_DEFAULT');
  GetIni(ini,LNG_S_SHCHANNELS_LABEL52                       ,'Settings','S_SHCHANNELS_LABEL52');
  GetIni(ini,LNG_S_SHCHANNELS_LABEL53                       ,'Settings','S_SHCHANNELS_LABEL53');
  GetIni(ini,LNG_S_SHCHANNELS_LABEL82                       ,'Settings','S_SHCHANNELS_LABEL82');
  GetIni(ini,LNG_S_SHCHANNELS_LABEL83                       ,'Settings','S_SHCHANNELS_LABEL83');
  GetIni(ini,LNG_S_SHCHANNELS_LBL_FLOOD1                    ,'Settings','S_SHCHANNELS_LBL_FLOOD1');
  GetIni(ini,LNG_S_SHCHANNELS_LBL_FLOOD2                    ,'Settings','S_SHCHANNELS_LBL_FLOOD2');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_ALLOWCREATE       ,'Settings','S_SHCHANNELS_CB_CHANNELS_ALLOWCREATE');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_BLOCKCQEX         ,'Settings','S_SHCHANNELS_CB_CHANNELS_BLOCKCQEX');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_OLDWALLOP         ,'Settings','S_SHCHANNELS_CB_CHANNELS_OLDWALLOP');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_SHOWOPS           ,'Settings','S_SHCHANNELS_CB_CHANNELS_SHOWOPS');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_TIMESTAMP         ,'Settings','S_SHCHANNELS_CB_CHANNELS_TIMESTAMP');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_LOW               ,'Settings','S_SHCHANNELS_CB_CHANNELS_LOW');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_PREVENTSHOUT      ,'Settings','S_SHCHANNELS_CB_CHANNELS_PREVENTSHOUT');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_FLOOD_WARN        ,'Settings','S_SHCHANNELS_CB_CHANNELS_FLOOD_WARN');
  GetIni(ini,LNG_S_SHCHANNELS_CB_CHANNELS_FLOODENABLE       ,'Settings','S_SHCHANNELS_CB_CHANNELS_FLOODENABLE');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL69                        ,'Settings','S_SHCONSOLE_LABEL69');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL70                        ,'Settings','S_SHCONSOLE_LABEL70');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL71                        ,'Settings','S_SHCONSOLE_LABEL71');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL144                       ,'Settings','S_SHCONSOLE_LABEL144');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL145                       ,'Settings','S_SHCONSOLE_LABEL145');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL146                       ,'Settings','S_SHCONSOLE_LABEL146');
  GetIni(ini,LNG_S_SHCONSOLE_LABEL147                       ,'Settings','S_SHCONSOLE_LABEL147');
  GetIni(ini,LNG_S_SHBLOCKED_LABEL68                        ,'Settings','S_SHBLOCKED_LABEL68');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NAPSTER               ,'Settings','S_SHBLOCKED_CB_BLOCK_NAPSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_AUDIOGNOME            ,'Settings','S_SHBLOCKED_CB_BLOCK_AUDIOGNOME');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_GNOMEPLUS             ,'Settings','S_SHBLOCKED_CB_BLOCK_GNOMEPLUS');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_AMSTER                ,'Settings','S_SHBLOCKED_CB_BLOCK_AMSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_FILENAVIGATOR         ,'Settings','S_SHBLOCKED_CB_BLOCK_FILENAVIGATOR');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_CQEX                  ,'Settings','S_SHBLOCKED_CB_BLOCK_CQEX');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_SUNSHINEUN            ,'Settings','S_SHBLOCKED_CB_BLOCK_SUNSHINEUN');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_TEKNAP                ,'Settings','S_SHBLOCKED_CB_BLOCK_TEKNAP');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NAP                   ,'Settings','S_SHBLOCKED_CB_BLOCK_NAP');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_MACNAP                ,'Settings','S_SHBLOCKED_CB_BLOCK_MACNAP');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_MP3RAGE               ,'Settings','S_SHBLOCKED_CB_BLOCK_MP3RAGE');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_XNAP                  ,'Settings','S_SHBLOCKED_CB_BLOCK_XNAP');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_SPOTLIGHT             ,'Settings','S_SHBLOCKED_CB_BLOCK_SPOTLIGHT');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NFS                   ,'Settings','S_SHBLOCKED_CB_BLOCK_NFS');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_DMNAPSTER             ,'Settings','S_SHBLOCKED_CB_BLOCK_DMNAPSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_KNAPSTER              ,'Settings','S_SHBLOCKED_CB_BLOCK_KNAPSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_LOPSTER               ,'Settings','S_SHBLOCKED_CB_BLOCK_LOPSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_RAPIGATOR             ,'Settings','S_SHBLOCKED_CB_BLOCK_RAPIGATOR');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_SWAPTOR               ,'Settings','S_SHBLOCKED_CB_BLOCK_SWAPTOR');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_OTHER                 ,'Settings','S_SHBLOCKED_CB_BLOCK_OTHER');
  GetIni(ini,LNG_S_SHBLOCKED_LABEL74                        ,'Settings','S_SHBLOCKED_LABEL74');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_DAGSTA                ,'Settings','S_SHBLOCKED_CB_BLOCK_DAGSTA');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_FLOODSTER             ,'Settings','S_SHBLOCKED_CB_BLOCK_FLOODSTER');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_DRUMBEAT              ,'Settings','S_SHBLOCKED_CB_BLOCK_DRUMBEAT');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_CUSTOMMESSAGE         ,'Settings','S_SHBLOCKED_CB_BLOCK_CUSTOMMESSAGE');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_DEFAULTMESSAGE        ,'Settings','S_SHBLOCKED_CB_BLOCK_DEFAULTMESSAGE');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NOMESSAGE             ,'Settings','S_SHBLOCKED_CB_BLOCK_NOMESSAGE');
  GetIni(ini,LNG_S_SHBLOCKED_LBL_BLOCK_MESSAGE              ,'Settings','S_SHBLOCKED_LBL_BLOCK_MESSAGE');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_MLDONKEY              ,'Settings','S_SHBLOCKED_CB_BLOCK_MLDONKEY');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NAPIGATOR             ,'Settings','S_SHBLOCKED_CB_BLOCK_NAPIGATOR');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_NAP08                 ,'Settings','S_SHBLOCKED_CB_BLOCK_NAP08');
  GetIni(ini,LNG_S_SHBLOCKED_CB_BLOCK_OPENNAP               ,'Settings','S_SHBLOCKED_CB_BLOCK_OPENNAP');
  GetIni(ini,LNG_S_SHLINKS_LABEL98                          ,'Settings','S_SHLINKS_LABEL98');
  GetIni(ini,LNG_S_SHLINKS_LABEL139                         ,'Settings','S_SHLINKS_LABEL139');
  GetIni(ini,LNG_S_SHLINKS_LABEL141                         ,'Settings','S_SHLINKS_LABEL141');
  GetIni(ini,LNG_S_SHLINKS_LABEL151                         ,'Settings','S_SHLINKS_LABEL151');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_ALL                      ,'Settings','S_SHLINKS_CB_LINK_ALL');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_LIST                     ,'Settings','S_SHLINKS_CB_LINK_LIST');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_LIST2                    ,'Settings','S_SHLINKS_CB_LINK_LIST2');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_NONE                     ,'Settings','S_SHLINKS_CB_LINK_NONE');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_HUB                      ,'Settings','S_SHLINKS_CB_LINK_HUB');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_SYNCREG                  ,'Settings','S_SHLINKS_CB_LINK_SYNCREG');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_NOAUTOCONNECT            ,'Settings','S_SHLINKS_CB_LINK_NOAUTOCONNECT');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_SYNCBAN                  ,'Settings','S_SHLINKS_CB_LINK_SYNCBAN');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_RESTRICTOUTGOING         ,'Settings','S_SHLINKS_CB_LINK_RESTRICTOUTGOING');
  GetIni(ini,LNG_S_SHLINKS_CB_META_ENABLED                  ,'Settings','S_SHLINKS_CB_META_ENABLED');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_SYNCBLOCK                ,'Settings','S_SHLINKS_CB_LINK_SYNCBLOCK');
  GetIni(ini,LNG_S_SHLINKS_CB_LINK_MAXSERVERS               ,'Settings','S_SHLINKS_CB_LINK_MAXSERVERS');
  GetIni(ini,LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_SEND         ,'Settings','S_SHSOCKETS_LBL_SOCKETS_USERS_SEND');
  GetIni(ini,LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_RECV         ,'Settings','S_SHSOCKETS_LBL_SOCKETS_USERS_RECV');
  GetIni(ini,LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_SEND       ,'Settings','S_SHSOCKETS_LBL_SOCKETS_SERVERS_SEND');
  GetIni(ini,LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_RECV       ,'Settings','S_SHSOCKETS_LBL_SOCKETS_SERVERS_RECV');
  GetIni(ini,LNG_S_SHSOCKETS_LABEL81                        ,'Settings','S_SHSOCKETS_LABEL81');
  GetIni(ini,LNG_S_SHSOCKETS_CB_SOCKETS_USERS_DEF           ,'Settings','S_SHSOCKETS_CB_SOCKETS_USERS_DEF');
  GetIni(ini,LNG_S_SHSOCKETS_CB_SOCKETS_SERVERS_DEF         ,'Settings','S_SHSOCKETS_CB_SOCKETS_SERVERS_DEF');
  GetIni(ini,LNG_S_SHREPORT_LABEL148                        ,'Settings','S_SHREPORT_LABEL148');
  GetIni(ini,LNG_S_SHREPORT_CB_REPORT_OLD_ENABLE            ,'Settings','S_SHREPORT_CB_REPORT_OLD_ENABLE');
  GetIni(ini,LNG_S_SHREPORT_LABEL89                         ,'Settings','S_SHREPORT_LABEL89');
  GetIni(ini,LNG_S_SHREPORT_CB_REPORT_NEW_ENABLED           ,'Settings','S_SHREPORT_CB_REPORT_NEW_ENABLED');
  GetIni(ini,LNG_S_SHREPORT_CB_REPORT_NEW_HIDEHUB           ,'Settings','S_SHREPORT_CB_REPORT_NEW_HIDEHUB');
  GetIni(ini,LNG_S_SHREPORT_LABEL90                         ,'Settings','S_SHREPORT_LABEL90');
  GetIni(ini,LNG_S_SHREPORT_CB_REPORT_TRUESTATS             ,'Settings','S_SHREPORT_CB_REPORT_TRUESTATS');
  GetIni(ini,LNG_S_SHREPORT_KSOOFFICEGROUPBOX2              ,'Settings','S_SHREPORT_KSOOFFICEGROUPBOX2');
  GetIni(ini,LNG_S_SHREPORT_KSOOFFICEGROUPBOX3              ,'Settings','S_SHREPORT_KSOOFFICEGROUPBOX3');
  GetIni(ini,LNG_S_SHOTHER_LABEL84                          ,'Settings','S_SHOTHER_LABEL84');
  GetIni(ini,LNG_S_SHOTHER_CB_ANN_ENABLE                    ,'Settings','S_SHOTHER_CB_ANN_ENABLE');
  GetIni(ini,LNG_S_SHOTHER_LABEL85                          ,'Settings','S_SHOTHER_LABEL85');
  GetIni(ini,LNG_S_SHOTHER_LABEL86                          ,'Settings','S_SHOTHER_LABEL86');
  GetIni(ini,LNG_S_SHOTHER_LABEL87                          ,'Settings','S_SHOTHER_LABEL87');
  GetIni(ini,LNG_S_SHOTHER_LABEL88                          ,'Settings','S_SHOTHER_LABEL88');
  GetIni(ini,LNG_S_SHOTHER_KSOOFFICEGROUPBOX1               ,'Settings','S_SHOTHER_KSOOFFICEGROUPBOX1');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL91                       ,'Settings','S_SHMINSHARE_LABEL91');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL92                       ,'Settings','S_SHMINSHARE_LABEL92');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL93                       ,'Settings','S_SHMINSHARE_LABEL93');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL94                       ,'Settings','S_SHMINSHARE_LABEL94');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL95                       ,'Settings','S_SHMINSHARE_LABEL95');
  GetIni(ini,LNG_S_SHMINSHARE_LABEL160                      ,'Settings','S_SHMINSHARE_LABEL160');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_BAN               ,'Settings','S_SHMINSHARE_CB_MINSHARE_BAN');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_ONLYFULL          ,'Settings','S_SHMINSHARE_CB_MINSHARE_ONLYFULL');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_BANIP             ,'Settings','S_SHMINSHARE_CB_MINSHARE_BANIP');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_FULL10            ,'Settings','S_SHMINSHARE_CB_MINSHARE_FULL10');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_KICKCHAT          ,'Settings','S_SHMINSHARE_CB_MINSHARE_KICKCHAT');
  GetIni(ini,LNG_S_SHMINSHARE_CB_MINSHARE_WALLOP            ,'Settings','S_SHMINSHARE_CB_MINSHARE_WALLOP');
  GetIni(ini,LNG_S_SHMOTD_LABEL96                           ,'Settings','S_SHMOTD_LABEL96');
  GetIni(ini,LNG_S_SHCOLORS_LABEL104                        ,'Settings','S_SHCOLORS_LABEL104');
  GetIni(ini,LNG_S_SHCOLORS_LABEL105                        ,'Settings','S_SHCOLORS_LABEL105');
  GetIni(ini,LNG_S_SHCOLORS_LABEL106                        ,'Settings','S_SHCOLORS_LABEL106');
  GetIni(ini,LNG_S_SHCOLORS_LABEL107                        ,'Settings','S_SHCOLORS_LABEL107');
  GetIni(ini,LNG_S_SHCOLORS_LABEL108                        ,'Settings','S_SHCOLORS_LABEL108');
  GetIni(ini,LNG_S_SHCOLORS_LABEL109                        ,'Settings','S_SHCOLORS_LABEL109');
  GetIni(ini,LNG_S_SHCOLORS_LABEL110                        ,'Settings','S_SHCOLORS_LABEL110');
  GetIni(ini,LNG_S_SHCOLORS_LABEL111                        ,'Settings','S_SHCOLORS_LABEL111');
  GetIni(ini,LNG_S_SHCOLORS_LABEL112                        ,'Settings','S_SHCOLORS_LABEL112');
  GetIni(ini,LNG_S_SHCOLORS_LABEL113                        ,'Settings','S_SHCOLORS_LABEL113');
  GetIni(ini,LNG_S_SHCOLORS_LABEL114                        ,'Settings','S_SHCOLORS_LABEL114');
  GetIni(ini,LNG_S_SHCOLORS_LABEL115                        ,'Settings','S_SHCOLORS_LABEL115');
  GetIni(ini,LNG_S_SHCOLORS_LABEL116                        ,'Settings','S_SHCOLORS_LABEL116');
  GetIni(ini,LNG_S_SHCOLORS_LABEL117                        ,'Settings','S_SHCOLORS_LABEL117');
  GetIni(ini,LNG_S_SHCOLORS_LABEL118                        ,'Settings','S_SHCOLORS_LABEL118');
  GetIni(ini,LNG_S_SHCOLORS_LABEL119                        ,'Settings','S_SHCOLORS_LABEL119');
  GetIni(ini,LNG_S_SHCOLORS_LABEL120                        ,'Settings','S_SHCOLORS_LABEL120');
  GetIni(ini,LNG_S_SHCOLORS_LABEL121                        ,'Settings','S_SHCOLORS_LABEL121');
  GetIni(ini,LNG_S_SHCOLORS_LABEL122                        ,'Settings','S_SHCOLORS_LABEL122');
  GetIni(ini,LNG_S_SHCOLORS_LABEL123                        ,'Settings','S_SHCOLORS_LABEL123');
  GetIni(ini,LNG_S_SHCOLORS_LABEL124                        ,'Settings','S_SHCOLORS_LABEL124');
  GetIni(ini,LNG_S_SHCOLORS_LABEL125                        ,'Settings','S_SHCOLORS_LABEL125');
  GetIni(ini,LNG_S_SHCOLORS_LABEL136                        ,'Settings','S_SHCOLORS_LABEL136');
  GetIni(ini,LNG_S_SHCOLORS_LABEL51                         ,'Settings','S_SHCOLORS_LABEL51');
  GetIni(ini,LNG_S_SHCOLORS_BTN_COLORS_DEFAULT              ,'Settings','S_SHCOLORS_BTN_COLORS_DEFAULT');
  GetIni(ini,LNG_S_SHLINKS2_LABEL80                         ,'Settings','S_SHLINKS2_LABEL80');
  GetIni(ini,LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCH            ,'Settings','S_SHLINKS2_CB_LINK2_LAGNOSEARCH');
  GetIni(ini,LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCHREQ         ,'Settings','S_SHLINKS2_CB_LINK2_LAGNOSEARCHREQ');
  GetIni(ini,LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSE            ,'Settings','S_SHLINKS2_CB_LINK2_LAGNOBROWSE');
  GetIni(ini,LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSEREQ         ,'Settings','S_SHLINKS2_CB_LINK2_LAGNOBROWSEREQ');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL103                        ,'Settings','S_SHDAGSTA_LABEL103');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL129                        ,'Settings','S_SHDAGSTA_LABEL129');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL130                        ,'Settings','S_SHDAGSTA_LABEL130');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL131                        ,'Settings','S_SHDAGSTA_LABEL131');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL132                        ,'Settings','S_SHDAGSTA_LABEL132');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL133                        ,'Settings','S_SHDAGSTA_LABEL133');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL134                        ,'Settings','S_SHDAGSTA_LABEL134');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL135                        ,'Settings','S_SHDAGSTA_LABEL135');
  GetIni(ini,LNG_S_SHDAGSTA_LABEL137                        ,'Settings','S_SHDAGSTA_LABEL137');
  GetIni(ini,LNG_S_SHDAGSTA_BTN_DAGSTA_PASSWORD             ,'Settings','S_SHDAGSTA_BTN_DAGSTA_PASSWORD');
  GetIni(ini,LNG_S_SHDAGSTA_CB_DAGSTA_ENABLED               ,'Settings','S_SHDAGSTA_CB_DAGSTA_ENABLED');
  GetIni(ini,LNG_S_SHDAGSTA_BTN_DAGSTA_DISCONNECT           ,'Settings','S_SHDAGSTA_BTN_DAGSTA_DISCONNECT');
  GetIni(ini,LNG_S_SHDAGSTA_CB_DAGSTA_AUTODISCONNECT        ,'Settings','S_SHDAGSTA_CB_DAGSTA_AUTODISCONNECT');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_LBL_BLOCKMX_PERCENTAGE    ,'Settings','S_SHBLOCKEDWINMX_LBL_BLOCKMX_PERCENTAGE');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_LABEL140                  ,'Settings','S_SHBLOCKEDWINMX_LABEL140');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_LABEL142                  ,'Settings','S_SHBLOCKEDWINMX_LABEL142');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_LABEL143                  ,'Settings','S_SHBLOCKEDWINMX_LABEL143');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_NORMAL         ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_NORMAL');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_LIMIT          ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_LIMIT');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_DETECT         ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_DETECT');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_JAP            ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_JAP');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_PONG           ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_PONG');
  GetIni(ini,LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_BAN            ,'Settings','S_SHBLOCKEDWINMX_CB_BLOCKMX_BAN');
  GetIni(ini,LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE           ,'Settings','S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE');
  GetIni(ini,LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE_ADMINS    ,'Settings','S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE_ADMINS');
  GetIni(ini,LNG_S_SHBLOCKS_CB_BLOCKS_CHECKMODS             ,'Settings','S_SHBLOCKS_CB_BLOCKS_CHECKMODS');
  GetIni(ini,LNG_S_SHOTHER2_LABEL153                        ,'Settings','S_SHOTHER2_LABEL153');
  GetIni(ini,LNG_S_SHOTHER2_LABEL154                        ,'Settings','S_SHOTHER2_LABEL154');
  GetIni(ini,LNG_S_SHOTHER2_GB_SEARCHBLOCK                  ,'Settings','S_SHOTHER2_GB_SEARCHBLOCK');
  GetIni(ini,LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKFILES         ,'Settings','S_SHOTHER2_CB_SEARCHBLOCK_CHKFILES');
  GetIni(ini,LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKSIZE          ,'Settings','S_SHOTHER2_CB_SEARCHBLOCK_CHKSIZE');
  GetIni(ini,LNG_S_SHOTHER2_RD_SEARCHBLOCK_HARD             ,'Settings','S_SHOTHER2_RD_SEARCHBLOCK_HARD');
  GetIni(ini,LNG_S_SHOTHER2_RD_SEARCHBLOCK_NORMAL           ,'Settings','S_SHOTHER2_RD_SEARCHBLOCK_NORMAL');
  GetIni(ini,LNG_S_SHOTHER2_GB_DOMBLOCK                     ,'Settings','S_SHOTHER2_GB_DOMBLOCK');
  GetIni(ini,LNG_S_SHOTHER2_CB_DOMBLOCK_CHKFILES            ,'Settings','S_SHOTHER2_CB_DOMBLOCK_CHKFILES');
  GetIni(ini,LNG_S_SHOTHER2_CB_DOMBLOCK_CHKSIZE             ,'Settings','S_SHOTHER2_CB_DOMBLOCK_CHKSIZE');
  GetIni(ini,LNG_S_SHOTHER2_RD_DOMBLOCK_HARD                ,'Settings','S_SHOTHER2_RD_DOMBLOCK_HARD');
  GetIni(ini,LNG_S_SHOTHER2_RD_DOMBLOCK_NORMAL              ,'Settings','S_SHOTHER2_RD_DOMBLOCK_NORMAL');
  GetIni(ini,LNG_S_SHOTHER2_GB_DLFLOODBLOCK                 ,'Settings','S_SHOTHER2_GB_DLFLOODBLOCK');
  GetIni(ini,LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BAN             ,'Settings','S_SHOTHER2_RD_DLFLOODBLOCK_BAN');
  GetIni(ini,LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BLOCK           ,'Settings','S_SHOTHER2_RD_DLFLOODBLOCK_BLOCK');
  GetIni(ini,LNG_S_SHOTHER2_RD_DLFLOODBLOCK_LEECH           ,'Settings','S_SHOTHER2_RD_DLFLOODBLOCK_LEECH');
  GetIni(ini,LNG_S_SHOTHER2_GB_WQFLOODBLOCK                 ,'Settings','S_SHOTHER2_GB_WQFLOODBLOCK');
  GetIni(ini,LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BAN             ,'Settings','S_SHOTHER2_RD_WQFLOODBLOCK_BAN');
  GetIni(ini,LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BLOCK           ,'Settings','S_SHOTHER2_RD_WQFLOODBLOCK_BLOCK');
  GetIni(ini,LNG_S_SHOTHER2_RD_WQFLOODBLOCK_LEECH           ,'Settings','S_SHOTHER2_RD_WQFLOODBLOCK_LEECH');
  GetIni(ini,LNG_S_SHOTHER2_CB_NOCOUNT_TEXT                 ,'Settings','S_SHOTHER2_CB_NOCOUNT_TEXT');
  GetIni(ini,LNG_S_SHOTHER2_CB_AUTOBAN_INCOMPLETE           ,'Settings','S_SHOTHER2_CB_AUTOBAN_INCOMPLETE');
  GetIni(ini,LNG_S_SHOTHER2_CB_DISABLE_FAKEEXT              ,'Settings','S_SHOTHER2_CB_DISABLE_FAKEEXT');
  GetIni(ini,LNG_S_SHOTHER2_CB_ENABLE_TRAPPORT              ,'Settings','S_SHOTHER2_CB_ENABLE_TRAPPORT');
  GetIni(ini,LNG_S_SHOTHER2_CB_BLOCK_TRANSFERPORT           ,'Settings','S_SHOTHER2_CB_BLOCK_TRANSFERPORT');
  GetIni(ini,LNG_S_SHOTHER2_CB_SHARE_MATCHEDFILE_ONLY       ,'Settings','S_SHOTHER2_CB_SHARE_MATCHEDFILE_ONLY');
  GetIni(ini,LNG_S_SHOTHER3_LABEL156                        ,'Settings','S_SHOTHER3_LABEL156');
  GetIni(ini,LNG_S_SHOTHER3_LABEL157                        ,'Settings','S_SHOTHER3_LABEL157');
  GetIni(ini,LNG_S_SHOTHER3_LABEL158                        ,'Settings','S_SHOTHER3_LABEL158');
  GetIni(ini,LNG_S_SHOTHER3_LABEL159                        ,'Settings','S_SHOTHER3_LABEL159');
  GetIni(ini,LNG_S_SHOTHER3_GROUPBOX1                       ,'Settings','S_SHOTHER3_GROUPBOX1');
  GetIni(ini,LNG_S_SHOTHER3_CB_ENABLE_LOGINIM               ,'Settings','S_SHOTHER3_CB_ENABLE_LOGINIM');
  GetIni(ini,LNG_S_SHOTHER3_LABEL155                        ,'Settings','S_SHOTHER3_LABEL155');
  GetIni(ini,LNG_S_SHOTHER3_CB_CHANNELS_FORCEENTER          ,'Settings','S_SHOTHER3_CB_CHANNELS_FORCEENTER');
  GetIni(ini,LNG_S_SHOTHER3_CB_ALLOW_2BYTENAME              ,'Settings','S_SHOTHER3_CB_ALLOW_2BYTENAME');
  GetIni(ini,LNG_S_SHOTHER3_CB_CHECK_LOGINPASS              ,'Settings','S_SHOTHER3_CB_CHECK_LOGINPASS');
  GetIni(ini,LNG_S_SHOTHER3_CB_ENABLE_MSGSERV               ,'Settings','S_SHOTHER3_CB_ENABLE_MSGSERV');
  GetIni(ini,LNG_S_SHOTHER3_CB_RESTRICT_HITPERUSER          ,'Settings','S_SHOTHER3_CB_RESTRICT_HITPERUSER');
  GetIni(ini,LNG_S_SHOTHER3_CB_REFRESH_SERVERS              ,'Settings','S_SHOTHER3_CB_REFRESH_SERVERS');
  GetIni(ini,LNG_S_SHOTHER3_RD_XBUTTON_ATTR                 ,'Settings','S_SHOTHER3_RD_XBUTTON_ATTR');
  GetIni(ini,LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS1          ,'Settings','S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS1');
  GetIni(ini,LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS2          ,'Settings','S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS2');
  GetIni(ini,LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS3          ,'Settings','S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS3');
  GetIni(ini,LNG_S_SHOTHER3_CB_KILL_IDLEUSER                ,'Settings','S_SHOTHER3_CB_KILL_IDLEUSER');
  GetIni(ini,LNG_S_SHOTHER3_LABEL161                        ,'Settings','S_SHOTHER3_LABEL161');
  GetIni(ini,LNG_S_SHOTHER3_LABEL162                        ,'Settings','S_SHOTHER3_LABEL162');
  GetIni(ini,LNG_S_SHOTHER3_CB_MINSHARE_NOBLOCKACT          ,'Settings','S_SHOTHER3_CB_MINSHARE_NOBLOCKACT');
  GetIni(ini,LNG_S_SHOTHER3_CB_DENY_LISTALL_FOR_USERS       ,'Settings','S_SHOTHER3_CB_DENY_LISTALL_FOR_USERS');
  GetIni(ini,LNG_S_SHOTHER3_CB_BLOCK_WEIRD_XNAPFILE         ,'Settings','S_SHOTHER3_CB_BLOCK_WEIRD_XNAPFILE');
  GetIni(ini,LNG_S_SHOTHER3_CB_SUGGEST_DBROWSE              ,'Settings','S_SHOTHER3_CB_SUGGEST_DBROWSE');
  GetIni(ini,LNG_S_SHOTHER4_CB_REGSOFT_ONLY                 ,'Settings','S_SHOTHER4_CB_REGSOFT_ONLY');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_NAPSTER                ,'Settings','S_SHOTHER4_CB_ALLOW_NAPSTER');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_WINMX                  ,'Settings','S_SHOTHER4_CB_ALLOW_WINMX');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_NAPCHAN                ,'Settings','S_SHOTHER4_CB_ALLOW_NAPCHAN');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_TEKNAP                 ,'Settings','S_SHOTHER4_CB_ALLOW_TEKNAP');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_LOPSTER                ,'Settings','S_SHOTHER4_CB_ALLOW_LOPSTER');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_XNAP                   ,'Settings','S_SHOTHER4_CB_ALLOW_XNAP');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_UTATANE                ,'Settings','S_SHOTHER4_CB_ALLOW_UTATANE');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_2GET                   ,'Settings','S_SHOTHER4_CB_ALLOW_2GET');
  GetIni(ini,LNG_S_SHOTHER4_CB_ALLOW_OTHER                  ,'Settings','S_SHOTHER4_CB_ALLOW_OTHER');
  GetIni(ini,LNG_S_SHOTHER4_LABEL163                        ,'Settings','S_SHOTHER4_LABEL163');
  GetIni(ini,LNG_FONT_CHARSET                               ,'Font','FONT_CHARSET');
  GetIni(ini,LNG_FONT_SIZE                                  ,'Font','FONT_SIZE');
  GetIni(ini,LNG_FONT_NAME                                  ,'Font','FONT_NAME');

  ini.Free;
  except
 end;
 try // client messages
  ini:=TIniFile.Create(ApplicationDir+'slavanap.msg');
  GetIni(ini,LNG_MSGFILE_VERSION          ,'Version','BUILD');
  SetConstant(LNG_INVALIDCOMMAND          ,'sȃR}hł [$1]');
  SetConstant(LNG_INVALIDARGS             ,'̐ł');
  SetConstant(LNG_ACCESS                  ,'ANZX');
  GetIni(ini,LNG_ACCESSREG                ,'Main','ACCESSREG');
  SetConstant(LNG_NOTLOGGED               ,'OCĂ܂');
  SetConstant(LNG_LOGGED                  ,'łɃOCĂ܂');
  SetConstant(LNG_NOUSER                  ,'̂悤ȃ[U[͂܂');
  SetConstant(LNG_OFFLINE                 ,'̃[U[̓ItCł');
  GetIni(ini,LNG_REMOTE                   ,'Main','REMOTE');
  GetIni(ini,LNG_GHOST                    ,'Main','GHOST');
  GetIni(ini,LNG_INVALIDNICK              ,'Main','INVALIDNICK');
  GetIni(ini,LNG_INVALIDPASS              ,'Main','INVALIDPASS');
  GetIni(ini,LNG_REGISTERED               ,'Main','REGISTERED');
  SetConstant(LNG_USERSLIMIT              ,'̃T[o[͖ł ($1l̃[U[)');
  GetIni(ini,LNG_INVSPEED                 ,'Main','INVSPEED');
  GetIni(ini,LNG_REGISTEREDONLY           ,'Main','REGISTEREDONLY');
  SetConstant(LNG_LEVEL                   ,'<Server $1> Ȃ̃[U[x$2($3)ɂ܂B');
  SetConstant(LNG_BANNED2                 ,'Ȃban܂: $1');
  GetIni(ini,LNG_BANNED3                  ,'Main','BANNED3');
  GetIni(ini,LNG_REASON_WINMXBAN           ,'Main','REASON_WINMXBAN');
  SetConstant(LNG_MAXCLONES               ,'ȂIP̃[U[܂');
  GetIni(ini,LNG_TOOMUCHMX                ,'Main','TOOMUCHMX');
  GetIni(ini,LNG_INVALIDLEVEL             ,'Main','INVALIDLEVEL');
  SetConstant(LNG_LEVEL1                  ,'<Server $1> $2̃[U[x$3($4)ɂ܂B');
  GetIni(ini,LNG_FRIENDLOGIN              ,'Main','FRIENDLOGIN');
  SetConstant(LNG_LEVEL2                  ,'<$1> $2̃[U[x$3($4)ɂ܂B');
  SetConstant(LNG_LEVEL3                  ,'<$1> Ȃ̃x$2($3)ɂ܂B');
  GetIni(ini,LNG_KICK                     ,'Main','KICK');
  GetIni(ini,LNG_ITEMSLISTED              ,'Main','ITEMSLISTED');
  SetConstant(LNG_NUKE                    ,'<$1> $2̃AJEg폜܂B: $3');
  SetConstant(LNG_UNREGISTER              ,'$1 unregistered $2''s account: $3');
  SetConstant(LNG_UNREGISTER              ,'<$1> $2o^܂B: $3');
  GetIni(ini,LNG_NUKEMSG                  ,'Main','NUKEMSG');
  GetIni(ini,LNG_KICKMSG                  ,'Main','KICKMSG');
  GetIni(ini,LNG_KICKMSG2                 ,'Main','KICKMSG2');
  GetIni(ini,LNG_MEMORYLIMIT              ,'Main','MEMORYLIMIT');
  GetIni(ini,LNG_BANDWIDTHLIMIT           ,'Main','BANDWIDTHLIMIT');
  SetConstant(LNG_FIREWALL                ,'[U[Ƃt@CA[EH[ɂĂ܂B');
  SetConstant(LNG_BROWSEMOD               ,'<$1 $2 ($3)> Ȃ̋Lt@CQƂĂ܂B');
  SetConstant(LNG_WHOISMOD                ,'<$1 $2 ($3)> Ȃ݂̏Ă܂B');
  SetConstant(LNG_IPREQMOD                ,'<$1 $2 ($3)> ȂIPAhX݂Ă܂B');
  GetIni(ini,LNG_SHAREFILESFIRST          ,'Main','SHAREFILESFIRST');
  GetIni(ini,LNG_SHAREMEGSFIRST           ,'Main','SHAREMEGSFIRST');
  GetIni(ini,LNG_BANREASONCHANGE          ,'Main','BANREASONCHANGE');
  GetIni(ini,LNG_BANEXPCHANGE             ,'Main','BANEXPCHANGE');
  GetIni(ini,LNG_MINSHARE_REASON          ,'Main','MINSHARE_REASON');
  GetIni(ini,LNG_MINSHARE_REASON2         ,'Main','MINSHARE_REASON2');
  GetIni(ini,LNG_MUZZLE1                  ,'Main','MUZZLE1');
  GetIni(ini,LNG_UNMUZZLE1                ,'Main','UNMUZZLE1');
  GetIni(ini,LNG_MUZZLE3                  ,'Main','MUZZLE3');
  GetIni(ini,LNG_UNMUZZLE3                ,'Main','UNMUZZLE3');
  GetIni(ini,LNG_MUZZLE                   ,'Main','MUZZLE');
  GetIni(ini,LNG_FLOODMUZZLE              ,'Main','FLOODMUZZLE');
  GetIni(ini,LNG_UNMUZZLE                 ,'Main','UNMUZZLE');
  GetIni(ini,LNG_MUZZLEEXPIRE             ,'Main','MUZZLEEXPIRE');
  GetIni(ini,LNG_CANTTALK                 ,'Main','CANTTALK');
  SetConstant(LNG_ALTERSPEED              ,'<$1> $2̉x$3ɕύX܂B');
  GetIni(ini,LNG_ERRCLOAKED               ,'Main','ERRCLOAKED');
  GetIni(ini,LNG_ERRUNCLOAK               ,'Main','ERRUNCLOAK');
  GetIni(ini,LNG_CLOAKED                  ,'Main','CLOAKED');
  GetIni(ini,LNG_UNCLOAKED                ,'Main','UNCLOAKED');
  SetConstant(LNG_CHPASS2                 ,'<$1> $2̃pX[hύX܂: $3');
  GetIni(ini,LNG_NOVAR                    ,'Main','NOVAR');
  GetIni(ini,LNG_BADVAR                   ,'Main','BADVAR');
  GetIni(ini,LNG_CHANGEVAR                ,'Main','CHANGEVAR');
  GetIni(ini,LNG_USERSERVER               ,'Main','USERSERVER');
  GetIni(ini,LNG_REGEXISTS                ,'Main','REGEXISTS');
  GetIni(ini,LNG_REGOK2                   ,'Main','REGOK2');
  GetIni(ini,LNG_INVALIDNICK2             ,'Main','INVALIDNICK2');
  GetIni(ini,LNG_ADDFRIEND                ,'Main','ADDFRIEND');
  GetIni(ini,LNG_REMOVEFRIEND             ,'Main','REMOVEFRIEND');
  GetIni(ini,LNG_CLIENTBLOCK              ,'Main','CLIENTBLOCK');
  GetIni(ini,LNG_LINKED                   ,'Main','LINKED');
  GetIni(ini,LNG_LINKREQ                  ,'Main','LINKREQ');
  GetIni(ini,LNG_LINKREQ2                 ,'Main','LINKREQ2');
  GetIni(ini,LNG_DELINK                   ,'Main','DELINK');
  GetIni(ini,LNG_DELINK2                  ,'Main','DELINK2');
  GetIni(ini,LNG_LINKERRRESOLVE           ,'Main','LINKERRRESOLVE');
  GetIni(ini,LNG_LINKERRCONNECT           ,'Main','LINKERRCONNECT');
  GetIni(ini,LNG_LINKCONNECTED            ,'Main','LINKCONNECTED');
  GetIni(ini,LNG_LINKBADVERSION           ,'Main','LINKBADVERSION');
  GetIni(ini,LNG_LINKBADVERSION2          ,'Main','LINKBADVERSION2');
  GetIni(ini,LNG_LINKNOLIST               ,'Main','LINKNOLIST');
  GetIni(ini,LNG_LINKNOLIST1              ,'Main','LINKNOLIST1');
  GetIni(ini,LNG_LINKNOLIST2              ,'Main','LINKNOLIST2');
  GetIni(ini,LNG_LINKNOLIST3              ,'Main','LINKNOLIST3');
  GetIni(ini,LNG_LINKLOGGED               ,'Main','LINKLOGGED');
  GetIni(ini,LNG_LINKLOGGED2              ,'Main','LINKLOGGED2');
  GetIni(ini,LNG_LINKLOGGING              ,'Main','LINKLOGGING');
  GetIni(ini,LNG_LINKLOGGING2             ,'Main','LINKLOGGING2');
  GetIni(ini,LNG_LINKNOLINK               ,'Main','LINKNOLINK');
  GetIni(ini,LNG_LINKNOLINK2              ,'Main','LINKNOLINK2');
  GetIni(ini,LNG_LINKMAXSERVERS           ,'Main','LINKMAXSERVERS');
  GetIni(ini,LNG_LINKMAXSERVERS2          ,'Main','LINKMAXSERVERS2');
  GetIni(ini,LNG_LINKINVHANDLE            ,'Main','LINKINVHANDLE');
  GetIni(ini,LNG_LINKINVHANDLE2           ,'Main','LINKINVHANDLE2');
  GetIni(ini,LNG_LINKINVHANDLE3           ,'Main','LINKINVHANDLE3');
  GetIni(ini,LNG_LINKINVIP                ,'Main','LINKINVIP');
  GetIni(ini,LNG_LINKINVIP2               ,'Main','LINKINVIP2');
  GetIni(ini,LNG_LINKERRLOGIN             ,'Main','LINKERRLOGIN');
  GetIni(ini,LNG_DELINKHUB                ,'Main','DELINKHUB');
  GetIni(ini,LNG_LINKINVPASS              ,'Main','LINKINVPASS');
  GetIni(ini,LNG_LINKINVPASS2             ,'Main','LINKINVPASS2');
  GetIni(ini,LNG_LINKSRVLOGGED            ,'Main','LINKSRVLOGGED');
  GetIni(ini,LNG_LINKSRVLOGGED2           ,'Main','LINKSRVLOGGED2');
  GetIni(ini,LNG_LINKLOGINERR             ,'Main','LINKLOGINERR');
  GetIni(ini,LNG_LINKINVCONSOLE           ,'Main','LINKINVCONSOLE');
  GetIni(ini,LNG_NOSUCHSERVER             ,'Main','NOSUCHSERVER');
  GetIni(ini,LNG_CANTDELINK               ,'Main','CANTDELINK');
  GetIni(ini,LNG_DELINKREQ                ,'Main','DELINKREQ');
  GetIni(ini,LNG_INVLINKHANDLE            ,'Main','INVLINKHANDLE');
  GetIni(ini,LNG_LINKSRVLOGGED3           ,'Main','LINKSRVLOGGED3');
  GetIni(ini,LNG_LINKINVHANDLE4           ,'Main','LINKINVHANDLE4');
  GetIni(ini,LNG_CANTREMOVE               ,'Main','CANTREMOVE');
  GetIni(ini,LNG_CANTKILL                 ,'Main','CANTKILL');
  GetIni(ini,LNG_KILLSERVER               ,'Main','KILLSERVER');
  GetIni(ini,LNG_REMOVESERVER             ,'Main','REMOVESERVER');
  GetIni(ini,LNG_MINSHARE                 ,'Main','MINSHARE');
  GetIni(ini,LNG_MINSHARE3                ,'Main','MINSHARE3');
  GetIni(ini,LNG_BLOCKEDWINMX             ,'Main','BLOCKEDWINMX');
  GetIni(ini,LNG_OUTGOINGRESTRICTED       ,'Main','OUTGOINGRESTRICTED');
  GetIni(ini,LNG_FLOODMUZZLE3             ,'Main','FLOODMUZZLE3');
  SetConstant(LNG_RECONNECT               ,'ĐڑłI');
  SetConstant(LNG_SAMENIC                 ,'Someone ($1,$2) is trying to use your nic');
  SetConstant(LNG_SAMENIC                 ,'ꂩ($1,$2)Ȃ̖OgƂĂ܂');
  GetIni(ini,LNG_LINKINVCONSOLE2          ,'Main','LINKINVCONSOLE2');
  GetIni(ini,LNG_LINKINVCONSOLE3          ,'Main','LINKINVCONSOLE3');
  SetConstant(LNG_BROWSEFAIL              ,'QƎs: ̂悤ȃ[U[͂܂');
  SetConstant(LNG_BROWSELEECH             ,'ANZX: Ȃleechł');
  SetConstant(LNG_BROWSEFIREWALL          ,'Ȃ$1͗Ƃt@CA[EH[̓ɂ܂B̐lBɑ΂Ă͎Q/DLł܂B');
  SetConstant(LNG_OFFLINE2                ,'[U[$1̓ItCł');
  SetConstant(LNG_OFFLINE3                ,'T[o[$1̓ItCł');
  GetIni(ini,LNG_LINKING                  ,'Main','LINKING');
  GetIni(ini,LNG_INVALIDSOFTWARE          ,'Main','INVALIDSOFTWARE');
  GetIni(ini,LNG_ALREADYREGISTERED        ,'Main','ALREADYREGISTERED');
  GetIni(ini,LNG_CHANNELMODERATED         ,'Channels','CHANNELMODERATED');
  GetIni(ini,LNG_CHANNELOPERATOR          ,'Channels','CHANNELOPERATOR');
  GetIni(ini,LNG_CHANNELOPERATOR2         ,'Channels','CHANNELOPERATOR2');
  GetIni(ini,LNG_INVALIDCHANNEL           ,'Channels','INVALIDCHANNEL');
  GetIni(ini,LNG_NOCREATE                 ,'Channels','NOCREATE');
  GetIni(ini,LNG_CHANNELLIMIT2            ,'Channels','CHANNELLIMIT2');
  GetIni(ini,LNG_CHANNELLIMIT             ,'Channels','CHANNELLIMIT');
  SetConstant(LNG_NOCHANNEL               ,'̂悤ȃ`l͂܂');
  SetConstant(LNG_CHALREADYBANNED         ,'łBanĂ܂');
  GetIni(ini,LNG_CHBANNED                 ,'Channels','CHBANNED');
  GetIni(ini,LNG_CHUNBANNED               ,'Channels','CHUNBANNED');
  GetIni(ini,LNG_CHJOINED                 ,'Channels','CHJOINED');
  GetIni(ini,LNG_INVITE                   ,'Channels','INVITE');
  Getini(ini,LNG_CLEARCHANNEL             ,'Channels','CLEARCHANNEL');
  GetIni(ini,LNG_CHLEVEL                  ,'Channels','CHLEVEL');
  GetIni(ini,LNG_LIMIT                    ,'Channels','LIMIT');
  GetIni(ini,LNG_CHKICK                   ,'Channels','CHKICK');
  GetIni(ini,LNG_CHNOOPS                  ,'Channels','CHNOOPS');
  GetIni(ini,LNG_CHANOP                   ,'Channels','CHANOP');
  GetIni(ini,LNG_CHANOP2                  ,'Channels','CHANOP2');
  GetIni(ini,LNG_CHANOP3                  ,'Channels','CHANOP3');
  GetIni(ini,LNG_CHANDEOP                 ,'Channels','CHANDEOP');
  GetIni(ini,LNG_CHANDEOP2                ,'Channels','CHANDEOP2');
  GetIni(ini,LNG_CHANDEOP3                ,'Channels','CHANDEOP3');
  GetIni(ini,LNG_CHANDEOP4                ,'Channels','CHANDEOP4');
  GetIni(ini,LNG_DROPCHANNEL              ,'Channels','DROPCHANNEL');
  GetIni(ini,LNG_UNKNOWNCHMODE            ,'Channels','UNKNOWNCHMODE');
  GetIni(ini,LNG_NOMODERATE               ,'Channels','NOMODERATE');
  GetIni(ini,LNG_VOICE                    ,'Channels','VOICE');
  GetIni(ini,LNG_VOICE2                   ,'Channels','VOICE2');
  GetIni(ini,LNG_VOICE3                   ,'Channels','VOICE3');
  GetIni(ini,LNG_VOICE4                   ,'Channels','VOICE4');
  GetIni(ini,LNG_DEVOICE                  ,'Channels','DEVOICE');
  GetIni(ini,LNG_DEVOICE2                 ,'Channels','DEVOICE2');
  GetIni(ini,LNG_DEVOICE3                 ,'Channels','DEVOICE3');
  GetIni(ini,LNG_DEVOICE4                 ,'Channels','DEVOICE4');
  GetIni(ini,LNG_DEVOICE5                 ,'Channels','DEVOICE5');
  GetIni(ini,LNG_CHLIMIT                  ,'Channels','CHLIMIT');
  GetIni(ini,LNG_CHLEVEL2                 ,'Channels','CHLEVEL2');
  GetIni(ini,LNG_CHCREATED                ,'Channels','CHCREATED');
  GetIni(ini,LNG_VOICE5                   ,'Channels','VOICE5');
  GetIni(ini,LNG_VOICE6                   ,'Channels','VOICE6');
  GetIni(ini,LNG_CHANOP4                  ,'Channels','CHANOP4');
  GetIni(ini,LNG_FLOODWARN                ,'Channels','FLOODWARN');
  GetIni(ini,LNG_FLOODMUZZLE1             ,'Channels','FLOODMUZZLE1');
  GetIni(ini,LNG_FLOODMUZZLE2             ,'Channels','FLOODMUZZLE2');
  GetIni(ini,LNG_CHTOPIC                  ,'Channels','CHTOPIC');
  GetIni(ini,LNG_SHARE_ERROR              ,'Share','SHARE_ERROR');
  Getini(ini,LNG_SHARE_SHORT              ,'Share','SHARE_SHORT');
  GetIni(ini,LNG_SHARE_BITRATE            ,'Share','SHARE_BITRATE');
  Getini(ini,LNG_SHARE_FREQ               ,'Share','SHARE_FREQ');
  GetIni(ini,LNG_SHARE_TIME               ,'Share','SHARE_TIME');
  GetIni(ini,LNG_SHARE_LIMIT              ,'Share','SHARE_LIMIT');
  GetIni(ini,LNG_SHARE_TOTAL_LIMIT        ,'Share','SHARE_TOTAL_LIMIT');
  GetIni(ini,LNG_SHARE_MEMORY_LIMIT       ,'Share','SHARE_MEMORY_LIMIT');
  GetIni(ini,LNG_SHARE_SMALL              ,'Share','SHARE_SMALL');
  GetIni(ini,LNG_SHARE_LARGE              ,'Share','SHARE_LARGE');
  GetIni(ini,LNG_NOSHARE_BITRATE          ,'Share','NOSHARE_BITRATE');
  GetIni(ini,LNG_SHARE_10300              ,'Share','SHARE_10300');
  ini.Free;
  except
 end;
end;

// from main thread

function  GetLangT(id: Integer): String;
begin
 try
   if (language_t=nil) or (id>LNG_MAX) or (id<0) then
   begin
    Result:='';
    exit;
   end;
   Result:=UnEscape(language_t.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangT(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
   if (language_t=nil) or (id>LNG_MAX) or (id<0) then
   begin
    Result:='';
    exit;
   end;
   str:=UnEscape(language_t.Strings[id]);
   i:=pos('$1',str);
   if i>0 then
   begin
    system.delete(str,i,2);
    system.insert(arg,str,i);
   end;
   Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangT(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 try
  if (language_t=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=GetLangEx(UnEscape(language_t.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

// from inertface

function  GetLangI(id: Integer): String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=UnEscape(language_i.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangI(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  str:=UnEscape(language_i.Strings[id]);
  i:=pos('$1',str);
  if i>0 then
  begin
   system.delete(str,i,2);
   system.insert(arg,str,i);
  end;
  Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangI(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=GetLangEx(UnEscape(language_i.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

// from other threads

function  GetLangE(id: Integer): String;
begin
 try
   if (language_e=nil) or (id>LNG_MAX) or (id<0) then
   begin
     Result:='';
     exit;
   end;
   Result:=UnEscape(language_e.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangE(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
   if (language_e=nil) or (id>LNG_MAX) or (id<0) then
   begin
     Result:='';
     exit;
   end;
   str:=UnEscape(language_e.Strings[id]);
   i:=pos('$1',str);
   if i>0 then
   begin
     system.delete(str,i,2);
     system.insert(arg,str,i);
   end;
   Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangE(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 if (language_e=nil) or (id>LNG_MAX) or (id<0) then
 begin
   Result:='';
   exit;
 end;
 try
   Result:=GetLangEx(UnEscape(language_e.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;


initialization
begin
 InitLanguage;
end;

finalization
begin
 DestroyLanguage;
end;

end.

