{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: chanattr

 Channel attributes window

*********************************************************}
unit chanattr;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs, stypes,
  vars, channels, handler, constants, lang, OfficeControls, StdCtrls,
  OfficeEdit, OfficeButtons, basecombo, ComboBox, Spin2000, slavastrings,
  Spin, Classes;

type
  TSlavaNapChannelAttr = class(TForm)
    lbl_topic: TLabel;
    edit_topic: TEdit;
    lbl_limit: TLabel;
    lbl_level: TLabel;
    lbl_motd: TLabel;
    box_attr: TGroupBox;
    cb_registered: TCheckBox;
    cb_private: TCheckBox;
    cb_moderated: TCheckBox;
    cb_topic: TCheckBox;
    edit_limit: TSpinEdit;
    edit_level: TComboBox;
    edit_motd: TMemo;
    btn_ok: TButton;
    btn_cancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    channel: String;
    procedure ShowChannel(str: String);
  end;

var
  SlavaNapChannelAttr: TSlavaNapChannelAttr;

implementation

{$R *.DFM}

procedure TSlavaNapChannelAttr.ShowChannel(str: String);
var
 i: Integer;
 ch: TChannel;
 item: PStringHashItem;
begin
 try
  Hide;
  except
 end;
 channel:=str;
 ch:=FindChannel(str);
 if ch=nil then exit;
 edit_level.Items.Clear;
 for i:=0 to 5 do
  edit_level.Items.Add(levels[i]);
 edit_topic.Text:=ch.topic;
 edit_limit.Value:=ch.limit;
 edit_level.ItemIndex:=Ord(ch.level);
 cb_registered.Checked:=chRegistered in ch.state;
 cb_private.Checked:=chPrivate in ch.state;
 cb_moderated.Checked:=chModerated in ch.state;
 cb_topic.Checked:=chTopic in ch.state;
 edit_motd.lines.Clear;
 item:=ch.motd.first;
 while item<>nil do
 begin
   edit_motd.lines.Add(item^.data);
   item:=item^.next;
 end;
 try
  Show;
  edit_topic.SetFocus;
  except
 end;
end;

procedure TSlavaNapChannelAttr.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
end;

procedure TSlavaNapChannelAttr.FormShow(Sender: TObject);
var
 i,j: Integer;
begin
 lbl_topic.Caption:=GetLangI(LNG_EDITCH_TOPIC);
 lbl_limit.Caption:=GetLangI(LNG_EDITCH_LIMIT);
 lbl_level.Caption:=GetLangI(LNG_EDITCH_LEVEL);
 box_attr.Caption:=' '+GetLangI(LNG_EDITCH_ATTR)+' ';
 cb_registered.Caption:=GetLangI(LNG_EDITCH_REGISTERED);
 cb_private.Caption:=GetLangI(LNG_EDITCH_PRIVATE);
 cb_moderated.Caption:=GetLangI(LNG_EDITCH_MODERATED);
 cb_topic.Caption:=GetLangI(LNG_EDITCH_TOPICATTR);
 lbl_motd.Caption:=GetLangI(LNG_EDITCH_MOTD);
 btn_ok.Caption:=GetLangI(LNG_EDITCH_OK);
 btn_cancel.Caption:=GetLangI(LNG_EDITCH_CANCEL);
 Caption:=GetLangI(LNG_EDITCH_CAPTION,channel);
 i:=lbl_topic.Width;
 i:=max(i,lbl_limit.Width);
 i:=max(i,lbl_level.Width);
 inc(i,lbl_topic.Left+8);
 j:=edit_topic.Left+edit_topic.Width-i;
 edit_topic.Left:=i;
 edit_topic.Width:=j;
 edit_limit.Left:=i;
 edit_limit.Width:=j;
 edit_level.Left:=i;
 edit_level.Width:=j;
end;

procedure TSlavaNapChannelAttr.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapChannelAttr.btn_okClick(Sender: TObject);
var
 str: String;
begin
 Close;
 if not running then exit;
 cmd_list.AddDoubleCmd(MSG_SERVER_TOPIC,0,channel+' '+edit_topic.Text,'');
 cmd_list.AddDoubleCmd(MSG_CLIENT_CHANNEL_LIMIT,0,channel+' '+edit_limit.Text,'');
 if edit_level.ItemIndex<>-1 then
  cmd_list.AddDoubleCmd(MSG_CLIENT_SET_CHAN_LEVEL,0,channel+' '+IntToStr(Ord(edit_level.ItemIndex)),'');
 if cb_registered.Checked then str:=' +REGISTERED'
 else str:=' -REGISTERED';
 if cb_private.Checked then str:=str+' +PRIVATE'
 else str:=str+' -PRIVATE';
 if cb_moderated.Checked then str:=str+' +MODERATED'
 else str:=str+' -MODERATED';
 if cb_topic.Checked then str:=str+' +TOPIC'
 else str:=str+' -TOPIC';
 cmd_list.AddDoubleCmd(MSG_CLIENT_CHANNEL_MODE,0,channel+str,'');
 try
  edit_motd.lines.SaveToFile(ApplicationDir+'chmotd.'+channel);
  except
 end;
 cmd_list.AddDoubleCmd(MSG_CMD_RELOADCHMOTD,0,channel,'');
 cmd_list.AddDoubleCmd(MSG_CMD_LISTCHANNELS,0,'','');
end;

end.
