{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: share2

 Some additional functions for unit share.pas

*********************************************************}
unit share2;

interface

uses
 Windows, Classes2, SysUtils, stypes, constants, slavastrings, class_cmdlist,
 class_cmd2list, share;

{$I defines.pas}

procedure SplitFileName(filename: String; var folder: String; var name: String);
procedure GetKeywords(filename: String; list: TNapCmdList); overload;
function  GetKeywords(filename: String; meta: Integer; item: PShare): Boolean; overload;
function  AddKeywordsItem(meta: Byte; item: PShare; keywords: TNapCmdList): Boolean;
procedure DeleteKeywordsItem(item: PShare);

implementation

uses
 vars, handler, keywords, keywords2;

procedure SplitFileName(filename: String; var folder: String; var name: String);
var
 i,p: Integer;
begin
 for i:=Length(filename)-3 downto 1 do
 if (filename[i]='\') or (filename[i]='/') then
 begin
   folder:=Copy(filename,1,i);
   name:=Copy(filename,i+1,Length(filename)-i);
   exit;
 end;
 folder:='';
 name:=filename;
end;

procedure GetKeywords(filename: String; list: TNapCmdList);
var
 i,j,k: Integer;
 dir, name, ext: String;
 start, len, crc: Integer;
 c: Char;
begin
 list.Clear;
 tmp_pos:=1264;
 len:=Length(filename);
 if len<MIN_FILE_NAME then exit;
 filename:=AnsiLowerCase(filename);
//DebugLog('Getting keywords from "'+filename+'":',true);
 // extracting extension (up to 4 characters extension)
 start:=0;
 for i:=0 to 4 do
  if start=0 then
   if filename[len-i]='.' then
    start:=len-i;
 if start=0 then // no extension
  ext:=''
 else
 begin // found extension
   ext:=Copy(filename, start+1, 5);
   len:=start-1;
   SetLength(filename, len);
 end;
 tmp_pos:=1265;
 // extracting filename
 start:=0;
 if len>0 then
  for i:=len downto 1 do
   if start=0 then
    if (filename[i]='/') or (filename[i]='\') or (filename[i]=':') then
     start:=i;
 if start=0 then // no filename???
   name:=''
 else
 begin
   name:=Copy(filename, start+1, len);
   len:=start-1;
   if len<0 then len:=0;
   SetLength(filename,len);
 end;
 tmp_pos:=1266;
 // extracting sub-dir
 start:=0;
 if len>0 then
  for i:=len downto 1 do
   if start=0 then
    if (filename[i]='/') or (filename[i]='\') or (filename[i]=':') then
     start:=i;
 if start=0 then // no directory
   dir:=''
 else
   dir:=Copy(filename, start+1, len);
//DebugLog('  Directory="'+dir+'", name="'+name+'", ext="'+ext+'"',true);
 // extracting keywords
 i:=MAX_FILE_KEYWORDS;
 dec(i,SplitToKeywords(ext+' ',list,1));
 j:=SplitToKeywords(name+' ',list,i);
 if j<1 then
 begin // no keywords in filename - cannot share file
   list.Clear;
   exit;
 end;
 dec(i,j);
 tmp_pos:=1267;
 if (i>0) and (Length(dir)>0) then
 begin
  // checking blocked dirs list
  crc:=StringCRC(dir,false);
  for i:=0 to db_dirs.count-1 do
   if crc>0 then
    if PNapCmd(db_dirs.Items[i])^.id=crc then
     if PNapCmd(db_dirs.Items[i])^.cmd=dir then
      crc:=0; // blocked directory
   if crc>0 then
    SplitToKeywords(dir+' ',list,i); // extracting keywords from directory
 end;
end;

function GetKeywords(filename: String; meta: Integer; item: PShare): Boolean;
var
 list: TNapCmdList;
 i,j: Integer;
 hash: TNapCmdList;
 match: Boolean;
begin
 tmp_pos:=1268;
 // getting keywords
 list:=TNapCmdList.Create;
 GetKeywords(filename,list);
 tmp_pos:=1269;
 // checking blocked files
 for i:=0 to db_blocks.count-1 do
 begin
   hash:=db_blocks.Items[i];
   match:=true;
   for j:=0 to hash.count-1 do
    if match then
     if list.FindById(PNapCmd(hash.Items[j])^.id)=-1 then
      match:=false;
   if match then // all crc matched - checking keywords
   for j:=0 to hash.count-1 do
    if match then
     if list.FindItem(PNapCmd(hash.Items[j])^.id,PNapCmd(hash.Items[j])^.cmd)=-1 then
      match:=false;
   if match then
   begin // blocked
     list.Free;
     Result:=false;
     exit;
   end;
 end;
 tmp_pos:=1270;
 // adding keywords
 result:=AddKeywordsItem(meta,item,list);
 list.Free;
end;

function AddKeywordsItem(meta: Byte; item: PShare; keywords: TNapCmdList): Boolean;
// adds keywords from 'keywords' pointing to 'item' to database
var
 i, j: Integer;
 lst: TMyList;
 keyword: String;
 kw: PKeyword;
 kwi: PKeywordItem;
 index, kwlength: Integer;
begin
 tmp_pos:=1271;
 Result:=true;
 if item^.num_words>0 then
   FreeKeywordsList(item);
 lst:=TMyList.Create;
 tmp_pos:=1272;
 for i:=0 to keywords.count-1 do
 begin
   keyword:=PNapCmd(keywords.Items[i])^.cmd;
   kwlength:=Length(keyword);
   index:=GetKeywordIndex(keyword);
   if index<>KEYWORDS_NOINDEX then
   begin
     tmp_pos:=1273;
     kw:=KWList_FindItem(db_keywords[meta,index,kwlength],keyword);
     if kw=nil then
      kw:=KWList_AddItem(db_keywords[meta,index,kwlength],meta,keyword);
     tmp_pos:=1274;
     kwi:=KWList_AddShare(kw,item);
     lst.Add(kw);
     lst.Add(kwi);
     if lst.count>=MAX_FILE_KEYWORDS*2 then
     begin // too many keywords. stopping
       tmp_pos:=1275;
       AllocateKeywordsList(item, lst.count div 2);
       for j:=0 to lst.count-1 do
        item^.keywords^[j]:=lst.Items[j];
       lst.Free;
       exit;
     end;
   end;
 end;
 tmp_pos:=1276;
 if lst.count<2 then
 begin
   result:=false;
   lst.Free;
   exit;
 end;
 AllocateKeywordsList(item, lst.count div 2);
 for j:=0 to lst.count-1 do
  item^.keywords^[j]:=lst.Items[j];
 lst.Free;
end;

procedure DeleteKeywordsItem(item: PShare);
// deletes all keyword items from database
var
 i: Integer;
begin
 tmp_pos:=1277;
 for i:=0 to item^.num_words-1 do
   KWList_DeleteShare(item^.keywords[i*2],item^.keywords[i*2+1],item);
 tmp_pos:=1278;
 FreeKeywordsList(item);
end;


end.
