unit blocks;

interface

uses
  Windows, Classes, Classes2, slavastrings, vars, constants, memory_manager,
  stypes, SysUtils, class_cmdlist;

procedure FreeBlocks;
procedure LoadBlocks;
procedure SaveBlocks;

implementation

procedure FreeBlocks;
var
 i: Integer;
begin
 for i:=0 to db_blocks.Count-1 do
  TNapCmdList(db_blocks.Items[i]).Free;
 db_blocks.Free;
 db_blocks:=nil;
end;

procedure LoadBlocks;
var
 i,j,k,crc: Integer;
 list,lst: TMyStringList;
 hash,h2: TNapCmdList;
 str: String;
 match: Boolean;
begin
 list:=TMyStringList.Create;
 try
  list.LoadFromFile(ApplicationDir+'block');
  except
   list.Free;
   exit;
 end;
 lst:=TMyStringList.Create;
 for i:=0 to list.Count-1 do
 if Length(list.Strings[i])>1 then
 if list.Strings[i][1]<>'#' then
 begin
   hash:=TNapCmdList.Create;
   SplitString(StripString(AnsiLowerCase(list.Strings[i])),lst);
   for j:=0 to lst.count-1 do
   begin
     str:=lst.Strings[j];
     if Length(str)>=KEYWORD_LEN_MIN then
     begin
       if Length(str)>KEYWORD_LEN_MAX then
        SetLength(str,KEYWORD_LEN_MAX);
       crc:=StringCRC(str,false);
       hash.AddCmd(crc,str);
     end;
   end;
   if hash.count>0 then
   begin
     for k:=0 to db_blocks.count-1 do
     if hash<>nil then
     begin
       h2:=db_blocks.Items[k];
       if h2.count=hash.count then
       begin
         match:=true; // comparing crc of every keyword (much faster than to compare all keywords)
         for j:=0 to hash.count-1 do
          if match then
           if h2.FindItem(PNapCmd(hash.Items[j]).id,PNapCmd(hash.Items[j]).cmd)=-1 then
            match:=false;
         if match then // all keywords from 'hash' are present in 'h2' (it doesn't guarantee that all keywords from 'h2' are present in 'hash' because there might be duplicate keywords)
         begin
           hash.Free;
           hash:=nil;
         end
       end;
     end;
     if hash<>nil then
     begin
       db_blocks.Add(hash);
     end;
   end
   else
     hash.Free;
 end;
 lst.Free;
 list.Free;
end;

procedure SaveBlocks;
var
 list: TMyStringList;
 str: String;
 i,j: Integer;
 hash: TNapCmdList;
begin
 list:=CreateStringList;
 for i:=0 to db_blocks.Count-1 do
 begin
   hash:=db_blocks.Items[i];
   str:='';
   for j:=0 to hash.count-1 do
    str:=str+PNapCmd(hash.Items[j])^.cmd+' ';
   if Length(str)>0 then
    list.Add(str);
 end;
 list.Sort;
 list.Insert(0,'# ! ̃t@C͎T[o[Vbg_EƂ㏑܂B');
 list.Insert(1,'# ҏWɃT[o[ғĂȂƂmFĂB');
 list.Insert(2,'#');
 list.Insert(3,'# L珜Ot@C̃XgłB');
 list.Insert(4,'# es͐K\ŋLq܂B');
 list.Insert(5,'# 啶/͋ʂ܂B');
 list.Insert(6,'#');
 list.Insert(7,'# : alanis morissette');
 list.Insert(8,'# "sample.block"t@CŏOt@C̕W̃Xg܂.');
 list.Insert(9,'#');
 try
  list.SaveToFile(ApplicationDir+'block');
  except
 end;
 FreeStringList(list);
end;

end.
