unit SlavaPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls;

type
  TSlavaBorder = (sbNone,sbRect,sbOval);
  TSlavaPanel = class(TCustomPanel)
  private
    { Private declarations }
    fBorder1: TColor;
    fBorder2: TColor;
    fBorderType: TSlavaBorder;
    fOnMouseOver,
    fOnMouseOut: TNotifyEvent;
  protected
    { Protected declarations }
    procedure SetBorder1(Value:TColor);
    procedure SetBorder2(Value:TColor);
    procedure SetBorderType(Value: TSlavaBorder);
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property BorderColor1:TColor read fBorder1 write SetBorder1;
    property BorderColor2:TColor read fBorder2 write SetBorder2;
    // default
    property Align;
    property Alignment;
    property Anchors;
    property AutoSize;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BiDiMode;
    property BorderWidth;
    property BorderStyle;
    property BorderType: TSlavaBorder read fBorderType write SetBorderType default sbRect;
    property Caption;
    property Color;
    property Constraints;
    property Ctl3D;
    property UseDockManager default True;
    property DockSite;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FullRepaint;
    property Font;
    property Locked;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnCanResize;
    property OnClick;
    property OnConstrainedResize;
    property OnDockDrop;
    property OnDockOver;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnGetSiteInfo;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDock;
    property OnStartDrag;
    property OnUnDock;
    property OnMouseOver: TNotifyEvent read fOnMouseOver write fOnMouseOver;
    property OnMouseOut:  TNotifyEvent read fOnMouseOut  write fOnMouseOut;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('SlavaNap', [TSlavaPanel]);
end;

constructor TSlavaPanel.Create(AOwner: TComponent);
begin
 inherited;
// BevelInner:=bvNone;
// BevelOuter:=bvNone;
// BorderStyle:=bsNone;
 ParentColor:=true;
 Caption:=' ';
 fBorder1:=clWhite;
 fBorder2:=clGray;
end;

destructor TSlavaPanel.Destroy;
begin
 inherited;
end;

procedure TSlavaPanel.CMMouseEnter(var Message: TMessage);
begin
 if Assigned(FOnMouseOver) then FOnMouseOver(self);
end;

procedure TSlavaPanel.CMMouseLeave(var Message: TMessage);
begin
 if Assigned(FOnMouseOut) then FOnMouseOut(self);
end;


procedure TSlavaPanel.SetBorder1(Value:TColor);
begin
 fBorder1:=Value;
 Invalidate;
end;

procedure TSlavaPanel.SetBorder2(Value:TColor);
begin
 fBorder2:=Value;
 Invalidate;
end;

procedure TSlavaPanel.Paint;
const
  Alignments: array[TAlignment] of Longint = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
  TopColor, BottomColor: TColor;
  FontHeight: Integer;
  Flags: Longint;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := fBorder1;
    if Bevel = bvLowered then TopColor := fBorder2;
    BottomColor := fBorder2;
    if Bevel = bvLowered then BottomColor := fBorder1;
  end;

begin
  Rect := GetClientRect;
  if BevelOuter <> bvNone then
  begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then
  begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  with Canvas do
  begin
    Brush.Color := Color;
    FillRect(Rect);
    Brush.Style := bsClear;
    Font := Self.Font;
    FontHeight := TextHeight('W');
    with Rect do
    begin
      Top := ((Bottom + Top) - FontHeight) div 2;
      Bottom := Top + FontHeight;
    end;
    Flags := DT_EXPANDTABS or DT_VCENTER or Alignments[Alignment];
    Flags := DrawTextBiDiModeFlags(Flags);
    DrawText(Handle, PChar(Caption), -1, Rect, Flags);
  end;
end;


procedure TSlavaPanel.SetBorderType(Value: TSlavaBorder);
begin
 fBorderType:=Value;
 Invalidate;
end;


end.
