{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: whoisform

 Whois window

*********************************************************}
unit whoisform;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, OfficePanel, ComCtrls, Classes;

type
  TSlavaNapWhois = class(TForm)
    MainMenu1: TMainMenu;
    mnu_close: TMenuItem;
    mnu_hotlist: TMenuItem;
    mnu_friend: TMenuItem;
    mnu_ignore: TMenuItem;
    mnu_message: TMenuItem;
    ksoOfficePanel1: TksoOfficePanel;
    log: TRichEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure CreateParams(Var params: TCreateParams); override;
    procedure mnu_draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
    procedure mnu_closeClick(Sender: TObject);
    procedure mnu_hotlistClick(Sender: TObject);
    procedure mnu_friendClick(Sender: TObject);
    procedure mnu_ignoreClick(Sender: TObject);
    procedure mnu_messageClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    user: String;
  end;

implementation

uses lang, stypes, vars, mainform, constants, slavamenu;

{$R *.DFM}

procedure TSlavaNapWhois.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapWhois.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 log.lines.clear;
 log.Color:=slBackground;
 log.Font.Color:=slText;
end;

procedure TSlavaNapWhois.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapWhois.mnu_draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 SlavaDrawMainMenu(self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapWhois.mnu_closeClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapWhois.mnu_hotlistClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST,0,user,'');
end;

procedure TSlavaNapWhois.mnu_friendClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_FRIENDS,0,'add '+user,'');
end;

procedure TSlavaNapWhois.mnu_ignoreClick(Sender: TObject);
begin
 if running then
  cmd_list.AddDoubleCmd(MSG_CLIENT_IGNORE_USER,0,user,'');
end;

procedure TSlavaNapWhois.mnu_messageClick(Sender: TObject);
begin
 if running then
  SlavaNapWindow.CreateChatWindow(user);
end;

procedure TSlavaNapWhois.FormDestroy(Sender: TObject);
var
 i: Integer;
begin
 if cons_whois<>nil then
  for i:=cons_whois.Count-1 downto 0 do
   if cons_whois.Items[i]=self then
    cons_whois.Delete(i);
end;

end.
