{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: invitationform

 Channel invitation window

*********************************************************}
unit invitationform;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, OfficeButtons, OfficeEdit, Classes;

type
  TSlavaNapInvitation = class(TForm)
    Panel1: TPanel;
    btn_accept: TButton;
    btn_deny: TButton;
    btn_whois: TButton;
    btn_message: TButton;
    btn_hotlist: TButton;
    Label1: TLabel;
    lbl_channel: TLabel;
    lbl_topic: TLabel;
    edit_channel: TEdit;
    edit_topic: TEdit;
    btn_ignore: TButton;
    procedure FormCreate(Sender: TObject);
    procedure CreateParams(var params: TCreateParams); override;
    procedure FormShow(Sender: TObject);
    procedure btn_acceptClick(Sender: TObject);
    procedure btn_denyClick(Sender: TObject);
    procedure btn_whoisClick(Sender: TObject);
    procedure btn_messageClick(Sender: TObject);
    procedure btn_hotlistClick(Sender: TObject);
    procedure btn_ignoreClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    user, channel, topic: String;
  end;

var
  SlavaNapInvitation: TSlavaNapInvitation;

implementation

uses lang, constants, console, mainform, vars, stypes;

{$R *.DFM}

procedure TSlavaNapInvitation.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapInvitation.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
end;

procedure TSlavaNapInvitation.FormShow(Sender: TObject);
var
 r: TRect;
 i,j: Integer;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 Caption:=GetLangI(LNG_INV_CAPTION);
 lbl_channel.Caption:=GetLangI(LNG_INV_NAME);
 lbl_topic.Caption:=GetLangI(LNG_INV_TOPIC);
 i:=max(lbl_channel.Width,lbl_topic.Width)+16;
 edit_channel.Left:=i;
 edit_topic.Left:=i;
 edit_channel.Text:=channel;
 edit_topic.Text:=topic;
 btn_accept.Caption:=GetLangI(LNG_INV_ACCEPT);
 btn_accept.Width:=Canvas.TextWidth(btn_accept.Caption)+20;
 i:=btn_accept.Left+btn_accept.Width+8;
 btn_deny.Caption:=GetLangI(LNG_INV_DENY);
 btn_deny.Width:=Canvas.TextWidth(btn_deny.Caption)+25;
 btn_deny.Left:=i;
 inc(i,btn_deny.Width+8);
 btn_whois.Caption:=GetLangI(LNG_INV_WHOIS);
 btn_whois.Width:=Canvas.TextWidth(btn_whois.Caption)+25;
 btn_whois.Left:=i;
 inc(i,btn_whois.Width+8);
 btn_message.Caption:=GetLangI(LNG_INV_PRIVMSG);
 btn_message.Width:=Canvas.TextWidth(btn_message.Caption)+25;
 btn_message.Left:=i;
 inc(i,btn_message.Width+8);
 btn_hotlist.Caption:=GetLangI(LNG_INV_HOTLIST);
 btn_hotlist.Width:=Canvas.TextWidth(btn_hotlist.Caption)+25;
 btn_hotlist.Left:=i;
 inc(i,btn_hotlist.Width+8);
 btn_ignore.Caption:=GetLangI(LNG_INV_IGNORE);
 btn_ignore.Width:=Canvas.TextWidth(btn_ignore.Caption)+25;
 btn_ignore.Left:=i;
 inc(i,btn_ignore.Width+8);
 ClientWidth:=i;
 panel1.Width:=ClientWidth-16;
 edit_channel.Width:=panel1.width-edit_channel.Left-10;
 edit_topic.Width:=panel1.width-edit_topic.left-10;
 label1.Caption:=GetLangI(LNG_INV_MESSAGE,user);
 label1.Left:=(Width-label1.Width) div 2;
end;

procedure TSlavaNapInvitation.btn_acceptClick(Sender: TObject);
begin
 if not running then exit;
 Close;
 cmd_list.AddDoubleCmd(MSG_CLIENT_CHANNEL_INVITE_ACCEPT,0,'','');
 cmd_list.AddDoubleCmd(MSG_CLIENT_JOIN,0,channel,'');
end;

procedure TSlavaNapInvitation.btn_denyClick(Sender: TObject);
begin
 if not running then exit;
 Close;
 cmd_list.AddDoubleCmd(MSG_CLIENT_CHANNEL_INVITE_DECLINE,0,'','');
end;

procedure TSlavaNapInvitation.btn_whoisClick(Sender: TObject);
begin
 if not running then exit;
 cmd_list.AddDoubleCmd(MSG_CLIENT_WHOIS,0,user,'');
end;

procedure TSlavaNapInvitation.btn_messageClick(Sender: TObject);
begin
 if running then
  SlavaNapWindow.CreateChatWindow(user);
end;

procedure TSlavaNapInvitation.btn_hotlistClick(Sender: TObject);
begin
 if not running then exit;
 cmd_list.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST,0,user,'');
end;

procedure TSlavaNapInvitation.btn_ignoreClick(Sender: TObject);
begin
 if not running then exit;
 Close;
 cmd_list.AddDoubleCmd(MSG_CLIENT_IGNORE_USER,0,user,'');
end;

end.
 