{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Languages

 Form for selecting language

*********************************************************}
unit Languages;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  IniFiles, ComCtrls, ExtCtrls, StdCtrls, Classes;

type
  TSlavaNapLanguage = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    Btn_Ok: TButton;
    Btn_Cancel: TButton;
    List: TListView;
    procedure FormShow(Sender: TObject);
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_OkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Modal: Boolean;
    procedure CreateParams(var Params: TCreateParams); override;
  end;

var
  SlavaNapLanguage: TSlavaNapLanguage;

procedure SetFont(Font: TFont; Fontsize: Integer = 0);

implementation

uses MainForm, Vars, STypes, Lang, Settings;

{$R *.DFM}

procedure SetFont(Font: TFont; Fontsize: Integer = 0);
var
  Charset: string;
begin
  if Font = nil then Exit;
  Charset := UpperCase(GetLangI(LNG_FONT_CHARSET));
  if Charset = 'ANSI_CHARSET' then
    Font.Charset := ANSI_CHARSET
  else if Charset = 'DEFAULT_CHARSET' then
    Font.Charset := DEFAULT_CHARSET
  else if Charset = 'SHIFTJIS_CHARSET' then
    Font.Charset := SHIFTJIS_CHARSET
  else if Charset = 'HANGEUL_CHARSET' then
    Font.Charset := HANGEUL_CHARSET
  else if Charset = 'JOHAB_CHARSET' then
    Font.Charset := JOHAB_CHARSET
  else if Charset = 'GB2312_CHARSET' then
    Font.Charset := GB2312_CHARSET
  else if Charset = 'CHINESEBIG5_CHARSET' then
    Font.Charset := CHINESEBIG5_CHARSET
  else if Charset = 'GREEK_CHARSET' then
    Font.Charset := GREEK_CHARSET
  else if Charset = 'TURKISH_CHARSET' then
    Font.Charset := TURKISH_CHARSET
  else if Charset = 'VIETNAMESE_CHARSET' then
    Font.Charset := VIETNAMESE_CHARSET
  else if Charset = 'HEBREW_CHARSET' then
    Font.Charset := HEBREW_CHARSET
  else if Charset = 'ARABIC_CHARSET' then
    Font.Charset := ARABIC_CHARSET
  else if Charset = 'BALTIC_CHARSET' then
    Font.Charset := BALTIC_CHARSET
  else if Charset = 'RUSSIAN_CHARSET' then
    Font.Charset := RUSSIAN_CHARSET
  else if Charset = 'THAI_CHARSET' then
    Font.Charset := THAI_CHARSET
  else if Charset = 'EASTEUROPE_CHARSET' then
    Font.Charset := EASTEUROPE_CHARSET
  else if Charset = 'OEM_CHARSET' then
    Font.Charset := OEM_CHARSET;
  if FontSize = 0 then
    Fontsize := StrToIntDef(GetLangI(LNG_FONT_SIZE), 0);
  if FontSize <> 0 then
    Font.Size := Fontsize;
  Font.Name := GetLangI(LNG_FONT_NAME);
end;

procedure TSlavaNapLanguage.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapLanguage.FormShow(Sender: TObject);
var
  I: Integer;
  Item: TListItem;
  Rec: TSearchRec;
  Str, FName, Lang, Comments, Ver: string;
  Ini: TIniFile;
begin
  Btn_Cancel.Visible := not modal;
  if Language = '' then
    Language := 'english';
  with List do
  begin
    Items.BeginUpdate;
    Items.Clear;
    I := FindFirst(ApplicationDir + '*.lng', faAnyFile, Rec);
    while I = 0 do
    begin
      if (Rec.Attr and faDirectory) = 0 then
        if Rec.Name <> '.' then
          if Rec.Name <> '..' then
          begin
            Str := AnsiLowerCase(ExtractFileName(Rec.Name));
            Str := Copy(Str, 1, Length(Str) - 4);
            FName := Str;
            Lang := '';
            Comments := '';
            Ver := '';
            try
              Ini := TIniFile.Create(ApplicationDir + FName + '.lng');
              Lang := Ini.ReadString('Version', 'Language', '');
              Comments := Ini.ReadString('Version', 'Comments', '');
              Ver := Ini.ReadString('Version', 'Version', '');
              Ini.Free;
            except
            end;
            if FName <> '' then
              if Lang <> '' then
                if Comments <> '' then
                begin
                  Item := Items.Add;
                  Item.Caption := Lang;
                  Item.SubItems.Add(FName + '.lng');
                  Item.SubItems.Add(Ver);
                  Item.SubItems.Add(Comments);
                  Item.SubItems.Add(FName);
                  if FName = Language then
                    Item.Selected := True;
                end;
          end;
      I := FindNext(Rec);
    end;
    FindClose(Rec);
    Items.EndUpdate;
  end;
end;

procedure TSlavaNapLanguage.Btn_CancelClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapLanguage.Btn_OkClick(Sender: TObject);
begin
  if List.Selected <> nil then
    Language := List.Selected.SubItems[3]
  else if List.Items.Count > 0 then
    Language := List.Items[0].SubItems[3];
  Close;
  if Btn_Cancel.Visible and Running then
  begin
    LoadLanguage(Language);
    SlavaNapWindow.ChangeInterface;
    SlavaNapSettings.ChangeInterface;
  end;
end;

end.
