{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: ModeForm

 Console user mode

*********************************************************}
unit ModeForm;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Classes;

type
  TSlavaNapMode = class(TForm)
    Cb_Errors: TCheckBox;
    Cb_Announcements: TCheckBox;
    Cb_MBan: TCheckBox;
    Cb_Change: TCheckBox;
    Cb_Kill: TCheckBox;
    Cb_Level: TCheckBox;
    Cb_Server: TCheckBox;
    Cb_Muzzle: TCheckBox;
    Cb_Port: TCheckBox;
    Cb_Wallop: TCheckBox;
    Cb_Cloak: TCheckBox;
    Cb_Flood: TCheckBox;
    Cb_Msg: TCheckBox;
    Cb_Whois: TCheckBox;
    Cb_Browse: TCheckBox;
    Cb_MFriends: TCheckBox;
    Cb_Channel: TCheckBox;
    Cb_Register: TCheckBox;
    Cb_Var: TCheckBox;
    Btn_Ok: TButton;
    Btn_All: TButton;
    Btn_None: TButton;
    Btn_Cancel: TButton;
    Cb_Ping: TCheckBox;
    Cb_MBanConn: TCheckBox;
    Cb_SBan: TCheckBox;
    Cb_SBanConn: TCheckBox;
    Cb_Leech: TCheckBox;
    Cb_Samenic: TCheckBox;
    Cb_SFriends: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_AllClick(Sender: TObject);
    procedure Btn_NoneClick(Sender: TObject);
    procedure Btn_OkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowForm;
  end;

var
  SlavaNapMode: TSlavaNapMode;

implementation

uses MainForm, Lang, Constants, Vars, STypes, Languages;

{$R *.DFM}

procedure TSlavaNapMode.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
end;

procedure TSlavaNapMode.ShowForm;
var
  St: TUserState;
begin
  SetFont(Self.Font);
  St := Cons.Data^.State;
  Caption := GetLangI(LNG_MODE_CAPTION);
  Cb_Errors.Caption := GetLangI(LNG_MODE_ERROR);
  Cb_Announcements.Caption := GetLangI(LNG_MODE_ANNOUNCE);
  Cb_Mban.Caption := GetLangI(LNG_MODE_MBAN);
  Cb_Mbanconn.Caption := GetLangI(LNG_MODE_MBANCONN);
  Cb_Sban.Caption := GetLangI(LNG_MODE_SBAN);
  Cb_Sbanconn.Caption := GetLangI(LNG_MODE_SBANCONN);
  Cb_Change.Caption := GetLangI(LNG_MODE_CHANGE);
  Cb_Kill.Caption := GetLangI(LNG_MODE_KILL);
  Cb_Level.Caption := GetLangI(LNG_MODE_LEVEL);
  Cb_Server.Caption := GetLangI(LNG_MODE_SERVER);
  Cb_Muzzle.Caption := GetLangI(LNG_MODE_MUZZLE);
  Cb_Port.Caption := GetLangI(LNG_MODE_PORT);
  Cb_Wallop.Caption := GetLangI(LNG_MODE_WALLOP);
  Cb_Cloak.Caption := GetLangI(LNG_MODE_CLOAK);
  Cb_Flood.Caption := GetLangI(LNG_MODE_FLOOD);
  Cb_Msg.Caption := GetLangI(LNG_MODE_MSG);
  Cb_Whois.Caption := GetLangI(LNG_MODE_WHOIS);
  Cb_Browse.Caption := GetLangI(LNG_MODE_BROWSE);
  // Cb_Friends.Caption := GetLangI(LNG_MODE_FRIEND);
  Cb_MFriends.Caption := GetLangI(LNG_MODE_MFRIEND);
  Cb_SFriends.Caption := GetLangI(LNG_MODE_SFRIEND);
  Cb_Channel.Caption := GetLangI(LNG_MODE_CHANNEL);
  Cb_Register.Caption := GetLangI(LNG_MODE_REGISTER);
  Cb_var.Caption := GetLangI(LNG_MODE_VAR);
  Cb_Ping.Caption := GetLangI(LNG_MODE_PING);
  Cb_Leech.Caption := GetLangI(LNG_MODE_LEECH);
  Cb_Samenic.Caption := GetLangI(LNG_MODE_SAMENIC);
  Btn_Ok.Caption := GetLangI(LNG_MODE_OK);
  Btn_All.Caption := GetLangI(LNG_MODE_ALL);
  Btn_None.Caption := GetLangI(LNG_MODE_NONE);
  Btn_Cancel.Caption := GetLangI(LNG_MODE_CANCEL);
  Cb_Errors.Checked := not (userHideErrors in St);
  Cb_Announcements.Checked := not (userHideAnnouncements in St);
  Cb_Mban.Checked := not (userHideMBans in St);
  Cb_Mbanconn.Checked := not (userHideMBanConn in St);
  Cb_Sban.Checked := not (userHideSBans in St);
  Cb_Sbanconn.Checked := not (userHideSBanConn in St);
  Cb_Change.Checked := not (userHideChange in St);
  Cb_Kill.Checked := not (userHideKill in St);
  Cb_Level.Checked := not (userHideLevel in St);
  Cb_Server.Checked := not (userHideServer in St);
  Cb_Muzzle.Checked := not (userHideMuzzle in St);
  Cb_Port.Checked := not (userHidePort in St);
  Cb_Wallop.Checked := not (userHideWallop in St);
  Cb_Cloak.Checked := not (userHideCloak in St);
  Cb_Flood.Checked := not (userHideFlood in St);
  Cb_Msg.Checked := not (userHidePM in St);
  Cb_Whois.Checked := not (userHideWhois in St);
  Cb_Browse.Checked := not (userHideBrowse in St);
  // Cb_Friends.Checked := not (userHideFriends in St);
  Cb_MFriends.Checked := not (userHideMFriends in St);
  Cb_SFriends.Checked := not (userHideSFriends in St);
  Cb_Channel.Checked := not (userHideChannel in St);
  Cb_Register.Checked := not (userHideRegister in St);
  Cb_var.Checked := not (userHideVar in St);
  Cb_Ping.Checked := not (userHidePing in St);
  Cb_Leech.Checked := not (userHideLeech in St);
  Cb_Samenic.Checked := not (userHideSameNic in St);
  try
    Show;
  except
  end;
end;

procedure TSlavaNapMode.Btn_CancelClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapMode.Btn_AllClick(Sender: TObject);
begin
  Cmd_List.AddDoubleCmd(MSG_CLIENT_USER_MODE, 0, 'ALL', '');
  Close;
end;

procedure TSlavaNapMode.Btn_NoneClick(Sender: TObject);
begin
  Cmd_List.AddDoubleCmd(MSG_CLIENT_USER_MODE, 0, 'NONE', '');
  Close;
end;

procedure TSlavaNapMode.Btn_OkClick(Sender: TObject);
var
  Str: string;
begin
  Close;
  if Cb_Errors.Checked then
    Str := '+ERROR'
  else
    Str := '-ERROR';
  if Cb_Announcements.Checked then
    Str := Str + ' +ANNOUNCE'
  else
    Str := Str + ' -ANNOUNCE';
  if Cb_Mban.Checked then
    Str := Str + ' +MBAN'
  else
    Str := Str + ' -MBAN';
  if Cb_Mbanconn.Checked then
    Str := Str + ' +MBANCONN'
  else
    Str := Str + ' -MBANCONN';
  if Cb_Sban.Checked then
    Str := Str + ' +SBAN'
  else
    Str := Str + ' -SBAN';
  if Cb_Sbanconn.Checked then
    Str := Str + ' +SBANCONN'
  else
    Str := Str + ' -SBANCONN';
  if Cb_Change.Checked then
    Str := Str + ' +CHANGE'
  else
    Str := Str + ' -CHANGE';
  if Cb_Kill.Checked then
    Str := Str + ' +KILL'
  else
    Str := Str + ' -KILL';
  if Cb_Level.Checked then
    Str := Str + ' +LEVEL'
  else
    Str := Str + ' -LEVEL';
  if Cb_Server.Checked then
    Str := Str + ' +SERVER'
  else
    Str := Str + ' -SERVER';
  if Cb_Muzzle.Checked then
    Str := Str + ' +MUZZLE'
  else
    Str := Str + ' -MUZZLE';
  if Cb_Port.Checked then
    Str := Str + ' +PORT'
  else
    Str := Str + ' -PORT';
  if Cb_Wallop.Checked then
    Str := Str + ' +WALLOP'
  else
    Str := Str + ' -WALLOP';
  if Cb_Cloak.Checked then
    Str := Str + ' +CLOAK'
  else
    Str := Str + ' -CLOAK';
  if Cb_Flood.Checked then
    Str := Str + ' +FLOOD'
  else
    Str := Str + ' -FLOOD';
  if Cb_Msg.Checked then
    Str := Str + ' +MSG'
  else
    Str := Str + ' -MSG';
  if Cb_Whois.Checked then
    Str := Str + ' +WHOIS'
  else
    Str := Str + ' -WHOIS';
  if Cb_Browse.Checked then
    Str := Str + ' +BROWSE'
  else
    Str := Str + ' -BROWSE';
  {if Cb_Friends.Checked then
    Str := Str + ' +FRIEND'
  else
    Str := Str + ' -FRIEND';}
  if Cb_MFriends.Checked then
    Str := Str + ' +MFRIEND'
  else
    Str := Str + ' -MFRIEND';
  if Cb_SFriends.Checked then
    Str := Str + ' +SFRIEND'
  else
    Str := Str + ' -SFRIEND';
  if Cb_Channel.Checked then
    Str := Str + ' +CHANNEL'
  else
    Str := Str + ' -CHANNEL';
  if Cb_Register.Checked then
    Str := Str + ' +REGISTER'
  else
    Str := Str + ' -REGISTER';
  if Cb_var.Checked then
    Str := Str + ' +VAR'
  else
    Str := Str + ' -VAR';
  if Cb_Ping.Checked then
    Str := Str + ' +PING'
  else
    Str := Str + ' -PING';
  if Cb_Leech.Checked then
    Str := Str + ' +LEECH'
  else
    Str := Str + ' -LEECH';
  if Cb_Samenic.Checked then
    Str := Str + ' +SAMENIC'
  else
    Str := Str + ' -SAMENIC';
  Cmd_List.AddDoubleCmd(MSG_CLIENT_USER_MODE, 0, Str, '');
end;

end.
