{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Friends

 class for Friends users

 original file: Registered.pas

*********************************************************}
unit Friends;

interface

{$I Defines.pas}

uses
  Windows, Classes2, SysUtils, Constants, STypes, Users, StringResources;

type
  TFriendUser = record
    Nick: string;
    Password: string;
    Created: Time_T;
    CreatedBy: string;
    LastSetBy: string;
    Comment: string;
  end;
  PFriendUser = ^TFriendUser;
  TFriendList = class(TMyList)
    function Add(Value: TFriendUser): Integer;
    procedure Insert(Index: Integer; Value: TFriendUser);
    procedure Clear; override;
    procedure Delete(Index: Integer);
    function FindUser(Nick: string): Integer;
    function FindUserRec(Nick: string): PFriendUser;
    function IsConsole(Index: Integer): Boolean;
    function User(Index: Integer): TFriendUser;
    function PasswordOk(Nick, Password: string): Boolean;
    constructor Create;
    destructor Destroy; override;
  end;
  TFriendDataBase = class(TObject)
    List: array[0..USERS_NAME_ARRAY - 1] of TFriendList;
    constructor Create;
    destructor Destroy; override;
    procedure SaveToFile(FileName: string);
    procedure LoadFromFile(FileName: string);
    function FindUser(Nick: string): PFriendUser;
    function PasswordOk(Nick, Password: string): Boolean;
    procedure Add(Fr: TFriendUser);
    procedure Delete(Nick: string);
    function CountUsers: Integer;
  end;

procedure ResetFriends(var Fr: TFriendUser);

implementation

uses
  Vars, Memory_Manager;

procedure ResetFriends(var Fr: TFriendUser);
begin
  Fr.Nick := '';
  Fr.Password := Null_Pass;
  Fr.Created := 0;
  Fr.CreatedBy := '';
  Fr.LastSetBy := '';
end;

function TFriendList.Add(Value: TFriendUser): Integer;
var
  Data: PFriendUser;
begin
  Data := AllocMem(SizeOf(TFriendUser));
  with Data^ do
  begin
    Pointer(Nick) := nil;
    Nick := Value.Nick;
    Pointer(Password) := nil;
    Password := Value.Password;
    Created := Value.Created;
    CreatedBy := Value.CreatedBy;
    Pointer(LastSetBy) := nil;
    LastSetBy := Value.LastSetBy;
    Comment := Value.Comment;
  end;
  Result := inherited Add(Data);
end;

procedure TFriendList.Insert(Index: Integer; Value: TFriendUser);
var
  Data: PFriendUser;
begin
  Data := AllocMem(SizeOf(TFriendUser));
  with Data^ do
  begin
    Pointer(Nick) := nil;
    Nick := Value.Nick;
    Pointer(Password) := nil;
    Password := Value.Password;
    Created := Value.Created;
    Pointer(CreatedBy) := nil;
    CreatedBy := Value.CreatedBy;
    Pointer(LastSetBy) := nil;
    LastSetBy := Value.LastSetBy;
    Pointer(Comment) := nil;
    Comment := Value.Comment;
  end;
  inherited Insert(Index, Data);
end;

procedure TFriendList.Clear;
begin
  while Count > 0 do
    Delete(Count - 1);
  inherited Clear;
end;

procedure TFriendList.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= Count) then Exit;
  if Items[Index] <> nil then
  begin
    Finalize(PFriendUser(Items[Index])^);
    FreeMem(PFriendUser(Items[Index]), SizeOf(TFriendUser));
  end;
  inherited Delete(Index);
end;

function TFriendList.FindUser(Nick: string): Integer;
var
  I: Integer;
beGin
  Result := -1;
  Nick := AnsiLowerCase(Nick);
  for I := 0 to Count - 1 do
    if AnsiLowerCase(PFriendUser(Items[I])^.Nick) = Nick then
    begin
      Result := I;
      Exit;
    end;
end;

function TFriendList.FindUserRec(Nick: string): PFriendUser;
var
  I: Integer;
begin
  Result := nil;
  Nick := AnsiLowerCase(Nick);
  for I := 0 to Count - 1 do
    if AnsiLowerCase(PFriendUser(Items[I])^.Nick) = Nick then
    begin
      Result := Items[I];
      Exit;
    end;
end;

function TFriendList.IsConsole(Index: Integer): Boolean;
var
  Str: string;
begin
  Str := PFriendUser(Items[Index])^.Password;
  Result := (Str = CONSOLE_PASS) or (Str = CONSOLE_PASS_OFFLINE);
end;

function TFriendList.User(Index: Integer): TFriendUser;
var
  User: TFriendUser;
  P: PFriendUser;
begin
  P := Items[Index];
  User.Nick := P.Nick;
  User.Password := P.Password;
  User.Created := P.Created;
  User.CreatedBy := P.CreatedBy;
  User.LastSetBy := P.LastSetBy;
  User.Comment := P.Comment;
  Result := User;
end;

function TFriendList.PasswordOk(Nick, Password: string): Boolean;
var
  I: Integer;
  Str: string;
begin
  Result := True;
  Nick := AnsiLowerCase(Nick);
  for I := 0 to Count - 1 do
    if AnsiLowerCase(PFriendUser(Items[I])^.Nick) = Nick then
    begin
      Str := PFriendUser(Items[I])^.Password;
      Result := (Str = Null_Password) or (Str = Password);
      Exit;
    end;
end;

constructor TFriendList.Create;
begin
  inherited Create;
end;

destructor TFriendList.Destroy;
begin
  Clear;
  inherited Destroy;
end;

constructor TFriendDataBase.Create;
var
  I: Integer;
begin
  inherited Create;
  for I := 0 to USERS_NAME_ARRAY - 1 do
    List[I] := TFriendList.Create;
end;

destructor TFriendDataBase.Destroy;
var
  I: Integer;
begin
  for I := 0 to USERS_NAME_ARRAY - 1 do
    List[I].Free;
  inherited Destroy;
end;

procedure TFriendDataBase.SaveToFile(FileName: string);
var
  Lst: TMyStringList;
  I, J: Integer;
  User: PFriendUser;
  Str: string;
  Spacer: array [0..21] of Char;
begin
  FillChar(Spacer, SizeOf(Spacer), Ord(' '));
  Lst := CreateStringList;
  for J := 0 to USERS_NAME_ARRAY - 1 do
    for I := 0 to List[J].Count - 1 do
    begin
      User := List[J].Items[I];
      if Length(User.Nick) < Length(Spacer) then
      begin
        Str := User.Nick + Spacer;
        SetLength(Str, Length(Spacer));
      end
      else
        Str := User.Nick;
      Str := Str + Format('%s %d %s %s %s', [User.Password, User.Created,
        AddStr(User.CreatedBy), AddStr(User.LastSetBy), AddStr(User.Comment)]);
      Lst.Add(Str);
      if (I mod 30) = 0 then
      begin
{$I CheckSync.pas}
      end;
    end;
  if Lst.Count < 1000 then
    Lst.Sort;
  Lst.Insert(0, RS_Friends_FileDescription0);
  Lst.Insert(1, RS_Friends_FileDescription1);
  Lst.Insert(2, RS_Friends_FileDescription2);
  Lst.Insert(3, RS_Friends_FileDescription3);
  Lst.Insert(4, RS_Friends_FileDescription4);
  Lst.Insert(5, RS_Friends_FileDescription5);
  Lst.Insert(6, RS_Friends_FileDescription6);
  try
    Lst.SaveToFile(FileName);
  except
  end;
  FreeStringList(Lst);
end;

procedure TFriendDataBase.LoadFromFile(FileName: string);
var
  Version: Integer;
  I: Integer;
  Lst, Entry: TMyStringList;
  Str: string;
  User: TFriendUser;
begin
  for I := 0 to USERS_NAME_ARRAY - 1 do
    List[I].Clear;
  Lst := CreateStringList;
  try
    Lst.LoadFromFile(FileName);
  except
    FreeStringList(Lst);
    Exit;
  end;
  Version := 0;
  Entry := CreateStringList;
  for I := 0 to Lst.Count - 1 do
    if Length(Lst.Strings[I]) > 1 then
    begin
      if Lst.Strings[I][1] = '#' then
      begin
        Str := LowerCase(Lst.Strings[I]);
        if Str = '# version 3' then
          Version := 3;
      end
      else
      begin
        SplitStringOld(Lst.Strings[I], Entry);
        if Entry.Count = 1 then
        begin
          // `
          if FindUser(Entry.Strings[0]) = nil then
          begin
            if (I mod 30) = 0 then
            begin
{$I CheckSync.pas}
            end;
            ResetFriends(User);
            User.Nick := Entry.Strings[0];
            User.Password := Null_Pass;
            User.Created := 946702800; // Shows created date as 1/1/00
            User.CreatedBy := '';
            User.LastSetBy := '';
            User.Comment := '';
            Add(User);
          end;
        end
        else if Entry.Count > 1 then
          if FindUser(Entry.Strings[0]) = nil then
          begin
            if (I mod 30) = 0 then
            begin
{$I CheckSync.pas}
            end;
            if Version = 3 then
            begin
              ResetFriends(User);
              User.Nick := Entry.Strings[0];
              User.Password := Entry.Strings[1];
              if Entry.Count > 2 then
                User.Created := StrToIntDef(Entry.Strings[2], 0)
              else
                User.Created := 946702800; // Shows created date as 1/1/00
              if Entry.Count > 3 then
                User.CreatedBy := Entry.Strings[3]
              else
                User.CreatedBy := '';
              if Entry.Count > 4 then
                User.LastSetBy := Entry.Strings[4]
              else
                User.LastSetBy := '';
              if Entry.Count > 5 then
                User.Comment := Entry.Strings[5]
              else
                User.Comment := '';
              Add(User);
            end;
          end;
      end;
    end;
  FreeStringList(Entry);
  FreeStringList(Lst);
end;

function TFriendDataBase.FindUser(Nick: string): PFriendUser;
var
  I: Integer;
begin
  Result := nil;
  I := GetCharIndex(Nick);
  if I = -1 then Exit;
  Result := List[I].FindUserRec(Nick);
end;

function TFriendDataBase.PasswordOk(Nick, Password: string): Boolean;
var
  I: Integer;
begin
  Result := False;
  I := GetCharIndex(Nick);
  if I = -1 then Exit;
  Result := List[I].PasswordOk(Nick, Password);
end;

procedure TFriendDataBase.Delete(Nick: string);
var
  I, J: Integer;
begin
  I := GetCharIndex(Nick);
  if I = -1 then Exit;
  J := List[I].FindUser(Nick);
  if J <> -1 then
    List[I].Delete(J);
end;

procedure TFriendDataBase.Add(Fr: TFriendUser);
var
  I: Integer;
begin
  I := GetCharIndex(Fr.Nick);
  if I = -1 then Exit;
  List[I].Add(Fr);
end;

function TFriendDataBase.CountUsers: Integer;
var
  I, J: Integer;
begin
  J := 0;
  for I := 0 to USERS_NAME_ARRAY - 1 do
    Inc(J, List[I].Count);
  Result := J;
end;

end.
