/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import java.util.Properties;
import junit.framework.Assert;

final class TestCaseProperties {
    private final Class testCaseClass;
    private Properties properties;

    TestCaseProperties(Class testCaseClass) {
        this.testCaseClass = testCaseClass;
        this.properties = new Properties();
        try {
            this.properties.load(this.getClass().getResourceAsStream(this.getPropertyFileName()));
        }
        catch (Exception e) {
            Assert.fail((String)("Please, create '" + this.getPropertyFileName() + "' file by '" + this.getPropertyFileName() + ".base' file in the same directory."));
        }
    }

    private String getPropertyFileName() {
        return String.valueOf(this.testCaseClass.getSimpleName()) + ".properties";
    }

    String getProperty(String key) {
        if (!this.properties.containsKey(key)) {
            throw new IllegalArgumentException("'" + this.getPropertyFileName() + "' file doesn't have '" + key + "' entry.");
        }
        return this.properties.getProperty(key);
    }
}

