package fuku.skk4j.im;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.im.spi.*;
import java.io.*;
import java.text.*;
import java.util.*;
import javax.swing.*;

import fuku.skk4j.resource.SKKProperties;

/**
 * JavaSKKץࡣ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class SKKInputMethod implements InputMethod {

    /** ץѥƥե̾ */
    private static final String _PROPERTY = "skk4j.im.properties";
    /** ꥽ѥ */
    private static final String _PATH = "fuku/skk4j/resource";

    /** ץѥƥ */
    private static SKKProperties _prop = null;

    /** ơɥ */
    private static JFrame _statusWindow = null;
    /** ơɥΰ */
    private static Point _statusWindowLocation = null;
    /** ơɥνͭ */
    private static SKKInputMethod _statusWindowOwner = null;

    /** 򤵤Ƥ */
    private Locale _locale = null;
    /** ץåȥ᥽åɥƥ */
    private InputMethodContext _imContext = null;

    /** ץåȥ᥽åɤƥ֤Ǥ뤳Ȥ򼨤ե饰 */
    private boolean _active = false;
    /** ϥ⡼ɽ֥ */
    private Controller _controller = null;

    /** ơɥꤹ뤫ɤ򼨤ť饰 */
    private static boolean _fixedStatusWindow = false;


    /**
     * ǥեȥ󥹥ȥ饯
     *
     * @exception IOException ˵I/O㳰
     */
    public SKKInputMethod() throws IOException {
        super();

        synchronized (getClass()) {
            if (_prop == null) {
                _prop = new SKKProperties(_PROPERTY, _PATH);
                _prop.load();
            }
            _fixedStatusWindow = getBoolean("skk4j.im.statuswindow.fix");
        }

        int mode = Controller.LATIN;
        if (_statusWindowOwner != null) {
            // Ǥ˥ץåȥ᥽åɤСϥ⡼ɤƱˤ
            mode = ((Controller)_statusWindowOwner.getControlObject()).getMode();
        }
        _controller = new Controller(this, mode);
    }


    /**
     * ץåȥ᥽åɤΥƥȤꤷޤ
     *
     * @param context ץåȥ᥽åɥƥ
     */
    public void setInputMethodContext(InputMethodContext context) {
        _imContext = context;
        if (_statusWindow == null) {
            JFrame sw = _imContext.createInputMethodJFrame("SKK4J", false);
            sw.setResizable(false);
            sw.getContentPane().setForeground(Color.white);
            sw.getContentPane().setBackground(Color.black);
            JLabel label = new JLabel();
            label.setFont(new Font("monospaced", Font.PLAIN, 12));
            label.setForeground(Color.white);
            label.setBackground(Color.black);
            synchronized (getClass()) {
                if (_statusWindow == null) {
                    _statusWindow = sw;
                    _statusWindow.getContentPane().add(label);
                    _statusWindowOwner = this;
                }
            }
        }
        updateStatusWindow();
        _imContext.enableClientWindowNotification(this, true);
    }

    /**
     * ϥߤޤ
     *
     * @param locale Ϥ
     * @return ꤵ줿뤬ݡȤƤtrue
     *         ݡȤƤʤfalse
     */
    public boolean setLocale(Locale locale) {
        if (locale.equals(SKKInputMethodDescriptor.SKK)
            || locale.equals(Locale.JAPAN)
            || locale.equals(Locale.JAPANESE)) {
            _locale = locale;
            if (_statusWindow != null) {
                updateStatusWindow();
            }
            return true;
        }
        return false;
    }

    /**
     * ߤϥ֤ޤ
     *
     * @return ߤϥޤnull
     */
    public Locale getLocale() {
        return _locale;
    }

    /**
     * ϲǽUnicodeʸåȤΥ֥åȤꤷޤ
     *
     * @param subsets ϤUnicodeʸåȤΥ֥å
     */
    public void setCharacterSubsets(Character.Subset[] subsets) {
        // ̵
    }

    /**
     * Ѵ򳫻Ϥޤ
     *
     */
    public void reconvert() {
        // ̤ݡ
        throw new UnsupportedOperationException();
    }

    /**
     * ץåȥ᥽åɤ˥٥Ȥǥѥåޤ
     *
     * @param event ץåȥ᥽åɤ˥ǥѥå륤٥
     */
    public void dispatchEvent(AWTEvent event) {
        // ٥Ȱʳ̵
        if (!(event instanceof KeyEvent))
            return;
        // ϥ⡼ɽ֥Ȥǽ
        _controller.dispatchKeyEvent((KeyEvent)event);
        _updateStatusWindowLocation();
    }

    /**
     * ¨ϽΤΥץåȥ᥽åɤưޤ
     *
     */
    public void activate() {
        _active = true;
        synchronized (_statusWindow) {
            _statusWindowOwner = this;
            if (!_statusWindow.isVisible()) {
                _statusWindow.setVisible(true);
            }
        }
        updateStatusWindow();
        _controller.activate();
    }

    /**
     * ץåȥ᥽åɤλޤ
     *
     * @param isTemporary եѹŪɤ
     */
    public void deactivate(boolean isTemporary) {
        if (isTemporary) { // եӼ
            _controller.deactivate();
            synchronized (_statusWindow) {
                if (_statusWindowOwner.equals(this)) {
                    _statusWindow.setVisible(false);
                }
            }
            _active = false;
        } else { // եΰư
            _controller.endComposition();
        }
    }

    /**
     * ץåȥ᥽åɤ٤ƤΥɥĤޤ
     *
     */
    public void hideWindows() {
        _controller.deactivate();
        synchronized (_statusWindow) {
            if (_statusWindowOwner.equals(this)) {
                _statusWindow.setVisible(false);
            }
        }
        _active = false;
    }

    /**
     * 饤ȥݡͥȤ޴طγؤƤ뤫
     * ץåȥ᥽åɤΥݡͥȤǻѤǤʤʤäƤ뤳Ȥ
     * ץåȥ᥽åɤΤޤ
     *
     */
    public void removeNotify() {
        _controller.endComposition();
    }

    /**
     * ΥƥȤǸ߿ʹѴλޤ
     *
     */
    public void endComposition() {
        _controller.endComposition();
    }

    /**
     * 饤ȤΥɥ֤ޤϾ֤ѹ
     * ץåȥ᥽åɤΤޤ
     *
     * @param bounds ̾Υ饤ȥɥζ
     *               饤ȥɥ/ԲĻξnull
     */
    public void notifyClientWindowChange(Rectangle bounds) {
        synchronized (_statusWindow) {
            if (!_statusWindowOwner.equals(this)) {
                return;
            }
            if (bounds != null && _active) {
                if (!_statusWindow.isVisible()) {
                    _statusWindow.setVisible(true);
                }
                _updateStatusWindowLocation();
                _controller.activate();
            } else {
                _statusWindow.setVisible(false);
            }
        }
    }

    /**
     * ץåȥ᥽åɤ˴ơ
     * Υ֥ȤѤ꥽ޤ
     *
     */
    public void dispose() {
        _controller.dispose();
    }

    /**
     * ץåȥ᥽åɤ楪֥Ȥ֤ޤ
     *
     * @return local.im.skk.Controller - ϥ⡼ɽ֥
     */
    public Object getControlObject() {
        return _controller;
    }

    /**
     * ץåȥ᥽åɤѲǽޤϻԲǽˤޤ
     *
     * @param enable ץåȥ᥽åɤѲǽˤ뤫ɤ
     */
    public void setCompositionEnabled(boolean enable) {
        // ̤ݡ
        throw new UnsupportedOperationException();
    }

    /**
     * ץåȥ᥽åɤѲǽɤȽ̤ޤ
     *
     * @return ѲǽʾtrueǤʤfalse
     */
    public boolean isCompositionEnabled() {
        // true
        return true;
    }

    /**
     * ơɥ򹹿ޤ
     *
     */
    void updateStatusWindow() {
        synchronized (_statusWindow) {
            JLabel label = (JLabel)_statusWindow.getContentPane().getComponent(0);
            String modeLine = " " + _controller.getModeLine() + ": ";
            if (!label.getText().equals(modeLine)) {
                label.setText(modeLine);
            }
            _statusWindow.pack();
        }
        _updateStatusWindowLocation();
    }

    /**
     * ơɥΰ֤򹹿ޤ
     *
     */
    private void _updateStatusWindowLocation() {
        if (_imContext == null) {
            return;
        }
        synchronized (_statusWindow) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension windowSize = _statusWindow.getSize();
            double x, y;

            if (_fixedStatusWindow) {
                x = screenSize.getWidth() - windowSize.getWidth();
                y = screenSize.getHeight() - windowSize.getHeight() - 30;
            } else {
                Rectangle textLocation =
                    _imContext.getTextLocation(TextHitInfo.leading(0));

                x = textLocation.getX();
                y = textLocation.getY() + textLocation.getHeight() + 5;

                if (x + windowSize.getWidth() > screenSize.getWidth()) {
                    x = screenSize.getWidth() - windowSize.getWidth();
                }
                if (y + windowSize.getHeight() > screenSize.getHeight()) {
                    y = textLocation.getY() - windowSize.getHeight() - 5;
                }
            }

            Point point = new Point((int)x, (int)y);
            if (_statusWindowLocation == null
                || !_statusWindowLocation.equals(point)) {
                _statusWindowLocation = point;
                _statusWindow.setLocation(_statusWindowLocation);
            }
        }
    }

    /**
     * 饤ȤإƥȤޤ
     *
     * @param text ʸ
     * @param count ꤷƤʸ
     * @param point 
     */
    void sendText(AttributedString text, int count, int point) {
        _imContext.dispatchInputMethodEvent(InputMethodEvent.INPUT_METHOD_TEXT_CHANGED,
                                            text.getIterator(), count,
                                            TextHitInfo.leading(point), null);
    }

    /**
     * ץåȥ᥽åɥƥȤ֤ޤ
     *
     * @return ץåȥ᥽åɥƥ
     */
    InputMethodContext getContext() {
        return _imContext;
    }

    /**
     * ץѥƥ֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    String getProperty(String key) {
        return _prop.getProperty(key);
    }

    /**
     * intΥץѥƥ֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    int getInt(String key) {
        return _prop.getInt(key);
    }

    /**
     * booleanΥץѥƥ֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    boolean getBoolean(String key) {
        return _prop.getBoolean(key);
    }
}

// end of SKKInputMethod.java
