package fuku.skk4j.im;

import java.util.*;

import fuku.skk4j.dic.SKKDic;
import fuku.skk4j.dic.UserDic;
import fuku.skk4j.dic.InnerDic;
import fuku.skk4j.dic.LocalDic;
import fuku.skk4j.dic.ServerDic;
import fuku.skk4j.dic.CollectedDic;
import fuku.skk4j.dic.DicUtil;

/**
 * 񥯥饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class SKKDictionary {

    /** 桼 */
    private static UserDic _userDic = null;
    /**  */
    private static InnerDic _innerDic = null;
    /** ʣ缭 */
    private static CollectedDic _dic = null;

    /** ץåȥ᥽åɤΥ󥹥 */
    private SKKInputMethod _skk = null;


    /**
     * 󥹥ȥ饯
     *
     * @param skk ץåȥ᥽å
     */
    SKKDictionary(SKKInputMethod skk) {
        super();
        _skk = skk;

        synchronized (getClass()) {
            if (_userDic == null) {
                _userDic = new UserDic(_skk.getProperty("skk4j.im.userdic"),
                                       _skk.getInt("skk4j.im.jisyo.save.count"));
            }
            if (_innerDic == null) {
                _innerDic = new InnerDic();
            }
            if (_dic == null) {
                SKKDic[] dic = new SKKDic[4];
                dic[0] = _userDic;
                dic[1] = _innerDic;

                String enc = _skk.getProperty("skk4j.im.localdic.encoding");
                String localdic = _skk.getProperty("skk4j.im.localdic");
                dic[2] = new LocalDic(localdic, enc);

                String host = _skk.getProperty("skk4j.im.serverdic.host");
                int port = _skk.getInt("skk4j.im.serverdic.port");
                dic[3] = new ServerDic(host, port);

                _dic = new CollectedDic(dic);
            }
        }

        // λ˼Ĥɲ
        Runtime.getRuntime().addShutdownHook(new Thread() {
            public void run() {
                _close();
            }
        });
    }


    /**
     * ٤ƤμĤޤ
     *
     */
    private void _close() {
        if (_dic != null) {
            _dic.close();
            _dic = null;
        }
    }

    /**
     * ñϿޤ(겾̾ʤ)
     *
     * @param key Ф + " " ()
     * @param word Ͽ
     */
    void regist(String key, String word) {
        _userDic.regist(key, word);
    }

    /**
     * ñϿޤ(겾̾)
     *
     * @param key Ф + " " ()
     * @param word Ͽ
     * @param okuri1 ꤷ겾̾
     */
    void regist(String key, String word, String okurigana) {
        _userDic.regist(key, word, okurigana);
    }

    /**
     * 񤫤ñޤ(겾̾ʤ)
     *
     * @param key Ф + " " ()
     * @param word 
     */
    void delete(String key, String word) {
        _userDic.delete(key, word);
    }

    /**
     * 񤫤ñޤ(겾̾)
     *
     * @param key Ф + " " ()
     * @param word 
     * @param okurigana ꤷ겾̾
     */
    void delete(String key, String word, String okurigana) {
        _userDic.delete(key, word, okurigana);
    }

    /**
     * 뼭򼭽ꥹȤκǽꤷޤ
     *
     */
    public void reset() {
        _dic.reset();
    }

    /**
     * ̤μο֤ޤ
     *
     * @return ̤μ
     */
    int countDics() {
        return _dic.countDics();
    }

    /**
     * ٤Ƥμ񤫤򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return Ѵ (ʤnull)
     */
    String search(String key) {
        return _dic.search(key);
    }

    /**
     * 񤫤򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return Ѵ (ʤnull)
     */
    String searchNext(String key) {
        return _dic.searchNext(key);
    }

    /**
     * 񤫤鿷ʸ򸡺θ˲äޤ
     *
     * @param key  (Ф+" ")
     * @param list Ѵ
     * @return Ѵ
     */
    String searchNext(String key, String list) {
        return _dic.searchNext(key, list);
    }

    /**
     * 桼񤫤keyФ䴰򸡺ޤ
     *
     * @param key  (Ф)
     * @return η (ʤnull)
     */
    List complement(String key) {
        List list1 = _userDic.complement(key);
        List list2 = _innerDic.complement(key);
        if (list2 != null) {
            if (list1 != null) {
                // list2list1νʣƤΤ
                Iterator itr1 = list1.iterator();
                while (itr1.hasNext()) {
                    String str1 = (String)itr1.next();
                    int idx = str1.indexOf(' ');
                    if (idx < 1) {
                        continue;
                    }
                    String yomi1 = str1.substring(0, idx);
                    Iterator itr2 = list2.iterator();
                    while (itr2.hasNext()) {
                        String str2 = (String)itr2.next();
                        idx = str2.indexOf(' ');
                        if (idx < 1) {
                            itr2.remove();
                        } else {
                            String yomi2 = str2.substring(0, idx);
                            if (yomi1.equals(yomi2)) {
                                itr2.remove();
                            }
                        }
                    }
                }
                list1.addAll(list2);
            } else {
                list1 = list2;
            }
        }
        return list1;
    }

    /**
     * ѴԤޤ<BR>
     * <BR>
     * #0: ̵Ѵ  12 -> 12 <BR>
     * #1: ʸ  12 ->  <BR>
     * #2:  (̼ʤ)  5500 -> ޸ޡ <BR>
     * #3:  (̼ꤢ)  5500 -> ɴ <BR>
     * #4: ͺѴ  125 -> 125򥭡ȤƼ񸡺ִ̤ <BR>
     * #5: ۵ (̼ꤢ)  1995 -> ɴ彦 <BR>
     * #9: δ  34 ->  <BR>
     *
     * @param word Ѵʸ (#0#0)
     * @param num ִ (1,10)
     * @return Ѵʸ
     *         "/1/.../n/"η֤
     *         ִ٤ͤʤִʤ
     */
    String replaceNum(String word, List num) {
        StringBuffer buf = new StringBuffer(word);
        Iterator iterator = num.iterator();
        List list = new ArrayList(); // Ƹݻ
        int idx = word.indexOf('#');
        while (idx != -1) {
            int type = -1;
            try {
                type = Integer.parseInt(String.valueOf(buf.charAt(idx+1)));
            } catch (NumberFormatException e) {
                type = -1;
            }
            String n = null;
            String result = null;
            switch (type) {
                case 0:
                    if (iterator.hasNext()) {
                        result = (String)iterator.next();
                    }
                    break;
                case 1:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        result = Converter.narrow2wide(n);
                    }
                    break;
                case 2:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        result = Converter.num2kanji(n, 0);
                    }
                    break;
                case 3:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        result = Converter.num2kanji(n, 1);
                    }
                    break;
                case 4:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        // ִμ
                        result = search(n+" ");
                        if (result != null) {
                            list.add(result);
                        } else {
                            list.add("/" + n + "/");
                        }
                    }
                    break;
                case 5:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        result = Converter.num2kanji(n, 2);
                    }
                    break;
                case 9:
                    if (iterator.hasNext()) {
                        n = (String)iterator.next();
                        result = Converter.num2shogi(n);
                    }
                    break;
                default:
                    type = -1;
                    break;
            }
            if (type != -1) {
                if (result == null) { // ̵ʿͤʤѴʤ
                    if (n == null) {
                        break;
                    }
                    result = n;
                }
                if (type != 4) {
                    buf.replace(idx, idx+2, result);
                }
            }
            idx = buf.toString().indexOf('#', idx+1);
        }
        if (list.isEmpty()) {
            return "/" + buf.toString() + "/";
        }
        StringBuffer candidate = new StringBuffer("/");
        String str = buf.toString(); // ִо
        Iterator itr = list.iterator();
        StringTokenizer st1 = new StringTokenizer((String)itr.next(), "/");
        idx = 0;
        while (st1.hasMoreTokens()) { // 䤹٤ƤˤĤ
            candidate.append(str).append('/');
            idx = candidate.toString().indexOf("#4", idx);
            candidate.replace(idx, idx+2, st1.nextToken()); // ִ
            idx = candidate.length();
        }
        while (itr.hasNext()) { // ִǽʿ
            StringTokenizer st2 = new StringTokenizer(candidate.toString(), "/");
            candidate.delete(1, candidate.length());
            String item = (String)itr.next();
            while (st2.hasMoreTokens()) { // ִоݤ٤ƤˤĤ
                str = st2.nextToken(); // ִоݤμ
                st1 = new StringTokenizer(item, "/");
                idx = 0;
                while (st1.hasMoreTokens()) { // 䤹٤ƤˤĤ
                    candidate.append(str).append('/');
                    idx = candidate.toString().indexOf("#4", idx);
                    candidate.replace(idx, idx+2, st1.nextToken()); // ִ
                    idx = candidate.length();
                }
            }
        }
        return candidate.toString();
    }
}

// end of SKKDictionary.java
