package fuku.skk4j.im;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.util.*;
import javax.swing.*;

// java.awt.Listȶ̤뤿ɲ
import java.util.List;

/**
 * ååץɥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class LookupWindow implements KeyListener {

    /** ååץɥΥ⡼ɼ (Ѵ⡼) */
    private static final int _CANDIDATE = 0;
    /** ååץɥΥ⡼ɼ (ɥ⡼) */
    private static final int _KANJICODE = 1;

    /** ɥ⡼ɤΥ֥⡼ɼ (ϥ⡼) */
    private static final int _CODE_INPUT = 10;
    /** ɥ⡼ɤΥ֥⡼ɼ (1ʳɽ⡼) */
    private static final int _CODE_FIRST = 11;
    /** ɥ⡼ɤΥ֥⡼ɼ (2ʳɽ⡼) */
    private static final int _CODE_SECOND = 12;

    /** ץåȥ᥽åɤΥ󥹥 */
    private SKKInputMethod _skk = null;
    /** ååץɥ */
    private Window _lookupWindow = null;
    /** ååץɥΥ⡼ */
    private int _mode = _CANDIDATE;
    /** ɥ⡼ɤΥ֥⡼ */
    private int _kanjiCodeMode = _CODE_INPUT;

    /** ѴΥǥå */
    private static final int[] _CANDIDATE_INDEX = {
        KeyEvent.VK_A, KeyEvent.VK_S, KeyEvent.VK_D, KeyEvent.VK_F,
        KeyEvent.VK_J, KeyEvent.VK_K, KeyEvent.VK_L
    };
    /** ѴΥǥå٥ */
    private static final String[] _CANDIDATE_LABEL = {
        "A:", "S:", "D:", "F:", "J:", "K:", "L:"
    };

    /** ɥ⡼ɻθΥǥå (1ʳ) */
    private static final int[] _CODE_FIRST_INDEX = {
        KeyEvent.VK_A, KeyEvent.VK_S, KeyEvent.VK_D, KeyEvent.VK_F,
        KeyEvent.VK_G, KeyEvent.VK_H, KeyEvent.VK_Q, KeyEvent.VK_W,
        KeyEvent.VK_E, KeyEvent.VK_R, KeyEvent.VK_T, KeyEvent.VK_Y
    };
    /** ɥ⡼ɻθΥǥå٥ (1ʳ) */
    private static final String[] _CODE_FIRST_LABEL = {
        "A:", "S:", "D:", "F:", "G:", "H:",
        "Q:", "W:", "E:", "R:", "T:", "Y:"
    };

    /** ɥ⡼ɻθΥǥå (2ʳ) */
    private static final int[] _CODE_SECOND_INDEX = {
        KeyEvent.VK_A, KeyEvent.VK_S, KeyEvent.VK_D, KeyEvent.VK_F,
        KeyEvent.VK_G, KeyEvent.VK_H, KeyEvent.VK_J, KeyEvent.VK_K,
        KeyEvent.VK_L, KeyEvent.VK_Q, KeyEvent.VK_W, KeyEvent.VK_E,
        KeyEvent.VK_R, KeyEvent.VK_T, KeyEvent.VK_Y, KeyEvent.VK_U
    };
    /** ɥ⡼ɻθΥǥå٥ (2ʳ) */
    private static final String[] _CODE_SECOND_LABEL = {
        "A:", "S:", "D:", "F:", "G:", "H:", "J:", "K:", "L:",
        "Q:", "W:", "E:", "R:", "T:", "Y:", "U:"
    };

    /** Ѵ */
    private Candidate _candidate = null;
    /** ɽƤ */
    private int _candidateCount = 0;
    /**  */
    private char _kanjiCode = 0;
    /** Ѵ/ɽѥܥå */
    private Box _box = null;
    /** ñϿꥢ */
    private JTextField _text = null;
    /** åפѴο (=ɽޤǤκѴ) */
    private int _skipCount = 0;


    /**
     * 󥹥ȥ饯()
     *
     * @param skk ץåȥ᥽å
     */
    LookupWindow(SKKInputMethod skk) {
        super();
        _skk = skk;
        _mode = _KANJICODE;
        _kanjiCodeMode = _CODE_INPUT;
    }

    /**
     * 󥹥ȥ饯(Ѵ)
     *
     * @param skk ץåȥ᥽å
     * @param candidate Ѵ
     */
    LookupWindow(SKKInputMethod skk, Candidate candidate) {
        super();
        _skk = skk;
        _candidate = candidate;
        _mode = _CANDIDATE;
        _skipCount = _candidate.getIndex();
    }


    /**
     * Ѵ/ɽѥɥޤ
     *
     */
    void setupSelectionWindow() {
        if (_lookupWindow != null) {
            _lookupWindow.dispose();
        }
        String title;
        switch (_mode) {
            case _CANDIDATE:
                title = "";
                break;
            case _KANJICODE:
                title = "";
                break;
            default:
                title = "";
                break;
        }
        JFrame frame = _skk.getContext().createInputMethodJFrame(title, true);
        frame.setResizable(false);
        _lookupWindow = frame;
        Container pane = frame.getContentPane();
        pane.setForeground(Color.white);
        pane.setBackground(Color.black);
        pane.setLayout(new BorderLayout());
        if (_box == null) {
            _box = Box.createVerticalBox();
            _box.setForeground(Color.white);
            _box.setBackground(Color.black);
        }
        pane.add(Box.createVerticalStrut(2), BorderLayout.NORTH);
        pane.add(Box.createVerticalStrut(2), BorderLayout.SOUTH);
        pane.add(Box.createHorizontalStrut(8), BorderLayout.WEST);
        pane.add(Box.createHorizontalStrut(8), BorderLayout.EAST);
        pane.add(_box, BorderLayout.CENTER);
        switch (_mode) {
            case _CANDIDATE:
                int index = _candidate.getIndex();
                if (index != 0) {
                    _candidate.setIndex(index-_candidateCount);
                }
                _makeCandidateList();
                break;
            case _KANJICODE:
                _makeKanjiCodeList();
                break;
            default:
                break;
        }
    }

    /**
     * ñϿ/ѥɥޤ
     *
     */
    void setupInputWindow() {
        if (_lookupWindow != null) {
            _lookupWindow.dispose();
        }
        JDialog dialog = new JDialog();
        _lookupWindow = dialog;
        String title;
        String labelText;
        switch (_mode) {
            case _CANDIDATE:
                title = "ñϿ";
                labelText = _candidate.getLabel();
                break;
            case _KANJICODE:
                title = "";
                labelText = "Unicode";
                break;
            default:
                title = "";
                labelText = "";
                break;
        }
        dialog.setTitle(title);
        dialog.setResizable(false);
        dialog.setModal(false);
        dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        dialog.getContentPane().setLayout(new FlowLayout());
        dialog.getContentPane().setForeground(Color.white);
        dialog.getContentPane().setBackground(Color.black);
        JLabel label = new JLabel(labelText);
        label.setFont(new Font("monospaced", Font.PLAIN, 12));
        label.setForeground(Color.white);
        label.setBackground(Color.black);
        dialog.getContentPane().add(label);
        _text = new JTextField();
        _text.setFont(new Font("monospaced", Font.PLAIN, 12));
        _text.setForeground(Color.white);
        _text.setBackground(Color.black);
        _text.setCaretColor(Color.white);
        _text.setColumns(40);
        _text.addKeyListener(this);
        dialog.getContentPane().add(_text);
        dialog.enableInputMethods(true);
        dialog.getInputContext().selectInputMethod(SKKInputMethodDescriptor.SKK);
        dialog.pack();
    }

    /**
     * ɥΰ֤򸽺Υնꤷޤ
     *
     */
    private void _updateWindowLocation() {
        if (_skk.getContext() == null) {
            return;
        }

        Rectangle textLocation =
            _skk.getContext().getTextLocation(TextHitInfo.leading(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = _lookupWindow.getSize();

        double x = textLocation.getX();
        double y = textLocation.getY() + textLocation.getHeight() + 5;

        if (x + windowSize.getWidth() > screenSize.getWidth()) {
            x = screenSize.getWidth() - windowSize.getWidth();
        }
        if (y + windowSize.getHeight() > screenSize.getHeight()) {
            y = textLocation.getY() - windowSize.getHeight() - 5;
        }

        _lookupWindow.setLocation(new Point((int)x,(int)y));
    }

    /**
     * ɥɽޤ
     *
     */
    void show() {
        _updateWindowLocation();
        _lookupWindow.show();
        if (_mode == _KANJICODE && _kanjiCodeMode == _CODE_INPUT) {
            Object obj = _text.getInputContext().getInputMethodControlObject();
            if (obj instanceof Controller) {
                ((Controller)obj).setMode(Controller.LATIN);
            }
        }
    }

    /**
     * ɥ˴ޤ
     *
     */
    void dispose() {
        _lookupWindow.dispose();
        _lookupWindow = null;
    }

    /**
     * ɥ򱣤ޤ
     *
     */
    void hide() {
        _lookupWindow.hide();
    }

    /**
     * Ѵɽޤ
     *
     */
    void prevCandidate() {
        int index = _candidate.getIndex() - _candidateCount - _CANDIDATE_INDEX.length;
        _candidate.setIndex(index);
        _makeCandidateList();
    }

    /**
     * Ѵɽޤ
     *
     */
    void nextCandidate() {
        _makeCandidateList();
    }

    /**
     * ѴΥꥹȤޤ
     *
     */
    private void _makeCandidateList() {
        _candidateCount = 0;
        List list = new ArrayList();
        int count = 0;
        for (int i=_CANDIDATE_INDEX.length; i>0; i--) {
            if (_candidate.hasNextCandidate()) {
                String str = _candidate.getNextCandidate();
                list.add(str);
                count = count + str.length();
                _candidateCount++;
            }
        }
        boolean flag = false;
        if (count > 30) {
            flag = true;
        }
        _box.removeAll();
        if (flag) {
            list = _makeLabelList(list);
            int size = list.size();
            for (int i=0; i<size; i++) {
                _box.add((JLabel)list.get(i));
            }
        } else {
            _box.add(_makeLabel(list));
        }
        _lookupWindow.pack();
        _updateWindowLocation();
    }

    /**
     * ѴѤΥ٥ޤ(ʣ)
     *
     * @param list ѴΥꥹ
     * @return ٥
     */
    private List _makeLabelList(List list) {
        List labelList = new ArrayList();
        int size = list.size();
        // "٥:Ѵ"JLabelκ
        for (int i=0; i<size; i++) {
            String str = (String)list.get(i);
            JLabel label = new JLabel(_CANDIDATE_LABEL[i] + str);
            label.setFont(new Font("monospaced", Font.PLAIN, 12));
            label.setForeground(Color.white);
            label.setBackground(Color.black);
            labelList.add(label);
        }
        if (_candidate.getCount() == 0) { // Ѵ䤬ʤФ˸
            _candidate.hasNextCandidate();
        }
        // "[Ĥ]"JLabelκ
        StringBuffer buf = new StringBuffer();
        buf.append("[Ĥ ").append(String.valueOf(_candidate.getCount()));
        int len = _candidate.getDicCount();
        for (int i=len; i>0; i--) {
            buf.append('+');
        }
        buf.append(']');
        JLabel label = new JLabel(buf.toString());
        label.setFont(new Font("monospaced", Font.PLAIN, 12));
        label.setForeground(Color.white);
        label.setBackground(Color.black);
        labelList.add(label);
        return labelList;
    }

    /**
     * ѴѤΥ٥ޤ(1)
     *
     * @param list ѴΥꥹ
     * @return ٥
     */
    private JLabel _makeLabel(List list) {
        StringBuffer buf = new StringBuffer();
        int size = list.size();
        // "٥:Ѵ"ɲ
        for (int i=0; i<size; i++) {
            String str = (String)list.get(i);
            buf.append(_CANDIDATE_LABEL[i]).append(str).append(' ');
        }
        if (_candidate.getCount() == 0) { // Ѵ䤬ʤФ˸
            _candidate.hasNextCandidate();
        }
        // "[Ĥ]"ɲ
        buf.append("  [Ĥ ").append(String.valueOf(_candidate.getCount()));
        int len = _candidate.getDicCount();
        for (int i=len; i>0; i--) {
            buf.append('+');
        }
        buf.append(']');
        // JLabel
        JLabel label = new JLabel(buf.toString());
        label.setFont(new Font("monospaced", Font.PLAIN, 12));
        label.setForeground(Color.white);
        label.setBackground(Color.black);
        return label;
    }

    /**
     * δɥꥹȤɽޤ
     *
     */
    void prevKanjiCode() {
        if (_kanjiCodeMode == _CODE_FIRST) {
            _kanjiCode = (char)(_kanjiCode - 16 * _CODE_FIRST_INDEX.length * 2);
        } else if (_kanjiCodeMode == _CODE_SECOND) {
            _kanjiCode = (char)(_kanjiCode - _CODE_SECOND_INDEX.length * 2);
        }
        _makeKanjiCodeList();
    }

    /**
     * δɥꥹȤɽޤ
     *
     */
    void nextKanjiCode() {
        _makeKanjiCodeList();
    }

    /**
     * ɥꥹȤᤷޤ
     *
     */
    void backKanjiCode() {
        if (_kanjiCodeMode == _CODE_SECOND) {
            _kanjiCode = (char)(_kanjiCode - _CODE_SECOND_INDEX.length - 1);
            _makeKanjiCodeList();
        }
    }

    /**
     * ɥꥹȤĿʤޤ
     *
     */
    void forwardKanjiCode() {
        if (_kanjiCodeMode == _CODE_SECOND) {
            _kanjiCode = (char)(_kanjiCode - _CODE_SECOND_INDEX.length + 1);
            _makeKanjiCodeList();
        }
    }

    /**
     * ɥꥹȤޤ
     *
     */
    private void _makeKanjiCodeList() {
        StringBuffer buf = new StringBuffer();
        String[] labelList = _CODE_FIRST_LABEL;
        int offset = 16;
        int start = _kanjiCode;
        if (_kanjiCodeMode == _CODE_SECOND) {
            labelList = _CODE_SECOND_LABEL;
            offset = 1;
        }
        // "٥:ʸ"ɲ
        for (int i=0; i<labelList.length; i++) {
            buf.append(labelList[i]).append(String.valueOf(_kanjiCode)).append(' ');
            _kanjiCode = (char)(_kanjiCode + offset);
        }
        // "[ʸϰ]"ɲ
        buf.append(" [");
        String hexcode = Integer.toHexString(start).toUpperCase();
        for (int i=hexcode.length(); i<4; i++) {
            buf.append('0');
        }
        buf.append(hexcode).append('-');
        hexcode =  Integer.toHexString((char)(_kanjiCode-offset)).toUpperCase();
        for (int i=hexcode.length(); i<4; i++) {
            buf.append('0');
        }
        buf.append(hexcode).append(']');
        // JLabel
        JLabel label = new JLabel(buf.toString());
        label.setFont(new Font("monospaced", Font.PLAIN, 12));
        label.setForeground(Color.white);
        label.setBackground(Color.black);
        _box.removeAll();
        _box.add(label);
        _lookupWindow.pack();
        _updateWindowLocation();
    }

    /**
     * Ѵ/ɤ򤷤ޤ
     *
     * @param index ֹ (*_INDEX)
     * @return ֹͭ椫ɤ
     */
    boolean selectCandidate(int index) {
        boolean flag = false;
        switch (_mode) {
            case _CANDIDATE:
                for (int i=_candidateCount-1; i>=0; i--) {
                    if (_CANDIDATE_INDEX[i] == index) {
                        i = _candidate.getIndex() - _candidateCount + i + 1;
                        _candidate.setIndex(i);
                        flag = true;
                        break;
                    }
                }
                break;
            case _KANJICODE:
                if (_kanjiCodeMode == _CODE_FIRST) {
                    for (int i=_CODE_FIRST_INDEX.length-1; i>=0; i--) {
                        if (_CODE_FIRST_INDEX[i] == index) {
                            int offset = 16 * _CODE_FIRST_INDEX.length;
                            _kanjiCode = (char)(_kanjiCode - offset + 16 * i);
                            _kanjiCodeMode = _CODE_SECOND;
                            nextKanjiCode();
                            break;
                        }
                    }
                } else if (_kanjiCodeMode == _CODE_SECOND) {
                    for (int i=_CODE_SECOND_INDEX.length-1; i>=0; i--) {
                        if (_CODE_SECOND_INDEX[i] == index) {
                            int offset = _CODE_SECOND_INDEX.length;
                            _kanjiCode = (char)(_kanjiCode - offset + i);
                            flag = true;
                            break;
                        }
                    }
                }
                break;
            default:
                break;
        }
        return flag;
    }

    /**
     * ɽ٤ѴꥹȤ뤫ɤȽ̤ޤ
     *
     * @return ѴꥹȤ뤫ɤ
     */
    boolean hasCandidate() {
        int i = _candidate.getIndex();
        if (i == 0) {
            return hasNextCandidate();
        }
        i = i - _skipCount;
        if (i > 0) {
            return true;
        }
        return false;
    }

    /**
     * ѴꥹȤ뤫ɤȽ̤ޤ
     *
     * @return ѴꥹȤ뤫ɤ
     */
    boolean hasPrevCandidate() {
        int i = _candidate.getIndex() - _candidateCount - _skipCount;
        if (i >= _CANDIDATE_INDEX.length) {
            return true;
        }
        return false;
    }

    /**
     * ѴꥹȤ뤫ɤȽ̤ޤ
     *
     * @return ѴꥹȤ뤫ɤ
     */
    boolean hasNextCandidate() {
        if (_candidate.hasNextCandidate()) {
            return true;
        }
        return false;
    }

    /**
     * ߤδɥ⡼ɤΥ֥⡼ɤλޤ<BR>
     * 1ʳξϴɥ⡼ɤλޤ<BR>
     * 2ʳξ1ʳޤ
     *
     * @return ɥ⡼ɤλ뤫ɤ
     */
    boolean exitKanjiCodeMode() {
        if (_kanjiCodeMode == _CODE_SECOND) {
            _kanjiCodeMode = _CODE_FIRST;
            _kanjiCode = (char)(_kanjiCode - _CODE_SECOND_INDEX.length);
            _makeKanjiCodeList();
            return false;
        } else {
            return true;
        }
    }

    /**
     * Ϥ줿ƥȤ֤ޤ
     *
     * @return Ϥ줿ƥ
     */
    private String _getText() {
        String str = _text.getText();
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    /**
     * 򤵤줿ɤ֤ޤ
     *
     * @return 򤵤줿
     */
    char getChar() {
        return _kanjiCode;
    }

    /**
     * 򲡤ƤȤ˸ƤӽФޤ
     *
     * @param evt ٥
     */
    public void keyPressed(KeyEvent evt) {
    }

    /**
     * ΥȤ˸ƤӽФޤ
     *
     * @param evt ٥
     */
    public void keyReleased(KeyEvent evt) {
        int code = evt.getKeyCode() | evt.getModifiersEx();
        switch (code) {
            case KeyEvent.VK_G | InputEvent.CTRL_DOWN_MASK: // C-g
                ((Controller)_skk.getControlObject()).cancel(); // 󥻥
                break;
            case KeyEvent.VK_J | InputEvent.CTRL_DOWN_MASK: // C-j
            case KeyEvent.VK_ENTER:
                String word = _getText();
                Controller ctrl = (Controller)_skk.getControlObject();
                if (word != null && word.length() > 0) {
                    if (_mode == _CANDIDATE) {
                        _candidate.regist(word);
                        ctrl.decision(); // 
                    } else if (_mode == _KANJICODE
                               && _kanjiCodeMode == _CODE_INPUT) {
                        boolean flag = false;
                        int len = word.length();
                        if (len == 1) { // 1ʸξϤʸΥ
                            _kanjiCode = word.charAt(0);
                            flag = true;
                        } else {
                            if (word.charAt(len-1) == '-') { // ɽϥ
                                word = word.substring(0, len-1);
                                len--;
                                flag = true;
                            }
                            int num = -1;
                            try {
                                num = Integer.parseInt(word, 16);
                            } catch (NumberFormatException exp) {
                                num = -1;
                            }
                            if (num > -1 && num < 0x10000) {
                                _kanjiCode = (char)num;
                            } else {
                                _text.setText("");
                                return;
                            }
                        }
                        if (flag) {
                            _kanjiCodeMode = _CODE_FIRST;
                            setupSelectionWindow();
                            ctrl.startKanjiCodeMode();
                        } else {
                            ctrl.decision(); // 
                        }
                    }
                } else {
                    if (_mode == _CANDIDATE) {
                        ctrl.cancel(); // 󥻥
                    } else if (_mode == _KANJICODE
                               && _kanjiCodeMode == _CODE_INPUT) {
                        _kanjiCodeMode = _CODE_FIRST;
                        setupSelectionWindow();
                        ctrl.startKanjiCodeMode();
                    }
                }
                break;
            default:
                break;
        }
    }

    /**
     * 򲡤Ȥ˸ƤӽФޤ
     *
     * @param evt ٥
     */
    public void keyTyped(KeyEvent evt) {
    }
}

// end of LookupWindow.java
